/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name :  MEMGTDLG.CPP
** Author:      Chris Fang
** Description: implement file of CMemGtDlg
**
** coding from: Sep 28, 1996
** Finished date:
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
// memgtdlg.cpp : implementation file
//

#include "stdafx.h"
#include "ep196.h"
#include "memgtdlg.h"
#include "abitype.h"
#include "uicom2.h"

#include <ctype.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMemGtDlg dialog


CMemGtDlg::CMemGtDlg(CWnd* pParent /*=NULL*/, BOOL isAsm)
	: CDialog(CMemGtDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemGtDlg)
	m_strAddr = "";
	m_strSpace = "";
	//}}AFX_DATA_INIT
	m_bAsm=isAsm;
	m_nBank=GetBankNum();
	m_bCombination=IsMapCombination();
	m_strP0="Program Bank0";
	m_strP1="Program Bank1";
	m_strP2="Program Bank2";
	m_strP3="Program Bank3";
	m_strX0="Data Bank0";
	m_strX1="Data Bank1";
	m_strI="On_chip Data";
}

BOOL CMemGtDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();
char buf[20];
int	nRet;

	((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
				AddString(m_strP0);
	if(m_nBank==2)
	{
		if(m_bCombination)
			((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					AddString(m_strP1);
		else
			((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					AddString(m_strX0);
	}
	else if(m_nBank==4)
	{
		if(m_bCombination)
		{
			((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					AddString(m_strP1);
			((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					AddString(m_strP2);
			((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					AddString(m_strP3);
		}
		else
		{
		    ((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					AddString(m_strP1);
			((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					AddString(m_strX0);
			((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					AddString(m_strX1);
		}
	}
	if(!m_bAsm)
		((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
				AddString(m_strI);
	wsprintf(buf, "%04X", m_dwAddress);
	m_strAddr=buf;
	switch(m_wSpace)
	{
		case MEM_P0:
			nRet=((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					SelectString(-1, m_strP0);
			break;
		case MEM_P1:
			nRet=((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					SelectString(-1, m_strP1);
			break;
		case MEM_P2:
			nRet=((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					SelectString(-1, m_strP2);
			break;
		case MEM_P3:
			nRet=((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					SelectString(-1, m_strP3);
			break;
		case MEM_X0:
			nRet=((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					SelectString(-1, m_strX0);
			break;
		case MEM_X1:
			nRet=((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					SelectString(-1, m_strX1);
			break;
		case MEM_I:
			nRet=((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->
					SelectString(-1, m_strI);
			break;
        default:
        	nRet=CB_ERR;
        	break;
	}
	if(nRet==CB_ERR)
	{
		m_wSpace=MEM_P0;
		((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->SetCurSel(0);
    }
    UpdateData(FALSE);
	GotoDlgCtrl(GetDlgItem(IDC_MEMGOTO_ADDR));
	return FALSE;  // return TRUE  unless you set the focus to a control
}

void CMemGtDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemGtDlg)
	DDX_Text(pDX, IDC_MEMGOTO_ADDR, m_strAddr);
	DDV_MaxChars(pDX, m_strAddr, 20);
	DDX_CBString(pDX, IDC_MEMGOTO_REGION, m_strSpace);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemGtDlg, CDialog)
	//{{AFX_MSG_MAP(CMemGtDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMemGtDlg message handlers

void CMemGtDlg::OnOK()
{
	// TODO: Add extra validation here
	int i;
	CString strSel;
	
	m_wSpace=(WORD)((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->GetCurSel();
	((CComboBox*)GetDlgItem(IDC_MEMGOTO_REGION))->GetLBText(m_wSpace, strSel);
	if(strSel==m_strP0)
		m_wSpace=MEM_P0;
	else if(strSel==m_strP1)
		m_wSpace=MEM_P1;
	else if(strSel==m_strX0)
		m_wSpace=MEM_X0;
	else if(strSel==m_strX1)
		m_wSpace=MEM_X1;
	else if(strSel==m_strP2)
		m_wSpace=MEM_P2;
	else if(strSel==m_strP3)
		m_wSpace=MEM_P3;
	else if(strSel==m_strI)
		m_wSpace=MEM_I;
	else
		ASSERT(0);


    if(!UpdateData(TRUE))
        return;
        
 	ADDRESS addr;
	if ( ADR_OK == AdrShellToAddr(m_strAddr, addr, m_wSpace) ) {	
		m_dwAddress = addr.adrAddress;
	}
	else if ( ADR_OK == AdrTextToAddr(m_strAddr, addr) ) {	
		m_dwAddress = addr.adrAddress;
		if (addr.adrSpace != 0) {
			MessageBox("Invalid Input!");
			return;
		}
		addr.adrSpace = m_wSpace;
		if (!AdrCheckAddrRange(addr)) {
			MessageBox("Invalid Address Range!");
			return;
		}
	}
	else {
		MessageBox("Invalid Input!");
		return;
	}
/*	else {
		m_strAddr.MakeUpper();
		if(m_strAddr.GetLength()>2&&m_strAddr[0]=='0'&&m_strAddr[1]=='X')
			m_strAddr=m_strAddr.Right(m_strAddr.GetLength()-2);
		if(!m_strAddr.GetLength())
		{
			MessageBox("Invalid Input!");
			return;
		}
		for(i=0; i<m_strAddr.GetLength(); i++)
			if(!isalnum(m_strAddr[i]))
			{
				MessageBox("Invalid Input!");
				return;
			}
		m_dwAddress=strtoul(m_strAddr, NULL, 16);
		if(m_dwAddress>0xffff)
		{
			MessageBox("Exceed maximum address!");
			return;
		}
	}
*/	CDialog::OnOK();
}
