/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

//
// mempage.cpp : implementation file of the memory page dialog
//       Copy, Compare, Checksum, Test, Search, Fill, (Total is six)
//
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include "resource.h"

#include "uicom2.h"
#include "memsvr.h"
#include "memwin.h"
#include "memdlg.h"
   
// Use ABI
//
#include <ctype.h>
//#include "abibase.h"
//#include "abitype.h"
//#include "basictyp.h"

// Use address server
//
#include "address.h"
//#include "addrapi.h"

// include error handling head file
#include "hosterrs.h"
                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
//extern ADDR_SIZE  dwpMax;        // program  max address
//extern ADDR_SIZE  dwpMin;        // program  min address
//extern ADDR_SIZE  dwxMax;        // external max address
//extern ADDR_SIZE  dwxMin;        // external min address
//extern ADDR_SIZE  dwiMax;        // external max address
//extern ADDR_SIZE  dwiMin;        // external min address

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define SPACE_DEFAULT SPACE_P0
long   lErrorID;
                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
int GetTokenNum(char* string);
BOOL StrtoVal(char* pStr, char& Val);
BOOL MyMemServerSearch(ADDRESS Start, ADDRESS End, char* pszPattern, 
					int nInsensitive, ADDRESS& RetAddr, BOOL& bFind);

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/**---------------------------------------------------------------------**
 ** Error handling routine
 **
 **---------------------------------------------------------------------**/

int GetTokenNum(char* string)
{
    char separation[3];
    char* temp;
    char* str1=new char[strlen(string)+1];
    int num;
    
    separation[0]=' ';
    separation[1]=',';
    separation[2]='\0';       
    num = 0;     
    
    if(!str1)
	{
	    ErrDisplayError(ER_APP_OUTMEMORY);
		return -1;
	}	
    strcpy(str1,string);
    
    temp = strtok(str1, separation);
    if (temp == NULL) 
    {	
        delete str1;
    	return num;
    }	
    
    do
    {
        num++;
        temp = strtok(NULL, separation);
    }while(temp!=NULL);    
    
    delete str1;
    return num;
}              

//return FALSE: failure in address exchange
//return TRUE:  success
BOOL GetAddrRange(CWnd* pWnd, WORD wIDStartAddr, WORD wIDEndMode, 
					WORD wIDEndAddr, ADDRESS& startAddr, ADDRESS& endAddr)
{
ADDR_RETCODE retAddr;
int nSelect;

	if(!GetAddr(pWnd, wIDStartAddr, startAddr))
		return FALSE;
	if(startAddr.adrSpace==SPACE_UNDEFINE)
		startAddr.adrSpace=SPACE_DEFAULT;
	nSelect=((CComboBox *)pWnd->GetDlgItem(wIDEndMode))->GetCurSel();
	if(!GetAddr(pWnd, wIDEndAddr, endAddr, nSelect))
		return FALSE;
	if(nSelect)	//is Length
	{
		endAddr.adrSpace=startAddr.adrSpace;
		endAddr.adrAddress=startAddr.adrAddress+endAddr.adrAddress-1;
	}
	else if(endAddr.adrSpace==SPACE_UNDEFINE)
		endAddr.adrSpace=startAddr.adrSpace;
	retAddr=AdrCheck2Addr(startAddr, endAddr);
	if(retAddr!=ADR_OK)
	{
		DisplayAddrError(retAddr);
		((CDialog*)pWnd)->GotoDlgCtrl(pWnd->GetDlgItem(wIDEndAddr));
		((CEdit*)pWnd->GetDlgItem(wIDEndAddr))->SetSel(0, -1);
		return FALSE;
	}
	return TRUE;
}

//return FALSE: failure in address exchange
//return TRUE:  success
BOOL GetAddr(CWnd* pWnd, WORD wIDAddr, ADDRESS& Addr, BOOL isLength)
{
ADDR_RETCODE retAddr;
char pStr[51];

	pStr[0]=NULL;
	pWnd->GetDlgItemText(wIDAddr, pStr, 50);
	if(isLength)
		retAddr=AdrTextToAddr(pStr, Addr, 0);
	else  {
		retAddr=AdrTextToAddr(pStr, Addr);
		if (ADR_OK == retAddr && Addr.adrSpace == 0) {
			AfxMessageBox("Unknown address space");
			((CDialog*)pWnd)->GotoDlgCtrl(pWnd->GetDlgItem(wIDAddr));
			((CEdit*)pWnd->GetDlgItem(wIDAddr))->SetSel(0, -1);
			return FALSE;
		}
	}
	if (ADR_OK != retAddr)
	{
		// Call Error handling
		::DisplayAddrError(retAddr);
		((CDialog*)pWnd)->GotoDlgCtrl(pWnd->GetDlgItem(wIDAddr));
		((CEdit*)pWnd->GetDlgItem(wIDAddr))->SetSel(0, -1);
		return FALSE;
	}
	return TRUE;
}

//count: input - the max length of pBuf volume;
//count: output- the length of the pattern.
BOOL GetPattern(CWnd* pWnd, WORD wIDPattern, char* pPattern, int& count)
{
int len, i;
char pBuf[101];
char sep[3];

	len=pWnd->GetDlgItemText(wIDPattern, pBuf, 100);
	if(len<=0)
	{
	    PatternErr(pWnd, wIDPattern);
	    count=0;
		return FALSE;
	}
	// Filter the tail white space
	i=len-1;
	while(i>=0&&pBuf[i] == ' ')
		i--;
	pBuf[i+1]=NULL;
    len=i+1;
	if(len<=0)
	{
		PatternErr(pWnd, wIDPattern);
		count=0;
		return FALSE;
	}
	if('"'==pBuf[0])
	{
		if('"'==pBuf[len-1]&&len>2&&len-1<=count)
		{
			pBuf[len-1]=NULL;
			strcpy(pPattern, &pBuf[1]);
			count=len-2;
			return TRUE;
		}
		else
		{
			PatternErr(pWnd, wIDPattern);
			count=0;
			return FALSE;
		}
	}
	len=GetTokenNum(pBuf);
	if((len<=0)||(len>count))
	{
		PatternErr(pWnd, wIDPattern);
		count=0;
		return FALSE;
	}
	sep[0]=' ';
	sep[1]=',';
	sep[2]=NULL;
	
	if(!StrtoVal(strtok(pBuf, sep), pPattern[0]))
	{
		PatternErr(pWnd, wIDPattern);
		count=0;
		return FALSE;
	}
	for(i=1; i<len; i++)
	{
		if(!StrtoVal(strtok(NULL, sep), pPattern[i]))
		{
			PatternErr(pWnd, wIDPattern);
			count=0;
			return FALSE;
		}
	}
	count=len;
	return TRUE;
}

BOOL StrtoVal(char* pStr, char& Val)
{
int i;
long l;
int base=16;

	ASSERT(pStr);
	
	if(pStr[0]==NULL)
		return FALSE;
	if(pStr[0]=='\''&&pStr[2]=='\'')
	{
		if(pStr[3]!=NULL)
			return FALSE;
		Val=pStr[1];
		return TRUE;
	}
	if(pStr[0]=='0'&&(pStr[1]=='x'||pStr[1]=='X'))
		pStr+=2;
	else
		base=10;
	i=0;
	while(pStr[i])
		if(!isxdigit(pStr[i++]))
			return FALSE;
	char *p;
	l=strtol(pStr, &p, base);
	if (*p != 0) return FALSE;
	if(l>0xff)
		return FALSE;
	Val=(char)l;
	return TRUE;
}

//refrence by memwin and memschdg
BOOL MyMemServerSearch(ADDRESS begAddr, ADDRESS endAddr, char* pszPattern, 
					int bInsensitive, ADDRESS& RetAddr, BOOL& bFind)
{
int len, i, count=32;
char pBuf[101];
char sep[3];
char pPattern[33];
STATUS retSvr;
CString	cstrMsg;

	strcpy(pBuf, pszPattern);
	bFind=FALSE;

//duplicate code(same as GetPattern in mempage.cpp)
	len=strlen(pBuf);
	if(len<=0)
		return FALSE;
	// Filter the tail white space
	i=len-1;
	while(i>=0&&pBuf[i] == ' ')
		i--;
	pBuf[i+1]=NULL;
    len=i+1;
	if(len<=0)
		return FALSE;
	if('"'==pBuf[0])
	{
		if('"'==pBuf[len-1]&&len>2&&len-1<=count)
		{
			pBuf[len-1]=NULL;
			strcpy(pPattern, &pBuf[1]);
			count=len-2;
		}
		else
			return FALSE;
	}
	len=GetTokenNum(pBuf);
	if((len<=0)||(len>count))
		return FALSE;
	sep[0]=' ';
	sep[1]=',';
	sep[2]=NULL;

	if(!StrtoVal(strtok(pBuf, sep), pPattern[0]))
		return FALSE;
	for(i=1; i<len; i++)
	{
		if(!StrtoVal(strtok(NULL, sep), pPattern[i]))
			return FALSE;
	}
	count=len;

	retSvr=MemServerSearch(begAddr, endAddr,
					pPattern, count, bInsensitive,
					RetAddr, cstrMsg, 2);
	bFind=(retSvr==ICE_OK);
	return TRUE;
}

void PatternErr(CWnd* pWnd, WORD wIDPattern)
{

	AfxMessageBox("Invalid input pattern!");
	((CDialog*)pWnd)->GotoDlgCtrl(pWnd->GetDlgItem(wIDPattern));
	((CEdit*)pWnd->GetDlgItem(wIDPattern))->SetSel(0, -1);
}

void
DisplayError(long lErrorID)
{
	CString errormsg;

	::ErrGetErrorText(lErrorID, errormsg);
	AfxMessageBox(errormsg, MB_OK|MB_ICONEXCLAMATION);
}

void
DisplayAddrError(ADDR_RETCODE  retCode)
{
   CString errormsg;
   
   ::AdrErrorDeal(retCode, errormsg);
   AfxMessageBox(errormsg, MB_OK|MB_ICONEXCLAMATION);
}   

/**--------------------------------------------------------------------**
 **                                                                    **
 **  CMemSearch dialog                                                 **
 **                                                                    **
 **   The memory search page dialog                                    **
 **                                                                    **
 **--------------------------------------------------------------------**/
 
//
// CMemSearchPage dialog
//

CMemSearchPage::CMemSearchPage()
   : CPropertyPage(CMemSearchPage::IDD)
{
	//{{AFX_DATA_INIT(CMemSearchPage)
	m_bCase = FALSE;
	//}}AFX_DATA_INIT

	m_nIDHelp=IDD_MEMSEARCG_PAGE;
}

void CMemSearchPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemSearchPage)
	DDX_Control(pDX, IDC_SEARCH_LIST, m_ctrlList);
	DDX_Check(pDX, IDC_SEARCH_CASE, m_bCase);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemSearchPage, CPropertyPage)
	//{{AFX_MSG_MAP(CMemSearchPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//
// CMemSearchPage message handlers
//
/////////////////////////////////////////////////////////////////////
// DoSearch
//
//    Do the memory search
//
/////////////////////////////////////////////////////////////////////
void CMemSearchPage::DoSearch()
{
	// TODO: Add your control notification handler code here

ADDRESS		startAddress, endAddress;
ADDRESS		retAddress;
char		pattern[33];
int			nPatlen=32;

char		pOutput[40];
STATUS		retSvr;
int			line;
CString		strAdr, strMsg;

	if(!UpdateData(TRUE))
		return;         // Get data from the dialog
	
	if(!GetAddrRange(this, IDC_SEARCH_STARTADDR, IDC_SEARCH_ENDSELECT, 
					IDC_SEARCH_ENDADDR, startAddress, endAddress))
		return;
	if (startAddress.adrSpace == SPACE_I) {
		m_ctrlList.AddString("On-chip data doesn't support this command.");
		return;
	}

	if(!GetPattern(this, IDC_SEARCH_DATA, pattern, nPatlen))
		return;
	                        
	line=0;
	m_ctrlList.ResetContent();
	BeginWaitCursor();
	do
	{
		line++;
		retSvr = ::MemServerSearch(startAddress,
									endAddress,
									pattern,       // pattern
									nPatlen,
									!m_bCase,
									retAddress, strMsg);
			
		if(retSvr==ICE_OK)
		{
			startAddress.adrAddress = retAddress.adrAddress;
			m_ctrlList.AddString(strMsg);
			startAddress.adrAddress++;
		}
		else
			break;
		if(line>=0xff)
		{
			m_ctrlList.AddString("*** Find Limitation: 0xff ***");
			break;
		}
	}while(startAddress.adrAddress<=endAddress.adrAddress);
	EndWaitCursor();
	
	if ((line == 1) && retSvr==ICE_NO_MATCH)
		m_ctrlList.AddString(strMsg);
	else if(retSvr==ICE_NO_MATCH||retSvr==ICE_OK)
		m_ctrlList.AddString("*** the End ***");
	else	//error occur
		m_ctrlList.AddString(strMsg);
	return;
}

/////////////////////////////////////////////////////////////////////
// OnInitDialog
//
//    Initialize the dialog   
//
////////////////////////////////////////////////////////////////////
BOOL CMemSearchPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// TODO: Add extra initialization here

/*	CWnd* ctrl;

	if (dwpMin == dwpMax) {        // no code area   
	  ctrl = GetDlgItem(IDC_SEARCH_SPACE);
	  ctrl->EnableWindow(FALSE);
	}
	if (dwxMin == dwxMax) {        // no data area   
	  ctrl = GetDlgItem(IDC_SEARCH_SPACE_DATA);
	  ctrl->EnableWindow(FALSE);
	}
*/  
	((CComboBox*)GetDlgItem(IDC_SEARCH_ENDSELECT))->SetCurSel(0);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////
// OnOk
//
//    Do the memory search.
//    The dialog will close if the focus does not on the search button when 
//    you press the 'Enter'.
//    Overide the OnOK from the class CPropertyPage to process the search
//
////////////////////////////////////////////////////////////////////
void CMemSearchPage::OnOK()
{
	// TODO: Add your control notification handler code here
	DoSearch();
	((CMemDlg*)GetParent())->SetModal(TRUE);   
}

/////////////////////////////////////////////////////////////////////
// OnCancel
//
//    Reset the m_bModeless
////////////////////////////////////////////////////////////////////
void CMemSearchPage::OnCancel()
{
	// TODO: Add your control notification handler code here
	((CMemDlg*)GetParent())->SetModal(FALSE);   
}

/**-------------------------------------------------------------------**
 **
 **  CMemComparePage dialog
 **   
 **   The memory compare page dialog   
 **
 **-------------------------------------------------------------------**/
 
//
// CMemComparePage dialog
//

CMemComparePage::CMemComparePage()
   : CPropertyPage(CMemComparePage::IDD)
{
	//{{AFX_DATA_INIT(CMemComparePage)
	m_bCompCheckStop = TRUE;
	//}}AFX_DATA_INIT

	m_nIDHelp=IDD_MEMCOMP_PAGE;
}

void CMemComparePage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemComparePage)
	DDX_Control(pDX, IDC_COMP_LIST, m_ctrlList);
	DDX_Check(pDX, IDC_COMP_CHECKSTOP, m_bCompCheckStop);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemComparePage, CPropertyPage)
	//{{AFX_MSG_MAP(CMemComparePage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//
// CMemComparePage message handlers
//
///////////////////////////////////////////////////////////////////////
// DoCompare
//
//    Do the memory compare
//
//
///////////////////////////////////////////////////////////////////////
void CMemComparePage::DoCompare()
{
	// TODO: Add your control notification handler code here
ADDRESS	startAddress, endAddress, destAddress, 
		startAddress2, destAddress2, retAddress;
	
char	pOutput[40];
STATUS	retSvr;
int		line;
CString	strAdr, strMsg;

	if(!UpdateData(TRUE))
		return;
	   
	if(!GetAddrRange(this, IDC_COMP_STARTADDR, IDC_COMP_ENDSELECT, 
					IDC_COMP_ENDADDR, startAddress, endAddress))
		return;
	if (startAddress.adrSpace == SPACE_I) {
		m_ctrlList.AddString("On-chip data doesn't support this command.");
		return;
	}
	if(!GetAddr(this, IDC_COMP_DESTADDR, destAddress))
		return;
	
	startAddress2=startAddress;
	destAddress2=destAddress;
	line=0;
	m_ctrlList.ResetContent();
	BeginWaitCursor();
	do
	{
		line++;
		retSvr = ::MemServerCompare(startAddress2,
									endAddress,
									destAddress2,
									retAddress,
									strMsg);
		if(retSvr==ICE_OK)
		{
			startAddress2.adrAddress = retAddress.adrAddress;
			m_ctrlList.AddString(strMsg);
			startAddress2.adrAddress++;
			destAddress2.adrAddress=destAddress.adrAddress+
					(startAddress2.adrAddress - startAddress.adrAddress);
			if(m_bCompCheckStop)
				break;
		}
		else
			break;
		if(line>=0xff)
		{
			m_ctrlList.AddString("*** Compare Limitation: 0xff ***");
			break;
		}
	}while(startAddress2.adrAddress<=endAddress.adrAddress);
	EndWaitCursor();
	
	if ((line == 1) && retSvr==ICE_NO_DIFF)
		m_ctrlList.AddString(strMsg);
	else if(retSvr==ICE_NO_DIFF||retSvr==ICE_OK)
		m_ctrlList.AddString("*** the End ***");
	else	//error occur
		m_ctrlList.AddString(strMsg);
	return;
}

//////////////////////////////////////////////////////////////////////////
// OnOK
//
//    Do the memory compare
//    The dialog will close if the focus does not on the compare button when 
//    you press the 'Enter'.
//    Overide the OnOK from the class CPropertyPage to process the compare
//
//////////////////////////////////////////////////////////////////////////
void CMemComparePage::OnOK()
{
	// TODO: Add your control notification handler code here
	DoCompare();
	((CMemDlg*)GetParent())->SetModal(TRUE);
}

/////////////////////////////////////////////////////////////////////
// OnCancel
//
//    Reset the m_bModeless
////////////////////////////////////////////////////////////////////
void CMemComparePage::OnCancel()
{
	// TODO: Add your control notification handler code here
	((CMemDlg*)GetParent())->SetModal(FALSE);   
}

/////////////////////////////////////////////////////////////////////////////
// OnInitDialog
//
//    Initialize the dialog
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMemComparePage::OnInitDialog()
{
   CPropertyPage::OnInitDialog();
   
   // TODO: Add extra initialization here
/*   
   CWnd* ctrl;
      
   if (dwpMin == dwpMax) {        // no code area   
      ctrl = GetDlgItem(IDC_COMP_SRCSPACE);
      ctrl->EnableWindow(FALSE);
      ctrl = GetDlgItem(IDC_COMP_DESTSPACE);
      ctrl->EnableWindow(FALSE);
   }
   if (dwxMin == dwxMax) {        // no data area   
      ctrl = GetDlgItem(IDC_COMP_SRCDATA);
      ctrl->EnableWindow(FALSE);
      ctrl = GetDlgItem(IDC_COMP_DESTDATA);
      ctrl->EnableWindow(FALSE);
   }
*/
	((CComboBox*)GetDlgItem(IDC_COMP_ENDSELECT))->SetCurSel(0);
	return TRUE;  // return TRUE  unless you set the focus to a control
} // End of CMemComparePage

/**-----------------------------------------------------------------------**
 **
 **  CMemChecksumPage dialog
 **   
 **   The memory checksum page dialog   
 **
 **-----------------------------------------------------------------------**/

CMemChecksumPage::CMemChecksumPage()
   : CPropertyPage(CMemChecksumPage::IDD)
{
	//{{AFX_DATA_INIT(CMemChecksumPage)
	//}}AFX_DATA_INIT

	m_nIDHelp=IDD_MEMCHECKSUM_PAGE;
}

void CMemChecksumPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemChecksumPage)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemChecksumPage, CPropertyPage)
	//{{AFX_MSG_MAP(CMemChecksumPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// DoChecksum
//
//    Do the memory checksum
//
/////////////////////////////////////////////////////////////////////////////
void CMemChecksumPage::DoChecksum()
{
	// TODO: Add your control notification handler code here
ADDRESS		startAddress, endAddress;
WORD		wChecksum;
CString		strMsg;

	if(!UpdateData(TRUE))
		return;

	if(!GetAddrRange(this, IDC_CHECKSUM_STARTADDR, IDC_CHECKSUM_ENDSELECT, 
					IDC_CHECKSUM_ENDADDR, startAddress, endAddress))
		return;
	   
	BeginWaitCursor();   
	MemServerChecksum(startAddress, endAddress, wChecksum, strMsg);
	EndWaitCursor();
	   
	SetDlgItemText(IDC_CHECKSUM_OUTPUT, strMsg);
	return;
}

/////////////////////////////////////////////////////////////////////////////
// OnOK
//
//    Do the memory checksum
//
/////////////////////////////////////////////////////////////////////////////
void CMemChecksumPage::OnOK()
{
	// TODO: Add your control notification handler code here
	DoChecksum();
	((CMemDlg*)GetParent())->SetModal(TRUE);      
}

/////////////////////////////////////////////////////////////////////
// OnCancel
//
//    Reset the m_bModeless
////////////////////////////////////////////////////////////////////
void CMemChecksumPage::OnCancel()
{
	// TODO: Add your control notification handler code here
	((CMemDlg*)GetParent())->SetModal(FALSE);   
}

////////////////////////////////////////////////////////////////////////////
// OnInitDialog
//
//    Initialize the dialog
//
////////////////////////////////////////////////////////////////////////////
BOOL CMemChecksumPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
   
   // TODO: Add extra initialization here
/*   
   CWnd* ctrl;
      
   if (dwpMin == dwpMax) {        // no code area   
      ctrl = GetDlgItem(IDC_CHECKSUM_SPACE);
      ctrl->EnableWindow(FALSE);
   }
   if (dwxMin == dwxMax) {        // no data area   
      ctrl = GetDlgItem(IDC_CHECKSUM_SPACE_DATA);
      ctrl->EnableWindow(FALSE);
   }
   if (dwiMin == dwiMax) {        // no on_chip area   
      ctrl = GetDlgItem(IDC_CHECKSUM_SPACE_CHIP);
      ctrl->EnableWindow(FALSE);
   }
*/   
	((CComboBox*)GetDlgItem(IDC_CHECKSUM_ENDSELECT))->SetCurSel(0);
	return TRUE;  // return TRUE  unless you set the focus to a control
}  // End of CMemCheckSumPage

/**-----------------------------------------------------------------------**
 **
 **  CMemCopyPage dialog
 **   
 **   The memory copy page dialog   
 **
 **-----------------------------------------------------------------------**/
 
//
// CMemCopyPage dialog
//

CMemCopyPage::CMemCopyPage()
   : CPropertyPage(CMemCopyPage::IDD)
{
	//{{AFX_DATA_INIT(CMemCopyPage)
	//}}AFX_DATA_INIT

	m_nIDHelp=IDD_MEMCOPY_PAGE;
}

void CMemCopyPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemCopyPage)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemCopyPage, CPropertyPage)
	//{{AFX_MSG_MAP(CMemCopyPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//
// CMemCopyPage message handlers
//
////////////////////////////////////////////////////////////////////////
// DoCopy
//
//    Do the memory copy
//
////////////////////////////////////////////////////////////////////////
void CMemCopyPage::DoCopy()
{
	// TODO: Add your control notification handler code here
ADDRESS	startAddress, endAddress, destAddress;
CString strMsg;

	if(!UpdateData(TRUE))
		return;

	if(!GetAddrRange(this, IDC_COPY_STARTADDR, IDC_COPY_ENDSELECT,
					IDC_COPY_ENDADDR, startAddress, endAddress))
		return;
	if (startAddress.adrSpace == SPACE_I) {
		SetDlgItemText(IDC_COPY_OUTPUT,"On-chip data doesn't support this command.");
		return;
	}
	if(!GetAddr(this, IDC_COPY_DESTADDR, destAddress))
		return;

	BeginWaitCursor();
	MemServerCopy(startAddress,
					endAddress,
					destAddress, strMsg);
	for (int no = 0; no < 1; no ++ )
	{
		if(gb_isMemOn[no])
			((CMemoryWindow*)gp_MemWnd[no])->RefreshMemWin(TRUE);
	} 
///	::RepaintStack();
///	::RepaintVariable();
	EndWaitCursor();
		SetDlgItemText(IDC_COPY_OUTPUT, strMsg);
	return;
}

////////////////////////////////////////////////////////////////////////
// OnOK
//
//    Do the memory copy
//
////////////////////////////////////////////////////////////////////////
void CMemCopyPage::OnOK()
{
	// TODO: Add your control notification handler code here
	DoCopy();
	((CMemDlg*)GetParent())->SetModal(TRUE);   
}

/////////////////////////////////////////////////////////////////////
// OnCancel
//
//    Reset the m_bModeless
////////////////////////////////////////////////////////////////////
void CMemCopyPage::OnCancel()
{
	// TODO: Add your control notification handler code here
	((CMemDlg*)GetParent())->SetModal(FALSE);   
}

/////////////////////////////////////////////////////////////////////////////
// OnInitDialog
//
//    Initialize the dialog
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMemCopyPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
			   
	// TODO: Add extra initialization here
/*			   
	CWnd* ctrl;
			      
	if (dwpMin == dwpMax) {        // no code area   
	  ctrl = GetDlgItem(IDC_COPY_SRCSPACE);
	  ctrl->EnableWindow(FALSE);
	  ctrl = GetDlgItem(IDC_COPY_DESTSPACE);
	  ctrl->EnableWindow(FALSE);
	}
	if (dwxMin == dwxMax) {        // no data area   
	  ctrl = GetDlgItem(IDC_COPY_SRCDATA);
	  ctrl->EnableWindow(FALSE);
	  ctrl = GetDlgItem(IDC_COPY_DESTDATA);
	  ctrl->EnableWindow(FALSE);
	}
*/			   
	((CComboBox*)GetDlgItem(IDC_COPY_ENDSELECT))->SetCurSel(0);
	return TRUE;  // return TRUE  unless you set the focus to a control
}  // End of copy page dialog

/**-----------------------------------------------------------------------**
 **
 **  CMemFillPage dialog
 **   
 **   The memory fill page dialog   
 **
 **-----------------------------------------------------------------------**/

//
// CMemFillPage dialog
//

CMemFillPage::CMemFillPage()
   : CPropertyPage(CMemFillPage::IDD)
{
	//{{AFX_DATA_INIT(CMemFillPage)
	//}}AFX_DATA_INIT

	m_nIDHelp=IDD_MEMFILL_PAGE;
}

void CMemFillPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemFillPage)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemFillPage, CPropertyPage)
	//{{AFX_MSG_MAP(CMemFillPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//
// CMemFillPage message handlers
//
///////////////////////////////////////////////////////////////////////
// DoFill
//
//    Do the memory fill
//
///////////////////////////////////////////////////////////////////////
void CMemFillPage::DoFill()
{
   // TODO: Add your control notification handler code here
ADDRESS		startAddress, endAddress;
char		pattern[0x100];
int			nPatlen=0xff;

STATUS		retAbi;

	if(!UpdateData(TRUE))
		return;         // Get data from the dialog

	if(!GetAddrRange(this, IDC_FILL_STARTADDR, IDC_FILL_ENDSELECT, 
					IDC_FILL_ENDADDR, startAddress, endAddress))
		return;

	if(!GetPattern(this, IDC_FILL_DATA, pattern, nPatlen))
		return;

	BeginWaitCursor();
	retAbi=MemServerFill(startAddress,
					endAddress,
					pattern, nPatlen);
	for(int no=0; no<1; no++)
	{
		if(gb_isMemOn[no])
			((CMemoryWindow*)gp_MemWnd[no])->RefreshMemWin(TRUE);
	}
///	::RepaintStack();
///	::RepaintVariable();
	EndWaitCursor();

	if(retAbi==ICE_OK)
		SetDlgItemText(IDC_FILL_OUTPUT, "Fill success.");
	else
		SetDlgItemText(IDC_FILL_OUTPUT, "Fill failure.");
	return;
}

///////////////////////////////////////////////////////////////////////
// OnOK
//
//    Do the memory fill
//
///////////////////////////////////////////////////////////////////////
void CMemFillPage::OnOK()
{
	// TODO: Add your control notification handler code here
	DoFill();
	((CMemDlg*)GetParent())->SetModal(TRUE);      
}

/////////////////////////////////////////////////////////////////////
// OnCancel
//
//    Reset the m_bModeless
////////////////////////////////////////////////////////////////////
void CMemFillPage::OnCancel()
{
	// TODO: Add your control notification handler code here
	((CMemDlg*)GetParent())->SetModal(FALSE);   
}

/////////////////////////////////////////////////////////////////////////////
// OnInirDialog
//
//    Initilaize the dialog
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMemFillPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// TODO: Add extra initialization here
/*
	CWnd* ctrl;

	if (dwpMin == dwpMax) {        // no code area   
	  ctrl = GetDlgItem(IDC_FILL_SPACE);
	  ctrl->EnableWindow(FALSE);
	}
	if (dwxMin == dwxMax) {        // no data area   
	  ctrl = GetDlgItem(IDC_FILL_SPACE_DATA);
	  ctrl->EnableWindow(FALSE);
	}
	if (dwiMin == dwiMax) {        // no on_chip area   
	  ctrl = GetDlgItem(IDC_FILL_SPACE_CHIP);
	  ctrl->EnableWindow(FALSE);
	}
*/
	((CComboBox*)GetDlgItem(IDC_FILL_ENDSELECT))->SetCurSel(0);
	return TRUE;  // return TRUE  unless you set the focus to a control
}  //End of fill page dialog


/**-----------------------------------------------------------------------**
 **
 **  CMemTestPage dialog
 **   
 **   The memory test page dialog   
 **
 **-----------------------------------------------------------------------**/

/////////////////////////////////////////////////////////////////////////////
// CMemTestPage dialog

CMemTestPage::CMemTestPage()
   : CPropertyPage(CMemTestPage::IDD)
{
	//{{AFX_DATA_INIT(CMemTestPage)
	//}}AFX_DATA_INIT

	//m_nIDHelp=IDD_MEMTEST_PAGE;
}

void CMemTestPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemTestPage)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemTestPage, CPropertyPage)
	//{{AFX_MSG_MAP(CMemTestPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//
// CMemTestPage message handlers
//
/////////////////////////////////////////////////////////////////////////////
// DoTest
//
//    Do the memory test
//
/////////////////////////////////////////////////////////////////////////////
void CMemTestPage::DoTest()
{
	// TODO: Add your control notification handler code here
ADDRESS		startAddress, endAddress, errAddress;
CString		strAdr, strMsg;

	if(!UpdateData(TRUE))
		return;

	if(!GetAddrRange(this, IDC_TEST_STARTADDR, IDC_TEST_ENDSELECT, 
					IDC_TEST_ENDADDR, startAddress, endAddress))
		return;
	   
	BeginWaitCursor();
	MemServerTest(startAddress, endAddress, errAddress, strMsg);
	SetDlgItemText(IDC_TEST_OUTPUT, strMsg);
	for (int no = 0; no < MAX_MEM_WND; no ++ )
	{
		if(gb_isMemOn[no])
			((CMemoryWindow*)gp_MemWnd[no])->RefreshMemWin(TRUE);
	} 
///	::RepaintStack();
///	::RepaintVariable();
	
	EndWaitCursor();
	return;
}

/////////////////////////////////////////////////////////////////////////////
// OnOK
//
//    Do the memory test
//
/////////////////////////////////////////////////////////////////////////////
void CMemTestPage::OnOK()
{
	// TODO: Add your control notification handler code here
	DoTest();
	((CMemDlg*)GetParent())->SetModal(TRUE);      
}

/////////////////////////////////////////////////////////////////////
// OnCancel
//
//    Reset the m_bModeless
////////////////////////////////////////////////////////////////////
void CMemTestPage::OnCancel()
{
	// TODO: Add your control notification handler code here
	((CMemDlg*)GetParent())->SetModal(FALSE);   
}

/////////////////////////////////////////////////////////////////////////////
// OnInitDialog
//
//    Initialize the dialog
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMemTestPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// TODO: Add extra initialization here
/*
	CWnd* ctrl;

	if (dwpMin == dwpMax) {        // no code area   
	  ctrl = GetDlgItem(IDC_TEST_SPACE);
	  ctrl->EnableWindow(FALSE);
	}
	if (dwxMin == dwxMax) {        // no data area   
	  ctrl = GetDlgItem(IDC_TEST_SPACE_DATA);
	  ctrl->EnableWindow(FALSE);
	}
	if (dwiMin == dwiMax) {        // no on_chip area   
	  ctrl = GetDlgItem(IDC_TEST_SPACE_CHIP);
	  ctrl->EnableWindow(FALSE);
	}
*/
	((CComboBox*)GetDlgItem(IDC_TEST_ENDSELECT))->SetCurSel(0);
	return TRUE;  // return TRUE  unless you set the focus to a control
}  // End of Test page dialog

/////////////////////////(EOF of MEMOPAGE.CPP)////////////////////////////////
