/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MEMSCHDG.CPP
//
//  Description:The implement file for the class: CMemSearchDlg
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95      
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// memschdg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "memschdg.h"
#include "ctype.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

BOOL StrtoVal(char* pStr, char& Val);

/////////////////////////////////////////////////////////////////////////////
// CMemSearchDlg dialog
//

CMemSearchDlg::CMemSearchDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMemSearchDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMemSearchDlg)
	m_str = "";
	//}}AFX_DATA_INIT
}

void CMemSearchDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CMemSearchDlg)
	DDX_Text(pDX, IDC_MEMSRH_EDIT1, m_str);
	DDV_MaxChars(pDX, m_str, 200);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemSearchDlg, CDialog)
   //{{AFX_MSG_MAP(CMemSearchDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMemSearchDlg message handlers
BOOL CMemSearchDlg::OnInitDialog()
{
   CDialog::OnInitDialog();
   CenterWindow();
   
   // TODO: Add extra initialization here
//   SetDlgItemText(IDC_MEMSRH_EDIT1,m_str);
   
   return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMemSearchDlg::OnOK()
{
	// TODO: Add extra validation here
	if (UpdateData()) {
		int nError = CheckSyntax(m_str,m_szPattern);
	    if (nError < 0) {
	    	switch (nError) {
	    	case -1	:
	    		AfxMessageBox("Search pattern too long!",MB_OK|MB_ICONEXCLAMATION);
	    		break;
	    	default	:
	    		AfxMessageBox("Search pattern error!",MB_OK|MB_ICONEXCLAMATION);
	    	}
			CWnd* ctrl = GetDlgItem(IDC_MEMSRH_EDIT1);
			ctrl->SetFocus();
			((CEdit*)ctrl)->SetSel(0,-1);
	    }
		else CDialog::OnOK();
	}
}

int CMemSearchDlg::CheckSyntax(LPCSTR lpszArgv,LPSTR lpszPattern)
{
	int nLen = lstrlen(lpszArgv);
//	char* pszAr = new char[nLen+1];
//	lstrcpy(pszAr,lpszArgv);
	CString strArgv = lpszArgv;
	char *pStart = strArgv.GetBuffer(nLen+1);
	char *p = pStart+nLen-1;
	while (isspace(*pStart) && *pStart) pStart++;
	if (*pStart == 0) return -2;
	while (isspace(*p)) p--;
	*(p+1) = '\0';
	
	nLen = lstrlen(pStart);
	if (*pStart == '\"') {
		if (*p == '\"' && nLen > 2) {
			*p = '\0';
			if (lstrlen(pStart+1) > SEARCH_PATLEN) return -1;
			nLen -= 2;
			memcpy(lpszPattern+1,pStart+1,nLen);
			*lpszPattern = nLen;
			return 0;
		}
	}
	else {
		char* pPatLen = lpszPattern++;
		char seps[] = " ,\t";
		char* token = strtok(pStart, seps);
		if (!token) return -2;
		int nTokens = 0;
		while (token) {
			char Val;
			if (!StrtoVal(token, Val))
				return -4;
			if (nTokens == SEARCH_PATLEN) return -1;
			nTokens++;
            *lpszPattern++ = Val;
			token = strtok(NULL, seps);
		}
		*pPatLen = (char)nTokens;
//		*lpszPattern = 0;
		return 0;
	}
	return -3;
}

//////////////////////(EOF of MEMSCHDG.CPP)///////////////////////////

