/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name :  MEMSVR.H
**				-- derived from MEMDUMP.H by Chen Jun.
**
** Author:      Chris Fang
** Description: implement file of memory server.
**
** coding from: Sep 20, 1996
** Finished date:
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _MEMSVR_
#define _MEMSVR_

#include "address.h"

//Memory      adr1 [adr2|Length length]
void MemoryCmd(int nArgc, char* pszArgv[]);
//BYte        adr data1 [..data32]
void ByteCmd(int nArgc, char* pszArgv[]);
//Word        adr data1 [..data16]
void WordCmd(int nArgc, char* pszArgv[]);
//LONg        adr data1 [..data8]
void LongCmd(int nArgc, char* pszArgv[]);
//Fill        adr1 {adr2|Length length} {"string"|data..}
void FillCmd(int nArgc, char* pszArgv[]);
//TEst        adr1 {adr2|Length length}
void TestCmd(int nArgc, char* pszArgv[]);
//SEarch      adr1 {adr2|Length length} {[Insensitive] "string"|data..}
void SearchCmd(int nArgc, char* pszArgv[]);
//Copy        adr1 {adr2|Length length} adr3
void CopyCmd(int nArgc, char* pszArgv[]);
//COMpare     adr1 {adr2|Length length} adr3
void CompareCmd(int nArgc, char* pszArgv[]);
//CHecksum    adr1 {adr2|Length length}
void ChecksumCmd(int nArgc, char* pszArgv[]);
//MAp         [{ALl adrtype}|{adr1 {adr2|Length length}} map_attribute]
void MapCmd(int nArgc, char* pszArgv[]);

//for compatible with old version:
WORD MemServerDump(BYTE* bDump, DWORD dwBegAddr, WORD size, WORD wAddrSpace);
WORD MemServerDump(BYTE* bDump, ADDRESS begAddr, WORD size, int nFromWhere=1);
//for compatible with old version:
STATUS MemServerFill(DWORD dwBegAddr, BYTE data, WORD wAddrSpace);
STATUS MemServerFill(ADDRESS Addr, BYTE data, int nFromWhere=1);
STATUS MemServerFill(ADDRESS begAddr, ADDRESS endAddr,
					char* szPattern, int nPatlen, int nFromWhere=1);
STATUS MemServerTest(ADDRESS begAddr, ADDRESS endAddr,
					ADDRESS& adrBadAddr, CString& strMsg, int nFromWhere=1);
STATUS MemServerSearch(ADDRESS begAddr, ADDRESS endAddr,
					char* pszPattern, int nPatlen, BOOL bInsensitive,
					ADDRESS& retAddr, CString& strMsg, int nFromWhere=1);
STATUS MemServerCopy(ADDRESS begAddr, ADDRESS endAddr, 
					ADDRESS TargetbegAddr, CString& strMsg, int nFromWhere=1);
STATUS MemServerCompare(ADDRESS begAddr, ADDRESS endAddr,
					ADDRESS TargetbegAddr, 
					ADDRESS& resultAddr, CString& strMsg, int nFromWhere=1);
STATUS MemServerChecksum(ADDRESS begAddr, ADDRESS endAddr,
					WORD& result, CString& strMsg, int nFromWhere=1);
STATUS MemServerSetMap(ADDRESS begAddr, ADDRESS endAddr,
					WORD wMapAttr, CString& strMsg, int nFromWhere=1);
STATUS MemServerGetMap(ADDRESS& begAddr, ADDRESS& endAddr,
					WORD& wMapAttr, CString& strMsg, int nFromWhere=1);

//internal use:
void ShowMapInfo(int nMemSpace);
BOOL SetData(char* pInput, char* pOutput, int& nLength, int type);
BOOL GetAddrRange(int nArgc, char* pszArgv[],
			ADDRESS& begAddr, ADDRESS& endAddr);
BOOL EscapeAbort(void);
void ErrShow(CString& strMsg, int nFromWhere);
void ErrorHandler(DWORD errorCode, int nFromWhere);

#endif
//////////////////////////////// End of File ////////////////////////////////
