/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name :  MEMWIN.H
** Author:      Chris Fang
** Description: header file of memory window
**
** coding from: Apr 21, 1997
** Finished date:
**
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _MEMWIN_H_
#define _MEMWIN_H_

#include "gridmem.h"

/////////////////////////////////////////////////////////////////////////////
// CMemoryWindow frame

class CMemoryWindow : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CMemoryWindow)

public:
	CMemoryWindow(BYTE no=0);
	virtual ~CMemoryWindow();
	BOOL Create(LPCSTR szTitle, LONG style = 0,
			const RECT& rect = rectDefault, 
			CMDIFrameWnd * pParent = NULL );

// Attributes
private:
	enum	{
				SM_BYTE=1,
				SM_WORD=2,
				SM_DWORD=3
			};
	enum	{
				SM_HEX=1,
				SM_UDEC=2,
				SM_DEC=3,
				SM_CODE=4
			};
	static CMenu NEAR m_menu;
    static char m_searchStr[200];
	static char m_szPattern[33];

	int	m_nLines;						//m_nLines-2 lines(not include title)
										//in window in fact.
	BYTE*	m_pMemBuffer;
	DWORD	m_dwBufStartAddr;
	DWORD	m_dwBufEndAddr;
	WORD	m_wMemBufferLen;
	BYTE*	m_byMem;
	struct	dsm	*m_dsm;
	WORD	m_wDSMBufferLen;
	int		m_nDSMNum;
	DWORD	m_dwBottomlineAddr;
	WORD	pMax, pMin, xMax, xMin, iMax, iMin;		//NOT IN EP251
	DWORD	m_dwMemRegionEnd;
	DWORD	m_dwMemRegionStart;

	CGridMem	m_gridAddr;           // Address grid
	CGridMem	m_gridMem;            // Memory grid
	CGridMem	m_gridAscii;          // Ascii grid
	CGridMem	m_gridInstruction;    // Instruction grid(only for disassembly)
	
	BOOL	m_bIconic;
	BOOL	m_bHScrollOn;

	int		m_nPosX;          	// Scroll increase
              
	WORD	m_wCaretPosX1;   // Indicate the every grid position
	WORD	m_wCaretPosX2;   // Indicate every char in one grid
	long	m_lCaretPosY;
	int		m_nCaretArea;

	int		m_nCharWidth;
	int		m_nLineHeight;

	BOOL	m_bFocus;
	int		m_nCursor;

	BOOL	m_bShiftDown;

	long	m_lValue;
	WORD	m_wValue;
	BYTE	m_byValue;
	char*	m_lpszValue;

public:
//next six varible all init in NewMemoryOpenWindow	
	BYTE	m_bWndNo;
	//BYTE	m_bMemoryRegion;
	WORD	m_wSpaceType;			//NOT IN EP251
	DWORD	m_dwStartAddress;

	// m_bViewMode1    SM_BYTE	--    Byte
	//                 SM_WORD	--    WORD
	//                 SM_DWORD	--   DWORD
	// m_bViewMode2    SM_HEX	--    Hexdecimal
	//                 SM_UDEC	--    Unsigned Decimal
	//                 SM_DEC	--    Signed Decimal
	//                 SM_CODE	--    Disassenbly
	BYTE	m_bViewMode1;
	BYTE	m_bViewMode2;
	BOOL	m_bShowAscii;
	int		m_nLineGroup;			//1 or 2
	
// Operations
private:
	void	ShowStatusGo(void);
	void	SetWindowTitle(long addr=-1);

	void FillText(LPCSTR,UINT,RECT,CDC*, BOOL isGrey=FALSE);
	void FillText2(LPCSTR,UINT,RECT,CDC*);

	void SetScrollBar();

	void SetAddress();
	void SetAscii();
	void SetInstruction();

	void SetByteSignedDecimal();
	void SetWordSignedDecimal();
	void SetLongSignedDecimal();

	void SetByteUnsignedDecimal();
	void SetWordUnsignedDecimal();
	void SetLongUnsignedDecimal();

	void SetByteHexadecimal();
	void SetWordHexadecimal();
	void SetLongHexadecimal();
	
	void SetDisassemble();
	
	void SetMemoryWindow();

	void ShowAddress(CDC*);
	void ShowAscii(CDC*);
	void ShowInstruction(CDC*);

	void ShowByteSignedDecimal(CDC*);
	void ShowWordSignedDecimal(CDC*);
	void ShowLongSignedDecimal(CDC*);
	
	void ShowByteUnsignedDecimal(CDC*);
	void ShowWordUnsignedDecimal(CDC*);
	void ShowLongUnsignedDecimal(CDC*);

	void ShowByteHexadecimal(CDC*);
	void ShowWordHexadecimal(CDC*);
	void ShowLongHexadecimal(CDC*);

	void ShowDisassemble(CDC*);

	void ShowMemoryWindow(CDC*);

	void SetMyCaretPos();
    
    void xGotoCursor();
	void GotoCursor();

	BOOL InWnd();
    void PaintLine(WORD line);
    
	void Right();
	void Left();
	void Up();
	void Down();
	void Home();
	void End();
	void Tab();

	void OnModeChange(void);
	void GetDsm(int space, DWORD startAddress, int line);
	void PrepareData(void);
	BOOL InputCheck(WORD);
	void WriteMemory(WORD);
	void GetValue();
	void ValueToStr();
	BOOL StrToValue();
	void SetRegionEnd(void);
	
	DWORD GetCaretAddr();
	BOOL SearchNext(DWORD dwStartAddr,LPSTR lpszPattern);

public:
	void RefreshMemWin(BOOL hard);

// Implementation
public:
	// Generated message map functions
	//{{AFX_MSG(CMemoryWindow)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnViewByte();
	afx_msg void OnUpdateViewByte(CCmdUI* pCmdUI);
	afx_msg void OnViewWord();
	afx_msg void OnUpdateViewWord(CCmdUI* pCmdUI);
	afx_msg void OnViewLong();
	afx_msg void OnUpdateViewLong(CCmdUI* pCmdUI);
	afx_msg void OnViewSigneddecimal();
	afx_msg void OnUpdateViewSigneddecimal(CCmdUI* pCmdUI);
	afx_msg void OnViewHexadecimal();
	afx_msg void OnUpdateViewHexadecimal(CCmdUI* pCmdUI);
	afx_msg void OnViewDisassemble();
	afx_msg void OnUpdateViewDisassemble(CCmdUI* pCmdUI);
	afx_msg void OnViewAscii();
	afx_msg void OnUpdateViewAscii(CCmdUI* pCmdUI);
	afx_msg void OnViewUnsigneddecimal();
	afx_msg void OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg long OnXMRepaint(UINT,LONG);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnEditGoto();
	afx_msg void OnUpdateEditGoto(CCmdUI* pCmdUI);
	afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
	afx_msg void OnViewRefresh();
	afx_msg void OnUpdateViewRefresh(CCmdUI* pCmdUI);
	afx_msg void OnEditSearch();
	afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
	afx_msg void OnEditSearchnext();
	afx_msg void OnUpdateEditSearchnext(CCmdUI* pCmdUI);
	afx_msg void OnGroupMemory();
	afx_msg void OnUpdateMap(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGroupMemory(CCmdUI* pCmdUI);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg void OnViewShortline();
	afx_msg void OnUpdateViewShortline(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnStkTab();
	afx_msg void OnShiftf10();
	afx_msg void OnOptionsMap();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

struct dsm
{
        DWORD address;
        char code[10];
        char instruction[256];
};

#endif
