/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MYEDIT2.H
//
//  Description:The header file for the class: CMyEdit2
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////
// myedit2.h
// Lane Li
// 95/7
////////////////////////////////////////////
#ifndef _MYEDIT2_H_
#define _MYEDIT2_H_

class CMyEdit2 : public CEdit
{
protected:
    WORD    m_wParseStyle;      // C++ member data
    long    m_nMin, m_nMax;           
    
public:
    UINT  m_uAddOrLen;
    UINT  m_uWhichEdit;
// Construction
    CMyEdit2();

    BOOL Create(DWORD dwStyle /* includes PES_ style*/, const RECT& rect,
        CWnd* pParentWnd, UINT nID);
    BOOL SubclassEdit(UINT nID, CWnd* pParent, WORD wParseStyle);
    static BOOL RegisterControlClass();
    void SetRange(long nMin, long nMax)
    { 
        ASSERT(nMax >= nMin);
        m_nMin = nMin; m_nMax = nMax; 
    }
    
// Overridables
    virtual void OnBadInput();

// Implementation
protected:
    //{{AFX_MSG(CMyEdit2)
    afx_msg void OnChar(UINT, UINT, UINT); // for character validation
    afx_msg void OnVScroll(UINT, UINT, CScrollBar*); // for spin buttons
    //}}AFX_MSG

    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////
// Parsed edit control sub-styles

#define PES_NUMBERS         0x0001
#define PES_LETTERS         0x0002
#define PES_OTHERCHARS      0x0004
#define PES_ALL             0xFFFF

///////////////////////////////////////////////////////////////////
// Extra control notifications

// above the range for normal EN_ messages
#define PEN_ILLEGALCHAR     0x8000
            // sent to parent when illegal character hit
            // return 0 if you want parsed edit to beep

#endif
//////////////////////////////(EOF)////////////////////////////////////
