/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MYLIST.H
//
//  Description:The header file of main list for Peripheral window
//
//  Author:     Jerry Yan 
//				modify by Richard Guo
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _mylist_
#define _mylist_

#include "percore.h"
/*
#define PERI_BITITEM    0x80000000
#define PERI_EXPANDED   0x40000000
#define PERI_ADDR		0x0000ff00
#define PERI_VALUE		0x000000ff
#define PERI_STRING     0x0fff0000
#define PERI_ADDR_OFFSET    8
#define PERI_VALUE_OFFSET   0
#define PERI_STRING_OFFSET  16     
*/

#define PERI_LEVEL_WIDTH 16
	
/////////////////////////////////////////////////////////////////////////////
// CMyList window

class CMyList : public CListBox
{
// Construction
public:
	CMyList(CWnd*);

// Attributes
protected:
   CPerCore* lpPerCore;
   
   CBitmap *m_pCloseBmp;
   CBitmap *m_pOpenBmp; 
   
   BOOL 	m_bLoadBmp;
   
// Operations
public:   
   int InsertChildItem(int index);
   int InsertOffspringItem(int index);
   int DeleteOffspringItem(int index);   
   
   BOOL CurTopItem(WORD wBaseID, int &index);
   
   BOOL InitList();
// Implementation
public:
	virtual ~CMyList();
    void ResetContent();
protected:
    void DrawLine(CDC *pDC,PERI_DRAWDATA*lpData,CRect rect,BOOL) ;
	// Generated message map functions
	//{{AFX_MSG(CMyList)
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg  void OnLButtonUp(UINT nFlags,CPoint point);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	virtual void MeasureItem(LPMEASUREITEMSTRUCT lpMIS);
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDIS);
	DECLARE_MESSAGE_MAP()
};

#endif

/*****************************end of file***************************/
