/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  PAREDIT.CPP
//
//  Description:The implement file for the class: CParsedEdit
//
//  Author:     Roger Zhang
//
//  Date:       04/07/95
//
//  Modification:
//
//      1. 04/07/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "paredit.h"

/////////////////////////////////////////////////////////////////////////////
// ParsedEdit

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CParsedEdit::CParsedEdit()
: m_wParseStyle(0), m_nMin(0), m_nMax(0)
{
}

BEGIN_MESSAGE_MAP(CParsedEdit, CEdit)
    //{{AFX_MSG_MAP(CParsedEdit)
    ON_WM_CHAR()
    ON_WM_VSCROLL()     // for associated spin controls
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Creating from C++ code

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CParsedEdit::Create(DWORD dwStyle, const RECT& rect,
        CWnd* pParentWnd, UINT nID)
{
    m_wParseStyle = LOWORD(dwStyle);
    // figure out edit control style
    DWORD dwEditStyle = MAKELONG(ES_LEFT, HIWORD(dwStyle));
    return CWnd::Create("EDIT", NULL, dwEditStyle, rect, pParentWnd, nID);
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Aliasing on top of an existing Edit control
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CParsedEdit::SubclassEdit(UINT nID, CWnd* pParent, WORD wParseStyle)
{
    m_wParseStyle = wParseStyle;

    // SubclassWindow requires an HWND so we call the Windows GetDlgItem
    // and avoid creating a tempory CWnd and then calling GetSafeHwnd
    HWND hWndEdit = ::GetDlgItem(pParent->m_hWnd, nID);
    if (hWndEdit == NULL)   return FALSE;
    else return SubclassWindow(hWndEdit);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Input character filter
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CParsedEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    WORD type;

    if(nChar < 0x20)    type = PES_ALL;     // always allow control chars
    else if(nChar >= '0' && nChar <= '9')   type = PES_NUMBERS;
    else if(nChar >= 'A' && nChar <= 'Z')   type = PES_LETTERS;
    else if(nChar >= 'a' && nChar <= 'z')   type = PES_LETTERS;
    else                                    type = PES_OTHERCHARS;

    if (m_wParseStyle & type)
        CEdit::OnChar(nChar, nRepCnt, nFlags);  // permitted
    else        // illegal character - inform parent
        OnBadInput();
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Spin controls will send scroll messages
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CParsedEdit::OnVScroll(UINT nSBCode, UINT, CScrollBar*)
{
    int nDelta = 0;
    if(nSBCode == SB_LINEDOWN)        nDelta = -1;
    else if(nSBCode == SB_LINEUP)     nDelta = +1;
    else        return; // nothing special

    // set the focus to this edit item and select it all
    SetFocus();

    //Get the number in the control.
    BOOL bOk;
    int nOld = GetParent()->GetDlgItemInt(GetDlgCtrlID(), &bOk);
    if(bOk) {
        // The MuScroll control also supports range checking
        // for this example, we just prevent overflow
        int nNew = nOld + nDelta;
        if(nNew >= m_nMin && nNew <= m_nMax)
            GetParent()->SetDlgItemInt(GetDlgCtrlID(), nNew);
        else    bOk = FALSE;
    }

    if (!bOk)   OnBadInput();
    SetSel(0, -1);
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: default bad input handler, beep (unless parent notification
//      returns -1). Most parent dialogs will return 0 or 1 for command
//      handlers (i.e. Beep is the default)
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CParsedEdit::OnBadInput()
{
    if (GetParent()->SendMessage(WM_COMMAND,
        GetDlgCtrlID(), MAKELONG(m_hWnd, PEN_ILLEGALCHAR)) != -1)
        MessageBeep(-1);
}

//////////////////////////////////(EOF)//////////////////////////////////////
