
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/PER6VIEW.CPP   1.7.1.6   18 Oct 1996 09:48:00   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/PER6VIEW.CPP  $
** 
**    Rev 1.7.1.6   18 Oct 1996 09:48:00   ZJRD
** EasyPack/SLD Version 2.00
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:32   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:04   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:08   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:58   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:30   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:34   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.3   16 May 1996 09:04:12   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:04   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.29   18 Apr 1996 12:58:48   Shirley
** No change.
** 
**    Rev 1.28   12 Apr 1996 10:38:54   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.26   15 Feb 1996 08:51:50   Shirley
** No change.
** 
**    Rev 1.25   12 Feb 1996 14:06:18   Shirley
** No change.
** 
**    Rev 1.24   06 Feb 1996 15:32:50   Shirley
** No change.
** 
**    Rev 1.23   06 Feb 1996 13:47:04   Shirley
** No change.
** 
**    Rev 1.22   01 Feb 1996 10:13:38   Shirley
** No change.
** 
**    Rev 1.21   26 Jan 1996 09:17:52   Shirley
** No change.
** 
**    Rev 1.20   25 Jan 1996 13:17:46   Shirley
** No change.
** 
**    Rev 1.19   24 Jan 1996 10:37:12   Shirley
** No change.
** 
**    Rev 1.18   23 Jan 1996 11:22:40   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.16   15 Jan 1996 16:10:30   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.14   30 Nov 1995 09:13:10   Shirley
** No change.
** 
**    Rev 1.13   28 Nov 1995 15:35:30   Shirley
** No change.
** 
**    Rev 1.12   21 Nov 1995 11:24:42   Shirley
** No change.
** 
**    Rev 1.11   13 Nov 1995 09:25:36   Shirley
** No change.
** 
**    Rev 1.10   12 Nov 1995 11:28:34   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.9   08 Nov 1995 16:29:20   Shirley
** No change.
** 
**    Rev 1.8   08 Nov 1995 12:39:50   Shirley
** No change.
** 
**    Rev 1.7   02 Nov 1995 10:08:14   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.1   29 Sep 1995 09:53:14   Shirley
** No change.
** 
**    Rev 1.0   20 Sep 1995 10:56:44   Shirley
** Initial revision.
** 
**    
** 
** 
**
**
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  PER6VIEW.CPP
//
//  Description:The implementation file of the CPer6View class for Peripheral window
//
//  Author:     Jerry Yan
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// per6view.cpp : implementation of the CPer6View class
//

#include "stdafx.h"
#include "resource.h"
//#include "xview.h"

#include "per6doc.h"
#include "per6view.h"
#include "flddlg.h"

#include "mylist.h" 
#include "listcol.h"   
#include "spin.h" 
#include "perwin.h"
#include "abiextfn.h"    
//#include "uicom3.h"  
#include "uicom2.h"
//#include "cpucom.h"
#include "cpusvr.h"
#include "perbase.h"   
                          
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif          

WORD cpuid; 
HINSTANCE hPerLib;   

extern BOOL IsEpRunning();

/////////////////////////////////////////////////////////////////////////////
// CPer6View

IMPLEMENT_DYNCREATE(CPer6View, CView)

BEGIN_MESSAGE_MAP(CPer6View, CView)
    //{{AFX_MSG_MAP(CPer6View)
    ON_WM_CREATE()  
    ON_WM_SIZE()
    ON_LBN_DBLCLK(IDC_LIST1, OnDblclkList1)
    ON_COMMAND(ID_VIEW_FRESH, OnFresh)
    ON_COMMAND(ID_VIEW_COMPRESS, OnViewCompress)
    ON_COMMAND(ID_VIEW_EXPAND, OnViewExpand)
	ON_WM_RBUTTONDOWN()
	ON_WM_SETFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
    //ON_COMMAND(IDR_FILE_EXIT, OnFileExit)

/////////////////////////////////////////////////////////////////////////////
// CPer6View construction/destruction

CPer6View::CPer6View()
{     
     m_Expanded=FALSE;   
		        
     m_lpRegList = NULL;
}

CPer6View::~CPer6View()
{ 

	FreeLibrary(hPerLib);
	if(m_lpRegList)	delete m_lpRegList;       
}

/////////////////////////////////////////////////////////////////////////////
// CPer6View drawing

void CPer6View::OnDraw(CDC* /*pDC*/)
{
    CPer6Doc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CPer6View diagnostics

#ifdef _DEBUG
void CPer6View::AssertValid() const
{
    CView::AssertValid();
}

void CPer6View::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CPer6Doc* CPer6View::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPer6Doc)));
    return (CPer6Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPer6View message handlers 

int CPer6View::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;
 /////////////////////////////////////////////////    
	if (!LoadPerLib()) return -1;
	  
    m_lpRegList = (CListBox*)(new CMyList(this));
    m_lpRegList->ShowWindow(SW_SHOW);
    return 0;
}

BOOL CPer6View::LoadPerLib()
{
	
	cpuid = GetCpuId();
	     
 //////////////////////////////////////////
    LPSTR lpDLLName; 
    
    if (cpuid>=EP9X_CPUID_START && cpuid<=EP9X_CPUID_END)
         lpDLLName = "ICE9X.DLL";
	else if (cpuid>=EP196KA_CPUID_START && cpuid<=EP196KA_CPUID_END)
         lpDLLName = "ICE196KA.DLL";
	else if (cpuid>=EP196KB_CPUID_START && cpuid<=EP196KB_CPUID_END)
         lpDLLName = "ICE196KA.DLL";
	else if (cpuid>=EP196KC_CPUID_START && cpuid<=EP196KC_CPUID_END)
         lpDLLName = "ICE196KA.DLL";
	else if (cpuid>=EP196MC_CPUID_START && cpuid<=EP196MH_CPUID_END)
         lpDLLName = "ICE196MX.DLL";
	else{
         AfxMessageBox("No Information for this CPU!",MB_OK);
//               ErrDisplayError(ER_PRE_CPU_NO_INFO);
         return FALSE;
    	}

    if ( (hPerLib= LoadLibrary(lpDLLName)) < HINSTANCE_ERROR)
	{
//		ErrDisplayError(ER_PRE_CPU_NO_INFO);
		return FALSE;
	 }  
	
	return TRUE;
}

void CPer6View::OnSize(UINT nType, int cx, int cy)
{   
	
    CView::OnSize(nType, cx, cy);
    
    CRect rect(0,0,0,0);   
   	GetClientRect(&rect) ; 
	rect.InflateRect(::GetSystemMetrics(SM_CXBORDER),::GetSystemMetrics(SM_CYBORDER)); 
	GetDlgItem(IDC_LIST1)->MoveWindow(&rect,TRUE);
}

void CPer6View::OnDblclkList1()
{
    if (IsEpRunning()){
    	AfxMessageBox("Ep is running");
		return;
	}
	
    int cursel;
    cursel=( (CListBox*)GetDlgItem(IDC_LIST1) )->GetCurSel(); 
    
    
    HINSTANCE hLibrary;
    if ((hLibrary = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
        int k;
        k=0;
//      AfxMessageBox("Can not do this test without custom control library",MB_OK);
//		ErrDisplayError(ER_PRE_NO_LIBRARY);
     } 
    
    	                                               
    CDialog* lpRegBitDlg= new CFldDlg(this,cursel); 
    
    if (lpRegBitDlg)
    {
    	lpRegBitDlg->DoModal();
    	delete lpRegBitDlg;
    }
    
    FreeLibrary(hLibrary);
}

void CPer6View::OnFresh()
{   
    ((CMyList*)GetDlgItem(IDC_LIST1))->ResetContent(); 
    ((CMyList*)GetDlgItem(IDC_LIST1))->InitList();
}


void CPer6View::OnViewCompress()
{                                 
    m_Expanded=FALSE;
    int i=0;
	PERI_DRAWDATA *lpDrawData;    
	int nCount = ((CListBox*)(GetDlgItem(IDC_LIST1)))->GetCount();
    while (i < nCount)
    { 
      lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(GetDlgItem(IDC_LIST1)))->GetItemDataPtr(i));
      if( !(lpDrawData->isBit) )  //OBYTE(LOWORD(dw)) )) 
         {
            if(lpDrawData->isExpanded)
               { 
//                  ((CListBox*)GetDlgItem(IDC_LIST1))->DeleteString(i);
//                  ((CListBox*)GetDlgItem(IDC_LIST1))->InsertString(i,(LPSTR)lpDrawData);
//                  ((CListBox*)GetDlgItem(IDC_LIST1))->SetItemDataPtr(i,lpDrawData);
                  nCount -= ((CMyList*)(GetDlgItem(IDC_LIST1)))->DeleteOffspringItem(i);
                }
         }                     
      i++;
    } 
    ((CListBox*)GetDlgItem(IDC_LIST1))->SetCurSel(0);   
}

void CPer6View::OnViewExpand()
{
    m_Expanded=TRUE;
    int i = 0;  
    int nCount = ((CListBox*)(GetDlgItem(IDC_LIST1)))->GetCount();
	PERI_DRAWDATA *lpDrawData;
    while (i<nCount)
    { 
      lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(GetDlgItem(IDC_LIST1)))->GetItemDataPtr(i));
      if(!(lpDrawData->isBit) ) 
      {
          if(!(lpDrawData->isExpanded) )
          { 
//              ((CListBox*)GetDlgItem(IDC_LIST1))->DeleteString(i);
//              ((CListBox*)GetDlgItem(IDC_LIST1))->InsertString(i,(LPSTR)lpDrawData);
//              ((CListBox*)GetDlgItem(IDC_LIST1))->SetItemDataPtr(i,lpDrawData);
              nCount += ((CMyList*)(GetDlgItem(IDC_LIST1)))->InsertChildItem(i);
          }
      }                 
      i++;
    }                   
}



void CPer6View::OnRButtonDown(UINT, CPoint point) 
{

    CMenu m_menu;
    m_menu.CreatePopupMenu() ;  
    m_menu.AppendMenu(MF_STRING	,ID_VIEW_COMPRESS,"&Compress All");	
    m_menu.AppendMenu(MF_STRING	,ID_VIEW_EXPAND,"&Expand All");
	
	ClientToScreen(&point);
    m_menu.TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
	m_menu.DestroyMenu();
}
/*
void CPer6View::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	CRect rect;  
	CPen pen,*pOldPen;
	pen.CreatePen(PS_INSIDEFRAME,2,RGB(0,0,0,));
	pOldPen=dc.SelectObject(&pen);
	GetClientRect(&rect);
	rect.bottom=20;
	rect.left=43;           
	
	dc.DrawText("Address",-1,&rect,DT_LEFT|DT_VCENTER);
	rect.left=80;
	dc.DrawText("Value",-1,&rect,DT_LEFT|DT_VCENTER);
		rect.left=150;
	dc.DrawText("Description",-1,&rect,DT_LEFT|DT_VCENTER);	
	// TODO: Add your message handler code here
	dc.SelectObject(pOldPen);
	pen.DeleteObject();
	// Do not call CView::OnPaint() for painting messages
}
*/
void CPer6View::OnSetFocus(CWnd* pOldWnd)
{
//	CView::OnSetFocus(pOldWnd);
	
	// TODO: Add your message handler code here
    if (m_lpRegList)
    	m_lpRegList->SetFocus();
	
}
