
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SAVECFG.CPP   1.7.1.0.1.2   09 Dec 1996 10:16:06   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SAVECFG.CPP  $
** 
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SAVECFG.CPP
//
//  Description:The implement file for the class: CSavecfgDialog
//
//  Author:     Roger Zhang
//
//  Date:       04/14/95
//
//  Modification:
//
//      1. 04/14/95, Initial version 0.1
//
//      2. 09/08/95 0.1a
//
//          2.1 Fixed bug No.22
//              Modify function: OnInitDialog               
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "savecfg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
    
/////////////////////////////////////////////////////////////////////////////
static char BASED_CODE szFilter[] = 
    "Config Files(*.cfg)|*.cfg|Event Files(*.evt)|*.evt"
    "|Map Files(*.map)|*.map|Qualify Files(*.qlf)|*.qlf"
    "|All Files(*.*)|*.*||";    
    
/////////////////////////////////////////////////////////////////////////////
// CSavecfgDialog dialog


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CSavecfgDialog::CSavecfgDialog(BOOL isSave)
: CFileDialog(TRUE, ".cfg", "*.cfg", 
  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, ::szFilter, NULL),
  m_nMap(1), m_nEvent(1), m_nQualify(1), m_isSave(isSave)
{                  
    m_ofn.lpstrTitle = m_isSave ? "Save Configuration" 
        : "Restore Configuration";
        
    if(isSave)  m_nIDHelp = IDD_SAVE_CONFIG;
    else    m_nIDHelp = IDD_RESTORE_CONFIG;        
    //{{AFX_DATA_INIT(CSavecfgDialog)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSavecfgDialog::DoDataExchange(CDataExchange* pDX)
{
    CFileDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CSavecfgDialog)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSavecfgDialog, CFileDialog)
    //{{AFX_MSG_MAP(CSavecfgDialog)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSavecfgDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSavecfgDialog::OnInitDialog()
{
    CFileDialog::OnInitDialog();
    
    // TODO: Add extra initialization here 

    CRect rect;
    GetWindowRect(rect);
    VERIFY(SetWindowPos(NULL, 50, 40, rect.Width() + 70, rect.Height() + 20,
        /*SWP_NOMOVE|*/SWP_NOZORDER|SWP_NOREDRAW|SWP_NOACTIVATE));

    CenterWindow();

    CRect rcCancel;
    GetDlgItem(IDCANCEL)->GetWindowRect(rcCancel);
    ScreenToClient(rcCancel);

    //CPoint   pt(rect.Width() - 80, rect.Height() - 100);
    CPoint   pt(rcCancel.left + 10, rect.Height() - 100);
    CRect rect1(pt.x, pt.y, pt.x + 105, pt.y + 20);                 
    CRect rect2(pt.x - 10, pt.y - 5, pt.x + 115, pt.y + 70);                 
    
    if(m_isSave)                                                     
        m_Stc.Create("Save What", WS_CHILD|WS_VISIBLE|SS_BLACKFRAME
            |WS_GROUP, rect2, this, IDC_SAVECFG_STATIC);
    else
        m_Stc.Create("Restore What", WS_CHILD|WS_VISIBLE|SS_BLACKFRAME
            |WS_GROUP, rect2, this, IDC_SAVECFG_STATIC);
                                                             
    m_btnMap.Create("&Map Setting",WS_VISIBLE|WS_TABSTOP|WS_CHILD|WS_GROUP
        |BS_AUTOCHECKBOX, rect1, this, IDC_SAVECFG_MAP);
    m_btnMap.SetFont(GetFont(), TRUE);
    
    rect1.OffsetRect(0, 22);
    m_btnEvent.Create("&Event Setting",WS_VISIBLE|WS_CHILD|WS_TABSTOP
        |WS_GROUP|BS_AUTOCHECKBOX, rect1, this, IDC_SAVECFG_EVENT);
    m_btnEvent.SetFont(GetFont(), TRUE);  
    
    rect1.OffsetRect(0, 25);
    m_btnQualify.Create("&Qualify Setting",WS_VISIBLE|WS_CHILD|WS_TABSTOP
        |WS_GROUP|BS_AUTOCHECKBOX, rect1, this, IDC_SAVECFG_QUALIFY);
    m_btnQualify.SetFont(GetFont(), TRUE);
    
    if(m_nMap)        m_btnMap.SetCheck(1);
    if(m_nEvent)      m_btnEvent.SetCheck(1);    
    if(m_nQualify)    m_btnQualify.SetCheck(1);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSavecfgDialog::OnOK()
{
    // TODO: Add extra validation here
    m_nMap     = m_btnMap.GetCheck();
    m_nEvent   = m_btnEvent.GetCheck();
    m_nQualify = m_btnQualify.GetCheck();
    
    CFileDialog::OnOK();
}

///////////////////////////////(EOF)/////////////////////////////////////////
