/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLBUF.H
//
//  Description:The header file for the class: ShellBuffer
//
//  Author:     Roger Zhang
//
//  Date:       03/22/95
//
//  Modification:
//
//      1. 03/22/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLBUF_
#define _SHLBUF_

/////////////////////////////////////////////////////////////////////////////    
const int  MAX_SHELL_LINES = 1000;//4096;  // lines of shell

/////////////////////////////////////////////////////////////////////////////
//  Line of the shell buffer
/////////////////////////////////////////////////////////////////////////////
class ShellBufLine
{
// attributes
public:
    int m_nLength;
    char * m_pchLine;   //  Not end with '\0'    
    BOOL m_isOK;

// constructor/destructor    
public:
    ShellBufLine();       
    ShellBufLine(char * pch, int nLen);
    ~ShellBufLine();
                         
// operations                         
public:
    void Shrink(void);
    int operator ! () const { return !m_isOK; }
};

/////////////////////////////////////////////////////////////////////////////
//  Shell Buffer
/////////////////////////////////////////////////////////////////////////////    
class ShellBuffer
{
// attributes
public:
    ShellBufLine * m_LinePtr[MAX_SHELL_LINES];
    int m_nLines;             
    BOOL m_isOK;

// constructor/destructor    
public:
    ShellBuffer();
    ~ShellBuffer();                       
                                     
// operations                         
public:
    BOOL AddLine(char * pch, int nLen);
    BOOL AddDispLine(char * pch, int nLen, BOOL isWS = TRUE);
    BOOL OvrDispLine(char * pch, int nLen);
    BOOL AddInputLine(void);
    void Shrink(void) { m_LinePtr[m_nLines - 1]->Shrink(); }
    int operator ! () const { return !m_isOK; }
};

#endif
///////////////////////(EOF)/////////////////////////////////////////////////
