
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLCOLOR.CPP
//
//  Description:The implement file of the class ShellSyntaxColor
//
//  Author:     Annie Yi
//
//  Date:       07/29/96
//
//  Modification:
//
//      1. 07/29/96, Initial version 
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
                                           
/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include <ctype.h>
#include <direct.h>

#include "colors.h" 
#include "address.h"
//#include "addrapi.h"
#include "aliaspub.h"
#include "syncore.h"
#include "syntax.h"
  
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
  

/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.     

/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern HintsList* pHintsList;

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.

/////////////////////////////////////////////////////////////////////////////
// External function prototypes.

 

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

void CSyntaxCheck::SetSyntaxColor(int nPos, int& nArgc, SynColor syncolor[])
{

    // Reset the error ID.
    m_nErrorID = 0;
    
    // Dispatch the syntax checking routine.
    switch ( m_nCommandID ) {    
        case CMDID_RUNMACRO:
			SetSyntaxColorRunMacro(nPos, nArgc, syncolor);
			break;
		case CMDID_VARDEFINE:
			SetSyntaxColorVarDefine(nPos, nArgc, syncolor);
			break;			
		case CMDID_ALIAS:
			SetSyntaxColorAlias(nPos, nArgc, syncolor);
			break;	
        case CMDID_ASSEMBLE:
            SetSyntaxColorAssemble(nPos, nArgc, syncolor);
            break;
/*
		case CMDID_BIT:
			SetSyntaxColorBit(nPos, nArgc, syncolor);
			break;	                              
*/
        case CMDID_BREAKPOINT:
            SetSyntaxColorBreakpoint(nPos, nArgc, syncolor);
            break;           
		case CMDID_BYTE:
			SetSyntaxColorByte(nPos, nArgc, syncolor);
			break;	                              
        case CMDID_CHECKSUM:
            SetSyntaxColorChecksum(nPos, nArgc, syncolor);
            break;
        case CMDID_CLEAR:
            SetSyntaxColorClear(nPos, nArgc, syncolor);
            break;             
        case CMDID_COMPARE:
            SetSyntaxColorCompare(nPos, nArgc, syncolor);
            break;
        case CMDID_CONTROL:
            SetSyntaxColorControl(nPos, nArgc, syncolor);
            break;
        case CMDID_COPY:         
        	//The syntax is same as Compare
            SetSyntaxColorCompare(nPos, nArgc, syncolor);
            break;
/*
        case CMDID_CYCLE:         
            SetSyntaxColorCycle(nPos, nArgc, syncolor);
            break;
*/
        case CMDID_DISASSEMBLE:
            SetSyntaxColorDisassemble(nPos, nArgc, syncolor);
            break;          
        case CMDID_DIAGNOSIS:
            //SetSyntaxColorDiagnosis(nPos, nArgc, syncolor);
        	break;       
        case CMDID_EV1:
        	SetSyntaxColorEv1(nPos, nArgc, syncolor);
        	break;	        	
        case CMDID_EV2:
        	SetSyntaxColorEv2(nPos, nArgc, syncolor);
        	break;	        	
        case CMDID_EV3:
        	SetSyntaxColorEv3(nPos, nArgc, syncolor);
        	break;	        
        case CMDID_EVENT:
            if ( m_nEvent == 0 )
            	SetSyntaxColorEvent(nPos, nArgc, syncolor);
			if ( m_nEvent == 1 )
            	SetSyntaxColorEv1(nPos, nArgc, syncolor);
            if ( m_nEvent == 2 )
            	SetSyntaxColorEv2(nPos, nArgc, syncolor);
            if ( m_nEvent == 3 )
            	SetSyntaxColorEv3(nPos, nArgc, syncolor);		             	
            break;                		
        case CMDID_FILL:
            SetSyntaxColorFill(nPos, nArgc, syncolor);
            break;
        case CMDID_GO:
            SetSyntaxColorGo(nPos, nArgc, syncolor);
            break;
        case CMDID_HALT:
            SetSyntaxColorHalt(nPos, nArgc, syncolor);
            break;
        case CMDID_HELP:
            SetSyntaxColorHelp(nPos, nArgc, syncolor);
            break;             
        case CMDID_IDENTIFY:
            SetSyntaxColorIdentify(nPos, nArgc, syncolor);
            break;
        case CMDID_INCLUDE:
            SetSyntaxColorInclude(nPos, nArgc, syncolor);                      
            break;
        case CMDID_INPORT:
            SetSyntaxColorInport(nPos, nArgc, syncolor);
            break;
        case CMDID_JUMP:
            SetSyntaxColorJump(nPos, nArgc, syncolor);
            break;    
        case CMDID_LEVEL:
        	SetSyntaxColorLevel(nPos, nArgc, syncolor);
        	break;
        case CMDID_LIST:
            SetSyntaxColorList(nPos, nArgc, syncolor);
            break;
        case CMDID_LOG:
            SetSyntaxColorLog(nPos, nArgc, syncolor);
            break;
        case CMDID_LONG:         
            SetSyntaxColorLong(nPos, nArgc, syncolor);
            break;
        case CMDID_LV1:
        	SetSyntaxColorLv1(nPos, nArgc, syncolor);
        	break;
        case CMDID_LV2:
        	SetSyntaxColorLv2(nPos, nArgc, syncolor);
        	break;	    
        case CMDID_MACRO:
        	SetSyntaxColorMacro(nPos, nArgc, syncolor); 
        	break;
        case CMDID_MAP:         
            SetSyntaxColorMap(nPos, nArgc, syncolor);
            break;
        case CMDID_MDEL:
        	SetSyntaxColorMdel(nPos, nArgc, syncolor); 
        	break;
        case CMDID_MEMORY:
            SetSyntaxColorMemory(nPos, nArgc, syncolor);
            break;
        case CMDID_MEND:
        	SetSyntaxColorMend(nPos, nArgc, syncolor); 
        	break;
        case CMDID_MLIST:
        	SetSyntaxColorMlist(nPos, nArgc, syncolor); 
        	break;
        case CMDID_OUTPORT:
            SetSyntaxColorOutport(nPos, nArgc, syncolor);
            break;
/*
        case CMDID_PORT:
            SetSyntaxColorPort(nPos, nArgc, syncolor);
            break;
*/
 		case CMDID_QUALIFY:
 			SetSyntaxColorQualify(nPos, nArgc, syncolor);
 			break; 
        case CMDID_REGISTER:
            SetSyntaxColorRegister(nPos, nArgc, syncolor);
            break;
        case CMDID_RESET:
            SetSyntaxColorReset(nPos, nArgc, syncolor);
            break;  
        case CMDID_RESTART:
        	SetSyntaxColorRestart(nPos, nArgc, syncolor);
        	break;    
        case CMDID_SEARCH:
            SetSyntaxColorSearch(nPos, nArgc, syncolor);
            break;              
        case CMDID_STEP:
            SetSyntaxColorStep(nPos, nArgc, syncolor);
            break;                      
        case CMDID_TEST:
            SetSyntaxColorTest(nPos, nArgc, syncolor);
            break;      
        case CMDID_TRACE:
        	SetSyntaxColorTrace(nPos, nArgc, syncolor);
        	break;
        case CMDID_TRIGGER:
        	SetSyntaxColorTrigger(nPos, nArgc, syncolor);
        	break;	    
        case CMDID_UPLOAD:
            SetSyntaxColorUpload(nPos, nArgc, syncolor);
            break;
        case CMDID_VERIFY:
            SetSyntaxColorVerify(nPos, nArgc, syncolor);
            break;
        case CMDID_WORD:
            SetSyntaxColorWord(nPos, nArgc, syncolor);
            break;
        case CMDID_CREATE:
            SetSyntaxColorCreate(nPos, nArgc, syncolor);
            break;
        case CMDID_DELETE:
            SetSyntaxColorDelete(nPos, nArgc, syncolor);
            break;
        case CMDID_LOAD:
            SetSyntaxColorLoad(nPos, nArgc, syncolor);
            break;
        case CMDID_QUERY:
            SetSyntaxColorQuery(nPos, nArgc, syncolor);
            break;
        case CMDID_SSAVE:
            SetSyntaxColorSsave(nPos, nArgc, syncolor);
            break;
        case CMDID_SRECALL:
            SetSyntaxColorSrecall(nPos, nArgc, syncolor);
            break;
        case CMDID_SYMBOL:
            SetSyntaxColorSymbol(nPos, nArgc, syncolor);
            break;
        case CMDID_WATCH:
            SetSyntaxColorWatch(nPos, nArgc, syncolor);
            break;
        default:
            ASSERT( FALSE );
            break;
    }              

}

void CSyntaxCheck::SetSyntaxColorInit(int& nArgc, SynColor syncolor[])
{
	int i;                        
	nArgc = pHintsList[m_nCommandID].nCount;
    for ( i = 0; i < nArgc; i++ ) {
   		syncolor[i].nColor = COLOR_BLACK; 	    
    }
	                                                  
	i = 0;	                                                  
   	POSITION posHead  = pHintsList[m_nCommandID].plistHints->GetHeadPosition();
    while (posHead) {
		syncolor[i].strText = pHintsList[m_nCommandID].plistHints->GetNext(posHead); 
		i++;
	}	
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::SetSyntaxColor***().
//
//  Description: Set Syntax color routine. 51 routines.
//
//  Input:  nPos - The total token number of shell line          
//
//  Output: nArgc - The total token number of hints
//          syncolor - The struct of hints
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////


void CSyntaxCheck::SetSyntaxColorRunMacro(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                          
			//@macroname (arg0,...,arg9)
			syncolor[2].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	
}


void CSyntaxCheck::SetSyntaxColorVarDefine(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
}


void CSyntaxCheck::SetSyntaxColorAlias(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
		
	switch (nPos) {
		case 1:                         
			//Alias (original_name)
			syncolor[2].nColor = COLOR_RED;						
			break;
		case 2:       
			//Alias original_name (new_name)
			syncolor[3].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorAssemble(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);

	switch (nPos) {
		case 1:                             
			//Assemble (adr)
			syncolor[2].nColor = COLOR_RED;						
			break;
        default:
        	break;  
     }   	

}

/*
void CSyntaxCheck::SetSyntaxColorBit(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:              
			//Bit (bit_adr)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:         
			//Bit bit_adr (data1)
			syncolor[2].nColor = COLOR_RED;			
			break;
		case 3:               
			//Bit bit_adr data1 (data32)
			syncolor[4].nColor = COLOR_RED;			
			break;    		
        default:
        	break;  
     }   	
}
*/

void CSyntaxCheck::SetSyntaxColorBreakpoint(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:            
			//Breakpoint (adr)
			syncolor[2].nColor = COLOR_RED;						
			break;
        default:
        	break;  
     }   	

}
                                       
void CSyntaxCheck::SetSyntaxColorByte(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:              
			//Byte (adr)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:         
			//Byte adr (data1)
			syncolor[2].nColor = COLOR_RED;			
			break;
		case 3:               
			//Byte adr data1 (data32)
			syncolor[4].nColor = COLOR_RED;			
			break;    		
        default:
        	break;  
     }   	
}
                                       

void CSyntaxCheck::SetSyntaxColorChecksum(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:               
			//Checksum (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:
			//Checksum adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;                       
		case 3:
			//Checksum adr1 Length length
			syncolor[6].nColor = COLOR_RED;			
			break;
        default: 
        	break;  
     }   	

}


void CSyntaxCheck::SetSyntaxColorClear(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);

	switch (nPos) {
		case 1:                          
			//Clear (All|adr)
			syncolor[2].nColor = COLOR_RED;				
			syncolor[4].nColor = COLOR_RED;			
			break;
		default:
			break;
	}			
}             

void CSyntaxCheck::SetSyntaxColorCompare(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                  
			//Compare (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:             
			//Compare adr1 (adr2|Length)                        
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;
		case 3:                         
			//Compare adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;			
			break;
		case 4:                           
			//Compare adr1 adr2 (adr3)
			//Compare adr1 Length length (adr3)
			syncolor[8].nColor = COLOR_RED;						
        default:
        	break;  
     }   	


}

void CSyntaxCheck::SetSyntaxColorControl(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                             
			//Control (Mclr|Watchdog|Peripheral)
			syncolor[2].nColor = COLOR_RED;						
			syncolor[4].nColor = COLOR_RED;									
			break;
		case 2:                             
			//Control Mclr (Enable|Disable)			
			syncolor[6].nColor = COLOR_RED;						
			syncolor[8].nColor = COLOR_RED;									
			break;
        default:
        	break;  
     }   	


}


void CSyntaxCheck::SetSyntaxColorCycle(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
}


void CSyntaxCheck::SetSyntaxColorDisassemble(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                            
			//Disassemble (adr1)
			syncolor[2].nColor = COLOR_RED;			
			break;
		case 2:                 
			//Disassemble adr1 (adr2|Length)
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			break;
		case 3:                             
			//Disassemble adr1 Length (length)
			syncolor[7].nColor = COLOR_RED;			
			break;
        default: 
        	break;  
     }   	
}

void CSyntaxCheck::SetSyntaxColorEv1(int nPos, int& nArgc,
	SynColor syncolor[])
{
	SetSyntaxColorInit(nArgc, syncolor);

	if ( m_nEvent == 1) {	
		syncolor[0].strText = "Event 1 ";
	}	
	
	switch (nPos) {
		case 1:
			//Ev1 (Address|Datum|Count|Clear)    
			syncolor[2].nColor = COLOR_RED;		//Address
			syncolor[12].nColor = COLOR_RED;	//Datum			
			syncolor[25].nColor = COLOR_RED;	//Count
			syncolor[28].nColor = COLOR_RED;	//Clear
			break;                          
		case 2:
			//Ev1 Address (Range|xadr|<badrs..>)
			syncolor[4].nColor = COLOR_RED;				
			syncolor[8].nColor = COLOR_RED;				
			syncolor[10].nColor = COLOR_RED;							
			break;
		case 3:
			//Ev1 Datum (Byte|Word)                
			syncolor[13].nColor = COLOR_RED;				
			syncolor[15].nColor = COLOR_RED;				
			break;
		case 4:
			//Ev1 Count (count)
			syncolor[26].nColor = COLOR_RED;				
			break;	
		case 5:
			//Ev1 Address Range (adr1)
			syncolor[5].nColor = COLOR_RED;
			break;
		case 6:
			//Ev1 Address Range adr1 (adr2)
			syncolor[6].nColor = COLOR_RED;
			break;
		case 7:
			//Ev1 Address ..(Datum|Count)
			syncolor[12].nColor = COLOR_RED;							
			syncolor[25].nColor = COLOR_RED;				
			break; 
		case 8:
			//Ev1 Datum Byte|Word (Range|xdata|bdata)
			syncolor[17].nColor = COLOR_RED;				
			syncolor[21].nColor = COLOR_RED;				
			syncolor[23].nColor = COLOR_RED;							
			break;             	
		case 9:
			//Ev1 Datum Byte|Word Range (data1)
			syncolor[18].nColor = COLOR_RED;				
			break;             	
		case 10:
			//Ev1 Datum Byte|Word Range data1 (data2)
			syncolor[19].nColor = COLOR_RED;				
			break;     
		case 11:
			//Ev1 Datum ..(Count)
			syncolor[25].nColor = COLOR_RED;				
			break;             	
       	default:
       		break;     										
	}		
}	
	

void CSyntaxCheck::SetSyntaxColorEv2(int nPos, int& nArgc,
	SynColor syncolor[])
{
	SetSyntaxColorInit(nArgc, syncolor);

	if ( m_nEvent == 2) {	
		syncolor[0].strText = "Event 2 ";
	}	
	
	switch (nPos) {
		case 1:
			//Ev2 (Address|Datum|Clear)    
			syncolor[2].nColor = COLOR_RED;				
			syncolor[12].nColor = COLOR_RED;							
			syncolor[25].nColor = COLOR_RED; //CLEAR				
			break;                          
		case 2:
			//Ev2 Address (Range|xadr|<badrs..>)
			syncolor[4].nColor = COLOR_RED;				
			syncolor[8].nColor = COLOR_RED;				
			syncolor[10].nColor = COLOR_RED;							
			break;
		case 3:
			//Ev2 Datum (Byte|Word)
			syncolor[13].nColor = COLOR_RED;				
			syncolor[15].nColor = COLOR_RED;				
			break;
		case 4:
			//Ev2 Address Range (adr1)
			syncolor[5].nColor = COLOR_RED;
			break;
		case 5:
			//Ev2 Address Range adr1 (adr2)
			syncolor[6].nColor = COLOR_RED;
			break;
		case 6:
			//Ev2 Address ..(Datum)
			syncolor[12].nColor = COLOR_RED;							
			break; 
		case 7:
			//Ev2 Datum Byte|Word (Range|xdata|bdata)
			syncolor[17].nColor = COLOR_RED;				
			syncolor[21].nColor = COLOR_RED;				
			syncolor[23].nColor = COLOR_RED;							
			break;             	
		case 8:
			//Ev2 Datum Byte|Word Range (data1)
			syncolor[18].nColor = COLOR_RED;				
			break;             	
		case 9:
			//Ev2 Datum Byte|Word Range data1 (data2)
			syncolor[19].nColor = COLOR_RED;				
			break;     
       	default:
       		break;     
	}		
}	

void CSyntaxCheck::SetSyntaxColorEv3(int nPos, int& nArgc,
	SynColor syncolor[])
{
	SetSyntaxColorInit(nArgc, syncolor);

	if ( m_nEvent == 3) {	
		syncolor[0].strText = "Event 3 ";
	}	
	
	switch (nPos) {
		case 1:
        	//Ev3 (High|Low)
        	syncolor[2].nColor = COLOR_RED;
            syncolor[4].nColor = COLOR_RED;
            break;
       	default:
       		break;     
   }         
}
	
void CSyntaxCheck::SetSyntaxColorEvent(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:        
			//Event (1|2|3|Clear)
			syncolor[2].nColor = COLOR_RED;			
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			syncolor[8].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	

}


void CSyntaxCheck::SetSyntaxColorFill(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Fill (adr1)
			syncolor[1].nColor = COLOR_RED;				
			break;
		case 2:          
			//Fill adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;				
			syncolor[5].nColor = COLOR_RED;				
			break;
		case 3:                      
			//Fill adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;						
			break;
		case 4:                 
			//Fill adr1 ...("string"|data..)
			syncolor[8].nColor = COLOR_RED;				
			syncolor[10].nColor = COLOR_RED;									
			break;
        default:                                                
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorGo(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:               
			//Go (Run|From|Till|Monitor)
			syncolor[2].nColor = COLOR_RED;				
			syncolor[7].nColor = COLOR_RED;				
			syncolor[10].nColor = COLOR_RED;				
			syncolor[13].nColor = COLOR_RED;				
			break;
		case 2: 
			//Go Run (From)
			syncolor[4].nColor = COLOR_RED;						
			break;
		case 3: 
			//Go From (adr1)
			syncolor[8].nColor = COLOR_RED;						
			break;    
		case 4:      
			//Go Till (adr2)
			syncolor[11].nColor = COLOR_RED;							
		    break;                                                            
		case 5:		 
			//Go Monitor (timer)
			syncolor[14].nColor = COLOR_RED;							
		    break;                                                            
		case 6:
			//Go Run From (adr1)
			syncolor[5].nColor = COLOR_RED;										
			break;
		case 7:
			//Go From adr1 (Till)
			syncolor[10].nColor = COLOR_RED;							
			break;
		case 8:
			//Go From adr1 Till (adr2)
			syncolor[11].nColor = COLOR_RED;										
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorHalt(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
}

void CSyntaxCheck::SetSyntaxColorHelp(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                  
			//Help (command)
			syncolor[2].nColor = COLOR_RED;							
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorIdentify(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
}

void CSyntaxCheck::SetSyntaxColorInclude(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:             
			//Include (filename)
			syncolor[1].nColor = COLOR_RED;									
			break;
        default:
        	break;  
     }   	

}


void CSyntaxCheck::SetSyntaxColorInport(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                            
			//Inport (port)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:          
			//Inport port (Bit|byte)
			syncolor[3].nColor = COLOR_RED;
			syncolor[6].nColor = COLOR_RED;
			break;
		case 3:       
			//Inport port Bit (bit_no)
			syncolor[4].nColor = COLOR_RED;
			break;    		
        default:
        	break;  
     }   	

}


void CSyntaxCheck::SetSyntaxColorJump(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                 
			//Jump (adr)
			syncolor[1].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorLevel(int nPos, int& nArgc, 
	SynColor syncolor[])
{
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {                   
		case 1:                       
			//Level (1|2)                   
			syncolor[2].nColor = COLOR_RED;	
			syncolor[4].nColor = COLOR_RED;	
			break;       
		case 2:
			//Level 1 (eventlogic)
			syncolor[6].nColor = COLOR_RED;	
			break;	
		default:
			break;	
	}
}

	
void CSyntaxCheck::SetSyntaxColorList(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:         
			//List (Number|frame|Address|Datum|Status)
			syncolor[2].nColor = COLOR_RED;		//Number	
			syncolor[4].nColor = COLOR_RED;		//frame
			syncolor[6].nColor = COLOR_RED;		//Address										
			syncolor[16].nColor = COLOR_RED;	//Datum
			syncolor[29].nColor = COLOR_RED;	//Status										
			break;                              
		case 3:        
			//List frame (Address|Datum|Status)
			syncolor[6].nColor = COLOR_RED;	 	//Address										
			syncolor[16].nColor = COLOR_RED;	//Datum
			syncolor[29].nColor = COLOR_RED;	//Status										
			break;                              
		case 4:        
			//List .. Address (Range|xadr|<badrs..>)
			syncolor[8].nColor = COLOR_RED;	//Range										
			syncolor[12].nColor = COLOR_RED;	//xadr
			syncolor[14].nColor = COLOR_RED;	//<badrs..>							
			break;			
		case 5:
			//List .. Address Range (adr1)
			syncolor[9].nColor = COLOR_RED;
			break;     			
		case 6:
			//List .. Address Range adr1 (adr2)
			syncolor[10].nColor = COLOR_RED;
			break;     			
        case 7:
        	//List .. Datum (Byte|Word)
        	syncolor[17].nColor = COLOR_RED;
        	syncolor[19].nColor = COLOR_RED;
        	break;
        case 8:
        	//List .. Status (<status..>)
        	syncolor[30].nColor = COLOR_RED;
        	break;	                                     
        case 9:
        	//List Address .. (Datum|Status)	
			syncolor[16].nColor = COLOR_RED;	//Datum
			syncolor[29].nColor = COLOR_RED;	//Status										
			break;                              
		case 10:
			//List Datum .. (Status)
			syncolor[29].nColor = COLOR_RED;	//Status
			break;
		case 12:
			//List Datum Byte|Word (Range|xdata|bdata)
			syncolor[21].nColor = COLOR_RED;	//Range
			syncolor[25].nColor = COLOR_RED;	//xdata
			syncolor[27].nColor = COLOR_RED;	//bdata									
			break;
        case 13:
        	//List Datum .. Range (data1)               
        	syncolor[22].nColor = COLOR_RED;	//data1
        	break;
        case 14:
        	//List Datum .. Range data1 (data2)               
        	syncolor[23].nColor = COLOR_RED;	//data2
        	break;             	
        default:
        	break;  
     }   	

}


void CSyntaxCheck::SetSyntaxColorLog(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:         
			//Log (filename|On|Off|Close)
			syncolor[2].nColor = COLOR_RED;	
			syncolor[8].nColor = COLOR_RED;											
			syncolor[10].nColor = COLOR_RED;											
			syncolor[12].nColor = COLOR_RED;	
			break;
		case 2:                          
			//Log filename (Command|Append)
			syncolor[4].nColor = COLOR_RED;	
			syncolor[6].nColor = COLOR_RED;	
			break;
		case 3:
			//Log filename Command (Append)
			syncolor[6].nColor = COLOR_RED;					
        default:
        	break;  
     }   	

}                                        

void CSyntaxCheck::SetSyntaxColorLong(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:              
			//Long (adr)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:         
			//Long adr (data1)
			syncolor[2].nColor = COLOR_RED;			
			break;
		case 3:               
			//Long adr data1 (data8)
			syncolor[4].nColor = COLOR_RED;			
			break;    		
        default:
        	break;  
     }   	
}
                                        
void CSyntaxCheck::SetSyntaxColorLv1(int nPos, int& nArgc, 
	SynColor syncolor[])
{
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                     
			//Lv1 (eventlogic)
			syncolor[2].nColor = COLOR_RED;
			break;
		default:
			break;	
	}
}
                                    
                                    
void CSyntaxCheck::SetSyntaxColorLv2(int nPos, int& nArgc, 
	SynColor syncolor[])
{
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Lv2 (eventlogic)
			syncolor[2].nColor = COLOR_RED;
			break;
		default:
			break;	
	}
}
                                    

void CSyntaxCheck::SetSyntaxColorMacro(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Macro (macroname)
			syncolor[1].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}                                      

void CSyntaxCheck::SetSyntaxColorMap(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);

	switch (nPos) { 
		case 1:                          
			//Map (All|adr1)
			syncolor[2].nColor = COLOR_RED;
			syncolor[5].nColor = COLOR_RED;
			break;    
		case 2:                          
			//Map All (adrtype)
			syncolor[3].nColor = COLOR_RED;
			break;    
		case 3:                          
			//Map adr1 (adr2|Length)
			syncolor[7].nColor = COLOR_RED;
			syncolor[9].nColor = COLOR_RED;
			break;    
		case 4:                          
			//Map All adrtype (map_attribute)
			syncolor[12].nColor = COLOR_RED;
			break;    
		case 5:                          
			//Map adr1 Length (length)
			syncolor[10].nColor = COLOR_RED;
			break;     					
        default:
        	break;  
     }   	

/*	
	switch (nPos) { 
		case 1:                          
			//Map (Combination|Seperation|All|adr1)
			syncolor[2].nColor = COLOR_RED;
			syncolor[4].nColor = COLOR_RED;
			syncolor[6].nColor = COLOR_RED;
			syncolor[9].nColor = COLOR_RED;
			break;    
		case 2:                          
			//Map All (adrtype)
			syncolor[7].nColor = COLOR_RED;
			break;    
		case 3:                          
			//Map adr1 (adr2|Length)
			syncolor[11].nColor = COLOR_RED;
			syncolor[13].nColor = COLOR_RED;
			break;    
		case 4:                          
			//Map All adrtype (map_attribute)
			syncolor[16].nColor = COLOR_RED;
			break;    
		case 5:                          
			//Map adr1 Length (length)
			syncolor[14].nColor = COLOR_RED;
			break;     					
        default:
        	break;  
     }   	
*/
}


void CSyntaxCheck::SetSyntaxColorMdel(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                
			//Mdel (macroname|All)
			syncolor[1].nColor = COLOR_RED;											
			syncolor[3].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorMemory(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1: 
			//Memory (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:           
			//Memory adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;
		case 3:                   
			//Memory adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;			
			break;
        default: 
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorMend(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
}

void CSyntaxCheck::SetSyntaxColorMlist(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                
			//Mlist (macroname)
			syncolor[2].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}


void CSyntaxCheck::SetSyntaxColorOutport(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Outport (port)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:  
			//Outport port (data)
			syncolor[2].nColor = COLOR_RED;									
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorQualify(int nPos, int& nArgc, 
	SynColor syncolor[])
{
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Qualify (Address|Datum|Status|Clear)    
			syncolor[2].nColor = COLOR_RED;				
			syncolor[12].nColor = COLOR_RED;				
			syncolor[25].nColor = COLOR_RED;				
			syncolor[28].nColor = COLOR_RED; //Clear				
			break;                          
		case 2:
			//Qualify Address (Range|xadr|<badrs..>)
			syncolor[4].nColor = COLOR_RED;				
			syncolor[8].nColor = COLOR_RED;				
			syncolor[10].nColor = COLOR_RED;							
			break;
		case 3:
			//Qualify Datum (Byte|Word)
			syncolor[13].nColor = COLOR_RED;				
			syncolor[15].nColor = COLOR_RED;				
			break;
		case 4:
			//Qualify Status (<status..>)
			syncolor[26].nColor = COLOR_RED;				
			break;
		case 6:
			//Qualify Address Range (adr1)
			syncolor[5].nColor = COLOR_RED;
			break;
		case 7:
			//Qualify Address Range adr1 (adr2)
			syncolor[6].nColor = COLOR_RED;
			break;
		case 8:
			//Qualify Address ..(Datum|Status)
			syncolor[12].nColor = COLOR_RED;				
			syncolor[25].nColor = COLOR_RED;				
			break; 
		case 10:
			//Qualify Datum Byte|Word (Range|xdata|bdata)
			syncolor[17].nColor = COLOR_RED;				
			syncolor[21].nColor = COLOR_RED;				
			syncolor[23].nColor = COLOR_RED;							
			break;             	
		case 11:
			//Qualify Datum Byte|Word Range (data1)
			syncolor[18].nColor = COLOR_RED;				
			break;             	
		case 12:
			//Qualify Datum Byte|Word Range data1 (data2)
			syncolor[19].nColor = COLOR_RED;				
			break;     
		case 13:
			//Qualify Datum ..(Status)
			syncolor[25].nColor = COLOR_RED;				
			break;             	        
		default:	
			break;
	}		
}


/*                                           
void CSyntaxCheck::SetSyntaxColorPort(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Port (port)
			syncolor[1].nColor = COLOR_RED;			
			break;
        default:
        	break;  
	}
}	                                           
*/                                           

void CSyntaxCheck::SetSyntaxColorRegister(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                
			//Register (reg_id)
			syncolor[2].nColor = COLOR_RED;
			break;
		case 2:                
			//Register reg_id (data)            
			syncolor[4].nColor = COLOR_RED;
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorReset(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);

	switch (nPos) {
		case 1:                     
			//Reset (adr)
			syncolor[2].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	
}
                                         
void CSyntaxCheck::SetSyntaxColorRestart(int /*nPos*/, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);

}


void CSyntaxCheck::SetSyntaxColorSearch(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Search (adr1)
			syncolor[1].nColor = COLOR_RED;				
			break;
		case 2:          
			//Search adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;				
			syncolor[5].nColor = COLOR_RED;				
			break;
		case 3:                      
			//Search adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;						
			break;
		case 4:                 
			//Search adr1 ...(Insensitive|"string"|data..)
			syncolor[8].nColor = COLOR_RED;							
			syncolor[10].nColor = COLOR_RED;				
			syncolor[12].nColor = COLOR_RED;					
			break;				
		case 5:
			//Search adr1 adr2 Insensitive ("string")
			syncolor[10].nColor = COLOR_RED;					
			break;
        default:                                                
        	break;  
     }   	

}


void CSyntaxCheck::SetSyntaxColorStep(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);

	switch (nPos) {
		case 1:        
			//Step  (Over|Forever|Out)
			syncolor[2].nColor = COLOR_RED;											
			syncolor[4].nColor = COLOR_RED;											
			syncolor[6].nColor = COLOR_RED;											
            break;
        case 2:
        	//Step Over (Forever)
        	syncolor[4].nColor = COLOR_RED;											
        	break;
        default:
        	break;
    }    		    
/*	
	switch (nPos) {
		case 1:        
			//Step (Over|count|Forever|adr1|Till|Till)
			syncolor[2].nColor = COLOR_RED;											
			syncolor[4].nColor = COLOR_RED;											
			syncolor[6].nColor = COLOR_RED;											
			syncolor[8].nColor = COLOR_RED;											
			syncolor[11].nColor = COLOR_RED;											 
			syncolor[17].nColor = COLOR_RED;											
			break;
		case 2:   
			//Step Over (count|Forever|adr1|Till|Till)
			syncolor[4].nColor = COLOR_RED;											
			syncolor[6].nColor = COLOR_RED;											
			syncolor[8].nColor = COLOR_RED;											
			syncolor[11].nColor = COLOR_RED;
			syncolor[17].nColor = COLOR_RED;											
			break;
		case 3:
			//Step adr1 (adr2)
			syncolor[9].nColor = COLOR_RED;											
			break;    
		case 4:	
			//Step Till (Ret|Call|@reg|adr)
        	syncolor[13].nColor = COLOR_RED;											
        	syncolor[15].nColor = COLOR_RED;
        	syncolor[19].nColor = COLOR_RED;											
        	syncolor[21].nColor = COLOR_RED;
        	break;
        case 5:   
        	//Step Over Till @reg (Is)
        	syncolor[23].nColor = COLOR_RED;											
        	break;	
		case 6:
        	//Step Over Till @reg Is (value)
        	syncolor[24].nColor = COLOR_RED;											
        	break;	
        default:
        	break;  
     }   	
*/
}


void CSyntaxCheck::SetSyntaxColorTest(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:          
			//Test (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:          
			//Test adr1 (adr2|Length)
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;
		case 3:                      
			//Test adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;			
			break;
		
        default:
        	break;  
     }   	                            

}


void CSyntaxCheck::SetSyntaxColorTrace(int nPos, int& nArgc, 
	SynColor syncolor[])
{                
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:          
			//Trace (On|Off|Clear)
			syncolor[2].nColor = COLOR_RED;			
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			break;
        default:
        	break;  
	}
}
                                       
void CSyntaxCheck::SetSyntaxColorTrigger(int nPos, int& nArgc, 
	SynColor syncolor[])
{
	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:         
			//Trigger (Run|Lv1|Lv2|Lv1|On|Off)      
			syncolor[2].nColor = COLOR_RED;			
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			syncolor[8].nColor = COLOR_RED;			
			syncolor[21].nColor = COLOR_RED;			
			syncolor[23].nColor = COLOR_RED;			
			break;     
		case 2:
			//Trigger run (Lv1|Lv2|Lv1)	
			syncolor[4].nColor = COLOR_RED;			
			syncolor[6].nColor = COLOR_RED;			
			syncolor[8].nColor = COLOR_RED;			
			break;
		case 3:
			//Trigger Lv1 (then|Forward|Backward|Center|Delay)
			syncolor[9].nColor = COLOR_RED;			
			syncolor[12].nColor = COLOR_RED;			
			syncolor[14].nColor = COLOR_RED;			
			syncolor[16].nColor = COLOR_RED;			
			syncolor[18].nColor = COLOR_RED;			
			break;	
		case 4:
			//Trigger Lv1 Delay (count)				
			syncolor[19].nColor = COLOR_RED;			
			break;	  
		case 5:
			//Trigger Lv1 then (Lv2)
			syncolor[10].nColor = COLOR_RED;				
			break;            
		case 6:	
			//Trigger Lv2(Forward|Backward|Center|Delay)
			syncolor[12].nColor = COLOR_RED;			
			syncolor[14].nColor = COLOR_RED;			
			syncolor[16].nColor = COLOR_RED;			
			syncolor[18].nColor = COLOR_RED;			
			break;				
		default:
			break;	
	}
}
                                       

void CSyntaxCheck::SetSyntaxColorUpload(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                             
			//Upload (adr1)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:            
			//Upload adr1 (adr2|Length)                         
			syncolor[3].nColor = COLOR_RED;			
			syncolor[5].nColor = COLOR_RED;			
			break;
		case 3:                        
			//Upload adr1 Length (length)
			syncolor[6].nColor = COLOR_RED;			
			break;
		case 4:                          
			//Upload adr1 adr2 (filename)
			syncolor[8].nColor = COLOR_RED;						
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorVerify(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                          
			//Verify (On|Off)
			syncolor[2].nColor = COLOR_RED;			
			syncolor[4].nColor = COLOR_RED;			
			break;
        default:
        	break;  
     }   	

}


void CSyntaxCheck::SetSyntaxColorWord(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:              
			//Word (adr)
			syncolor[1].nColor = COLOR_RED;			
			break;
		case 2:         
			//Word adr (data1)
			syncolor[2].nColor = COLOR_RED;			
			break;
		case 3:               
			//Word adr data1 (..data16)
			syncolor[4].nColor = COLOR_RED;			
			break;    		
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorCreate(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                        
			//Create (#symbol)             
			syncolor[1].nColor = COLOR_RED;					
			break;
		case 2:               
			//Create #symbol (adr)
			syncolor[2].nColor = COLOR_RED;					
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorDelete(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                   
			//Delete (#symbol|$variable|All)                          
			syncolor[1].nColor = COLOR_RED;					
			syncolor[3].nColor = COLOR_RED;					
			syncolor[5].nColor = COLOR_RED;													
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorLoad(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Load (filename)
			syncolor[1].nColor = COLOR_RED;					
			break;
		case 2:
			//Load filename (Symbols|Nosymbols|Code|Nocode|Warn|Nowarn|Append|Noappend|P0|P1|P2|P3)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 3:   
			//Load filename Symbols (..)		
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn				
			syncolor[13].nColor = COLOR_RED;	//Nowarn				
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 4:
			//Load filename Code (..)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[11].nColor = COLOR_RED;	//Warn				
			syncolor[13].nColor = COLOR_RED;	//Nowarn				
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;          
		case 5:
			//Load filename Symbols Code (..)
			syncolor[11].nColor = COLOR_RED;	//Warn				
			syncolor[13].nColor = COLOR_RED;	//Nowarn				
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 6:
			//Load filename Append (Symbols|Nosymbols|Code|Nocode|Warn|Nowarn|P0|P1|P2|P3)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 7:			
			//Load filename Symbos Append(...)
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 8:
			//Load filename Code Append(...)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 9:
			//Load filename Symbols Code Append (Warn|Nowarn|P0|P1|P2|P3)
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 10:
			//Load filename Warn (..)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code				
			syncolor[9].nColor = COLOR_RED;		//Nocode				
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 11:
			//Load filename Symbols Warn (..)
			syncolor[7].nColor = COLOR_RED;		//Code				
			syncolor[9].nColor = COLOR_RED;		//Nocode				
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 12:
			//Load filename Code Warn (..)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 13:			
			//Load filename Symbols Warn Code (P0|P1|P2|P3|Append|Noappend)	
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 14:
			//Load filename Warn Append(...)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 15:
			//Load filename Symbols Warn Append (Code|Nocode|P0|P1|P2|P3)
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 16:
			//Load filename Code Warn Append (Symbols|Nosymbols|Nowarn|P0|P1|P2|P3)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;
		case 17:
			//Load filename Symbols Warn Code Append(P0)	
			syncolor[19].nColor = COLOR_RED;	//P0
			syncolor[21].nColor = COLOR_RED;	//P1
			syncolor[23].nColor = COLOR_RED;	//P2
			syncolor[25].nColor = COLOR_RED;	//P3
			syncolor[27].nColor = COLOR_RED;	//X0
			syncolor[29].nColor = COLOR_RED;	//X1
			break;                               
		case 18:
			//Load filename P0 (Symbols|Nosymbols|Code|Nocode|Warn|Nowarn|Append|Noappend)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			break;
		case 19:
			//Load filename Symbols P0 (Code|Nocode|Warn|Nowarn|Append|Noappend)
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			break;
    	case 20:
			//Load filename Code P0 (Symbols|Nosymbols|Warn|Nowarn|Append|Noappend)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			break;
		case 21:
			//Load filename Symbols Code P0 (Warn|Nowarn|Append|Noappend)
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			break;
		case 22:
			//Load filename P0: Append(...)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			break;
		case 23:
			//Load filename Symbols P0 Append (Code|Nocode|Warn|Nowarn)
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			break;
		case 24:
			//Load filename Code Append P0(Symbols|Nosymbols|Warn|Nowarn)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			break;
		case 25:
			//Load filename Append Symbols Code P0(Warn|Nowarn)
			syncolor[11].nColor = COLOR_RED;	//Warn			
			syncolor[13].nColor = COLOR_RED;	//Nowarn
			break;
    	case 26:
			//Load filename Warn P0 (Symbols|Nosymbols|Code|Nocode|Append|Noappend)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			break;
		case 27:
			//Load filename Symbols Warn P0 (Code|Nocode|Append|Noappend)
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			break;
		case 28:
			//Load filename Code Warn P0 (Symbols|Nosymbols|Append|Noappend)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			break;                          
		case 29: 
			//Load filename Symbols Code Warn P0 (Append|Noappend)
			syncolor[15].nColor = COLOR_RED;	//Append	
			syncolor[17].nColor = COLOR_RED;	//Noappend
			break;
		case 30:		
			//Load filename Warn Append P0 (Symbols|Nosymbols|Code|Nocode)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			break;      
		case 31:
			//Load filename Append Symbols Warn P0(Code|Nocode)
			syncolor[7].nColor = COLOR_RED;		//Code			
			syncolor[9].nColor = COLOR_RED;		//Nocode			
			break;
		case 32:
			//Load filename Append Code Warn P0 (Symbols|Nosymbols)
			syncolor[3].nColor = COLOR_RED;		//Symbols			
			syncolor[5].nColor = COLOR_RED;		//Nosymbols			
			break;
        default:                                                    
        	break;  
     }
}

void CSyntaxCheck::SetSyntaxColorQuery(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                    
			//Query (#symbol|hex_adr)
			syncolor[1].nColor = COLOR_RED;					
			syncolor[3].nColor = COLOR_RED;					
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorSsave(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                      
			//Ssave (filename)      
			syncolor[1].nColor = COLOR_RED;											
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorSrecall(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:
			//Srecall (filename)
			syncolor[1].nColor = COLOR_RED;									
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorSymbol(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:      
			//Symbol (Global|Module|#module|Lines)
			syncolor[2].nColor = COLOR_RED;											
			syncolor[4].nColor = COLOR_RED;									
			syncolor[6].nColor = COLOR_RED;															
			syncolor[8].nColor = COLOR_RED;												
			break;
        default:
        	break;  
     }   	

}

void CSyntaxCheck::SetSyntaxColorWatch(int nPos, int& nArgc, 
	SynColor syncolor[])
{                

	SetSyntaxColorInit(nArgc, syncolor);
	
	switch (nPos) {
		case 1:                                 
			//Watch ("C-Expression")			
			syncolor[1].nColor = COLOR_RED;	
			break;
        default:
        	break;  
     }
}

//////////////////////////////// End of File ////////////////////////////////
