/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLEDIT.CPP
//
//  Description:The implement file for the class: ShellEditor
//
//  Author:     Roger Zhang
//
//  Date:       03/25/95
//
//  Modification:
//
//      1. 03/25/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
       
#include "shlcom.h"       
#include "shledit.h"

/////////////////////////////////////////////////////////////////////////////
//  Set new line to edit
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Set a new line buffer to edit
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void ShellEditor::SetNew(char * pch, int nMax)
{
    ASSERT(pch);
    ASSERT(nMax > 0);
    
    m_pchText = pch;
    m_nLength = 0;
    m_nPos = 0;
    if(nMax > 0)    m_nMaxLen = nMax;
}
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to previous char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoPrev(void)
{
    if(m_nPos == 0)   return FALSE;
    -- m_nPos;
    return TRUE;
}        
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to next char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoNext(void)
{
    if(m_nPos == m_nLength) return FALSE;
    ++ m_nPos;
    return TRUE;
}     

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the first char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoHome(void)
{
    if(m_nPos == 0)   return FALSE;
    m_nPos = 0;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the next position of the last buffer
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoEnd(void)
{
    if(m_nPos == m_nLength) return FALSE;
    m_nPos = m_nLength;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the specified position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::SetPos(int nIdx)
{
    if(m_nPos == nIdx)    return FALSE;
    if(nIdx < 0)    m_nPos = 0;
    else if(nIdx > m_nLength) m_nPos = m_nLength;
    else m_nPos = nIdx;
    return TRUE;
}   
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Insert caret at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::InsChar(char ch)
{           
    if(m_nPos == m_nMaxLen) return FALSE;
    if(m_nLength < m_nMaxLen)   ++ m_nLength;
    if(m_nPos < m_nMaxLen - 1) 
        memmove(m_pchText + m_nPos + 1, m_pchText + m_nPos, 
            m_nMaxLen - m_nPos - 1);
    * (m_pchText + m_nPos++) = ch;
    return TRUE;
}
                
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Overwrite a char at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::OvrChar(char ch)
{           
    if(m_nPos == m_nMaxLen) return FALSE;
    if(m_nPos == m_nLength) ++ m_nLength;
    * (m_pchText + m_nPos++) = ch;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the char at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::DelChar(void)
{           
    if(m_nPos == m_nLength) return FALSE;
    -- m_nLength;
    memmove(m_pchText + m_nPos, m_pchText + m_nPos + 1,
        m_nMaxLen - m_nPos - 1);
    return TRUE;
}               

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the char before the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::BackChar(void)
{                           
    if(!GotoPrev())   return FALSE;
    return DelChar();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Insert a string at the caret caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::InsString(char * pch, int nLen)
{    
    ASSERT(pch);
    
    for(int i = 0; i < nLen; i ++)
        if(InsChar(*pch++) == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Overwrite a string at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::OvrString(char * pch, int nLen)
{    
    ASSERT(pch);
    
    for(int i = 0; i < nLen; i ++)
        if(OvrChar(*pch++) == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete a string at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::DelString(int nLen)
{    
    for(int i = 0; i < nLen; i ++)
        if(DelChar() == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the string before the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::BackString(int nLen)
{    
    for(int i = 0; i < nLen; i ++)
        if(BackChar() == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete all the chars
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::Clear(void)
{
    if(m_nLength == 0)    return FALSE;
    m_nLength = 0;
    m_nPos = 0;
    return TRUE;
}

///////////////////////////////////(EOF)/////////////////////////////////////                                  
                
