/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLEDIT.H
//
//  Description:The header file for the class: ShellEditor
//
//  Author:     Roger Zhang
//
//  Date:       03/25/95
//
//  Modification:
//
//      1. 03/25/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLEDIT_
#define _SHLEDIT_
    
class ShellEditor
{
// attributes
public:
    char * m_pchText;   // not end with '\0'
    int m_nMaxLen;
    int m_nLength;
    int m_nPos;         // Current caret position
             
// operations             
public:
    void SetNew(char * pch, int nMax = 0);
 
    BOOL GotoPrev(void);
    BOOL GotoNext(void);
    BOOL GotoHome(void);
    BOOL GotoEnd(void);
    BOOL SetPos(int nIdx);
    
    BOOL InsChar(char ch);
    BOOL OvrChar(char ch);
    BOOL DelChar(void);
    BOOL BackChar(void);
    
    BOOL InsString(char * pch, int nLen);
    BOOL OvrString(char * pch, int nLen);
    BOOL DelString(int nLen);
    BOOL BackString(int nLen);        
    
    BOOL Clear(void);
};

#endif
////////////////////////////(EOF)////////////////////////////////////////////
