/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLEDIT1.CPP
//
//  Description:The implement file of the class ShellEditor1
//
//  Author:     Roger Zhang
//
//  Date:       01/10/96
//
//  Modification:
//
//      1. 01/10/96, Initial version 
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <ctype.h>

#include "syntest.h"
#include "address.h"
#include "synlib.h"
#include "syncore.h" 
#include "syntax.h"

#include "shlcom.h"                   
#include "shledit.h"                   
#include "shledit1.h"
#include "aliaspub.h"      
#include "colors.h"

/////////////////////////////////////////////////////////////////////////////
// refer to command table

extern int nMaxCmdNo;
extern int nAsmFlag;
extern BOOL isFirstToken;        
extern BOOL bFile;
extern BOOL isDefineMacro;

/////////////////////////////////////////////////////////////////////////////
// External function prototypes.

BOOL SearchCommand(const char* pszCommand, int& nArgc, char* pszArgv[]);
int ExpandCommand(const char* pszCommand, char* pszExpand/*, char* pszHints*/);
BOOL ExpandParameter(const char* pszCommand, const char* pszParameter, char* pszExpand);
//for build
//int GetControlOption(CString &strReset,CString &strEa,CString &strEben);
void GetSyntaxColor(char* pszText, int nLength, int& nArgc, SynColor syncolor[]);

BOOL isToupper = TRUE;                
BOOL isStr = FALSE;

/////////////////////////////////////////////////////////////////////////////
ShellEditor1::ShellEditor1()
{
	m_pszCommand = new char[260];
	m_pszEvent = new char[10];
	memset(m_pszEvent, 0, 10);	
}                           

ShellEditor1::~ShellEditor1()
{
	if (m_pszCommand) {
		delete []m_pszCommand;    
		m_pszCommand = 0;
	}	
	if (m_pszEvent) {
		delete []m_pszEvent;  
		m_pszEvent = 0;
	}	
}


/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor1::GetFirstToken(void)
{ 

	m_nLeft = 0;	
	if (m_nLeft >= 0) {	
		// skip space
		while (m_nLeft < m_nLength) {
			if ( isspace(m_pchText[m_nLeft])) ++m_nLeft;
			else break;	
		}

		// scan token                              
		m_nRight = m_nLeft;
		while(m_nRight < m_nLength) {
		 	if(!isspace(m_pchText[m_nRight]) ) 	
		 		++ m_nRight;
		 	else break;
		}                                             
		if ( m_nLeft != m_nRight)
			return TRUE;
		else 
			return FALSE;		
	}
	else {
		// Skip heading space                		
		m_nLeft = 0;
		while(m_nLeft < m_nLength) {
		 	if(isspace(m_pchText[m_nLeft]))	++ m_nLeft;
		 	else	break;
		}              
		
		// scan token                              
		m_nRight = m_nLeft;
		while(m_nRight < m_nLength) {
		 	if(!isspace(m_pchText[m_nRight]))	++ m_nRight;
		 	else break;
		}                                             
		
		if(m_nRight == m_nLeft) {	// No token found
			return	FALSE;	
		}            
		
		return	TRUE;	
	}	
}                
   
// return 0:Fail, 1:First token, 2:Not first token   
int ShellEditor1::GetToken(void)
{   
	m_nLeft = 0;
 	if ( m_nLeft > 0) {	
 		while (m_nLeft < m_nLength) {
 			if ( isspace(m_pchText[m_nLeft])) 
 				m_nLeft++;
 			else break;	
 		}
 	   
		if (m_nLeft == m_nLength) {	
			return	0;
		}
		else {		
			// scan token                              
			m_nRight = m_nLeft;
			while(m_nRight < m_nLength) {
			 	if(!isspace(m_pchText[m_nRight]) ) 	
			 		++ m_nRight;
			 	else break;
			}
			if ( m_nRight >= m_nPos ) {
				return 1;
			}
			else {
				// Scan left
				m_nLeft = m_nPos;
				while(m_nLeft > 0) {
				 	if(isspace(m_pchText[m_nLeft-1]))	break;
				 	-- m_nLeft;
				}              
				
				// Scan right
				m_nRight = m_nPos;                            
				while(m_nRight < m_nLength-1) {
				 	if(isspace(m_pchText[m_nRight]))	break;
				 	++ m_nRight;
				}               
				return 2;		
			}				                                             
	    } 
	}
	else {
		// Scan left
		m_nLeft = m_nPos;
		while(m_nLeft > 0) {
		 	if(isspace(m_pchText[m_nLeft-1]))	break;
		 	-- m_nLeft;
		}              
		
		// Scan right
		m_nRight = m_nPos;                            
		while(m_nRight < m_nLength) {
		 	if(isspace(m_pchText[m_nRight]))	break;
		 	++ m_nRight;
		}               
	
		if(m_nLeft == m_nRight || m_nLeft == m_nPos) {	// No token found
			return	0;
		}
		                 
		// is first token
		int nTemp = 0;
		
		while(nTemp < m_nLeft) {
		 	if(!isspace(m_pchText[nTemp])) {	// Found first token
		 		return	2;
		 	}   
		 	++ nTemp;
		}    
		
		return	1;	// First token
	}	
}                                              

BOOL ShellEditor1::GetHints(int& nArgc, SynColor syncolor[])
{   
	// Default no command valid
 	m_nCmdID = -1;
 	
 	CString str("");	// use to hold the hints            
 	                           
	// Get first token 	                           
 	if(!GetFirstToken()) {
 		nArgc = 1;
		syncolor[0].nColor = COLOR_BLACK;
		if ( isDefineMacro ) {
			syncolor[0].strText = "Use \"MEND\" command to exit macro define.";		
		}
		else {
			syncolor[0].strText = "Wait for input...";
		}	
 		return	FALSE;
 	}	
	
	char* pszCommand = new char[m_nRight - m_nLeft+2];
	char* pszExpand = new char[21];
	char* pszHints = new char[400];
	int nComArgc = 20;  
		
	char* pszArgv[20];
		
	for ( int i = 0; i < 20; i++ ) {
        pszArgv[i] = new char[100];
    }
		
	strncpy( pszCommand, m_pchText + m_nLeft, m_nRight - m_nLeft);
	pszCommand[m_nRight - m_nLeft] = '\0';	
		
	if ( m_pchText[m_nRight] == ' ' ) {
		if (::ExpandCommand(pszCommand, pszExpand, pszHints) 
			!= CCommandSet::NO_COMMAND) {   
			if (0 == stricmp(pszExpand, "control")) {
			    CString strReset, strEa, strEben;
			    //for build
			    //::GetControlOption(strReset,strEa,strEben);
            	if (strEben.IsEmpty()) {
					str = "CONtrol [{Reset|EA}{Enable|Disable}]";
					strcpy(m_pszCommand, pszExpand);             	       
					GetSyntaxColor(m_pchText, m_nLength, nArgc, syncolor); 
               	}
            	else {
					str = pszHints; 
					strcpy(m_pszCommand, pszExpand);
					GetSyntaxColor(m_pchText, m_nLength, nArgc, syncolor);  
            	} 
			}
			else {
				str = pszHints; 
				strcpy(m_pszCommand, pszExpand); 
				GetSyntaxColor(m_pchText, m_nLength, nArgc, syncolor); 
			}	
		}
	}
	else {
		if (::SearchCommand(pszCommand, nComArgc, pszArgv)) {
			for (int i = 0; i <nComArgc; i++) {
				CString strCommand(pszArgv[i]);
				str += strCommand;
				str += ' ';
			} 
			nArgc = 1;
			syncolor[0].nColor = COLOR_BLACK;
			syncolor[0].strText = str;
		}	
	}    
		
	if (pszCommand) {
		delete []pszCommand;           
		pszCommand = 0;
	}	
	if (pszExpand) {
		delete []pszExpand;
		pszExpand = 0;
	}	
	if (pszHints) {
		delete []pszHints;
		pszHints = 0;
	}	
    for ( i = 0; i < 20; i++ ) {
        if ( pszArgv[i] ) {
            delete []pszArgv[i];
            pszArgv[i] = 0;
        }
    }
	
	if(str == "") {	//	no match
		str = "No such command";
		nArgc = 1;
		syncolor[0].nColor = COLOR_BLACK;
		syncolor[0].strText = str;
    }		
	return	TRUE;
		
}               

BOOL ShellEditor1::ExpandCommand(void)
{                        
	
	char pszCommand[300];
	char pszExpand[21];
	char pszHints[300];

	int nLen = m_nPos - m_nLeft;
	
	strncpy( pszCommand, m_pchText + m_nLeft, nLen);
	pszCommand[nLen] = '\0';	
    
    int nRet = ::ExpandCommand(pszCommand, pszExpand, pszHints);
	if ( nRet == CCommandSet::COMMAND) {
		int nComLen = strlen(pszCommand);
		int nExpLen = strlen(pszExpand);			
		if ( nExpLen > nComLen ) { 
			if (m_isIns) {
				InsString(pszExpand+nComLen, nExpLen - nComLen);
			}
			else {
				OvrString(pszExpand+nComLen, nExpLen - nComLen);
			}	
		}
		strcpy(m_pszCommand, pszExpand);                                                       		
		return TRUE;	
	}
	else if (nRet == CCommandSet::ALIAS) {
		strcpy(m_pszCommand, pszExpand);
		return TRUE;
	}              
	else if (nRet == CCommandSet::NO_COMMAND) {
		strcpy(m_pszCommand, pszCommand);      
		return TRUE;
    }
                
    return FALSE;
}


BOOL ShellEditor1::ExpandArgument(void)
{                         
	int nLen = m_nPos - m_nLeft;
	
	char* pszExpand = new char[21];
	char* pszParameter = new char[nLen+2];
	                
	strncpy( pszParameter, m_pchText + m_nLeft, nLen);
	pszParameter[nLen] = '\0';	

 	int nRet = TestEvent();
 	if (nRet == 0) {	    
	    if (::ExpandParameter(m_pszCommand, pszParameter, pszExpand)) {
			int nParLen = strlen(pszParameter);
			int nExpLen = strlen(pszExpand);			
			if ( 0 == stricmp(pszExpand, "eben")) {
			    CString strReset, strEa, strEben;
			    //for build
			    //::GetControlOption(strReset,strEa,strEben);
            	if (!strEben.IsEmpty()) {
					if (m_isIns) {                                   
						InsString(pszExpand + nParLen, nExpLen - nParLen);
					}
					else {
						OvrString(pszExpand + nParLen, nExpLen - nParLen);
					}	
            	}
			}
			else {
				if ( nExpLen > nParLen ) {   
				//Check syntax 
					char pszTemp[300];
					int nLen;               
					int nPos;
					BOOL isOk = FALSE;
					memset(pszTemp, 0 , 300);
					strncpy(pszTemp, m_pchText, m_nPos); 				
					strncat(pszTemp, pszExpand + nParLen, nExpLen - nParLen);
					strcat(pszTemp, " ");
					nLen = strlen(pszTemp);
				    CSyntaxCheck* pSyntaxCheck = new CSyntaxCheck;     
					isOk = pSyntaxCheck->CheckCommandSyntax(pszTemp, nLen, nPos);    
					delete pSyntaxCheck;                       
				
					if (isOk) {
						if (m_isIns) {
							InsString(pszExpand + nParLen, nExpLen - nParLen);
						}
						else {
							OvrString(pszExpand + nParLen, nExpLen - nParLen);
						}	
					}	
				}                                                       		
			}	
			if (pszParameter) {
				delete []pszParameter;
				pszParameter = 0;			
			}
			if (pszExpand) {	
				delete []pszExpand;
				pszExpand = 0;
			}	
			return TRUE;	
		}
		else {              
			if (pszParameter) {   
				delete []pszParameter;      
				pszParameter = 0;		
			}		            
			if (pszExpand) {	
				delete []pszExpand;
				pszExpand = 0;
			}	
			return TRUE;
		}        
	}
	else {
		if (ExpandEventPara(m_pszEvent, pszParameter, pszExpand)) {
			int nParLen = strlen(pszParameter);
			int nExpLen = strlen(pszExpand);			
			if ( nExpLen > nParLen ) { 
				//Check syntax 
				char pszTemp[300];
				int nLen;               
				int nPos;
				BOOL isOk = FALSE;
				memset(pszTemp, 0 , 300);
				strncpy(pszTemp, m_pchText, m_nPos); 				
				strncat(pszTemp, pszExpand + nParLen, nExpLen - nParLen);
				strcat(pszTemp, " ");
				nLen = strlen(pszTemp);
			    CSyntaxCheck* pSyntaxCheck = new CSyntaxCheck;     
				isOk = pSyntaxCheck->CheckCommandSyntax(pszTemp, nLen, nPos);    
				delete pSyntaxCheck;                       
				
				if (isOk) { 
					if (m_isIns) {
						InsString(pszExpand + nParLen, nExpLen - nParLen);
					}
					else {
						OvrString(pszExpand + nParLen, nExpLen - nParLen);
					}	                                                  
				}	
			}                                                       		
			if (pszParameter) {   			
				delete []pszParameter;
				pszParameter = 0; 
			}	
			if (pszExpand) {		
				delete []pszExpand;   
	            pszExpand = 0;  
	        }    
			return TRUE;	
		}
		else {                 
			if (pszParameter) {   			
				delete []pszParameter;
				pszParameter = 0; 
			}	
			if (pszExpand) {		
				delete []pszExpand;   
	            pszExpand = 0;  
	        }    
			return TRUE;
		}        
			
	}	
	if (pszParameter) {   			
		delete []pszParameter;
		pszParameter = 0; 
	}	
	if (pszExpand) {		
		delete []pszExpand;   
        pszExpand = 0;  
    }    
    return FALSE;
}

BOOL ShellEditor1::OnSpace(void)
{   
	BOOL is = TRUE;
		
	// Get token at current position
 	int i = GetToken();   

 	if(!i) {	// No token
 		goto _SHLNOEXPAND;
 	}	
	else if ( /*isFirstToken ||*/ i == 1) {
		if(1 != nAsmFlag ) {
			is = ExpandCommand(); 
		 	goto _SHLNOEXPAND;
		}
 	} else  {	// Argument
		if (1 != nAsmFlag ){          
			if ( bFile ) {
				is = ExpandArgument(); 
			 	goto _SHLNOEXPAND;
			} 	
		}
 	}        
            
_SHLNOEXPAND:   
	if(is) {	
		if(m_isIns)	return ShellEditor::InsChar(' '); 	
		else		return ShellEditor::OvrChar(' '); 	
	} else	return FALSE;
}
    
    
BOOL ShellEditor1::BackChar(void)
{                                       
	// can't do back delete
	if(m_nPos == 0)	return TRUE;
	
	// Record old pos
	int nOld = m_nPos;
	                 
	// Back Delete a space if exist	                 
	if(isspace(m_pchText[m_nPos-1]))	ShellEditor::BackChar();
	
	//only delete a char when after "#" or "$"
	char* pszText = new char[m_nPos+1];
	memset(pszText, 0, m_nPos+1);
	strncpy(pszText, m_pchText, m_nPos);
	CString strLine(pszText);
	delete []pszText;
	
	int nFndWell = strLine.ReverseFind('#');
	int nFndSpace = strLine.ReverseFind(' ');
	int nFndDollar = strLine.ReverseFind('$');
	int nFndSemicolon = strLine.ReverseFind(';');
	BOOL isVar;
    //has no both "$" and "#"
    if (nFndWell == -1 && nFndDollar == -1) {
		// Back delete all lowercase chars
		isVar = FALSE;
    }                        
    //has "#"
    else if (nFndDollar == -1) {     
    	if (nFndSemicolon == -1) {
			if (nFndSpace < nFndWell) 
				isVar = TRUE;	
			else
				isVar = FALSE;
		}	 
		else {
			if (nFndSemicolon > nFndWell )
				isVar = FALSE;
			else
				isVar = TRUE;		      		
		}
    }
    //has "$"
    else if (nFndWell == -1) {     
    	if (nFndSemicolon == -1) {
			if (nFndSpace < nFndDollar) 
				isVar = TRUE;	
			else
				isVar = FALSE;
		}	 
		else {
			if (nFndSemicolon > nFndDollar )
				isVar = FALSE;
			else
				isVar = TRUE;		      		
		}
    }                                           
    //has both "#" and "$"
    else if (nFndWell != -1 && nFndDollar != -1) {
    	if (nFndWell > nFndDollar) {
	    	if (nFndSemicolon == -1) {
				if (nFndSpace < nFndWell) 
					isVar = TRUE;	
				else
					isVar = FALSE;
			}	 
			else {
				if (nFndSemicolon > nFndWell )
					isVar = FALSE;
				else
					isVar = TRUE;		      		
			}
    	}
    	else {
	    	if (nFndSemicolon == -1) {
				if (nFndSpace < nFndDollar) 
					isVar = TRUE;	
				else
					isVar = FALSE;
			}	 
			else {
				if (nFndSemicolon > nFndDollar )
					isVar = FALSE;
				else
					isVar = TRUE;		      		
			}
    	}
	}
	else {                      
		isVar = FALSE;			
	}
	if ( isVar == FALSE ) {		
		// Back delete all lowercase chars
		while(m_nPos > 0) {
		 	if(islower(m_pchText[m_nPos-1])) {
				ShellEditor::BackChar();
		 	} else break;
		}
	}                      
	else                                        
		ShellEditor::BackChar();
		                                  
	// if nothing deleted, back delete any char	                                  
	if(nOld == m_nPos)	ShellEditor::BackChar();
	
	return TRUE; 	
}           
                
BOOL ShellEditor1::DelChar(void)
{
	return ShellEditor::DelChar(); 	
}                     

BOOL ShellEditor1::InsChar(char ch)
{                        
	m_isIns = TRUE;
	if (ch == ' ' && isToupper == TRUE) {
		return OnSpace();                  
	}	
	else if (ch == ' ' && isToupper == FALSE && isStr == FALSE) {
		isToupper = TRUE;
		return OnSpace();
	}	                   	
	if(ch == '#' ) {
		isToupper = FALSE;	
	}
	else if ( ch == '$' ) {
		isToupper = FALSE;			
	}
	else if (ch == '\"') {
		isToupper = FALSE;
		isStr = TRUE;
	}	
	char* p = new char[m_nPos+2];
	strncpy(p, m_pchText, m_nPos);
	p[m_nPos] = '\0';
	CString str(p);

	int nFndWell = str.ReverseFind('#');
	int nFndQuotation = str.ReverseFind('\"');
	int nFndDollar = str.ReverseFind('$');
	if ( nFndWell != -1 && nFndDollar == -1) {
		if (nFndWell < m_nPos) {
			int nFndSpace = str.ReverseFind(' ');
			if ( nFndSpace != -1 ) {
				if ( nFndSpace < nFndWell ) {
					isToupper = FALSE;				
				}
				else {
				    isToupper = TRUE;
				}
			}           
		}
	}
	if ( nFndQuotation != -1) {                                
		if (nFndQuotation < m_nPos) {
			int nFndSpace = str.ReverseFind(' ');
			if ( nFndSpace != -1 ) {            
				isToupper = FALSE;				
			}   
		}
	}
	if ( nFndDollar != -1 && nFndWell == -1) {                                		                                
		if (nFndDollar < m_nPos) {
			int nFndSpace = str.ReverseFind(' ');
			if ( nFndSpace != -1 ) {
				if ( nFndSpace < nFndDollar ) {
					isToupper = FALSE;				
				}
				else {
				    isToupper = TRUE;
				}
			}   
		}
	}                                   
	if (nFndDollar != -1 && nFndWell != -1) {                                		                                
		if (nFndDollar > nFndWell ) {
			if (nFndDollar < m_nPos) {
				int nFndSpace = str.ReverseFind(' ');
				if ( nFndSpace != -1 ) {
					if ( nFndSpace < nFndDollar ) {
						isToupper = FALSE;				
					}
					else {
					    isToupper = TRUE;
					}
				}
			}
		}
		else {
			if (nFndWell < m_nPos) {
				int nFndSpace = str.ReverseFind(' ');
				if ( nFndSpace != -1 ) {
					if ( nFndSpace < nFndWell ) {
						isToupper = FALSE;				
					}
					else {
					    isToupper = TRUE;
					}
				}   
			}
		}
	}
	if (nFndWell == -1 && nFndQuotation == -1 && nFndDollar == -1) {
		isToupper = TRUE;
	}
	delete []p;	                 
	p = 0;

    if (isToupper == TRUE)
		return ShellEditor::InsChar((char)toupper(ch)); 	
	else {
		return ShellEditor::InsChar(ch); 		
	}	
}           

BOOL ShellEditor1::OvrChar(char ch)
{
	m_isIns = FALSE;
	if (ch == ' ' && isToupper == TRUE) {
		return OnSpace();                  
	}	
	else if (ch == ' ' && isToupper == FALSE && isStr == FALSE) {
		isToupper = TRUE;
		return OnSpace();
	}	                   	
	if(ch == '#') {
		isToupper = FALSE;	
	}             
	else if ( ch == '$' ) {
		isToupper = FALSE;			
	}
	else if (ch == '\"') {
		isToupper = FALSE;
		isStr = TRUE;
	}
	char* p = new char[m_nPos+2];
	strncpy(p, m_pchText, m_nPos);
	p[m_nPos] = '\0';
	CString str(p);

	int nFndWell = str.ReverseFind('#');
	int nFndQuotation = str.ReverseFind('\"');
	int nFndDollar = str.ReverseFind('$');
	if ( nFndWell != -1 && nFndDollar == -1 ) {
		if (nFndWell < m_nPos) {
			int nFndSpace = str.ReverseFind(' ');
			if ( nFndSpace != -1 ) {
				if ( nFndSpace < nFndWell ) {
					isToupper = FALSE;				
				}
				else {
				    isToupper = TRUE;
				}
			}    
		}
	}
	if ( nFndQuotation != -1) {                                
		if (nFndQuotation < m_nPos) {
			int nFndSpace = str.ReverseFind(' ');
			if ( nFndSpace != -1 ) {
				isToupper = FALSE;				
			}   
		}
	}
	if ( nFndDollar != -1 && nFndWell == -1 ) {                                		                                
		if (nFndDollar < m_nPos) {
			int nFndSpace = str.ReverseFind(' ');
			if ( nFndSpace != -1 ) {
				if ( nFndSpace < nFndDollar ) {
					isToupper = FALSE;				
				}
				else {
				    isToupper = TRUE;
				}
			}   
		}
	}    
	if (nFndDollar != -1 && nFndWell != -1) {                                		                                
		if (nFndDollar > nFndWell ) {
			if (nFndDollar < m_nPos) {
				int nFndSpace = str.ReverseFind(' ');
				if ( nFndSpace != -1 ) {
					if ( nFndSpace < nFndDollar ) {
						isToupper = FALSE;				
					}
					else {
					    isToupper = TRUE;
					}
				}
			}
		}
		else {
			if (nFndWell < m_nPos) {
				int nFndSpace = str.ReverseFind(' ');
				if ( nFndSpace != -1 ) {
					if ( nFndSpace < nFndWell ) {
						isToupper = FALSE;				
					}
					else {
					    isToupper = TRUE;
					}
				}   
			}
		}
	}
	if (nFndWell == -1 && nFndQuotation == -1 && nFndDollar == -1) {
		isToupper = TRUE;
	}
	delete []p;	                 
	p = 0;
	
	if (isToupper == TRUE)
		return ShellEditor::OvrChar((char)toupper(ch)); 	
	else {   
	    return ShellEditor::OvrChar(ch); 	
	}    
}                         

int ShellEditor1::TestEvent(void)
{
	char* pszBuf = new char[m_nPos+2];	
	for (int i=0 ; i<m_nPos; i++) {
		pszBuf[i] = m_pchText[i];	
	}                            
	pszBuf[i] = '\0';

	CString strBuf(pszBuf);
	delete []pszBuf;	
	pszBuf = 0;

	strBuf.TrimLeft();
	strBuf.MakeLower();
	if (strBuf.Find("event") == 0 ) {
    	strcpy(m_pszEvent, "Event");
    	strcat(m_pszEvent, " ");
		int nLen = strBuf.GetLength();
		if (nLen >= 8) {
			CString str = strBuf.Right(nLen -5);
			str.TrimLeft();
			if ( str.GetLength() >= 2 ) {
				if (str[0] == '1' && str[1] == ' ') {
					strcat(m_pszEvent, "1");
					return 1;                        
				}	
				else if (str[0] == '2' && str[1] == ' ') {
					strcat(m_pszEvent, "2");
					return 2;                             
				}	
				else if (str[0] == '3' && str[1] == ' ') {
					strcat(m_pszEvent, "3");
					return 3;	                          
				}	
				else
					return 0;	
			}
			else {
				return 0;
			}		
		}
		else 
			return 0;		
	}	    
	else {
		return 0;		
	}
}
