/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLEDIT1.H
//
//  Description:The header file of the class ShellEditor1
//
//  Author:     Roger Zhang
//
//  Date:       01/10/96
//
//  Modification:
//
//      1. 01/10/96, Initial version 
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLEDIT1_
#define _SHLEDIT1_         

#include "shledit.h"                                  
#include "syncore.h"

class ShellEditor1 : public ShellEditor
{                
// Construction & Destruction.
public:
    ShellEditor1();
    ~ShellEditor1();

// attributes
private:              
	BOOL m_isIns;

	int m_nCmdID;

	int	m_nLeft; 	//	Token pos
	int	m_nRight;   //
	
	int m_nKeyLen;	// Keyword length	
         
    char* m_pszCommand ;

	char* m_pszEvent; // m_pszEvent = Event 1(2|3)
	             
// implementation             
private:              
	BOOL GetFirstToken(void);
	int GetToken(void);
	//int SearchCommand(void);
	//int SearchArgument(void);    
	
	//BOOL ExpandCommand(int nCmd);
	//BOOL ExpandArgument(int nArg);
	
	BOOL ExpandCommand(void);
	BOOL ExpandArgument(void);
	
	BOOL OnSpace(void);
	int TestEvent(void);
	
// operations	
public:             
	//CString GetHints(void);
    BOOL GetHints(int& nArgc, SynColor syncolor[]);

	BOOL InsChar(char ch);
	BOOL OvrChar(char ch);
	BOOL BackChar();
	BOOL DelChar();
};

#endif
                      
                      