/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLHIST.CPP
//
//  Description:The implement file for the class: HistoryList
//
//  Author:     Roger Zhang
//
//  Date:       03/16/95
//
//  Modification:
//
//      1. 03/16/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "shlcom.h"
#include "shlhist.h"
    
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//              Implement of the class: HistoryElement                     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryElement::HistoryElement(char * pch, int nLen)
 : m_isOK(TRUE)
{                    
    ASSERT(pch && nLen > 0);
    
    if((m_nLength = nLen) == 0)   return;
    if((m_pchElem = new char [nLen]) == 0)    m_isOK = FALSE;
    else {
        m_nLength = nLen;
        strncpy(m_pchElem, pch, m_nLength);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryElement::~HistoryElement()
{
    if(m_isOK && m_nLength)    delete [] m_pchElem;
}                                          
                                          
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//              Implement of the class: HistoryList                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryList::HistoryList(void)
: m_nMaxSize(nShellHistSize), m_isOK(TRUE), m_nElem(0), m_nPos(0),
  m_isRecall(FALSE)
{  
    if(m_nMaxSize && (m_Elem = new PHistoryElement[m_nMaxSize]) == 0) 
        m_isOK = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryList::~HistoryList()
{
    if(!m_isOK) return;
    if(!m_nMaxSize)   return;
    for(int i = 0; i < m_nElem; i ++) {
        delete m_Elem[i];
    }                  
    delete [] m_Elem;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void HistoryList::DelHead(void)
{
    if(IsEmpty())   return;
    delete m_Elem[0];
    for(int i = 0; i < m_nElem - 1; i ++)
        m_Elem[i] = m_Elem[i + 1];
    -- m_nElem;
    m_nPos = IsEmpty() ? 0 : m_nElem - 1;
    m_isRecall = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL HistoryList::AddTail(char * pch, int nLen)
{                                                   
    ASSERT(nLen >= 0 && pch);
                         
	if (nLen == 254) nLen++;                                                                                  
    
    HistoryElement * pElem = new HistoryElement(pch, nLen);
    if(!pElem || !(*pElem)) return FALSE;        
    if(IsFull())  DelHead();
    m_Elem[m_nElem++] = pElem;
    m_nPos = m_nElem - 1;            
    m_isRecall = FALSE;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL HistoryList::SetMaxSize(int nMax)
{       
    ASSERT(nMax >= 0);
    
    if(nMax == m_nMaxSize)    return TRUE;
    
    PHistoryElement * p;
    int i;
    
    if(nMax && (p = new PHistoryElement[nMax]) == 0) return FALSE;
    if(nMax >= m_nElem) {
        for(i = 0; i < m_nElem; i ++) p[i] = m_Elem[i];
    }
    else {
        for(i = 0; i < nMax; i ++)  p[nMax - i - 1] = m_Elem[m_nElem - i - 1];
        for(i = 0; i < m_nElem - nMax; i ++)  delete m_Elem[i];
        m_nElem = nMax;        
    }                
    if(m_nMaxSize)   delete [] m_Elem;
    m_Elem = p;
    m_nMaxSize = nMax;
    m_nPos = m_nElem - 1;        
    m_isRecall = FALSE;
    return TRUE;
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: can't be empty 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryElement * HistoryList::GetPrev(void)
{
    ASSERT(!IsEmpty() && m_nMaxSize > 0);
    
    if(!m_isRecall) {
        m_isRecall = TRUE;
        return m_Elem[m_nPos];
    } else if(IsHead()) return m_Elem[m_nPos];
    else return m_Elem[--m_nPos];           
}                            

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: can't be empty
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryElement * HistoryList::GetNext(void)
{
    ASSERT(!IsEmpty() && m_nMaxSize > 0);

    if(IsTail()) {
        m_isRecall = FALSE;   return 0;
    } else return m_Elem[++m_nPos];
}

/////////////////////////////////////(EOF)///////////////////////////////////
                                   
