/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLHIST.H
//
//  Description:The header file for the class: HistoryList
//
//  Author:     Roger Zhang
//
//  Date:       03/16/95
//
//  Modification:
//
//      1. 03/16/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLHIST_
#define _SHLHIST_               

/////////////////////////////////////////////////////////////////////////////
//  HistoryElement
/////////////////////////////////////////////////////////////////////////////

class HistoryElement
{
// attributes
public:
    int m_nLength;
    char * m_pchElem;                    
    BOOL m_isOK;
             
// constructor/destructors             
public:
    HistoryElement() : m_nLength(0), m_isOK(TRUE) {}
    HistoryElement(char * pch, int nLen);
    ~HistoryElement();
                          
// operations                          
public:
    int operator ! () const { return !m_isOK; }
};

typedef HistoryElement * PHistoryElement;

/////////////////////////////////////////////////////////////////////////////
//  HistoryList
/////////////////////////////////////////////////////////////////////////////

class HistoryList 
{
// constructor/destructors             
public:
    HistoryList(void);
    ~HistoryList();

// operations                          
public:
    BOOL AddTail(char * pch, int nLen);
    void DelHead(void);
    
    HistoryElement * GetPrev(void);
    HistoryElement * GetNext(void);
    
    BOOL SetMaxSize(int nMax);
    
    int IsEmpty(void) const { return !m_nElem; }
    int IsFull(void) const { return m_nElem == m_nMaxSize; } 
    int IsHead(void) const { return m_nPos == 0; }
    int IsTail(void) const { return m_nPos == m_nElem - 1; }
    
    int operator ! () const { return !m_isOK; }

// attributes
public:
    int m_nMaxSize;           
    int m_nElem;
    int m_nPos;
    PHistoryElement * m_Elem;
    BOOL m_isOK;
    BOOL m_isRecall;
};

#endif
/////////////////////////////(EOF)///////////////////////////////////////////
