/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLMSHBR.H
//
//  Description:The header file for the class: CMessageBar
//
//  Author:     Roger Zhang
//
//  Date:       03/18/95
//
//  Modification:
//
//      1. 03/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLMSGBR_
#define _SHLMSGBR_     

#include "syncore.h"

/////////////////////////////////////////////////////////////////////////////
// CMessageBar window

class CMessageBar : public CWnd
{   
	DECLARE_DYNAMIC(CMessageBar)
// Construction
public:
    
    CMessageBar();
    BOOL Create(LONG style, const RECT& rect, CWnd * pParent = NULL );

// Attributes
public:
    enum { IDW = IDW_MSGBAR };
    enum { SPINWD = 26 };
    enum { BARHZEDGE = 8, BARVTEDGE = 1 };
// Operations
public:
    //void ShowText(char * szText = 0);
    void ShowText(int nArgc, SynColor syncolor[]);

// Implementation
public:
    virtual ~CMessageBar();

protected:                  
    CSpinControl m_Spin;
    BOOL m_isSpinOn;
    int m_nTextPos;            
    int m_nTextLen;
    int m_nFont;    
    int m_nLen;
    CSize m_szFont;
    CPoint m_ptChar;
    char m_pszText[1024];                       
    CRect m_rectFrame;
    HINSTANCE m_hLib;                  
    
    int m_nArgc;
    SynColor m_syncolor[100];
    
    void DrawFrame(CDC * pDC, CRect &rect);
    void GetLength(void);
    BOOL CreateSpin(void);

    // Generated message map functions
    //{{AFX_MSG(CMessageBar)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnPaint();
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////(EOF)//////////////////////////////////////////
