/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLSYNCO.CPP
//
//  Description:The implement file of the class ShellSyntaxColor
//
//  Author:     Annie Yi
//
//  Date:       06/17/96
//
//  Modification:
//
//      1. 06/17/96, Initial version 
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
                                           
/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include <ctype.h>
#include <direct.h>

#include "colors.h" 
#include "address.h"
//#include "addrapi.h"
#include "aliaspub.h"
//#include "hosterrs.h"
#include "syncore.h"
#include "syntax.h"
#include "resource.h"
  
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
  

/////////////////////////////////////////////////////////////////////////////
// Type definitions.

/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.     
int nMaxCmdNo = 57;
HintsList* pHintsList;
BOOL bFile = FALSE;

/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern char szAppPath[_MAX_PATH+1];

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void GetSyntaxColor(char* pszText, int nLength, int& nArgc, SynColor syncolor[]) ;                        
void SplitCommand(CString strLine, CString& strCommand, int& nCount,
	 CStringList* listHints);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.

/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
 

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

void GetSyntaxColor(char* pszText, int nLength, int& nArgc, SynColor syncolor[])
{                             
    int nPos; 
    BOOL isOk = FALSE;
    CSyntaxCheck* pSyntax = new CSyntaxCheck;     
	isOk = pSyntax->CheckCommandSyntax(pszText, nLength, nPos);    
	pSyntax->SetSyntaxColor(nPos, nArgc, syncolor);
	delete pSyntax;          
    
}

void MakeHints(void)
{   
	CString strPath, strFile, strTemp;
	                                 
	strTemp.Empty();
	strTemp.LoadString(ID_HINTS);	                                 
	//char pszTemp[50];
	//strcpy(pszTemp, "hintsjfkdj;dgjdkgj");
	
	 
	strPath = ::szAppPath;
	mkdir(strPath);                 
	strFile = strPath;
	strFile += strTemp;
	// Assign the open flag.
    CFileStatus status;
	if ( !CFile::GetStatus(strFile, status) ) {
	    AfxMessageBox("Error: Cannot find the file:hints.dat");
//        char pchText[256];
//        ErrGetErrorText(ER_NOT_FIND_FILE, pchText);
//		AfxMessageBox(pchText);

		return;
	}                                       
	
	pHintsList = new HintsList[nMaxCmdNo];		
    // Open the record file.
	UINT nOpenFlag = CFile::modeRead | CFile::typeText;
	CStdioFile* fp = new CStdioFile(strFile, nOpenFlag);
	
		// Read from the record file.
	int nMax = 300;
	char* pszLine = new char[nMax];
	CString strCommand("");
	int nCount = 0;
		
	int i=0;
	while ( fp->ReadString(pszLine, nMax) ) {
		// Split string.                                          
		pHintsList[i].plistHints = new CStringList;
		
		SplitCommand(CString(pszLine), strCommand, nCount, pHintsList[i].plistHints);
		pHintsList[i].strCommand = strCommand;
		pHintsList[i].nCount = nCount;
		i++;
		if (i > nMaxCmdNo) break;							
	}
	while (i<nMaxCmdNo) {
		pHintsList[i].strCommand = "";
		pHintsList[i].nCount = 0;
		pHintsList[i].plistHints = 0;	
	    i++;	
    }
	delete []pszLine;
	
	// Close the record file.
	fp->Close();
	delete fp;	    
	
    bFile = TRUE;	
}                                                                       


void SplitCommand(CString strLine, CString& strCommand, int& nCount,
	 CStringList* plistHints)
{
	// Get Command token.        
	enum { delimiter = ';', space = ' ' };
	CString strTemp(strLine);
	int nFind = strLine.Find(delimiter);
	if ( -1 == nFind ) {
		return;
	}
	strCommand = strLine.Left(nFind);
	strTemp = strLine.Right(strLine.GetLength()-nFind-1);
	nFind = strTemp.Find(delimiter);             
	plistHints->RemoveAll();                                
	plistHints->AddTail(strCommand);         
	while ( -1 != nFind ) {
		plistHints->AddTail(strTemp.Left(nFind));         
		strTemp = strTemp.Right(strTemp.GetLength()-nFind-1);	
		nFind = strTemp.Find(delimiter);
	}
	nCount = plistHints->GetCount();
}	

void FreeHints(void)
{                        
	if ( !bFile ) return;
	if ( pHintsList == 0 ) return;
		 
	for (int i = 0; i < nMaxCmdNo; i++) {
	    if (pHintsList[i].plistHints) {
		   	POSITION posHead  = pHintsList[i].plistHints->GetHeadPosition();
		    while (posHead) {
				(pHintsList[i].plistHints->GetNext(posHead)).Empty();    
		    }               
		    pHintsList[i].plistHints->RemoveAll();
		    delete pHintsList[i].plistHints;
		    pHintsList[i].plistHints = 0;
	    }                                                
		
	}
	
	delete []pHintsList;
	pHintsList = 0;	
}

//////////////////////////////// End of File ////////////////////////////////
