
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/STKLOCAL.H__   1.14   09 Jan 1997 14:25:36   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/STKLOCAL.H__  $
** 
**    Rev 1.14   09 Jan 1997 14:25:36   ZJRD
** No change.
** 
**    Rev 1.13   13 Dec 1996 11:20:30   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:28   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:44   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:42   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:30   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:47:42   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:18   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:52   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:28   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:14   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:36   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:20   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:36   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKLOCAL.H
//
//  Description: The header file for the class: CStackLocalView.
//
//  Author: Chen Jun
//
//  Date: 07/18/95
//
//  Modification:
//      1. 07/18/95, Initial version of the class: CStackLocalView.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _STKLOCAL_
#define _STKLOCAL_


/////////////////////////////////////////////////////////////////////////////
// CStackLocalView view

class CStackLocalView : public CView
{
    DECLARE_DYNCREATE(CStackLocalView)
public:
    CStackLocalView();          // protected constructor used by dynamic creation
    void InitialMember(void);
    void ClearMember(void);

// Attributes
public:
    CStackDoc* GetDocument();

public:
    int m_nMaxRow;
    int m_nMaxCol;

    int m_nCurRow;
    int m_nCurCol;

	int m_nRowSize;
	int m_nColSize;

	int m_nStartRow;
	int m_nStartCol;
		
    CRect m_rectClient;

private:
    int m_nClientLine;  // Indicate the start line in the client area.
    
public:    
    int m_nFocus;
    
private:
    enum { bottomHeight = 20 };
    int m_nFontWidth;
    int m_nFontHeight;

private:
    enum { caretWidth = 2 };
    int m_xCaret;
    int m_yCaret;

// Operations
private:
    enum {
        noError = 0,        // No error.
        insufficientMemory, // Insufficient memory.
        bmpLoad,            // Cannot load VAR_xxx bitmap.
        invalidLevel,
        hasError,
        maxError = 10       // Limition of error ID.
    };
    BOOL m_nErrorID;
    
    void DisplayErrorMessage(void) const;

private:
    enum { 
        pageUnit = 30,
        lineUnit = 1,
        pageScroll = 1,
        limitRow = 400,
        limitColumn = 400
    };
    int m_nLimitLine;
    int m_nLimitColumn;
//    void UpdateScrollSizes(void);

private:
    enum {
        bmpWidth = 16,
        bmpHeight = 13,
    };
    CBitmap m_bmpInvalid;
    CBitmap m_bmpSimple;
    CBitmap m_bmpOpen;
    CBitmap m_bmpClose;
    
    BOOL AllocateBitmap(void);
    void ReleaseBitmap(void);
    void DisplayBitmap(CDC* pDC, const int xPos, const int yPos);

public:
    enum {
        invalidSign = 0,
        simpleSign,
        openSign,
        closeSign
    };
    int m_nBmpStatus;
    void DetectVarFormat(void);

private:
    CString m_strName;
    CString m_strValue;
    CString m_strResult;

public:
    struct VarNode FAR * m_pVarNode;
    void OutputAllVariable(CDC* pDC);
	void OutputOneVariable(CDC* pDC , int nLine);
    void UpdateBottomPane(void);

//private:
//    void UpdateModifiedRegion(BOOL bAdjustScrollRange);
//    void UpdateMarkLine(int nMarkLine);
//    void UpdateToLine(int nLine);
        
private:
    BOOL m_bCaretOn;
    void TurnOnCaret(void);
    void TurnOffCaret(void);
        
private:
    int m_nScrollBox;
    BOOL m_bAdjustScrollBox;
    BOOL m_bAdjustScrollRange;
    int m_nHScroll;
    int m_nVScroll;   

    void ResizeScroll();        
    void ResizeScrollBarRange();        

//    void AssumeScrollBox(void);
//    void RestoreScrollBox(void);
// Implementation
public:
    // Public function.
    void UpdateLocalWindow(int nLevel);
    void UpdateLocalWindow(void);
    
    void DeleteOneNode(void);
    BOOL IsEmpty(void);
    void GetHighlightName(CString& strName);
    void GetHighlightValue(CString& strValue);
    void SearchToken(CString& strToken);
    void SearchNextToken(CString& strToken);
    BOOL ModifyValue(CString& strNewValue);
    void TypeCast(CString& strTypeCast);
    
protected:
    virtual ~CStackLocalView();    // protected destructor

    // Standard overrides of MFC classes.
    virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
    virtual void OnDraw(CDC* pDC);      // overridden to draw this view
    virtual void OnInitialUpdate();     // first time after construct
    virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);

    // Generated message map functions
    //{{AFX_MSG(CStackLocalView)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnSetFocus(CWnd* pOldWnd);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnPaint();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////// End of File ////////////////////////////////
