
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/STKSELE.CPP   1.14   09 Jan 1997 14:25:38   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/STKSELE.CPP  $
** 
**    Rev 1.14   09 Jan 1997 14:25:38   ZJRD
** No change.
** 
**    Rev 1.13   13 Dec 1996 11:20:30   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:28   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:44   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:44   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:44   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:20   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:54   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:30   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:16   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:38   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:22   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:36   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKSELE.CPP
//
//  Description: The implementation file fore class: CStackSelectLocalDialog.
//
//  Author: Chen Jun
//
//  Date: 08/22/95
//
//  Modification:
//      1. 08/22/95, Initial version of the class: CStackSelectLocalDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "symblsvr.h"
#include "stkinit.h"
#include "varinit.h"

#include "stkobj.h"

#include "stkdoc.h"

#include "stklocal.h"

#include "stksele.h"
#include "stkexp.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CPtrList* pStkAddLocalList;
CPtrList* pStkRemoveLocalList;


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void StkSimpleUpdateLocalWindow(void);


/////////////////////////////////////////////////////////////////////////////
// CStackSelectLocalDialog dialog

void CStackSelectLocalDialog::AllocateSpace(void)
{
    // Allocate m_pAddLocalList & m_pRemoveLocalList.
    m_pStkAddLocalList = new CPtrList;
    ASSERT( m_pStkAddLocalList );

    m_pStkRemoveLocalList = new CPtrList;
    ASSERT( m_pStkRemoveLocalList );

    if ( !m_pStkAddLocalList || !m_pStkRemoveLocalList ) {
        AfxMessageBox("Insufficient memory.");
    }
}

void CStackSelectLocalDialog::ReleaseSpace(void)
{
    // Release m_pAddLocalList & m_pRemoveLocalList.
    if ( m_pStkAddLocalList ) {
        delete m_pStkAddLocalList;
    }

    if ( m_pStkRemoveLocalList ) {
        delete m_pStkRemoveLocalList;
    }
}

void CStackSelectLocalDialog::SetGlobalList(void)
{
    // Reset the global list.
    ::pStkAddLocalList->RemoveAll();
    ::pStkRemoveLocalList->RemoveAll();

    // Add contents from m_pStkAddLocalList to ::pStkAddLocalList.
    if ( !m_pStkAddLocalList->IsEmpty() ) {
        ::pStkAddLocalList->AddTail(m_pStkAddLocalList);
    }
        
    // Add contents from m_pStkRemoveLocalList to ::pStkRemoveLocalList.
    if ( !m_pStkRemoveLocalList->IsEmpty() ) {
        ::pStkRemoveLocalList->AddTail(m_pStkRemoveLocalList);
    }
}

void CStackSelectLocalDialog::RemoveAllLocal(void)
{
    // Delete from Local window.
    if ( !m_pStkRemoveLocalList->IsEmpty() ) {
        POSITION posHead = m_pStkRemoveLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(m_pStkRemoveLocalList->GetNext(posHead));
            ::Stk_DeleteLocal(pObj->GetDest());
        }
    }

    if ( !m_pStkAddLocalList->IsEmpty() ) {
        POSITION posHead = m_pStkAddLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(m_pStkAddLocalList->GetNext(posHead));
            ::Stk_DeleteLocal(pObj->GetDest());
        }
    }
}

void CStackSelectLocalDialog::AddLocal(void)
{
    // Add to Local window.
    if ( !m_pStkAddLocalList->IsEmpty() ) {
        POSITION posHead = m_pStkAddLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(m_pStkAddLocalList->GetNext(posHead));
            ::Stk_AddLocalVar(pObj->GetDest(), pObj->GetName());
        }
    }
}


CStackSelectLocalDialog::CStackSelectLocalDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CStackSelectLocalDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CStackSelectLocalDialog)
    //}}AFX_DATA_INIT

    // Allocate m_pAddLocalList & m_pRemoveLocalList.
    AllocateSpace();
}

void CStackSelectLocalDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CStackSelectLocalDialog)
    DDX_Control(pDX, IDC_LIST_VARSELECTLOCAL_ONDISPLAY, m_lstOnDisplay);
    DDX_Control(pDX, IDC_LIST_VARSELECTLOCAL_NOTONDISPLAY, m_lstNotOnDisplay);
    DDX_Control(pDX, IDC_BUTTON_VARSELECTLOCAL_REMOVE, m_btnRemove);
    DDX_Control(pDX, IDC_BUTTON_VARSELECTLOCAL_ADD, m_btnAdd);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStackSelectLocalDialog, CDialog)
    //{{AFX_MSG_MAP(CStackSelectLocalDialog)
    ON_LBN_SETFOCUS(IDC_LIST_VARSELECTLOCAL_NOTONDISPLAY, OnSetfocusNotondisplay)
    ON_LBN_SETFOCUS(IDC_LIST_VARSELECTLOCAL_ONDISPLAY, OnSetfocusOndisplay)
    ON_BN_CLICKED(IDC_BUTTON_VARSELECTLOCAL_ADD, OnButtonAdd)
    ON_BN_CLICKED(IDC_BUTTON_VARSELECTLOCAL_REMOVE, OnButtonRemove)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStackSelectLocalDialog message handlers

BOOL CStackSelectLocalDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Add contents to the left list box.
    if ( !::pStkRemoveLocalList->IsEmpty() ) {
        m_lstNotOnDisplay.ResetContent();
        POSITION posHead = ::pStkRemoveLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(::pStkRemoveLocalList->GetNext(posHead));
            m_lstNotOnDisplay.AddString(pObj->GetName());
        }
        // Add contents from ::pStkRemoveLocalList to m_pStkRemoveLocalList.
        ASSERT ( m_pStkRemoveLocalList->IsEmpty() );
        m_pStkRemoveLocalList->AddTail(::pStkRemoveLocalList);
    }
    
    // Add contents to the right list box.
    if ( !::pStkAddLocalList->IsEmpty() ) {
        m_lstOnDisplay.ResetContent();
        POSITION posHead = ::pStkAddLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(::pStkAddLocalList->GetNext(posHead));
            m_lstOnDisplay.AddString(pObj->GetName());
        }
        // Add contents from ::pStkAddLocalList to m_pStkAddLocalList.
        ASSERT ( m_pStkAddLocalList->IsEmpty() );
        m_pStkAddLocalList->AddTail(::pStkAddLocalList);
    }
    
    // Set the first focus.
    m_lstOnDisplay.SendMessage(WM_SETFOCUS);
    //GotoDlgCtrl(GetDlgItem(IDC_LIST_VARSELECTLOCAL_ONDISPLAY));
    
    // Set the initial value.
    UpdateData(FALSE);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CStackSelectLocalDialog::OnSetfocusNotondisplay()
{
    // TODO: Add your control notification handler code here
    
    // Select the first string.
    if ( m_lstNotOnDisplay.GetCount() >= 0 ) {
        m_lstNotOnDisplay.SetCurSel(0);
    }
    if ( m_lstOnDisplay.GetCount() >= 0 ) {
        m_lstOnDisplay.SetCurSel(-1);
    }

    // Enable "Add" button.
    m_btnAdd.EnableWindow();

    // Disable "Remove" button.
    m_btnRemove.EnableWindow(FALSE);
}

void CStackSelectLocalDialog::OnSetfocusOndisplay()
{
    // TODO: Add your control notification handler code here
    
    // Select the first string.
    if ( m_lstOnDisplay.GetCount() >= 0 ) {
        m_lstOnDisplay.SetCurSel(0);
    }
    if ( m_lstNotOnDisplay.GetCount() >= 0 ) {
        m_lstNotOnDisplay.SetCurSel(-1);
    }

    // Enable "Remove" button.
    m_btnRemove.EnableWindow();

    // Disable "Add" button.
    m_btnAdd.EnableWindow(FALSE);
}

void CStackSelectLocalDialog::OnOK()
{
    // TODO: Add extra validation here
    
    // Global list operation.
    SetGlobalList();
    
    // Remove local variables.
    RemoveAllLocal();
    
    // Add local variables.
    AddLocal();
    
    // Update Stack local window.
    ::StkSimpleUpdateLocalWindow();

    // Release m_pAddLocalList & m_pRemoveLocalList.
    ReleaseSpace();

    CDialog::OnOK();
}

void CStackSelectLocalDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    // Release m_pAddLocalList & m_pRemoveLocalList.
    ReleaseSpace();

    CDialog::OnCancel();
}

void CStackSelectLocalDialog::OnButtonAdd()
{
    // TODO: Add your control notification handler code here
    
    // Get the contents from the list control.
    UpdateData();
    
    // List operation.
    int nNotOnDisplayIndex = m_lstNotOnDisplay.GetCurSel();
    if ( LB_ERR == nNotOnDisplayIndex ) {
        return;
    }
    POSITION pos = m_pStkRemoveLocalList->FindIndex(nNotOnDisplayIndex);
    CStkObject* pObj = (CStkObject* )m_pStkRemoveLocalList->GetAt(pos);
    m_pStkAddLocalList->AddTail(pObj);
    m_pStkRemoveLocalList->RemoveAt(pos);
    
    // Remove from the left list box.
    m_lstNotOnDisplay.DeleteString(nNotOnDisplayIndex);
    
    // Add to the right list box.
    pObj = (CStkObject* )(m_pStkAddLocalList->GetTail());
    m_lstOnDisplay.AddString(pObj->GetName());

    // Select the first string.
    //m_lstOnDisplay.SendMessage(WM_SETFOCUS);
    GotoDlgCtrl(GetDlgItem(IDC_LIST_VARSELECTLOCAL_ONDISPLAY));
}

void CStackSelectLocalDialog::OnButtonRemove()
{
    // TODO: Add your control notification handler code here

    // Get the contents from the list control.
    UpdateData();
    
    // List operation.
    int nOnDisplayIndex = m_lstOnDisplay.GetCurSel();
    if ( LB_ERR == nOnDisplayIndex ) {
        return;
    }
    POSITION pos = m_pStkAddLocalList->FindIndex(nOnDisplayIndex);
    CStkObject* pObj = (CStkObject* )m_pStkAddLocalList->GetAt(pos);
    m_pStkRemoveLocalList->AddTail(pObj);
    m_pStkAddLocalList->RemoveAt(pos);
    
    // Remove from the right list box.
    m_lstOnDisplay.DeleteString(nOnDisplayIndex);
    
    // Add to the left list box.
    pObj = (CStkObject* )(m_pStkRemoveLocalList->GetTail());
    m_lstNotOnDisplay.AddString(pObj->GetName());

    // Select the first string.
    //m_lstNotOnDisplay.SendMessage(WM_SETFOCUS);
    GotoDlgCtrl(GetDlgItem(IDC_LIST_VARSELECTLOCAL_NOTONDISPLAY));
}
