
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/STKVIEW.H__   1.14   09 Jan 1997 14:25:40   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/STKVIEW.H__  $
** 
**    Rev 1.14   09 Jan 1997 14:25:40   ZJRD
** No change.
** 
**    Rev 1.13   13 Dec 1996 11:20:32   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:32   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:48   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:46   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:44   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:18   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:54   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:28   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:16   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:38   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:20   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:36   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKVIEW.H
//
//  Description: The header file for the class: CStackView.
//
//  Author: Chen Jun
//
//  Date: 07/29/95
//
//  Modification:
//      1. 07/29/95, Initial version of the class: CStackView.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _STKVIEW_
#define _STKVIEW_

#include "stkdoc.h"

#include "symblsvr.h"
#include "stkinit.h"      
#include "yyhgrid.h"

#define IDC_YYHGRID   888   

////////////////////////////////////////////////////////////////////////////
// CStackView form view

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CStackView : public CView
{
    DECLARE_DYNCREATE(CStackView)
protected:
    CStackView();           // protected constructor used by dynamic creation
    void InitialMember(void);

// Form Data
public:
    //{{AFX_DATA(CStackView)

	//}}AFX_DATA

// Attributes
public:
    CStackDoc* GetDocument();
    CYYHGrid m_Grid;
private:
    int m_nCurRow;

    int m_nMaxColumn;
    enum {
        levelColumn = 0,
        addressColumn,
        entryPointColumn,
        moduleColumn,
        functionColumn,
        totalColumn = 5,
    };

// Operations
private:
    // Get from Stack server.
    int m_nMaxLevel;
    
    CString m_strLevel;
    CString m_strAddress;
    CString m_strEntryPoint;
    CString m_strModule;
    CString m_strFunction;
    
    struct STKNode* m_pStkNode;
    void GetMaxLevel(void);
    void GetStackInfo(void);
    void ShowStackInfo(void);

private:
    // Initial grid.
    enum { 
        staticText = 5,
        alignHLeft = 0,
        alignHCenter = 2,
        alignVCenter = 1,
    };
    CRect m_rectClient;
 //   void InitialGrid(void);
    
private:
    // Update grid.
    void UpdateGrid(void);
    void HideColumn(void);

private:
    // Highlight the active row.   
    BOOL m_bUpdateStackOnly;
    //void HighLightRow(void);

private:
    // Reset the active row.
    enum { actionActiveCell = 0 };
   // void ResetRow(void);
    
private:

private:
// Implementation
public:
    // Public function.
    void UpdateStackWindow(BOOL bUpdateStackOnly);
    void InspectSource(void);
    void SetBreakpoint(void);
    void RunUntil(void);      	
    int GetActiveLevel(void);

protected:
     ~CStackView();
      void OnDraw(CDC* pDC) ;

    // Standard overrides of MFC classes.
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

    // Generated message map functions
    //{{AFX_MSG(CStackView)
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnDestroy();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg LONG OnUpdateLocal(UINT,LONG);
	//}}AFX_MSG
	
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////// End of File ////////////////////////////////
