
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symmgr.h
**
**  Description:
**     Prototypes for the functions to manage the symbol memory pool
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMMGR.H__   1.7.1.0.1.0   11 Nov 1996 13:00:52   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMMGR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "symblsvr.h"
#include "symmanag.h"
#include "symutil.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef union {
   OFFSET_ADDR_TYPE startAddr;      // code symbol address
   AUTO_VAR_OFFSET  autoVarOffset;  // var offset from stack frame
   STATIC_VAR_ADDR  staticVarAddr;  // static (not global) variable address
   GLOBAL_VAR_ADDR  globalVarAddr;  // global variable
   REG_INDEX        registerIndex;  // for ATN2 and ATN10 register vars
} BEGIN_ADDR_INFO;

typedef union {
   OFFSET_ADDR_TYPE endAddr;     // for code symbols and fixed address vars
   U32          varSize;         // for auto vars and register vars
} END_ADDR_INFO;

typedef struct {
   VAR_LIFETIME_INFO lifetimeInfo;
   TABLE_OFFSET nextLifetimeInfo;
} SYM_LIFETIME_INFO;

typedef struct {
   TABLE_OFFSET firstEntry;
   TABLE_OFFSET lastEntry;
} SYM_LIFETIME_START_INFO;

// defines action preformed on the last symbol
typedef enum {
   SYM_OPEN,
   SYM_CLOSE,
} SYM_ACTION;

typedef struct {
   SYM_TYPE_TYPE symType:4;
   BASE_INDEX baseIndex:12;  // must change MAX_BASE_INDEX_SIZE if more bits
} PACKED_TYPE_INDEX;         // are allowed for BASE_INDEX

// All variable symbols use this as their common header.
typedef struct {
   PACKED_TYPE_INDEX typeIndex;
   TABLE_OFFSET symbolNameOffset;
   TABLE_OFFSET symParentOffset;
   TABLE_OFFSET symSiblingOffset;
   BEGIN_ADDR_INFO beginAddrInfo;
   END_ADDR_INFO endAddrInfo;
   U32 ordinalVal;
} COMMON_SYMBOL_HEADER;

typedef struct {
   TABLE_OFFSET varListOffset;
   TABLE_OFFSET labelListOffset;
   TABLE_OFFSET constListOffset;
   TABLE_OFFSET miscListOffset;
} COMMON_LIST_HEADER;

// All block/function/module symbols use this as their common header.
typedef struct {
   COMMON_SYMBOL_HEADER symHeader;
   TABLE_OFFSET child;
   COMMON_LIST_HEADER list;
} COMMON_BLOCK_HEADER;

typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   TABLE_OFFSET        linenumOffsetStart;
   TABLE_OFFSET        linenumOffsetEnd;
   TABLE_OFFSET        srcFilenameOffset;
   TIMESTAMP_TYPE      timestamp;
   U32                 fileOffset;
      /* offset to start of module record when onDemand state is TRUE;
         a value of 0 ==> all symbols are loaded for this module */ 
   U32                 srcFilePosition;
   U32                 typeDelta;
} SYM_TYPE_MODULE;

typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   FUNC_CLASS funcClass;
   U32 stackSpace;
   U32 typeIndex;    /* temporary type cast */  
   
   U32 retOffset;
   U16 framePtr;
   BOOL bFrameFlag;
   U8 prologBytes;
} SYM_TYPE_FUNCTION;


typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   U32 stackSpace;
} SYM_TYPE_BLOCK;

typedef struct {
   TABLE_OFFSET baseNameOffset;
   TABLE_OFFSET nextBaseOffset;
   U32 addressMin;
   U32 addressMax;
   U32 addressCount;
   U32 addrTable;
   BASE_ADDRESS baseAddress;
   U8 baseType;
   U8 addrTableDirty;
} SYM_BASE_ENTRY;

typedef struct {
   COMMON_SYMBOL_HEADER symHeader;
   TABLE_OFFSET         typeIndex;
   VAR_STORAGE_CLASS    storageClass;
   VAR_REGISTER_CLASS   registerClass;
   BOOLEAN              isConstant;    /* TRUE ==> read-only constant;   */
                                       /* FALSE==> read-write access     */
   BOOLEAN              isValidAddr;   /* TRUE ==> address is valid;     */
                                       /* FALSE==> address not known yet */
} SYM_TYPE_VARIABLE;

typedef struct {
    U16        recordSize;   /* bytes making up the entire type record */
    U16        memberCount;
    TYPE_CLASS typeChoice;   /* determines access to union */
    union {
        SIMPLE_TYPE simpleType;
        COMPLEX_TYPE complexType;
    } t;
    U32 sizeInMAUs;           /* number of MAUs making up type template */
    TABLE_OFFSET typeName;    /* empty string if type doesn't have name */
    BOOLEAN sizeCalculated;   /* Flag to indicates MAU calculated */
} TYPE_HEADER_TYPE2;

typedef struct {
   U32 attribute;
   U8 frameType;
   U32 pushMask;
   TYPE_INDEX returnType;     
   U8 argCount;
   U8 level;
   TABLE_OFFSET fatherName;
} FUNC_TYPE_HEADER;
   
typedef struct {
    TABLE_OFFSET nameOffset;
    TYPE_INDEX typeIndex;      
    U16 offset; 
    BOOL bBit;
    U16 size;
} TYPE_STRUCT_HEADER;

typedef struct {
   U32 enumValue;
   TABLE_OFFSET enumName;
} ENUM_TYPE_STRUCT;

#define _SYMMGR_
#endif
/******************************** E O F ***********************************/
