
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMOBJ.H
**
**  Description:
**      All expression object's basic class have the prefix: CSymObj
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   27 Feb. 1996 15:30:00pm   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMOBJ_H_
#define _SYMOBJ_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save expression string          *
*                                                                     *
**********************************************************************/                        
class CSymObj {
protected :
    CSymObj() {
        m_strCmd = 0;
        m_nCmdFlag = 0;
        m_nLen = 0;
        m_nErrNo = 0;
    }
    ~CSymObj() {
        if ( m_strCmd ) delete []m_strCmd;
        m_strCmd = 0;
        m_nLen = 0;  
        m_nErrNo = 0;
    }
     
protected :
    char *m_strCmd;
    int m_nCmdFlag;
    int m_nLen;
    int m_nErrNo;    // 0  --  no error
                     // 1  --  new memory failure
                     // 2  --  m_strCmd is Empty
                     // 3  --  Input parameters Error            
                     // 4  --  Token is Empty                   
                     // 5  --  not find required node            
                     // 6  --  invalid token
                     // 7  --  error symbol token
                     // 8  --  error syntax
                     // 9  --  stack operator error !
                     //10  --  c expression calculate run time error!
                     //11  --  operand type error
                     //12  --  convert operand failure 
                     //13  --  division by 0 
                     //14  --  Abi read memory failure
                     //15  --  Abi write memory failure       
                     //16  --  array size overflow

public :
	void GetErrorNum(int& nErrorNum ) {
		nErrorNum = m_nErrNo;
	};
	    
protected :
    void InitStrCmd(const char* pStrSrc,int flag = 0);
    void SkipLeftSpace(char* pStrSrc, char*& pStrRst);
    void SkipLeftSpace(int nPos, int &nResultPos);
    void SkipRightSpace(char* pStrSrc);

};
                
#endif
/******************************** E O F ***********************************/
