/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNCORE.H
//
//  Description: The header file for the class: CSyntaxCore.
//
//  Author: Chen Jun
//
//  Date: 05/17/95
//
//  Modification:
//      1. 05/17/95, Initial version of the class: CSyntaxCore.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNCORE_
#define _SYNCORE_

#include "address.h"
#include "synlib.h"

typedef struct tagSynColor
{
	CString strText;
	int nColor;
}SynColor;

typedef struct tagHintsList
{
	CString strCommand;
	CStringList* plistHints;
	int nCount;
}HintsList;

/////////////////////////////////////////////////////////////////////////////
// CSyntaxCheck class.
class CSyntaxCore : public CSyntaxLib
{
// Construction & Destruction.
public:
    CSyntaxCore();
    ~CSyntaxCore();
    
// Member variables.
protected:
    // Command parsing varibles.
    enum { MAX_CMDLINE = 255, MAX_ARGV = (255+1)/2 };
    int m_nArgc;
    char* m_pszArgv[MAX_ARGV];

    // Syntax error ID.
    int m_nErrorID;
    int nRet;                               
	int m_nPos;   //The token number till syntax OK    
	int m_nToken; //The total token number
	int m_nEvent;        

    // Command ID.
    int m_nCommandID;
	
    enum { MIN_CMDID        = 0,
           CMDID_VARDEFINE  = 0,
           CMDID_RUNMACRO,           
           CMDID_ALIAS,
           CMDID_ASSEMBLE,           
           CMDID_BREAKPOINT,
           CMDID_BYTE,
           CMDID_CHECKSUM,
           CMDID_CLEAR,
           CMDID_COMPARE,
           CMDID_CONTROL,
           CMDID_COPY,
           CMDID_CREATE,
           CMDID_DELETE,
           CMDID_DISASSEMBLE,
           CMDID_EV1,  //NEW
           CMDID_EV2,  //NEW
           CMDID_EV3,  //NEW
           CMDID_EVENT,//NEW
           CMDID_FILL,
           CMDID_GO,
           CMDID_HALT,
           CMDID_HELP,
           CMDID_IDENTIFY,
           CMDID_INCLUDE,
           CMDID_INPORT, //NEW
           CMDID_JUMP, 
           CMDID_LEVEL, //NEW
           CMDID_LIST,
           CMDID_LOAD,
           CMDID_LOG,
           CMDID_LONG, 
           CMDID_LV1,  //NEW
           CMDID_LV2,  //NEW
           CMDID_MACRO,			
           CMDID_MAP,   
           CMDID_MDEL,
           CMDID_MEMORY,         
		   CMDID_MEND,
		   CMDID_MLIST,
           CMDID_OUTPORT, //NEW
           CMDID_QUALIFY, //NEW          
           CMDID_QUERY,
           CMDID_REGISTER,
           CMDID_RESET,
           CMDID_RESTART,
           CMDID_SEARCH,
           CMDID_SRECALL,
           CMDID_SSAVE,
           CMDID_STEP,
           CMDID_SYMBOL,
           CMDID_TEST,   
           CMDID_TRACE,   //NEW
           CMDID_TRIGGER, //NEW
           CMDID_UPLOAD,                                         
           CMDID_VERIFY,
           CMDID_WATCH,
           CMDID_WORD,
           CMDID_DIAGNOSIS,
           MAX_CMDID    = CMDID_DIAGNOSIS

    };
    
// Implementations.
private:
    BOOL PreStringData(int nArgc, unsigned uDigit);

    // Syntax check kernel routine.
    BOOL SyntaxCheckRunMacro(BOOL isSub);
    BOOL SyntaxCheckVarDefine(BOOL isSub);
    BOOL SyntaxCheckAlias(BOOL isSub);
    BOOL SyntaxCheckAssemble(BOOL isSub);
    //BOOL SyntaxCheckBit(BOOL isSub);
    BOOL SyntaxCheckBreakpoint(BOOL isSub);
    BOOL SyntaxCheckByte(BOOL isSub);
    BOOL SyntaxCheckChecksum(BOOL isSub);
    BOOL SyntaxCheckClear(BOOL isSub);
    BOOL SyntaxCheckCompare(BOOL isSub);
    BOOL SyntaxCheckControl(BOOL isSub);
    BOOL SyntaxCheckCopy(BOOL isSub);
    BOOL SyntaxCheckCycle(BOOL isSub);
    BOOL SyntaxCheckDisassemble(BOOL isSub);  
    BOOL SyntaxCheckEv1(BOOL isSub);
    BOOL SyntaxCheckEv2(BOOL isSub);
    BOOL SyntaxCheckEv3(BOOL isSub);
    BOOL SyntaxCheckEvent(BOOL isSub);
    BOOL SyntaxCheckDiagnosis(BOOL isSub);
    BOOL SyntaxCheckFill(BOOL isSub);
    BOOL SyntaxCheckGo(BOOL isSub);
    BOOL SyntaxCheckHalt(BOOL isSub);
    BOOL SyntaxCheckHelp(BOOL isSub);
    BOOL SyntaxCheckIdentify(BOOL isSub);
    BOOL SyntaxCheckInclude(BOOL isSub);
    BOOL SyntaxCheckInport(BOOL isSub);
    BOOL SyntaxCheckJump(BOOL isSub);
    BOOL SyntaxCheckLevel(BOOL isSub);
    BOOL SyntaxCheckList(BOOL isSub);
    BOOL SyntaxCheckLog(BOOL isSub);
    BOOL SyntaxCheckLong(BOOL isSub);
    BOOL SyntaxCheckLv1(BOOL isSub);
    BOOL SyntaxCheckLv2(BOOL isSub);
    BOOL SyntaxCheckMap(BOOL isSub);
	BOOL SyntaxCheckMacro(BOOL isSub);    
    BOOL SyntaxCheckMdel(BOOL isSub);
    BOOL SyntaxCheckMemory(BOOL isSub);
    BOOL SyntaxCheckMend(BOOL isSub);
    BOOL SyntaxCheckMlist(BOOL isSub);
    BOOL SyntaxCheckOutport(BOOL isSub); 
    BOOL SyntaxCheckQualify(BOOL isSub);
    BOOL SyntaxCheckRegister(BOOL isSub);
    BOOL SyntaxCheckReset(BOOL isSub);
    BOOL SyntaxCheckRestart(BOOL isSub);
    BOOL SyntaxCheckSearch(BOOL isSub);
    BOOL SyntaxCheckStep(BOOL isSub);
    BOOL SyntaxCheckTest(BOOL isSub);
    BOOL SyntaxCheckTrace(BOOL isSub);
	BOOL SyntaxCheckTrigger(BOOL isSub);
    BOOL SyntaxCheckUpload(BOOL isSub);
    BOOL SyntaxCheckVerify(BOOL isSub);
    BOOL SyntaxCheckWord(BOOL isSub);
    BOOL SyntaxCheckCreate(BOOL isSub);
    BOOL SyntaxCheckDelete(BOOL isSub);
    BOOL SyntaxCheckLoad(BOOL isSub);
    BOOL SyntaxCheckQuery(BOOL isSub);
    BOOL SyntaxCheckSsave(BOOL isSub);
    BOOL SyntaxCheckSrecall(BOOL isSub);
    BOOL SyntaxCheckSymbol(BOOL isSub);
    BOOL SyntaxCheckWatch(BOOL isSub);

protected:
    BOOL SyntaxDispatch(const int nCommandID, BOOL isSub = FALSE);
    void FreeMem(char* &pszBuffer);
    void NewMem(char* &pszBuffer, int nLen);

};  // End of class: CSyntaxCore.

#endif
//////////////////////////////// End of File ////////////////////////////////
