/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNCORE1.CPP
//
//  Description: The implementation file for the class: CSyntaxCore.
//
//  Author: Chen Jun
//
//  Date: 05/17/95
//
//  Modification:
//      1. 05/17/95, Initial version of the class: CSyntaxCore.
//      2. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "syncore.h"
//Add by Annie, 3/15/96
#include "address.h"
//#include "addrapi.h"
#include "ctype.h"
//for build
//#include "abibase.h"
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//Define in the Syntax.cpp
void DisplayOutOfMemory(void);
void ShowLine(char* pszBuffer);
//for build
//STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxCore.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::CSyntaxCore().
//
//  Description: The construction of the class: CSyntaxCore.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCore::CSyntaxCore()
{
    // Command parsing varibles initialization.
    m_nArgc = 0;
    for ( int i = 0; i < MAX_ARGV; i++ ) {
        m_pszArgv[i] = 0;
    }

    // Syntax error ID initialization.
    m_nErrorID = 0;

}   // End of CSyntaxCore::CSyntaxCore().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::~CSyntaxCore().
//
//  Description: The destruction of the class: CSyntaxCore.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCore::~CSyntaxCore()
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc >= 0 && m_nArgc <= MAX_ARGV );

    // Release the allocated space.
    for ( int i = 0; i < m_nArgc; i++ ) {
        if ( m_pszArgv[i] ) {
            delete []m_pszArgv[i];
            m_pszArgv[i] = 0;
        }
    }
    if ( m_pszArgv[m_nArgc] ) {
        delete []m_pszArgv[m_nArgc];
        m_pszArgv[m_nArgc] = 0;    
    }
}   // End of CSyntaxCore::~CSyntaxCore().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::PreStringData().
//
//  Description: Pre-process the "string" & data.
//
//  Input:  nArgc - Subscribution of the "string"/data argument.
//          nDigit - bit:1; byte:2; word:4; long:8
//
//  Output: m_nArgc & m_nArgv.
//
//  Return: FALSE - syntax error; TRUE - OK.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCore::PreStringData(int nArgc, unsigned uDigit)
{
    // Assertion of the input parameters.
    ASSERT( 1 == uDigit || 2 == uDigit ||
            4 == uDigit || 8 == uDigit );

    // Pre-process the "string" & data.
    BOOL isString = FALSE;
    char pszArgv[260];
    memset(pszArgv, 0, sizeof(pszArgv));

    if ( '\"' == *m_pszArgv[nArgc] ) {
        isString = TRUE;
    }

    for ( int i = nArgc; i < m_nArgc; i++ ) {
        if ( m_pszArgv[i] ) {
            if ( FALSE == isString ) {  
            	//Add by Annie, 3/20
            	if ('0' == m_pszArgv[i][0] && 
            		'X' == toupper(m_pszArgv[i][1])) {
                	if (2 == strlen(m_pszArgv[i])) { 
						m_nErrorID = SYNTAX_ERROR;                		
                		return (FALSE);             
                	}	
                	if ( strlen(m_pszArgv[i]) > (uDigit+2) ) {
                    	m_nErrorID = SYNTAX_ERROR;
                    	return (FALSE);
                	}                    
                	else {
                		for (UINT j = 0; j<strlen(m_pszArgv[i]) ; j++)
                			m_pszArgv[i][j] = m_pszArgv[i][j+2];
                	}
                	
                }
                else {        
                	char* p = m_pszArgv[i];
    				while ( *p ) {
			        	if ( !isdigit(*p) ) {     
			        		m_nErrorID = SYNTAX_ERROR;
			            	return (FALSE);
        				}                  
        				p++;
        			}                          
                	int nValue = atoi(m_pszArgv[i]);
    				itoa(nValue,m_pszArgv[i],16);  
                	if ( strlen(m_pszArgv[i]) > uDigit ) {
                    	m_nErrorID = SYNTAX_ERROR;
                    	return (FALSE);
                	}
                }	
            }
            strcat(pszArgv, m_pszArgv[i]);
            FreeMem(m_pszArgv[i]);
            if ( FALSE == isString ) {
                strcat(pszArgv, " ");
            }
            else {  
            	if ( pszArgv[strlen(pszArgv)] == ' ' )
                	pszArgv[strlen(pszArgv)-1] = 0;
            }
        }
    }
    m_nArgc = nArgc + 1;

    int nNewLen = MAX_CMDLINE+1;
    NewMem(m_pszArgv[m_nArgc-1], nNewLen);
    if ( !m_pszArgv[m_nArgc-1] ) {
        //AfxMessageBox("Insufficient Memory !");
        DisplayOutOfMemory();
        ASSERT( FALSE );
        return (FALSE);
    }
    else {
        memset(m_pszArgv[m_nArgc-1], 0, sizeof(m_pszArgv[m_nArgc-1]));
        for ( i = strlen(pszArgv)-1; i >= 0; i-- ) {
            if ( ' ' != pszArgv[i] ) {
                break;
            }
            else {
                pszArgv[i] = 0;
            }
        }
        if ( !isString ) {
            strcat(pszArgv, " ");
        }
        strcpy(m_pszArgv[m_nArgc-1], pszArgv);
        //DumpText(m_pszArgv[m_nArgc-1]);
    }
    
    return (TRUE);

}   // End of CSyntaxCore::PreStringData().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::SyntaxDispatch().
//
//  Description: Invoke the syntax checking routine.
//
//  Input:  nCommandID - ID of the command.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCore::SyntaxDispatch(const int nCommandID, BOOL isSub)
{   
    // Assertion of the input parameters.
    ASSERT( nCommandID >= MIN_CMDID && nCommandID <= MAX_CMDID );

    BOOL isTrue = FALSE;
    // Reset the error ID.
    m_nErrorID = 0;
  
    // Dispatch the syntax checking routine.
    switch ( nCommandID ) {                
        case CMDID_RUNMACRO:
			isTrue = SyntaxCheckRunMacro(isSub);
			break;
		case CMDID_VARDEFINE:
			isTrue = SyntaxCheckVarDefine(isSub);
			break;			
		case CMDID_ALIAS:
			isTrue = SyntaxCheckAlias(isSub);
			break;	
        case CMDID_ASSEMBLE:
            isTrue = SyntaxCheckAssemble(isSub);
            break;                             
        case CMDID_BREAKPOINT:
            isTrue = SyntaxCheckBreakpoint(isSub);
            break;                     
        case CMDID_BYTE:
            isTrue = SyntaxCheckByte(isSub);
            break;                             
        case CMDID_CHECKSUM:
            isTrue = SyntaxCheckChecksum(isSub);
            break;
        case CMDID_CLEAR:
            isTrue = SyntaxCheckClear(isSub);
            break;             
        case CMDID_COMPARE:
            isTrue = SyntaxCheckCompare(isSub);
            break;
        case CMDID_CONTROL:
            isTrue = SyntaxCheckControl(isSub);
            break;
        case CMDID_COPY:                  
            isTrue = SyntaxCheckCopy(isSub);
            break;
/*
        case CMDID_CYCLE:                  
            isTrue = SyntaxCheckCycle(isSub);
            break;
*/
        case CMDID_DISASSEMBLE:
            isTrue = SyntaxCheckDisassemble(isSub);
            break;                         
        case CMDID_EV1:                  
            isTrue = SyntaxCheckEv1(isSub);
            break;
        case CMDID_EV2:                  
            isTrue = SyntaxCheckEv2(isSub);
            break;
        case CMDID_EV3:                  
            isTrue = SyntaxCheckEv3(isSub);
            break;
        case CMDID_EVENT:              
            isTrue = SyntaxCheckEvent(isSub);
            break;
        case CMDID_DIAGNOSIS:
            //isTrue = SyntaxCheckDiagnosis(isSub);
        	break;
        case CMDID_FILL:
            isTrue = SyntaxCheckFill(isSub);
            break;
        case CMDID_GO:
            isTrue = SyntaxCheckGo(isSub);
            break;
        case CMDID_HALT:
            isTrue = SyntaxCheckHalt(isSub);
            break;
        case CMDID_HELP:
            isTrue = SyntaxCheckHelp(isSub);
            break;
        case CMDID_IDENTIFY:
            isTrue = SyntaxCheckIdentify(isSub);
            break;
        case CMDID_INCLUDE:
            isTrue = SyntaxCheckInclude(isSub);                      
            break;
        case CMDID_INPORT:
            isTrue = SyntaxCheckInport(isSub);
            break;         
        case CMDID_JUMP:
            isTrue = SyntaxCheckJump(isSub);
            break;       
        case CMDID_LEVEL:                  
            isTrue = SyntaxCheckLevel(isSub);
            break;                               
        case CMDID_LIST:        	
        	isTrue = SyntaxCheckList(isSub);
        	break;        
        case CMDID_LOG:
            isTrue = SyntaxCheckLog(isSub);
            break;
        case CMDID_LONG:
            isTrue = SyntaxCheckLong(isSub);
            break;                 
        case CMDID_LV1:    
            isTrue = SyntaxCheckLv1(isSub);
            break;
        case CMDID_LV2: 
            isTrue = SyntaxCheckLv2(isSub);
            break;
        case CMDID_MACRO:            
        	isTrue = SyntaxCheckMacro(isSub); 
        	break;    
        case CMDID_MAP:
        	isTrue = SyntaxCheckMap(isSub); 
        	break;
        case CMDID_MDEL:
        	isTrue = SyntaxCheckMdel(isSub); 
        	break;
        case CMDID_MEMORY:
            isTrue = SyntaxCheckMemory(isSub);
            break;
        case CMDID_MEND:
        	isTrue = SyntaxCheckMend(isSub); 
        	break;
        case CMDID_MLIST:
        	isTrue = SyntaxCheckMlist(isSub); 
        	break;     
        case CMDID_OUTPORT:
            isTrue = SyntaxCheckOutport(isSub);
            break;
        case CMDID_QUALIFY:        	
        	isTrue = SyntaxCheckQualify(isSub);
        	break;               
        case CMDID_REGISTER:
            isTrue = SyntaxCheckRegister(isSub);
            break;      
        case CMDID_RESET:
            isTrue = SyntaxCheckReset(isSub);
            break;
        case CMDID_RESTART:
        	isTrue = SyntaxCheckRestart(isSub);
        	break;    
        case CMDID_SEARCH:
            isTrue = SyntaxCheckSearch(isSub);
            break;       
        case CMDID_STEP:
            isTrue = SyntaxCheckStep(isSub);
            break;
        case CMDID_TEST:
            isTrue = SyntaxCheckTest(isSub);
            break;
        case CMDID_TRACE:
        	isTrue = SyntaxCheckTrace(isSub);
        	break;
        case CMDID_TRIGGER:        	
        	isTrue = SyntaxCheckTrigger(isSub);
        	break;	                     
        case CMDID_UPLOAD:
            isTrue = SyntaxCheckUpload(isSub);
            break;       
        case CMDID_VERIFY:
            isTrue = SyntaxCheckVerify(isSub);
            break;
        case CMDID_WORD:
            isTrue = SyntaxCheckWord(isSub);
            break;       
        case CMDID_CREATE:
            isTrue = SyntaxCheckCreate(isSub);
            break;                    
        case CMDID_DELETE:
            isTrue = SyntaxCheckDelete(isSub);
            break;
        case CMDID_LOAD:
            isTrue = SyntaxCheckLoad(isSub);
            break;      
        case CMDID_QUERY:
            isTrue = SyntaxCheckQuery(isSub);
            break;                    
        case CMDID_SSAVE:
            isTrue = SyntaxCheckSsave(isSub);
            break;
        case CMDID_SRECALL:
            isTrue = SyntaxCheckSrecall(isSub);
            break;
        case CMDID_SYMBOL:
            isTrue = SyntaxCheckSymbol(isSub);
            break;
        case CMDID_WATCH:
            isTrue = SyntaxCheckWatch(isSub);
            break;
        default:
            ASSERT( FALSE );
            break;
    }              

    return isTrue;

}   // End of CSyntaxCore::SyntaxDispatch().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::SyntaxCheck***().
//
//  Description: Syntax check kernel routine. 58 routines.
//
//  Input:  m_nArgc - The number of the command parameters.
//          m_pszArgv[nArgc] - The contents of the command parameters.
//
//  Output: m_nErrorID - ID of the syntax error.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
//@macroname 	[(arg0,...,arg9)]
BOOL CSyntaxCore::SyntaxCheckRunMacro(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }                                   
    
    BOOL isTrue = FALSE;
    char p[260];
    int nRet = 0;
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
        case 1:         
        	m_nPos = 1;          
        	isTrue = TRUE;
        	break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
            strcpy(p,m_pszArgv[0]+1);
            if ( IsFilename(p, nRet) ) {
            	m_nPos = 1;     
            	isTrue = TRUE;
            }    
            else {
                m_nErrorID = nRet;
            }                 			
            break;
		default:
			m_nPos = 100;
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return isTrue;    

}	//End of CSyntaxCore::SyntaxCheckRunMacro().                  
                  
//$variable = value
BOOL CSyntaxCore::SyntaxCheckVarDefine(BOOL /*isSub*/)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc = 1 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	
	if ('$' != m_pszArgv[0][0])           
		m_nErrorID = SYNTAX_ERROR;

	return TRUE;	
}                  

// Alias [original_name new_name]
BOOL CSyntaxCore::SyntaxCheckAlias(BOOL isSub)    
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }                   
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
    	case 1:
    		m_nPos = 1;       
    		isTrue = TRUE;
    		break;      
        case 2:           
			if ( IsCommandName(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;
			}              
			else {
			    m_nPos = 1;			    
			}                                           
			m_nErrorID = SYNTAX_ERROR;			
        	break;                    
        case 3:          
			if ( IsCommandName(m_pszArgv[1]) ) {
				if ( IsCommandName(m_pszArgv[2]) ) {				
					m_nPos = 100;       	
				}
				else {
					m_nPos = 2;                     
					m_nErrorID = SYNTAX_ERROR;			
				}	
			}                                           
			else {                                  
				m_nPos = 1;                     
				m_nErrorID = SYNTAX_ERROR;			
			}             			     
            break;
        default:
			if ( IsCommandName(m_pszArgv[1]) ) {
				if ( IsCommandName(m_pszArgv[2]) ) {				
					m_nPos = 100;       
				}
				else {
					m_nPos = 2;                     					
				}	
			}                                           
			else {                                  
				m_nPos = 1;                     				
			}   
			m_nErrorID = SYNTAX_ERROR;						          			     
            break;
	}        
    return isTrue;    
}                           
                               
// Assemble     [adr]
BOOL CSyntaxCore::SyntaxCheckAssemble(BOOL isSub)
{   
    char szArgv[260];
    
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:
            m_nPos = 1;  
			isTrue = TRUE;
            break;
        case 2:
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_P0)) {
              	m_nErrorID = nRet; 
              	m_nPos = 1;
            	break;
            }                                 
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);                                  
                   
        	if ( IsAddrPX(m_pszArgv[1]) ) {
		        isTrue = TRUE;
		        m_nPos = 100;  
		    }    
        	else {
                m_nErrorID = ADDR_TYPE_ERROR;
                m_nPos = 1;            	
        	}
        	break;
        default:           
        	if ( IsAddrPX(m_pszArgv[1]) ) {
		        m_nPos = 100;  
		    }    
        	else {
                m_nPos = 1;            	
        	}
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
    return isTrue;
    	
}   // End of CSyntaxCore::SyntaxCheckAssemble().

/*
// Bit          bit-adr {0|1} [..{0|1}]
BOOL CSyntaxCore::SyntaxCheckBit(BOOL isSub)
{              

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    char* szArgv;
    szArgv = new char[260];
    ASSERT(szArgv);

    BOOL isTrue = FALSE;                     
    int nCount;
    int nArgc;
    
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	     
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
		case 2:                       
			if ( IsBAddr(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
			}
			m_nErrorID = SYNTAX_ERROR;			
			break;
        default:
		    nArgc = 2;
		    
			if ( IsBAddr(m_pszArgv[1]) ) {           
			    if ( !PreStringData(nArgc, 2) ) { 
			    	m_nErrorID = SYNTAX_ERROR;
			        m_nPos = 2;
			        break;
			    }            
				ConvertAddress(m_pszArgv[1], szArgv, nRet);				
            	if( !IsDataBit(m_pszArgv[2])) {
            		m_nErrorID = SYNTAX_ERROR;
            		m_nPos = 2;
                	break;
            	}                 
	            NewMem(m_pszArgv[1], strlen(szArgv)+1);
	            strcpy(m_pszArgv[1],szArgv);
	            if ( !IsBitRange(m_pszArgv[1], m_pszArgv[2]) ) {
	                m_nErrorID = SYNTAX_ERROR;
	                m_nPos = 2;
	                break;
	            }                     
				m_nPos = 3;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
				m_nErrorID = SYNTAX_ERROR;			
			}                                       			
			break;
    }
    if (szArgv) {
    	delete []szArgv;    
    	szArgv = 0;
    }	

	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckBit().
*/

// BReakpoint   [adr]
BOOL CSyntaxCore::SyntaxCheckBreakpoint(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }           
    char szArgv[260];

    // Check command syntax.
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:        
            m_nPos = 1;  
			isTrue = TRUE;
            break;
        case 2:
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_P0)) {
              	m_nErrorID = nRet;
              	m_nPos = 1;  
            	break;
            }                      
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);
        	if ( IsPAddr(m_pszArgv[1]) ) {
                isTrue = TRUE;
                m_nPos = 100;  
            }    
            else {    
                m_nErrorID = ADDR_TYPE_ERROR;
                m_nPos = 1;  
            }   
	       	break;
        default:
        	if ( IsPAddr(m_pszArgv[1]) ) {
                m_nPos = 100;  
            }    
            else {    
                m_nPos = 1;  
            }   
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return isTrue;    
}   // End of CSyntaxCore::SyntaxCheckBreakpoint().


// Byte         adr data1 [.. data32]
BOOL CSyntaxCore::SyntaxCheckByte(BOOL isSub)
{

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.      
	char szArgv[260];

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	     
    
    int nArgc;
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
		case 2:                       
			if ( IsAddr(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
			}
			m_nErrorID = SYNTAX_ERROR;			
			break;
        default:
		    nArgc = 2;
		    
			if ( IsAddr(m_pszArgv[1]) ) {           
			    if ( !PreStringData(nArgc, 2) ) { 
			    	m_nErrorID = SYNTAX_ERROR;
			        m_nPos = 2;
			        break;
			    }            
				ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_X0);				
/*
	            if (IsBAddr(szArgv)) {
	            	if( !IsDataBit(m_pszArgv[2])) {
	            		m_nErrorID = SYNTAX_ERROR;
	            		m_nPos = 2;
	                	break;
	            	}                 
	            }	
	            else if ( !IsData(m_pszArgv[2]) ) {
*/
	            if ( !IsData(m_pszArgv[2]) ) {
	                m_nErrorID = SYNTAX_ERROR;
	                m_nPos = 2;
	                break;
	            }
	            NewMem(m_pszArgv[1], strlen(szArgv)+1);
	            strcpy(m_pszArgv[1],szArgv);
	            if ( !IsDataRange(m_nArgc, m_pszArgv, 1) ) {
	                m_nErrorID = SYNTAX_ERROR;
	                m_nPos = 2;
	                break;
	            }    
				m_nPos = 3;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
				m_nErrorID = SYNTAX_ERROR;			
			}                                       			
			break;
    }

	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckByte().


// CHecksum     adr1 {adr2|Length length}
BOOL CSyntaxCore::SyntaxCheckChecksum(BOOL isSub)
{
	char szArgv1[260];
	char szArgv2[260];
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;              
        	m_nErrorID = SYNTAX_ERROR;
        	break;
        case 2:   
            if ( IsAddrPXI(m_pszArgv[1]) ) {
            	m_nPos = 2;            	
            	isTrue = TRUE;
            }              
            else {
			    m_nPos = 1;   			    
            }                       
            m_nErrorID = SYNTAX_ERROR;
            break;
        case 3:                       
            if ( IsAddrPXI(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;     
		            	m_nPos = 2;
		            }	           
		            else {
			            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0)) {
			              	m_nErrorID = nRet;
			            	break;
			            }	
			            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet, SPACE_X0)) {
			              	m_nErrorID = nRet;
			            	break;
			            }	                          						                                         
						NewMem(m_pszArgv[1], strlen(szArgv1)+1);
						NewMem(m_pszArgv[2], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv1);                                  
			            strcpy(m_pszArgv[2],szArgv2); 		            
			            m_nPos = 100;
			            isTrue = TRUE;              
		            }                			
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
            		m_nPos = 3;
            		isTrue = TRUE;	
            	}            
            	else {         
            		m_nPos = 2;
					m_nErrorID = SYNTAX_ERROR;            	
            	}
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }      
            break;
        case 4:
            if ( IsAddrPXI(m_pszArgv[1])) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;
		            }	           
		            else {   
						m_nPos = 100;
					}
					m_nErrorID = SYNTAX_ERROR;
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_X0)) {
			              	m_nErrorID = nRet;
			              	m_nPos = 3;
			            	break;
			            }			            
			            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv2);                                  
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			                m_nErrorID = nRet;                
			            	m_nPos = 3;
			            	break;
			            }                     
			            ConvertLen(m_pszArgv[3], szArgv1);
			           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[3],szArgv1);                                  					
						isTrue = TRUE;	
						m_nPos = 100;
            		}   
            		else {
	            		m_nPos = 3;
	            		m_nErrorID = nRet;                	            		
	            	}	
            	}            
            	else {         
            		m_nPos = 2;
					m_nErrorID = SYNTAX_ERROR;            	
            	}
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }       
            break;
        default:
            if ( IsAddrPXI(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;		            	
		            }	           
		            else {   
						m_nPos = 100;
					}
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			            	m_nPos = 3;
			            }                     
						m_nPos = 100;
            		}   
            	}            
            	else {         
            		m_nPos = 2;
            	}
            }
            else {
            	m_nPos = 1;                       	
            }   
            m_nErrorID = SYNTAX_ERROR;    
            break;
    }
	return isTrue;
}   // CSyntaxCore::SyntaxCheckChecksum().


// CLear        {All|adr}
BOOL CSyntaxCore::SyntaxCheckClear(BOOL isSub)
{
	char szArgv[260];
	
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:
            m_nPos = 1;  
			m_nErrorID = SYNTAX_ERROR;
            break;
        case 2:         
        	if ( IsKeywordAll(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	isTrue = TRUE;
            	break;    
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_P0)) {
              	m_nErrorID = nRet;
              	m_nPos = 1;  
            	break;
            }                      
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);
        	if ( IsPAddr(m_pszArgv[1]) ) {
                isTrue = TRUE;
                m_nPos = 100;  
            }    
            else {    
                m_nErrorID = ADDR_TYPE_ERROR;
                m_nPos = 1;  
            }   
            break;
        default:
        	if ( IsKeywordAll(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	break;    
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_P0)) {
              	m_nErrorID = SYNTAX_ERROR;
              	m_nPos = 1;  
            	break;
            }                      
        	if ( IsPAddr(m_pszArgv[1]) ) {
                m_nPos = 100;  
            }    
            else {    
                m_nPos = 1;  
            }   
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    	
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckClear().


// COMpare      adr1 {adr2|Length length} adr3
BOOL CSyntaxCore::SyntaxCheckCompare(BOOL isSub)
{
	char szArgv1[260];
	char szArgv2[260];
	char szArgv3[260];	
	
    ADDR_RETCODE retCode;
    
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:
        	m_nPos = 1;   
        	m_nErrorID = SYNTAX_ERROR;
        	break;
        case 2:   
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	m_nPos = 2;            	
            	isTrue = TRUE;
            }              
            else {
			    m_nPos = 1;   			    
	        }                       
        	m_nErrorID = SYNTAX_ERROR;
        	break;
        case 3:          
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
		        	retCode = AdrCheck2Addr(m_pszArgv[1], m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
                    	m_nPos = 2;
                    }
                    else {
	            		m_nPos = 4;            		
	            		isTrue = TRUE;
	            	}	
            	}
            	else if ( IsKeywordLength(m_pszArgv[2]) ) {
            		m_nPos = 3;   
            		isTrue = TRUE;         	
            	}	            
            	else {
            		m_nPos = 2;
            	}		
            }              
            else {
			    m_nPos = 1;   			    
            }                       
        	m_nErrorID = SYNTAX_ERROR;
        	break;        
        case 4:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
		        	if ( IsAddrPX(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[1], m_pszArgv[2]);
			            if (ADR_OK != retCode) {       
			            	m_nErrorID = SYNTAX_ERROR;
			            	m_nPos = 2;
			            	break;
			            }	                              
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
			            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
			            ConvertAddress(m_pszArgv[3], szArgv3, nRet, SPACE_X0);
			            if ( !IsAddrRange(szArgv1, szArgv2, szArgv3) ) {
			                m_nErrorID = ADDR_OUT_OF_RANGE;//SYNTAX_ERROR;
			                m_nPos = 4;
			                break;  
			            }                             
			            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
			            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
			            NewMem(m_pszArgv[3], strlen(szArgv3)+1);
			            strcpy(m_pszArgv[1], szArgv1);                                  
			            strcpy(m_pszArgv[2], szArgv2); 
			            strcpy(m_pszArgv[3], szArgv3); 
			            isTrue = TRUE;
    				}
            		else {
	            		m_nPos = 4;            		  
	            		m_nErrorID = SYNTAX_ERROR;
	            	}	
            	}
            	else if ( IsKeywordLength(m_pszArgv[2]) ) {
            		if ( IsAddrLen(m_pszArgv[3], nRet) ) {
						if ( IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {            			
	            			m_nPos = 4;
	            			isTrue = TRUE;         	
	            		}
	            		else {
	            			m_nPos = 3;
	            		}	
            		}
            		else {            		
            			m_nPos = 3;   
            		}
					m_nErrorID = SYNTAX_ERROR;            		
            	}	            
            	else {
            		m_nPos = 2;               
            		m_nErrorID = SYNTAX_ERROR;
            	}		
            }              
            else {
			    m_nPos = 1;   			      
			    m_nErrorID = SYNTAX_ERROR;
            }                       
            break;                 
        case 5:                              
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
		        	if ( IsAddrPX(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[1], m_pszArgv[2]);
			            if (ADR_OK != retCode) {       
			            	m_nErrorID = SYNTAX_ERROR;
			            	m_nPos = 2;
			            	break;
			            }	                              
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
			            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
			            ConvertAddress(m_pszArgv[3], szArgv3, nRet, SPACE_X0);
			            if ( !IsAddrRange(szArgv1, szArgv2, szArgv3) ) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;  
			            }                             
    				}
            		else {
	            		m_nPos = 4;            		  
	            		m_nErrorID = SYNTAX_ERROR;
	            	}	
            	}
            	else if ( IsKeywordLength(m_pszArgv[2]) ) {
            		if ( IsAddrLen(m_pszArgv[3], nRet) ) {
						if ( IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {            			
							if ( IsAddrPX(m_pszArgv[4]) ) {
					            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_X0)) {
					              	m_nErrorID = nRet;
					            	break;
					            }	
					            if (!ConvertAddress(m_pszArgv[4], szArgv3, nRet, SPACE_X0)) {
					              	m_nErrorID = nRet;
					            	break;
					            } 
					            if ( !IsLengthRange(szArgv2, m_pszArgv[3], szArgv3, nRet) ) {
					                m_nErrorID = nRet;
					                m_nPos = 4;                
					                break;
					            }                                                               
					            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
					            strcpy(m_pszArgv[1],szArgv2);                                  
					            
					            ConvertLen(m_pszArgv[3], szArgv1);
					           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
					            strcpy(m_pszArgv[3],szArgv1);                                  
					        	
					            NewMem(m_pszArgv[4], strlen(szArgv3)+1);
					            strcpy(m_pszArgv[4],szArgv3);            

								m_nPos = 100;       
								isTrue = TRUE;         	
							}
							else {
	            				m_nPos = 4;
	            				m_nErrorID = SYNTAX_ERROR;
	            			}	
	            		}
	            		else {
	            			m_nPos = 3;                   
	            			m_nErrorID = SYNTAX_ERROR;
	            		}	
            		}
            		else {            		
            			m_nPos = 3;                   
            			m_nErrorID = SYNTAX_ERROR;
            		}                             										                                    
            	}	            
            	else {
            		m_nPos = 2;               
            		m_nErrorID = SYNTAX_ERROR;
            	}		
            }              
            else {
			    m_nPos = 1;   			      
			    m_nErrorID = SYNTAX_ERROR;
            }                       
        	break;
        default:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
		        	if ( IsAddrPX(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[1], m_pszArgv[2]);
			            if (ADR_OK != retCode) {       
			            	m_nPos = 2;
			            	m_nErrorID = SYNTAX_ERROR;
			            	break;
			            }	                              
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet);
			            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
			            ConvertAddress(m_pszArgv[3], szArgv3, nRet);
			            if ( !IsAddrRange(szArgv1, szArgv2, szArgv3) ) {
			                m_nPos = 4;
			            }                             
    				}
            		else {
	            		m_nPos = 4;            		  
	            	}	
            	}
            	else if ( IsKeywordLength(m_pszArgv[2]) ) {
            		if ( IsAddrLen(m_pszArgv[3], nRet) ) {
						if ( IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {            			
							if ( IsAddrPX(m_pszArgv[4]) ) {
					            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet)) {
					              	m_nErrorID = nRet;
					            	break;
					            }	
					            if (!ConvertAddress(m_pszArgv[4], szArgv3, nRet)) {
					              	m_nErrorID = nRet;
					            	break;
					            } 
					            if ( !IsLengthRange(szArgv2, m_pszArgv[3], szArgv3, nRet) ) {
					                m_nErrorID = nRet;                
					                break;
					            }                                                               
					            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
					            strcpy(m_pszArgv[1],szArgv2);                                  
					            
					            ConvertLen(m_pszArgv[3], szArgv1);
					           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
					            strcpy(m_pszArgv[3],szArgv1);                                  
					        	
					            NewMem(m_pszArgv[4], strlen(szArgv3)+1);
					            strcpy(m_pszArgv[4],szArgv3);            
								m_nPos = 100;       
							}
							else {
	            				m_nPos = 4;
	            			}	
	            		}
	            		else {
	            			m_nPos = 3;                   
	            		}	
            		}
            		else {            		
            			m_nPos = 3;                   
            		}                             										                                    
            	}	            
            	else {
            		m_nPos = 2;               
            	}		
            }              
            else {
			    m_nPos = 1;   			      
            }                       
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    	
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckCompare().


// CONtrol      [ {Reset|Nmi|EXtint} {Enable|Disable} ]
BOOL CSyntaxCore::SyntaxCheckControl(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
        case 1:
        	m_nPos = 1;   
			isTrue = TRUE;
        	break;        
		case 2:   
			if ( IsKeywordControlOption(m_pszArgv[1]) ) { 
			    m_nPos = 2; 
			    isTrue = TRUE;
			}
			else {                    
				m_nPos = 1;
			}
			m_nErrorID = SYNTAX_ERROR;
			break;        	
        case 3:           
			if ( IsKeywordControlOption(m_pszArgv[1]) ) { 
				if ( IsKeywordEnable(m_pszArgv[2]) ||
					 IsKeywordDisable(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
				}
				else {						
			    	m_nPos = 2;           
			    	m_nErrorID = SYNTAX_ERROR;
			    }	
			}
			else {                    
				m_nPos = 1;
				m_nErrorID = SYNTAX_ERROR;
			}
            break;
        default:
			if ( IsKeywordControlOption(m_pszArgv[1]) ) { 
				if ( IsKeywordEnable(m_pszArgv[2]) ||
					 IsKeywordDisable(m_pszArgv[2]) ) {
					m_nPos = 100;
				}
				else {						
			    	m_nPos = 2;           
			    }	
			}
			else {                    
				m_nPos = 1;
			}
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckControl().


// Copy         adr1 {adr2|Length length} adr3
BOOL CSyntaxCore::SyntaxCheckCopy(BOOL isSub)
{
	char szArgv1[260];
	char szArgv2[260];
	char szArgv3[260];
	
	ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
        case 1:
        	m_nPos = 1;   
        	m_nErrorID = SYNTAX_ERROR;
        	isTrue = TRUE;
        	break;
        case 2:   
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	m_nPos = 2;            	
            	isTrue = TRUE;
            }              
            else {
			    m_nPos = 1;   			    
	        }                       
        	m_nErrorID = SYNTAX_ERROR;
        	break;
        case 3:          
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
		        	retCode = AdrCheck2Addr(m_pszArgv[1], m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
                    	m_nPos = 2;
                    }
                    else {
	            		m_nPos = 4;            		
	            		isTrue = TRUE;
	            	}	
            	}
            	else if ( IsKeywordLength(m_pszArgv[2]) ) {
            		m_nPos = 3;   
            		isTrue = TRUE;         	
            	}	            
            	else {
            		m_nPos = 2;
            	}		
            }              
            else {
			    m_nPos = 1;   			    
            }                       
        	m_nErrorID = SYNTAX_ERROR;
        	break;        
        case 4:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
		        	if ( IsAddrPX(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[1], m_pszArgv[2]);
			            if (ADR_OK != retCode) {       
			            	m_nErrorID = SYNTAX_ERROR;
			            	m_nPos = 2;
			            	break;
			            }	                              
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
			            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
			            ConvertAddress(m_pszArgv[3], szArgv3, nRet, SPACE_X0);
			            if ( !IsAddrRange(szArgv1, szArgv2, szArgv3) ) {
			                m_nErrorID = ADDR_OUT_OF_RANGE;
			                m_nPos = 4;
			                break;  
			            }                             
			            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
			            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
			            NewMem(m_pszArgv[3], strlen(szArgv3)+1);
			            strcpy(m_pszArgv[1], szArgv1);                                  
			            strcpy(m_pszArgv[2], szArgv2); 
			            strcpy(m_pszArgv[3], szArgv3); 
			            isTrue = TRUE;
    				}
            		else {
	            		m_nPos = 4;            		  
	            		m_nErrorID = SYNTAX_ERROR;
	            	}	
            	}
            	else if ( IsKeywordLength(m_pszArgv[2]) ) {
            		if ( IsAddrLen(m_pszArgv[3], nRet) ) {
						if ( IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {            			
	            			m_nPos = 4;
	            			isTrue = TRUE;         	
	            		}
	            		else {
	            			m_nPos = 3;
	            		}	
            		}
            		else {            		
            			m_nPos = 3;   
            		}
					m_nErrorID = SYNTAX_ERROR;            		
            	}	            
            	else {
            		m_nPos = 2;               
            		m_nErrorID = SYNTAX_ERROR;
            	}		
            }              
            else {
			    m_nPos = 1;   			      
			    m_nErrorID = SYNTAX_ERROR;
            }                       
            break;                 
        case 5:                              
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
		        	if ( IsAddrPX(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[1], m_pszArgv[2]);
			            if (ADR_OK != retCode) {       
			            	m_nErrorID = SYNTAX_ERROR;
			            	m_nPos = 2;
			            	break;
			            }	                              
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
			            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
			            ConvertAddress(m_pszArgv[3], szArgv3, nRet, SPACE_X0);
			            if ( !IsAddrRange(szArgv1, szArgv2, szArgv3) ) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;  
			            }                             
    				}
            		else {
	            		m_nPos = 4;            		  
	            		m_nErrorID = SYNTAX_ERROR;
	            	}	
            	}
            	else if ( IsKeywordLength(m_pszArgv[2]) ) {
            		if ( IsAddrLen(m_pszArgv[3], nRet) ) {
						if ( IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {            			
							if ( IsAddrPXI(m_pszArgv[4]) ) {
					            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_X0)) {
					              	m_nErrorID = nRet;
					            	break;
					            }	
					            if (!ConvertAddress(m_pszArgv[4], szArgv3, nRet, SPACE_X0)) {
					              	m_nErrorID = nRet;
					            	break;
					            } 
					            if ( !IsLengthRange(szArgv2, m_pszArgv[3], szArgv3, nRet) ) {
					                m_nErrorID = nRet;     
					                m_nPos = 4;           
					                break;
					            }                                                               
					            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
					            strcpy(m_pszArgv[1],szArgv2);                                  
					            
					            ConvertLen(m_pszArgv[3], szArgv1);
					           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
					            strcpy(m_pszArgv[3],szArgv1);                                  
					        	
					            NewMem(m_pszArgv[4], strlen(szArgv3)+1);
					            strcpy(m_pszArgv[4],szArgv3);            

								m_nPos = 100;       
								isTrue = TRUE;         	
							}
							else {
	            				m_nPos = 4;
	            				m_nErrorID = SYNTAX_ERROR;
	            			}	
	            		}
	            		else {
	            			m_nPos = 3;                   
	            			m_nErrorID = SYNTAX_ERROR;
	            		}	
            		}
            		else {            		
            			m_nPos = 3;                   
            			m_nErrorID = SYNTAX_ERROR;
            		}                             										                                    
            	}	            
            	else {
            		m_nPos = 2;               
            		m_nErrorID = SYNTAX_ERROR;
            	}		
            }              
            else {
			    m_nPos = 1;   			      
			    m_nErrorID = SYNTAX_ERROR;
            }                       
        	break;
        default:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
		        	if ( IsAddrPX(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[1], m_pszArgv[2]);
			            if (ADR_OK != retCode) {       
			            	m_nPos = 2;
			            	m_nErrorID = SYNTAX_ERROR;
			            	break;
			            }	                              
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0 );
			            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
			            ConvertAddress(m_pszArgv[3], szArgv3, nRet, SPACE_X0);
			            if ( !IsAddrRange(szArgv1, szArgv2, szArgv3) ) {
			                m_nPos = 4;
			            }                             
    				}
            		else {
	            		m_nPos = 4;            		  
	            	}	
            	}
            	else if ( IsKeywordLength(m_pszArgv[2]) ) {
            		if ( IsAddrLen(m_pszArgv[3], nRet) ) {
						if ( IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {            			
							if ( IsAddrPXI(m_pszArgv[4]) || IsAddrDefault(m_pszArgv[4]) ) {
					            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_X0)) {
					              	m_nErrorID = nRet;
					            	break;
					            }	
					            if (!ConvertAddress(m_pszArgv[4], szArgv3, nRet, SPACE_X0)) {
					              	m_nErrorID = nRet;
					            	break;
					            } 
					            if ( !IsLengthRange(szArgv2, m_pszArgv[3], szArgv3, nRet) ) {
					                m_nErrorID = nRet;                
					                m_nPos = 4;
					                break;
					            }                                                               
					            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
					            strcpy(m_pszArgv[1],szArgv2);                                  
					            
					            ConvertLen(m_pszArgv[3], szArgv1);
					           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
					            strcpy(m_pszArgv[3],szArgv1);                                  
					        	
					            NewMem(m_pszArgv[4], strlen(szArgv3)+1);
					            strcpy(m_pszArgv[4],szArgv3);            
								m_nPos = 100;       
							}
							else {
	            				m_nPos = 4;
	            			}	
	            		}
	            		else {
	            			m_nPos = 3;                   
	            		}	
            		}
            		else {            		
            			m_nPos = 3;                   
            		}                             										                                    
            	}	            
            	else {
            		m_nPos = 2;               
            	}		
            }              
            else {
			    m_nPos = 1;   			      
            }                       
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    	
	return TRUE;
}   // End of CSyntaxCore::SyntaxCheckCopy().


// CYcle             
/*
BOOL CSyntaxCore::SyntaxCheckCycle(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
        case 1:
        	m_nPos = 100; 
        	isTrue = TRUE;  
        	break;
        default:
        	m_nPos = 100;
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckCycle().
*/

// Disassemble  [adr1 [adr2|Length length]]
BOOL CSyntaxCore::SyntaxCheckDisassemble(BOOL isSub)
{
	char szArgv1[260];
	char szArgv2[260];
	
	ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;              
        	break;
        case 2:         
        	if ( ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_P0) ) {
				NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[1],szArgv1);      
	            if ( IsAddrPX(m_pszArgv[1]) ) {
	            	m_nPos = 2;            	
	            	isTrue = TRUE;
	            }              
	            else {
				    m_nPos = 1;  
				    m_nErrorID = SYNTAX_ERROR;      			    	            
	            }
	        }    
            else {
			    m_nPos = 1;  
			    m_nErrorID = SYNTAX_ERROR;      			    
            }                       
            break;
        case 3:                       
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;     
		            	m_nPos = 2;
		            }	           
		            else {
			            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_P0)) {
			              	m_nErrorID = nRet;
			            	break;
			            }	
			            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
			              	m_nErrorID = nRet;
			            	break;
			            }	                          						                                         
						NewMem(m_pszArgv[1], strlen(szArgv1)+1);
						NewMem(m_pszArgv[2], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv1);                                  
			            strcpy(m_pszArgv[2],szArgv2); 		                           
			            m_nPos = 100;
			            isTrue = TRUE;			            
		            }                			
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
            		m_nPos = 3;
            		isTrue = TRUE;	
            	}            
            	else {         
            		m_nPos = 2;
					m_nErrorID = SYNTAX_ERROR;            	
            	}
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }      
            break;
        case 4:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;
		            }	           
		            else {   
						m_nPos = 100;
					}
					m_nErrorID = SYNTAX_ERROR;
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			                m_nErrorID = nRet;                
			            	m_nPos = 3;
			            	break;
			            }                     
			            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_P0)) {
			              	m_nErrorID = nRet;
			              	m_nPos = 3;
			            	break;
			            }
			            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv2);                                  
			            
			            ConvertLen(m_pszArgv[3], szArgv1);
			           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[3],szArgv1);                                  
					
						isTrue = TRUE;	
						m_nPos = 100;
            		}   
            		else {
	            		m_nPos = 3;
	            		m_nErrorID = nRet;                	            		
	            	}	
            	}            
            	else {         
            		m_nPos = 2;
					m_nErrorID = SYNTAX_ERROR;            	
            	}
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }       
            break;
        default:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;		            	
		            }	           
		            else {   
						m_nPos = 100;
					}
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			            	m_nPos = 3;
			            }                     
			            else {
							m_nPos = 100;
						}	
            		}   
            		else { 	            		
	            		m_nPos = 3;
	            	}	
            	}            
            	else {         
            		m_nPos = 2;
            	}
            }
            else {
            	m_nPos = 1;                       	
            }   
            m_nErrorID = SYNTAX_ERROR;    
            break;
    }
    
    return isTrue;
}   // End of CSyntaxCore::SyntaxCheckDisassemble().
                               
//Add by Annie, 3/7/96
//!DIAgnotics [ [PIO] [MAP] [EVENTADDR] [EVENTDATA] [SPOON] [EMULATION] [TRACE] ]
BOOL CSyntaxCore::SyntaxCheckDiagnosis(BOOL /*isSub*/)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	
    // Check command syntax.
    switch ( m_nArgc ) {
	    case 1:        
            break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:                    
            if ( !IsDiagnosisOption(m_nArgc, m_pszArgv) ) {
	                m_nErrorID = SYNTAX_ERROR;
	        }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return TRUE;
}  //End of CSyntacCore::SyntaxCheckDiagnosis()
        
                                                 
//EV1         [[Address {Range adr1 adr2|xadr|<badrs..>}]
//            [DATum Byte|Word {Range data1 data2|xdata|bdata}]
//            [COunt count]] |
//            [Clear]                                                 
BOOL CSyntaxCore::SyntaxCheckEv1(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                    
	BOOL isTrue = FALSE;	                    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    // Check command syntax.
    switch ( nCount ) {
	    case 1: 
	    	m_nPos = 1;
	    	isTrue = TRUE;       
            break;        
        case 2:
        	if ( IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;
        	}                 
        	else if ( IsKeywordAddress(m_pszArgv[1]) ) {
        		m_nPos = 2;   
        		isTrue = TRUE;                
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	else if ( IsKeywordDatum(m_pszArgv[1]) ) {
        		m_nPos = 3;   
        		isTrue = TRUE;            
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	else if ( IsKeywordCount(m_pszArgv[1]) ) {
        		m_nPos = 4;   
        		isTrue = TRUE;            
        		m_nErrorID = SYNTAX_ERROR;
        	}             
        	else {
        		m_nPos = 1;               
        		m_nErrorID = SYNTAX_ERROR;
        	}        	                  
        	break;
        default:                                               	
	        // Initial flag.
	        BOOL isA = FALSE;   //Address
	        BOOL isD = FALSE;   //Datum	        
	        BOOL isC = FALSE;   //Count
            int nIndex = 1;           
            ADDR_RETCODE retCode;        
            char szArgv1[300];         
            char szArgv2[300];
            
            if ( IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;        	
        		m_nErrorID = SYNTAX_ERROR;	
        	}                             
        	while ( nIndex < nCount ) {  
        		//Address ...
       			if ( IsKeywordAddress(m_pszArgv[nIndex]) ) {
        			if ( !isA ) {       
        				isA = TRUE;	
        				if ( ++nIndex < nCount ) {
        					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {								
								if ( ++nIndex < nCount ) {
									if ( IsPAddr(m_pszArgv[nIndex]) ) {
								 		if ( ++nIndex < nCount ) {
								 			if ( IsPAddr(m_pszArgv[nIndex]) || IsAddrDefault(m_pszArgv[nIndex])) {
												retCode = AdrCheck2Addr(m_pszArgv[nIndex-1],m_pszArgv[nIndex]);
									            if (ADR_OK == retCode) {   									            	    
										            if (!ConvertAddress(m_pszArgv[nIndex-1], szArgv1, nRet, SPACE_P0)) {
										              	m_nErrorID = nRet;
										            	break;
										            }	
										            if (!ConvertAddress(m_pszArgv[nIndex], szArgv2, nRet)) {
										              	m_nErrorID = nRet;
										            	break;
										            }	                          						                                         
													NewMem(m_pszArgv[nIndex-1], strlen(szArgv1)+1);
													NewMem(m_pszArgv[nIndex], strlen(szArgv2)+1);
										            strcpy(m_pszArgv[nIndex-1],szArgv1);                                  
										            strcpy(m_pszArgv[nIndex],szArgv2); 		                           
									 				m_nPos = 7;
									 				if ( ++nIndex >= nCount ) {								 				
									 					isTrue = TRUE;								 													 					
									 				}    
									 			}
									 			else {
									 				m_nPos = 6;
									 				m_nErrorID = SYNTAX_ERROR;
									 				break;
									 			}	
								 			}
								 			else {
								 				m_nPos = 6;
								 				m_nErrorID = SYNTAX_ERROR;
								 				break;
								 			}
								 		}
								 		else {
								 			m_nPos = 6;
								 			isTrue = TRUE;                    
								 			m_nErrorID = SYNTAX_ERROR;    
								 			break;
								 		}			
								 	}   
								 	else {
								 		m_nPos = 5;
								 		m_nErrorID = SYNTAX_ERROR;
								 		break;
								 	}
								}     
								else {
								 	m_nPos = 5;
								 	isTrue = TRUE;                    
								 	m_nErrorID = SYNTAX_ERROR;
								 	break;
								}
        					}	
        					else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
        						m_nPos = 7;
        						if ( ++nIndex >= nCount ) {
        							isTrue = TRUE;	
        						}
        					}
        					else if ( IsMultipleAddr(m_pszArgv[nIndex]) ) {
        						m_nPos = 7;
        						if ( ++nIndex >= nCount ) {
        							isTrue = TRUE;	
        						}
        					}
        					else {
        						m_nPos = 2;
        						m_nErrorID = SYNTAX_ERROR;
        						break;
        					}
        				}
        				else {
        					m_nPos = 2;
        					isTrue = TRUE;                  
        					m_nErrorID = SYNTAX_ERROR;
        					break;
        				}	
        			}   
        			else {                          
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}
        		}                   
        		//Datum ..
       			else if ( IsKeywordDatum(m_pszArgv[nIndex]) ) {
        			if ( !isD ) {       
        				isD = TRUE;	  
        				if ( ++nIndex < nCount ) {
        					if ( IsKeywordByteOrWord(m_pszArgv[nIndex]) ) {
        						if ( ++nIndex < nCount ) {				        				
		        					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {								
										if ( ++nIndex < nCount ) {
											if ( IsEventData(m_pszArgv[nIndex]) ) {
										 		if ( ++nIndex < nCount ) {
										 			if ( IsEventData(m_pszArgv[nIndex]) ) {
										 				m_nPos = 11;          
										 				if ( ++nIndex >= nCount ) {								 																 					
										 					isTrue = TRUE;								 													 					
										 				}
										 			}
										 			else {
										 				m_nPos = 10;
										 				m_nErrorID = SYNTAX_ERROR;
										 				break;
										 			}
										 		}
										 		else {
										 			m_nPos = 10;
										 			isTrue = TRUE;                    
										 			m_nErrorID = SYNTAX_ERROR;    
										 			break;
										 		}			
										 	}   
										 	else {
										 		m_nPos = 9;
										 		m_nErrorID = SYNTAX_ERROR;
										 		break;
										 	}
										}     
										else {
										 	m_nPos = 9;
										 	isTrue = TRUE;                    
										 	m_nErrorID = SYNTAX_ERROR;
										 	break;
										}
		        					}	
		        					else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
		        						m_nPos = 11;
		        						if ( ++nIndex >= nCount ) {
		        							isTrue = TRUE;	
		        						}
		        					}
		        					else if ( IsEventData(m_pszArgv[nIndex]) ) {
		        						m_nPos = 11;
		        						if ( ++nIndex >= nCount ) {
		        							isTrue = TRUE;	
		        						}
		        					}
		        					else {
		        						m_nPos = 8;
		        						m_nErrorID = SYNTAX_ERROR;
		        						break;
		        					}
		        				}
        						else {
        							m_nPos = 8;
        							isTrue = TRUE;
        							m_nErrorID = SYNTAX_ERROR;
        							break;	
        						}
        					}             
        					else {
        						m_nPos = 3;
        						m_nErrorID = SYNTAX_ERROR;
        						break; 
        					}
        				}
        				else {
        					m_nPos = 3;        					
        					isTrue = TRUE;
        					m_nErrorID = SYNTAX_ERROR;
        					break;
        				}
        			}   
        			else {                          
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}
        		}                           		 
        		else if ( IsKeywordCount(m_pszArgv[nIndex]) ) {
        			if ( !isC ) {
						isC = TRUE;
						if ( ++nIndex < nCount ) {
							if ( IsEv1Count(m_pszArgv[nIndex]) ) {
								m_nPos = 100;
								if ( ++nIndex >= nCount ) {
									isTrue = TRUE;
								}      
							}
							else {
								m_nPos = 4;
								m_nErrorID = SYNTAX_ERROR;
								break;
							}					
						}
						else {
							m_nPos = 4;
							isTrue = TRUE;
							m_nErrorID = SYNTAX_ERROR;
							break;
						}        		        		
					}
					else {
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}						
        		}
        		else {                              
        			m_nPos = 2;
        			m_nErrorID = SYNTAX_ERROR;		
        			break;	
        		}                                	
        	}
        	break;                          
	}             
	return isTrue;
}	
                                             
                                             
//Ev2         [[Address {Range adr1 adr2|xadr|<badrs..>}]
//            [DATum Byte|Word {Range data1 data2|xdata|bdata}]
//            [Clear]                                                 
BOOL CSyntaxCore::SyntaxCheckEv2(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                           
	BOOL isTrue = FALSE;	                           
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    // Check command syntax.
    switch ( nCount ) {
	    case 1: 
	    	m_nPos = 1;
	    	isTrue = TRUE;       
            break;        
        case 2:
        	if ( IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;
        	}                 
        	else if ( IsKeywordAddress(m_pszArgv[1]) ) {
        		m_nPos = 2;   
        		isTrue = TRUE;                
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	else if ( IsKeywordDatum(m_pszArgv[1]) ) {
        		m_nPos = 3;   
        		isTrue = TRUE;            
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	else {
        		m_nPos = 1;               
        		m_nErrorID = SYNTAX_ERROR;
        	}        	                  
        	break;
        default:                                               	
	        // Initial flag.
	        BOOL isA = FALSE;	//Address
	        BOOL isD = FALSE;   //Datum	        
            int nIndex = 1;  
            ADDR_RETCODE retCode;                                           
			char szArgv1[300];
			char szArgv2[300];
			            
            if ( IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;        	
        		m_nErrorID = SYNTAX_ERROR;	
        	}                             
        	while ( nIndex < nCount ) {  
        		//Address ...
       			if ( IsKeywordAddress(m_pszArgv[nIndex]) ) {
        			if ( !isA ) {       
        				isA = TRUE;	
        				if ( ++nIndex < nCount ) {
        					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {								
								if ( ++nIndex < nCount ) {
									if ( IsPAddr(m_pszArgv[nIndex]) ) {
								 		if ( ++nIndex < nCount ) {
								 			if ( IsPAddr(m_pszArgv[nIndex]) || IsAddrDefault(m_pszArgv[nIndex])) {
												retCode = AdrCheck2Addr(m_pszArgv[nIndex-1],m_pszArgv[nIndex]);
									            if (ADR_OK == retCode) {       
										            if (!ConvertAddress(m_pszArgv[nIndex-1], szArgv1, nRet, SPACE_P0)) {
										              	m_nErrorID = nRet;
										            	break;
										            }	
										            if (!ConvertAddress(m_pszArgv[nIndex], szArgv2, nRet)) {
										              	m_nErrorID = nRet;
										            	break;
										            }	                          						                                         
													NewMem(m_pszArgv[nIndex-1], strlen(szArgv1)+1);
													NewMem(m_pszArgv[nIndex], strlen(szArgv2)+1);
										            strcpy(m_pszArgv[nIndex-1],szArgv1);                                  
										            strcpy(m_pszArgv[nIndex],szArgv2); 		                           
									 				m_nPos = 6;
									 				if ( ++nIndex >= nCount ) {								 				
									 					isTrue = TRUE;								 													 					
									 				}    
									 			}
									 			else {
									 				m_nPos = 5;
									 				m_nErrorID = SYNTAX_ERROR;
									 				break;
									 			}	
								 			}
								 			else {
								 				m_nPos = 5;
								 				m_nErrorID = SYNTAX_ERROR;
								 				break;
								 			}
								 		}
								 		else {
								 			m_nPos = 5;
								 			isTrue = TRUE;                    
								 			m_nErrorID = SYNTAX_ERROR;    
								 			break;
								 		}			
								 	}   
								 	else {
								 		m_nPos = 4;
								 		m_nErrorID = SYNTAX_ERROR;
								 		break;
								 	}
								}     
								else {
								 	m_nPos = 4;
								 	isTrue = TRUE;                    
								 	m_nErrorID = SYNTAX_ERROR;
								 	break;
								}
        					}	
        					else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
        						m_nPos = 6;
        						if ( ++nIndex >= nCount ) {
        							isTrue = TRUE;	
        						}
        					}
        					else if ( IsMultipleAddr(m_pszArgv[nIndex]) ) {
        						m_nPos = 6;
        						if ( ++nIndex >= nCount ) {
        							isTrue = TRUE;	
        						}
        					}
        					else {
        						m_nPos = 2;
        						m_nErrorID = SYNTAX_ERROR;
        						break;
        					}
        				}
        				else {
        					m_nPos = 2;
        					isTrue = TRUE;                  
        					m_nErrorID = SYNTAX_ERROR;
        					break;
        				}	
        			}   
        			else {                          
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}
        		}                   
        		//Datum ..
       			else if ( IsKeywordDatum(m_pszArgv[nIndex]) ) {
        			if ( !isD ) {       
        				isD = TRUE;	  
        				if ( ++nIndex < nCount ) {
        					if ( IsKeywordByteOrWord(m_pszArgv[nIndex]) ) {
								if ( ++nIndex < nCount ) {
		        					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {								
										if ( ++nIndex < nCount ) {
											if ( IsEventData(m_pszArgv[nIndex]) ) {
										 		if ( ++nIndex < nCount ) {
										 			if ( IsEventData(m_pszArgv[nIndex]) ) {
										 				m_nPos = 100;          
										 				if ( ++nIndex >= nCount ) {								 																 					
										 					isTrue = TRUE;								 													 					
										 				}
										 			}
										 			else {
										 				m_nPos = 9;
										 				m_nErrorID = SYNTAX_ERROR;
										 				break;
										 			}
										 		}
										 		else {
										 			m_nPos = 9;
										 			isTrue = TRUE;                    
										 			m_nErrorID = SYNTAX_ERROR;    
										 			break;
										 		}			
										 	}   
										 	else {
										 		m_nPos = 8;
										 		m_nErrorID = SYNTAX_ERROR;
										 		break;
										 	}
										}     
										else {
										 	m_nPos = 8;
										 	isTrue = TRUE;                    
										 	m_nErrorID = SYNTAX_ERROR;
										 	break;
										}
		        					}	
		        					else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
		        						m_nPos = 100;
		        						if ( ++nIndex >= nCount ) {
		        							isTrue = TRUE;	
		        						}
		        					}
		        					else if ( IsEventData(m_pszArgv[nIndex]) ) {
		        						m_nPos = 100;
		        						if ( ++nIndex >= nCount ) {
		        							isTrue = TRUE;	
		        						}
		        					}
		        					else {
		        						m_nPos = 7;
		        						m_nErrorID = SYNTAX_ERROR;
		        						break;
		        					}
		        				}
		        				else {
		        					m_nPos = 7;
		        					isTrue = TRUE;                  
		        					m_nErrorID = SYNTAX_ERROR;
		        					break;
		        				}	        							
        					}             
        					else {
        						m_nPos = 3;
        						m_nErrorID = SYNTAX_ERROR;
        						break; 
        					}
        				}
        				else {
        					m_nPos = 3;        					
        					isTrue = TRUE;
        					m_nErrorID = SYNTAX_ERROR;
        					break;
        				}
        			}   
        			else {                          
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}
        		}                           		 
        		else {                              
        			m_nPos = 2;
        			m_nErrorID = SYNTAX_ERROR;		
        			break;	
        		}                                	
        	}
        	break;            
	}             
	return isTrue;
}	                            


//EV3		[High|Low]                                               
BOOL CSyntaxCore::SyntaxCheckEv3(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                    
	BOOL isTrue = FALSE;	                    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    // Check command syntax.
    switch ( nCount ) {
	    case 1:    
	    	m_nPos = 1;
	    	isTrue = TRUE;    
            break;  
        case 2:
        	if  ( IsKeywordHigh(m_pszArgv[1]) ||
        		  IsKeywordLow(m_pszArgv[1]) ) {    
        		m_nPos = 100;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}		  
			break;
		default:
        	if  ( IsKeywordHigh(m_pszArgv[1]) ||
        		  IsKeywordLow(m_pszArgv[1]) ) {    
        		m_nPos = 100;
        	}
        	else {
        		m_nPos = 1;                   		
        	}	
        	m_nErrorID = SYNTAX_ERROR;	  
			break;                                  
	}             
	return isTrue;
}	


//Event       [ [ [ 1 [Address {Range adr1 adr2|xadr|<badrs..>}]
//            [DATum Byte|Word {Range data1 data2|xdata|bdata}]
//            [COunt count]] |
//            [Clear] ] |
//            [ 2 [[Address {Range adr1 adr2|xadr|<badrs..>}]
//            [DATum Byte|Word {Range data1 data2|xdata|bdata}]
//            [Clear] ] |
//            [ 3 [High|Low] ] |
//            [Clear] ]
BOOL CSyntaxCore::SyntaxCheckEvent(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                    
	BOOL isTrue = FALSE;	                    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    // Check command syntax.
    switch ( nCount ) {
	    case 1:        
			m_nEvent = 0;
			m_nPos = 1;
            break;       
        default:
        	if ( IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;       
        		m_nEvent = 0;  		
        		if ( nCount > 2 ) {            		
        			m_nErrorID = SYNTAX_ERROR;
        		}
        		else {
        			isTrue = TRUE;
        		}	  
        	}
        	else if ( 0 == stricmp(m_pszArgv[1], "1") ) {
    	    	for ( int i = 0 ; i < (nCount-1); i++) {
    	    		NewMem(m_pszArgv[i], 300);
    	    	    strcpy(m_pszArgv[i], m_pszArgv[i+1]);        	    	
    	    	}                                        
    	    	m_nToken--;
    	    	m_nArgc--;
    	    	m_nCommandID = CMDID_EV1;
    	    	isTrue = SyntaxCheckEv1(isSub);
    	    	m_nEvent = 1;
    	    	break;        	
        	}
        	else if ( 0 == stricmp(m_pszArgv[1], "2") ) {
    	    	for ( int i = 0 ; i < (nCount-1); i++) {
    	    		NewMem(m_pszArgv[i], 300);
    	    	    strcpy(m_pszArgv[i], m_pszArgv[i+1]);        	    	
    	    	}                                        
    	    	m_nToken--;
    	    	m_nArgc--;
    	    	m_nCommandID = CMDID_EV2;
    	    	isTrue = SyntaxCheckEv2(isSub);
    	    	m_nEvent = 2;
    	    	break;        	        	
        	}
        	else if ( 0 == stricmp(m_pszArgv[1], "3") ) {
    	    	for ( int i = 0 ; i < (nCount-1); i++) {
    	    		NewMem(m_pszArgv[i], 300);
    	    	    strcpy(m_pszArgv[i], m_pszArgv[i+1]);        	    	
    	    	}                                        
    	    	m_nToken--;
    	    	m_nArgc--;
    	    	m_nCommandID = CMDID_EV3;
    	    	isTrue = SyntaxCheckEv3(isSub);
    	    	m_nEvent = 3;
    	    	break;        	        	
        	}                                      
        	else {
        		m_nPos = 1;
        		m_nEvent = 0;
        		m_nErrorID = SYNTAX_ERROR;
        	}        		
        	break;        
	} 
	return isTrue;
}	                              

// Fill         adr1 {adr2|Length length} {"string"|data..}
BOOL CSyntaxCore::SyntaxCheckFill(BOOL isSub)
{
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
                 
	char szArgv1[260];
	char szArgv2[260];                             
	
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
		case 2:                       
			if ( IsAddr(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
			}
			m_nErrorID = SYNTAX_ERROR;			
			break;
		case 3:            
			if ( IsAddr(m_pszArgv[1]) ) {
				if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);	
		            if (ADR_OK != retCode) {       		            	
		            	m_nPos = 2;                		            	
		            }	                              
                    else {
						m_nPos = 4;
						isTrue = TRUE;			            			
					}	
				}
				else if ( IsKeywordLength(m_pszArgv[2]) ) {
					m_nPos = 3;                                         
					isTrue = TRUE;			            			
				}
				else {
					m_nPos = 2;			            			
				}	
			}                                   
			else {
				m_nPos = 1;	
			}
			m_nErrorID = SYNTAX_ERROR;			
			break;
        case 4:          
            if ( IsAddr(m_pszArgv[1]) ) {
            	if ( IsKeywordLength(m_pszArgv[2]) ) {
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {		                
		                m_nPos = 3;                        
		                m_nErrorID = nRet;
		                break;
		            }    
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		            	m_nPos = 3;		            	
		                m_nErrorID = nRet;
		                break;
		            }              
		            m_nPos = 4;
		            m_nErrorID = SYNTAX_ERROR;       
            	}
            	else if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
				    if ( !PreStringData(3, 2) ) {
				        m_nErrorID = SYNTAX_ERROR;
				        m_nPos = 4;
				        break;
				    }		            
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);	
		            if (ADR_OK != retCode) {      
		            	m_nErrorID = SYNTAX_ERROR; 		            	
		            	m_nPos = 2;
		            	break;                                        
		            }	                              
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            /*
		            if (IsBAddr(szArgv1)) {            
		            	if( !IsDataBit(m_pszArgv[3])) {
		            		m_nErrorID = SYNTAX_ERROR;
		                	m_nPos = 4;
		                	break;
		            	}                  
		            }	
		            else */
		            if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 4;
		                break;
		            }
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1); 
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2);             		
		            if ( !IsFillDataRange(3, m_pszArgv, TRUE) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 4;
		                break;
		            }
		            isTrue = TRUE;
            	}
            	else {
					m_nErrorID = SYNTAX_ERROR;			
					m_nPos = 2;            		
            	}
            }                  
            else {
				m_nErrorID = SYNTAX_ERROR;			
				m_nPos = 1;            		            
            }
            break;                          
		default:            
		    int nArgc;
		    
		    if ( IsKeywordLength(m_pszArgv[2]) ) {
		        nArgc = 4;		    
		    }
		    else {
		        nArgc = 3;
		    }
		
		    if ( !PreStringData(nArgc, 2) ) {
		        m_nErrorID = SYNTAX_ERROR;
		        m_nPos = 4;
		        break;
		    }
            if ( IsAddr(m_pszArgv[1]) ) {
            	if ( IsKeywordLength(m_pszArgv[2]) ) {
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {		                
		                m_nPos = 3;                        
		                m_nErrorID = nRet;
		                break;
		            }    
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		            	m_nPos = 3;		            	
		            	m_nErrorID = nRet;
		            	break;
		            }              
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
		            if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 4;
		                break;
		            }
		            if ( !IsFillDataRange(4, m_pszArgv, FALSE) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 4;
		                break;
		            }                               		
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[1],szArgv1);   		            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);   		            
		            m_nPos = 100; 
		            isTrue = TRUE;		            
            	}
            	else if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet, SPACE_X0);
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);	
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 2;
		            	break;                                        
		            }	                              
		            if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 4;
		                break;
		            }
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1); 
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2);             		
		            if ( !IsFillDataRange(3, m_pszArgv, TRUE) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 4;
		                break;
		            }
		            isTrue = TRUE;
            	}
            	else {
					m_nErrorID = SYNTAX_ERROR;			
					m_nPos = 2;            		
            	}
            }                  
            else {
				m_nErrorID = SYNTAX_ERROR;			
				m_nPos = 1;            		            
            }               
        
        	break;    
    }
    	
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckFill().


// Go           [[Run][From adr1]|[From adr1][Till adr2]|Monitor timer]
BOOL CSyntaxCore::SyntaxCheckGo(BOOL isSub)
{
	char szArgv1[260];
	char szArgv2[260];
	
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
        case 1:
        	m_nPos = 1;
        	isTrue = TRUE;
            break;
        case 2:                           
            if ( IsKeywordRun(m_pszArgv[1]) ) {  
            	m_nPos = 2;
            	isTrue = TRUE;
			}
			else if ( IsKeywordMonitor(m_pszArgv[1]) ) {
            	m_nPos = 5;
            	isTrue = TRUE;
				m_nErrorID = SYNTAX_ERROR;			
			}                                           
			else if ( IsKeywordFrom(m_pszArgv[1]) ) {
            	m_nPos = 3;
            	isTrue = TRUE;                      
            	m_nErrorID = SYNTAX_ERROR;			
			}
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
            	m_nPos = 4;
            	isTrue = TRUE;                      
            	m_nErrorID = SYNTAX_ERROR;			
			}
			else {
				m_nPos = 1;
				m_nErrorID = SYNTAX_ERROR;				
			}
            break;             
        case 3:
            if ( IsKeywordRun(m_pszArgv[1]) ) {  
            	if ( IsKeywordFrom(m_pszArgv[2]) ) {            		
            		m_nPos = 6;
            		isTrue = TRUE;                              		
            	}
            	else {            	
            		m_nPos = 2;                     					
            	}   
            	m_nErrorID = SYNTAX_ERROR;			
			}
			else if ( IsKeywordMonitor(m_pszArgv[1]) ) {
				if ( IsGoMonitorTimer(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
				}                 
				else {
            		m_nPos = 5;                                 
            		m_nErrorID = SYNTAX_ERROR;            		
            	}	
			}                                           
			else if ( IsKeywordFrom(m_pszArgv[1]) ) {
				if ( IsPAddr(m_pszArgv[2]) ) {                  
					ConvertAddress(m_pszArgv[2], szArgv1, nRet, SPACE_P0);
		            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[2],szArgv1);           
					m_nPos = 7; 
					isTrue = TRUE;
				}				
				else {	
            		m_nPos = 3;               
            		m_nErrorID = SYNTAX_ERROR;
            	}	                                      	
			}
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {                  
					ConvertAddress(m_pszArgv[2], szArgv1, nRet, SPACE_P0);
		            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[2],szArgv1);           
					m_nPos = 100;
					isTrue = TRUE;
				}				
				else {	
	            	m_nPos = 4;  
	            	m_nErrorID = SYNTAX_ERROR;
                }
			}
			else {
				m_nPos = 1;
				m_nErrorID = SYNTAX_ERROR;				
			}
            break;             
        case 4:
            if ( IsKeywordRun(m_pszArgv[1]) ) {  
            	if ( IsKeywordFrom(m_pszArgv[2]) ) {            		
					if ( IsPAddr(m_pszArgv[3]) ) {                  
						ConvertAddress(m_pszArgv[3], szArgv1, nRet, SPACE_P0);
			            NewMem(m_pszArgv[3], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[3],szArgv1);           
						m_nPos = 100;
						isTrue = TRUE;
					}            	
            	    else {
            			m_nPos = 6;                     
            			m_nErrorID = SYNTAX_ERROR;				
            		}
            	}
            	else {            	
            		m_nPos = 2;                     
					m_nErrorID = SYNTAX_ERROR;            		
            	}
			}
			else if ( IsKeywordMonitor(m_pszArgv[1]) ) {
				if ( IsGoMonitorTimer(m_pszArgv[2]) ) {
					m_nPos = 100;					
				}                 
				else {
            		m_nPos = 5;                                         		
            	}	
            	m_nErrorID = SYNTAX_ERROR;            		
			}                                           
			else if ( IsKeywordFrom(m_pszArgv[1]) ) {
				if ( IsPAddr(m_pszArgv[2]) ) {                  
					if ( IsKeywordTill(m_pszArgv[3]) ) {
						m_nPos = 8;
						isTrue = TRUE;
					}
					else {	
						m_nPos = 7; 
					}						
				}				
				else {	
            		m_nPos = 3;               
            	}	                                      	
				m_nErrorID = SYNTAX_ERROR;            		
			}       			
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {                  
					m_nPos = 100;
				}				
				else {	
	            	m_nPos = 4;           	            	
                }   
                m_nErrorID = SYNTAX_ERROR;
			}
			else {
				m_nPos = 1;
				m_nErrorID = SYNTAX_ERROR;				
			}
            break;             
        case 5:
            if ( IsKeywordRun(m_pszArgv[1]) ) {  
            	if ( IsKeywordFrom(m_pszArgv[2]) ) {            		
					if ( IsPAddr(m_pszArgv[3]) ) {                  
						m_nPos = 100;
					}            	
            	    else {
            			m_nPos = 6;                     
            		}
            	}
            	else {            	
            		m_nPos = 2;                             					
            	}   
            	m_nErrorID = SYNTAX_ERROR;            		
			}
			else if ( IsKeywordMonitor(m_pszArgv[1]) ) {
				if ( IsGoMonitorTimer(m_pszArgv[2]) ) {
					m_nPos = 100;					
				}                 
				else {
            		m_nPos = 5;                                         		
            	}	
            	m_nErrorID = SYNTAX_ERROR;            		
			}                                           
			else if ( IsKeywordFrom(m_pszArgv[1]) ) {
				if ( IsPAddr(m_pszArgv[2]) ) {                  
					if ( IsKeywordTill(m_pszArgv[3]) ) {
						if ( IsPAddr(m_pszArgv[4]) || IsAddrDefault(m_pszArgv[4])) {
							ConvertAddress(m_pszArgv[2], szArgv1, nRet, SPACE_P0);
				            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
				            strcpy(m_pszArgv[2],szArgv1);           
							ConvertAddress(m_pszArgv[4], szArgv2, nRet, SPACE_P0);
				            NewMem(m_pszArgv[4], strlen(szArgv2)+1);
				            strcpy(m_pszArgv[4],szArgv2);           
						    m_nPos = 100;
						    isTrue = TRUE;
						}                 
						else {
							m_nPos = 8;
							m_nErrorID = SYNTAX_ERROR;            		
						}						
					}
					else {	
						m_nPos = 7;                             
						m_nErrorID = SYNTAX_ERROR;            		
					}						
				}				
				else {	
            		m_nPos = 3;               
            		m_nErrorID = SYNTAX_ERROR;            		
            	}	    				
			}       			
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {                  
					m_nPos = 100;
				}				
				else {	
	            	m_nPos = 4;           	            	
                }   
                m_nErrorID = SYNTAX_ERROR;
			}
			else {
				m_nPos = 1;
				m_nErrorID = SYNTAX_ERROR;				
			}
            break;             
        default:
            if ( IsKeywordRun(m_pszArgv[1]) ) {  
            	if ( IsKeywordFrom(m_pszArgv[2]) ) {            		
					if ( IsPAddr(m_pszArgv[3]) ) {                  
						m_nPos = 100;
					}            	
            	    else {
            			m_nPos = 6;                     
            		}
            	}
            	else {            	
            		m_nPos = 2;                             					
            	}   
			}
			else if ( IsKeywordMonitor(m_pszArgv[1]) ) {
				if ( IsGoMonitorTimer(m_pszArgv[2]) ) {
					m_nPos = 100;					
				}                 
				else {
            		m_nPos = 5;                                         		
            	}	
			}			                       
			else if ( IsKeywordFrom(m_pszArgv[1]) ) {
				if ( IsPAddr(m_pszArgv[2]) ) {                  
					if ( IsKeywordTill(m_pszArgv[3]) ) {
						if ( IsPAddr(m_pszArgv[4]) || IsAddrDefault(m_pszArgv[4])) {
						    m_nPos = 100;
						}                 
						else {
							m_nPos = 8;							
						}						
					}
					else {	
						m_nPos = 7;                             
					}						
				}				
				else {	
            		m_nPos = 3;               
            	}	    	
			}       			
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {                  
					m_nPos = 100;
				}				
				else {	
	            	m_nPos = 4;           	            	
                }   
			}
			else {
				m_nPos = 1;                         				
			}   
			m_nErrorID = SYNTAX_ERROR;				
            break;             
    }
        
    return isTrue;
}   // End of CSyntaxCore::SyntaxCheckGo().


// Halt
BOOL CSyntaxCore::SyntaxCheckHalt(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
        case 1:           
        	m_nPos = 1;
            isTrue = TRUE;
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
                                            
	return isTrue;                                            
}   // End of CSyntaxCore::SyntaxCheckHalt().


// Help         [command]
BOOL CSyntaxCore::SyntaxCheckHelp(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
        case 1:
			m_nPos = 1;       
			isTrue = TRUE;
            break;
        case 2:
            if ( IsCommand(m_pszArgv[1]) ) {
        		m_nPos = 100;  
        		isTrue = TRUE;
            }            
            else {
                m_nErrorID = SYNTAX_ERROR;
                m_nPos = 1;  
            }
            break;
        default:          
			if ( IsCommand(m_pszArgv[1]) ) {
        		m_nPos = 100;  
			}
        	else {
        		m_nPos = 1;                   		
        	}	
        	m_nErrorID = SYNTAX_ERROR;                                      
            break;
    }

	return isTrue;    
}   // End of CSyntaxCore::SyntaxCheckHelp().


void CSyntaxCore::FreeMem(char* &pszBuffer)
{
	if (pszBuffer != 0) {
		delete []pszBuffer;
		pszBuffer = 0;
	}	
}    

void CSyntaxCore::NewMem(char* &pszBuffer, int nLen)
{
	FreeMem(pszBuffer);
	pszBuffer = new char[nLen+2];
	if (!pszBuffer) {
		//AfxMessageBox("Insufficient Memory !");
		DisplayOutOfMemory();
	}

}

//////////////////////////////// End of File ////////////////////////////////
