/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNCORE2.CPP
//
//  Description: The implementation file for the class: CSyntaxCore.
//
//  Author: Chen Jun
//
//  Date: 05/17/95
//
//  Modification:
//      1. 05/17/95, Initial version of the class: CSyntaxCore.
//      2. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
#include "syncore.h"
#include "address.h"
#include "ctype.h"
#include "uicom2.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isDefineMacro;

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxCore.




// IDentify
BOOL CSyntaxCore::SyntaxCheckIdentify(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
        case 1:   
        	isTrue = TRUE;
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckIdentify().


// INclude      filename 
BOOL CSyntaxCore::SyntaxCheckInclude(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }                     
    int nRet;
    BOOL isTrue = FALSE;    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
			isTrue = TRUE;                              
			m_nErrorID = SYNTAX_ERROR;				
        	break;        
        case 2:
            if ( IsFilename(m_pszArgv[1], nRet) ) {
            	m_nPos = 100;
                isTrue = TRUE;                    
            }              
            else {
        		m_nPos = 1;  
        		m_nErrorID = nRet;
            }
            break;
        default:
			if ( IsFilename(m_pszArgv[1], nRet) ) {
        		m_nPos = 100;  
			}
        	else {
        		m_nPos = 1;
        	}	                                    
        	m_nErrorID = SYNTAX_ERROR;				
            break;
    }
	
	return isTrue;                
	
}   // End of CSyntaxCore::SyntaxCheckInclude().


// Inport       port [Bit bit_no|BYte]
//          ( port = 0, 1, 2, 3,; bit_no = 0 - 7 )
BOOL CSyntaxCore::SyntaxCheckInport(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
        case 2:
            if ( IsPort(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;            
            }
            else {                                    
                m_nPos = 1;
                m_nErrorID = SYNTAX_ERROR;
            }                                         
            break;
        case 3:
            if ( IsPort(m_pszArgv[1]) ) {
				if ( IsKeywordByte(m_pszArgv[2]) ) {            
					m_nPos = 100;
					isTrue = TRUE;
				}
				else if ( IsKeywordBit(m_pszArgv[2]) ) {
					m_nPos = 3;   
					isTrue = TRUE;
					m_nErrorID = SYNTAX_ERROR;
				} 	              
				else {
					m_nPos = 2;           
					m_nErrorID = SYNTAX_ERROR; 
				}	
            }
            else {                                    
                m_nPos = 1;
                m_nErrorID = SYNTAX_ERROR;
            }                                         
            break;
        case 4:
            if ( IsPort(m_pszArgv[1]) ) {
				if ( IsKeywordByte(m_pszArgv[2]) ) {            
					m_nPos = 100;       
					m_nErrorID = SYNTAX_ERROR;
				}
				else if ( IsKeywordBit(m_pszArgv[2]) ) {
					if ( IsBitNo(m_pszArgv[3]) ) {
						m_nPos = 100;
						isTrue = TRUE;
					}
					else {	
						m_nPos = 3;   					
						m_nErrorID = SYNTAX_ERROR;
					}	
				} 	              
				else {
					m_nPos = 2;           
					m_nErrorID = SYNTAX_ERROR; 
				}	
            }
            else {                                    
                m_nPos = 1;
                m_nErrorID = SYNTAX_ERROR;
            }                                         
            break;
        default:
            if ( IsPort(m_pszArgv[1]) ) {
				if ( IsKeywordByte(m_pszArgv[2]) ) {            
					m_nPos = 100;
				}
				else if ( IsKeywordBit(m_pszArgv[2]) ) {
					if ( IsBitNo(m_pszArgv[3]) ) {
						m_nPos = 100;
					}
					else {	
						m_nPos = 3;   					
					}	
				} 	              
				else {
					m_nPos = 2;           
				}	
            }
            else {                                    
                m_nPos = 1;
            }                                         
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckInport().


// Jump         adr
BOOL CSyntaxCore::SyntaxCheckJump(BOOL isSub)
{                
	char szArgv1[260];

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
        case 2:
	        if ( IsPAddr(m_pszArgv[1]) ) {
				ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_P0);
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[1],szArgv1);
				m_nPos = 100;						        	        
				isTrue = TRUE;			            						
	        }   
	        else {
				m_nPos = 1;       
				m_nErrorID = SYNTAX_ERROR;			
	        }
            break;
        default:
	        if ( IsPAddr(m_pszArgv[1]) ) {
				m_nPos = 100;						        	
	        }   
	        else {
				m_nPos = 1;       
	        }
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckJump().


//LEvel       [{1|2} [eventlogic]]
BOOL CSyntaxCore::SyntaxCheckLevel(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                                
	BOOL isTrue = FALSE;	                                
    int nCount;
    char pszEventSeq[255];	        
    memset(pszEventSeq, 0, sizeof(pszEventSeq));

    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
	    case 1: 
	    	m_nPos = 1;
            isTrue = TRUE;
            break;
        case 2:
        	if ( 0 == stricmp(m_pszArgv[1], "1") ||
        		 0 == stricmp(m_pszArgv[1],  "2") ) {
        		m_nPos = 2;
        		isTrue = TRUE;	 
        	}	              
        	else {
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}                                  
        	break;         
        case 3:	
        	if ( 0 == stricmp(m_pszArgv[1], "1") ||
        		 0 == stricmp(m_pszArgv[1],  "2") ) {   
        		strcpy(pszEventSeq, m_pszArgv[2]);
        		strcat(pszEventSeq, " "); 
        		if ( IsEventSequence(pszEventSeq) ) {
        			m_nPos = 100;
        			isTrue = TRUE;
        		}                 
        		else {
	        		m_nPos = 2;           
	        		m_nErrorID = SYNTAX_ERROR;
	        	}
        	}	              
        	else {
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}                                  
        	break;         
        default:
	        for ( int i = 2; i < nCount; i++ ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");                
            }

        	if ( 0 == stricmp(m_pszArgv[1], "1") ||
        		 0 == stricmp(m_pszArgv[1],  "2") ) {
        		if ( IsEventSequence(pszEventSeq) ) {
        			m_nPos = 100;
        			isTrue = TRUE;
        		}                 
        		else {
	        		m_nPos = 2;           
	        		isTrue = TRUE;
	        		m_nErrorID = SYNTAX_ERROR;
	        	}
        	}	              
        	else {
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}                                  
			break;                                                  
	}
    return isTrue;
}	                              


//List        [Number]|[[frame]
//            [Address {Range adr1 adr2|xadr|<badrs..>}]
//            [DATum Byte|Word {Range data1 data2|xdata|bdata}]
//            [STatus <status..>]]
BOOL CSyntaxCore::SyntaxCheckList(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
        	break;            
        case 2:   
        	if ( IsKeywordNumber(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;
        	}
        	else if ( IsListFrame(m_pszArgv[1]) ) {
        		m_nPos = 3;
	       		isTrue = TRUE;        	
        	} 
        	else if ( IsKeywordAddress(m_pszArgv[1]) ) {
        		m_nPos = 4;
        		isTrue = TRUE;
        		m_nErrorID = SYNTAX_ERROR;
        	}      	    
        	else if ( IsKeywordDatum(m_pszArgv[1]) ) {
        		m_nPos = 7;
        		isTrue = TRUE;
        		m_nErrorID = SYNTAX_ERROR;        		
        	}             
        	else if ( IsKeywordStatus(m_pszArgv[1]) ) {
        		m_nPos = 8;
        		isTrue = TRUE;
        		m_nErrorID = SYNTAX_ERROR;
			}        	
        	else {
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}
            break;
         default:
	        // Initial flag.
	        BOOL isA = FALSE;	//Address
	        BOOL isD = FALSE;   //Datum
	        BOOL isS = FALSE;   //Status
            int nIndex = 1;  
            ADDR_RETCODE retCode;                                           
			char szArgv1[300];
			char szArgv2[300];

        	if ( IsKeywordNumber(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;
        		break;
        	}
        	if ( IsListFrame(m_pszArgv[1]) ) {
				nIndex = 2;
        	}
        	while ( nIndex < nCount ) {  
        		//Address ...
       			if ( IsKeywordAddress(m_pszArgv[nIndex]) ) {
        			if ( !isA ) {       
        				isA = TRUE;	
        				if ( ++nIndex < nCount ) {
        					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {								
								if ( ++nIndex < nCount ) {
									if ( IsPAddr(m_pszArgv[nIndex]) ) {
								 		if ( ++nIndex < nCount ) {
								 			if ( IsPAddr(m_pszArgv[nIndex]) || IsAddrDefault(m_pszArgv[nIndex]) ) {
												retCode = AdrCheck2Addr(m_pszArgv[nIndex-1],m_pszArgv[nIndex]/*, SPACE_P0*/);
									            if (ADR_OK == retCode) {       
										            if (!ConvertAddress(m_pszArgv[nIndex-1], szArgv1, nRet, SPACE_P0)) {
										              	m_nErrorID = nRet;
										            	break;
										            }	
										            if (!ConvertAddress(m_pszArgv[nIndex], szArgv2, nRet)) {
										              	m_nErrorID = nRet;
										            	break;
										            }	                          						                                         
													NewMem(m_pszArgv[nIndex-1], strlen(szArgv1)+1);
													NewMem(m_pszArgv[nIndex], strlen(szArgv2)+1);
										            strcpy(m_pszArgv[nIndex-1],szArgv1);                                  
										            strcpy(m_pszArgv[nIndex],szArgv2); 		                           
									 				m_nPos = 9;
									 				if ( ++nIndex >= nCount ) {								 				
									 					isTrue = TRUE;								 													 					
									 				}    
									 			}
									 			else {
									 				m_nPos = 6;
									 				m_nErrorID = SYNTAX_ERROR;
									 				break;
									 			}	
								 			}
								 			else {
								 				m_nPos = 6;
								 				m_nErrorID = SYNTAX_ERROR;
								 				break;
								 			}
								 		}
								 		else {
								 			m_nPos = 6;
								 			isTrue = TRUE;                    
								 			m_nErrorID = SYNTAX_ERROR;    
								 			break;
								 		}			
								 	}   
								 	else {
								 		m_nPos = 5;
								 		m_nErrorID = SYNTAX_ERROR;
								 		break;
								 	}
								}     
								else {
								 	m_nPos = 5;
								 	isTrue = TRUE;                    
								 	m_nErrorID = SYNTAX_ERROR;
								 	break;
								}
        					}	
        					else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
        						m_nPos = 9;
        						if ( ++nIndex >= nCount ) {
        							isTrue = TRUE;	
        						}
        					}
        					else if ( IsMultipleAddr(m_pszArgv[nIndex]) ) {
        						m_nPos = 9;
        						if ( ++nIndex >= nCount ) {
        							isTrue = TRUE;	
        						}
        					}
        					else {
        						m_nPos = 4;
        						m_nErrorID = SYNTAX_ERROR;
        						break;
        					}
        				}
        				else {
        					m_nPos = 4;
        					isTrue = TRUE;                  
        					m_nErrorID = SYNTAX_ERROR;
        					break;
        				}	
        			}   
        			else {                          
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}
        		}                   
        		//Datum ..
       			else if ( IsKeywordDatum(m_pszArgv[nIndex]) ) {
        			if ( !isD ) {       
        				isD = TRUE;	  
        				if ( ++nIndex < nCount ) {
        					if ( IsKeywordByteOrWord(m_pszArgv[nIndex]) ) {
		        				if ( ++nIndex < nCount ) {
		        					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {								
										if ( ++nIndex < nCount ) {
											if ( IsEventData(m_pszArgv[nIndex]) ) {
										 		if ( ++nIndex < nCount ) {
										 			if ( IsEventData(m_pszArgv[nIndex]) ) {
										 				m_nPos = 10;          
										 				if ( ++nIndex >= nCount ) {								 																 					
										 					isTrue = TRUE;								 													 					
										 				}
										 			}
										 			else {
										 				m_nPos = 14;
										 				m_nErrorID = SYNTAX_ERROR;
										 				break;
										 			}
										 		}
										 		else {
										 			m_nPos = 14;
										 			isTrue = TRUE;                    
										 			m_nErrorID = SYNTAX_ERROR;    
										 			break;
										 		}			
										 	}   
										 	else {
										 		m_nPos = 13;
										 		m_nErrorID = SYNTAX_ERROR;
										 		break;
										 	}
										}     
										else {
										 	m_nPos = 13;
										 	isTrue = TRUE;                    
										 	m_nErrorID = SYNTAX_ERROR;
										 	break;
										}
		        					}	
		        					else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
		        						m_nPos = 10;
		        						if ( ++nIndex >= nCount ) {
		        							isTrue = TRUE;	
		        						}
		        					}
		        					else if ( IsEventData(m_pszArgv[nIndex]) ) {
		        						m_nPos = 10;
		        						if ( ++nIndex >= nCount ) {
		        							isTrue = TRUE;	
		        						}
		        					}
		        					else {
		        						m_nPos = 12;
		        						m_nErrorID = SYNTAX_ERROR;
		        						break;
		        					}
		        				}
		        				else {
		        					m_nPos = 12;
		        					isTrue = TRUE;                  
		        					m_nErrorID = SYNTAX_ERROR;
		        					break;
		        				}	
        							
        					}             
        					else {
        						m_nPos = 7;
        						m_nErrorID = SYNTAX_ERROR;
        						break; 
        					}
        				}
        				else {
        					m_nPos = 7;        					
        					isTrue = TRUE;
        					m_nErrorID = SYNTAX_ERROR;
        					break;
        				}
        			}   
        			else {                          
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}
        		}       
        		//Status..                    		 
        		else if ( IsKeywordStatus(m_pszArgv[nIndex]) ) {
					if ( !isS ) {
						isS = TRUE;
						if ( ++nIndex < nCount ) {
							if ( IsStatusOption(m_pszArgv[nIndex]) ) {
								m_nPos = 100;
								if ( ++nIndex >= nCount ) {
									isTrue = TRUE;
								}      
							}
							else {
								m_nPos = 8;
								m_nErrorID = SYNTAX_ERROR;     
								break;
							}
						}
						else {
							m_nPos = 8;
							isTrue = TRUE;
							m_nErrorID = SYNTAX_ERROR;
							break;
						}        		
					}
					else {
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;						
					}	
        		}
        		else {                              
        			m_nPos = 2;
        			m_nErrorID = SYNTAX_ERROR;		
        			break;	
        		}                                	
        	}
        	break;            
	}

	return isTrue;	
}	      
      
// LOG          {filename [Command] [Append]} | {ON|OFf|Close}
BOOL CSyntaxCore::SyntaxCheckLog(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;            
        case 2:
			if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	isTrue = TRUE;
            	break;
            }
			if ( IsFilename(m_pszArgv[1], nRet) ) { 
				if ( !IsKeywordCommand(m_pszArgv[1]) && 
					 !IsKeywordAppend(m_pszArgv[1] )) {                    
	            	m_nPos = 2;
	            	isTrue = TRUE;
	            	break;
	            }
	            else {
	            	m_nPos = 2;  
	            	isTrue = FALSE;
	            	break;
	            }	
			}
            m_nPos = 1;           
            m_nErrorID = nRet;
            break;
        case 3:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                m_nPos = 100;             
                break;
            }                
			if ( IsFilename(m_pszArgv[1], nRet) ) {
				if (IsKeywordCommand(m_pszArgv[2]) ) {                    
                    m_nPos = 3;
                    isTrue = TRUE;
                    break;
                }   
                if (IsKeywordAppend(m_pszArgv[2]) ) { 
                	m_nPos = 100;
                	isTrue = TRUE;
                	break;
                }	
                m_nPos = 2;               
                m_nErrorID = SYNTAX_ERROR;
			}                     
			else {
				m_nErrorID = nRet;
				m_nPos = 1;			
			}	
            break;
        case 4:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                m_nPos = 100;             
                break;
            }                             
			if ( IsFilename(m_pszArgv[1], nRet) ) {
				if (IsKeywordCommand(m_pszArgv[2]) ) {
                    if (IsKeywordAppend(m_pszArgv[3]) ) {
	                    m_nPos = 100;
	                    isTrue = TRUE;   
	                }
	                else {
	                    m_nPos = 3;       
	                    m_nErrorID = SYNTAX_ERROR;
	                }                    
	                break;
                }            
                if (IsKeywordAppend(m_pszArgv[2]) ) {
                	m_nPos = 100;                 
                	m_nErrorID = SYNTAX_ERROR;
                }
                else {
                	m_nPos = 2;
                	m_nErrorID = SYNTAX_ERROR;
                }                                                                           
                break;
			}             
			m_nPos = 1;			
			m_nErrorID = SYNTAX_ERROR;	            
            break;
        default:
			if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	m_nErrorID = SYNTAX_ERROR;
            	break;
            }
			if ( IsFilename(m_pszArgv[1], nRet) ) {
				if (IsKeywordCommand(m_pszArgv[2]) ) {
                    if (IsKeywordAppend(m_pszArgv[3]) ) {
	                    m_nPos = 100;
	                }
	                else {
	                    m_nPos = 3;
	                }                     
	                m_nErrorID = SYNTAX_ERROR;
	                break;                    
                }            
                if (IsKeywordAppend(m_pszArgv[2]) ) {
                	m_nPos = 100;
                }
                else {
                	m_nPos = 2;
                }                             
                m_nErrorID = SYNTAX_ERROR;
                break;
			}             
			m_nPos = 1;			
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckLog().


// LONG         adr data1 [.. data8]
BOOL CSyntaxCore::SyntaxCheckLong(BOOL isSub)
{
	char szArgv[260];
    
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	     
    
    int nArgc;
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
		case 2:                       
			if ( IsAddr(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
			}
			m_nErrorID = SYNTAX_ERROR;			
			break;
        default:
		    nArgc = 2;
		    
			if ( IsAddr(m_pszArgv[1]) ) {           
			    if ( !PreStringData(nArgc, 8) ) { 
			    	m_nErrorID = SYNTAX_ERROR;
			        m_nPos = 2;
			        break;
			    }            
				ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_X0);				
/*
	            if (IsBAddr(szArgv)) {
	            	if( !IsDataBit(m_pszArgv[2])) {
	            		m_nErrorID = SYNTAX_ERROR;
	            		m_nPos = 2;
	                	break;
	            	}                 
	            }	
	            else */
	            if ( !IsDataLong(m_pszArgv[2]) ) {
	                m_nErrorID = SYNTAX_ERROR;
	                m_nPos = 2;
	                break;
	            }
	            NewMem(m_pszArgv[1], strlen(szArgv)+1);
	            strcpy(m_pszArgv[1],szArgv);
	            if ( !IsDataRange(m_nArgc, m_pszArgv, 4) ) {
	                m_nErrorID = SYNTAX_ERROR;
	                m_nPos = 2;
	                break;
	            }    
				m_nPos = 3;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
				m_nErrorID = SYNTAX_ERROR;			
			}                                       			
			break;
	}		
    
    return isTrue;
}   // End of CSyntaxCore::SyntaxCheckLong().


//LV1         [eventlogic]
BOOL CSyntaxCore::SyntaxCheckLv1(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                    
	BOOL isTrue = FALSE;	                    	
    int nCount;
    char pszEventSeq[255];	        
    memset(pszEventSeq, 0, sizeof(pszEventSeq));
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
	    case 1:
	    	m_nPos = 1;
	    	isTrue = TRUE;        
            break;        
        case 2:
    		strcpy(pszEventSeq, m_pszArgv[1]);
    		strcat(pszEventSeq, " "); 
    		if ( IsEventSequence(pszEventSeq) ) {
    			m_nPos = 100;
    			isTrue = TRUE;
    		}                 
    		else {
        		m_nPos = 1;           
        		m_nErrorID = SYNTAX_ERROR;
        	}   
        	break;
        default:
	        for ( int i = 1; i < nCount; i++ ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");                
            }

       		if ( IsEventSequence(pszEventSeq) ) {
    			m_nPos = 100;
    			isTrue = TRUE;
    		}                 
        	else {
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}                                  
			break;                 
	}
    return isTrue;
}	                              


//LV2         [eventlogic]
BOOL CSyntaxCore::SyntaxCheckLv2(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                    
	BOOL isTrue = FALSE;	                    	
    int nCount;
    char pszEventSeq[255];	        
    memset(pszEventSeq, 0, sizeof(pszEventSeq));
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
	    case 1:
	    	m_nPos = 1;
	    	isTrue = TRUE;        
            break;        
        case 2:
    		strcpy(pszEventSeq, m_pszArgv[1]);
    		strcat(pszEventSeq, " "); 
    		if ( IsEventSequence(pszEventSeq) ) {
    			m_nPos = 100;
    			isTrue = TRUE;
    		}                 
    		else {
        		m_nPos = 1;           
        		m_nErrorID = SYNTAX_ERROR;
        	}   
        	break;
        default:
	        for ( int i = 1; i < nCount; i++ ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");                
            }

       		if ( IsEventSequence(pszEventSeq) ) {
    			m_nPos = 100;
    			isTrue = TRUE;
    		}                 
        	else {
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}                                  
			break;                 
	}
    return isTrue;
}	                              

//Old:
//MAp         [{COmbination|Seperation}]|  
//        	  [{ALl adrtype}|{adr1 {adr2|Length length}} map_attribute]
//New:
//MAp         [{ALl adrtype}|{adr1 {adr2|Length length}} map_attribute]

BOOL CSyntaxCore::SyntaxCheckMap(BOOL isSub)
{                              
	char szArgv1[260];
	char szArgv2[260];

    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	     

    // Check command syntax.
    switch ( nCount ) {
        case 1:
            m_nPos = 1;
            isTrue = TRUE;
            break;        
        case 2:        
        	if ( IsKeywordAll(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;                      
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
	            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[1],szArgv1);                                  

                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;                 
                    m_nPos = 1;
                    break;
                }
        		m_nPos = 3;
        		isTrue = TRUE;         
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}
			else {
				m_nPos = 1;           				
				m_nErrorID = SYNTAX_ERROR;     	    
			}			
			break;
		case 3:
        	if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			m_nPos = 4;
        			isTrue = TRUE;
        		}
        		else {	
        			m_nPos = 2;
        		}
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
	            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[1],szArgv1);                                  
                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;                 
                    m_nPos = 1;
                    break;
                }
        		if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
           			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	 
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[2],szArgv2);                                  
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }     		                                         
        			m_nPos = 4;
        			isTrue = TRUE;
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) {
        			m_nPos = 5;
        			isTrue = TRUE;
        		}	          
        		else {
        			m_nPos = 3;
        		}
        	}
			else {
				m_nPos = 1;           				
			}   
			m_nErrorID = SYNTAX_ERROR;     	    
			break;	
		case 4:
	       	if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			if ( IsKeywordOverlay(m_pszArgv[3]) ||
        			     IsKeywordTarget(m_pszArgv[3]) ) {
        				if ( IsMapCombination() ) {
	        				m_nPos = 100;	
	        				isTrue = TRUE;
	        			}
	        			else {
	        				m_nPos = 4;
	        				isTrue = TRUE;
	        			}	
        			}
        			else {	
        				m_nPos = 4;             
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}        			
        		}
        		else {	
        			m_nPos = 2;                             
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
        		if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
        			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	 
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2); 
	                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
	                    m_nErrorID = SYNTAX_ERROR;                 
	                    m_nPos = 1;
	                    break;
	                }
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }     		                                         
        			if ( IsKeywordOverlay(m_pszArgv[3]) ||
        			     IsKeywordTarget(m_pszArgv[3]) ) {
        				if ( IsMapCombination() ) {
	        				m_nPos = 100;	
	        				isTrue = TRUE;
	        			}
	        			else {
	        				m_nPos = 4;
	        				isTrue = TRUE;
	        			}	
        			}
        			else {
        				m_nPos = 4;                     
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}	
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) { 
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;
		                m_nPos = 5;
		                break;
		            }   
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;                
		            	m_nPos = 5;
		            	break;
		            }                     
		            ConvertAddress(m_pszArgv[1], szArgv2, nRet,SPACE_X0);
		            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv2);                                  
			            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);                                  
			        	
		            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 1;
		                break;
		            }        
		            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 5;
		                break;
		            }             
           			m_nPos = 4;
        			isTrue = TRUE;                          
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}	          
        		else {
        			m_nPos = 3;                         
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}
        	}
			else {
				m_nPos = 1;           				    
				m_nErrorID = SYNTAX_ERROR;     	    
			}   
			break;	
		case 5: 
        	if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			if ( IsKeywordOverlay(m_pszArgv[3]) ||
        			     IsKeywordTarget(m_pszArgv[3]) ) {                     			    
        				if ( IsMapCombination() ) {
	        				if ( IsKeywordCombination(m_pszArgv[4]) ) {
		        				m_nPos = 100;	
		        				isTrue = TRUE;
		        			}
		        			else {
		        				m_nPos = 4;	        
		        				m_nErrorID = SYNTAX_ERROR;     	    
		        			}	
	        			}       	        			
	        			else {  
	        				if ( IsKeywordCombination(m_pszArgv[4]) ||
	        				     IsKeywordSeparation(m_pszArgv[4]) ) {
	        					m_nPos = 100;
	        					isTrue = TRUE;
	        				}                 
	        				else {
	        					m_nPos = 4;                         
	        					m_nErrorID = SYNTAX_ERROR;     	    
	        				}	                                    	        				
	        			}	
        			}
        			else {	
        				m_nPos = 4;                     
        				m_nErrorID = SYNTAX_ERROR;     	    				
        			}        			
        		}
        		else {	
        			m_nPos = 2;                             
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}                                                   		
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
        		if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
        			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
	       			
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2); 
	                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
	                    m_nErrorID = SYNTAX_ERROR;                 
	                    m_nPos = 1;
	                    break;
	                }
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }              
        			if ( IsKeywordOverlay(m_pszArgv[3]) ||
        			     IsKeywordTarget(m_pszArgv[3]) ) {
        				if ( IsMapCombination() ) {
	        				if ( IsKeywordCombination(m_pszArgv[4]) ) {
		        				m_nPos = 100;	
		        				isTrue = TRUE;
		        			}
		        			else {
		        				m_nPos = 4;	        
		        				m_nErrorID = SYNTAX_ERROR;     	    
		        			}	
	        			}       	        			
	        			else {  
	        				if ( IsKeywordCombination(m_pszArgv[4]) ||
	        				     IsKeywordSeparation(m_pszArgv[4]) ) {
	        					m_nPos = 100;
	        					isTrue = TRUE;
	        				}                 
	        				else {
	        					m_nPos = 4;                         
	        					m_nErrorID = SYNTAX_ERROR;     	    
	        				}	                                    	        				
	        			}	                                				
        			}
        			else {
        				m_nPos = 4;                             				
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}	        			
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) { 
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;
		                m_nPos = 5;
		                break;
		            }   
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;                
		            	m_nPos = 5;
		            	break;
		            }                                    
					
		            ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_X0);
		            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv2);                                  
			            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);                                  
			        	
		            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 1;
		                break;
		            }        
		            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 5;
		                break;
		            }             
        			if ( IsKeywordOverlay(m_pszArgv[4]) ||
        			     IsKeywordTarget(m_pszArgv[4]) ) {                  
        			    isTrue = TRUE; 
        				if ( IsMapCombination() ) {	        				
	        				m_nPos = 100;		        				
	        			}       	        			
	        			else {  
        					m_nPos = 4;                         
        					m_nErrorID = SYNTAX_ERROR;     	    
	        			}	                                				
        			}
           			else {
           				m_nPos = 4;
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}	
        		}	          
        		else {
        			m_nPos = 3;                         
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}
        	}
			else {
				m_nPos = 1;           				    
				m_nErrorID = SYNTAX_ERROR;     	    
			}   
			break;	
		case 6: 
        	if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			if ( IsKeywordOverlay(m_pszArgv[3]) ||
        			     IsKeywordTarget(m_pszArgv[3]) ) {                     			    
        				if ( IsMapCombination() ) {
	        				if ( IsKeywordCombination(m_pszArgv[4]) ) {
		        				m_nPos = 100;	
		        				isTrue = TRUE;
		        			}
		        			else {
		        				m_nPos = 4;	        		        				
		        			}	
	        			}       	        			
	        			else {  
	        				if ( IsKeywordCombination(m_pszArgv[4]) ||
	        				     IsKeywordSeparation(m_pszArgv[4]) ) {
	        					m_nPos = 100;
	        					isTrue = TRUE;
	        				}                 
	        				else {
	        					m_nPos = 4;                         	        					
	        				}	                                    	        				
	        			}	
        			}
        			else {	
        				m_nPos = 4;                             				
        			}        			
        		}
        		else {	
        			m_nPos = 2;                                     			
        		}                                       
        		m_nErrorID = SYNTAX_ERROR;     	                		
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
        		if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
        			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
	       			
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2); 
	                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
	                    m_nErrorID = SYNTAX_ERROR;                 
	                    m_nPos = 1;
	                    break;
	                }
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }              
        			if ( IsKeywordOverlay(m_pszArgv[3]) ||
        			     IsKeywordTarget(m_pszArgv[3]) ) {
        				if ( IsMapCombination() ) {
	        				if ( IsKeywordCombination(m_pszArgv[4]) ) {
		        				m_nPos = 100;	
		        				isTrue = TRUE;
		        			}
		        			else {
		        				m_nPos = 4;	        
		        				m_nErrorID = SYNTAX_ERROR;     	    
		        			}	
	        			}       	        			
	        			else {  
	        				if ( IsKeywordCombination(m_pszArgv[4]) ||
	        				     IsKeywordSeparation(m_pszArgv[4]) ) {
	        					m_nPos = 100;
	        					isTrue = TRUE;
	        				}                 
	        				else {
	        					m_nPos = 4;                         
	        					m_nErrorID = SYNTAX_ERROR;     	    
	        				}	                                    	        				
	        			}	                                				
        			}
        			else {
        				m_nPos = 4;                             				
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}
        			m_nErrorID = SYNTAX_ERROR;     	    		        			
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) { 
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;
		                m_nPos = 5;
		                break;
		            }   
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;                
		            	m_nPos = 5;
		            	break;
		            }                                    
					
		            ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_X0);
		            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv2);                                  
			            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);                                  
			        	
		            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 1;
		                break;
		            }        
		            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 5;
		                break;
		            }             
        			if ( IsKeywordOverlay(m_pszArgv[4]) ||
        			     IsKeywordTarget(m_pszArgv[4]) ) {
        				if ( IsMapCombination() ) {	        				
	        				if ( IsKeywordCombination(m_pszArgv[5]) ) {
		        				m_nPos = 100;	
		        				isTrue = TRUE;
		        			}
		        			else {
		        				m_nPos = 4;	        		    
		        				m_nErrorID = SYNTAX_ERROR;     	        				
		        			}	                                    
	        			}       	        			
	        			else {  
	        				if ( IsKeywordCombination(m_pszArgv[5]) ||
	        				     IsKeywordSeparation(m_pszArgv[5]) ) {
	        					m_nPos = 100;
	        					isTrue = TRUE;
	        				}                 
	        				else {
	        					m_nPos = 4;                         
	        					m_nErrorID = SYNTAX_ERROR;     	    
	        				}	                                    	        				
	        			}	                                				
        			}
           			else {
           				m_nPos = 4;
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}	
        		}	          
        		else {
        			m_nPos = 3;                         
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}        		
        	}
			else {
				m_nPos = 1;           				    
				m_nErrorID = SYNTAX_ERROR;     	    
			}                               
			break;	
		default:
        	if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			if ( IsMapAttr(m_pszArgv[2][0], m_pszArgv[3]) ) {
        				m_nPos = 100;	
        			}
        			else {	
        				m_nPos = 4;                     				
        			}        			
        		}
        		else {	
        			m_nPos = 2;                             
        		}        		
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
        		if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
        			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
	       			
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2); 
	                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
	                    m_nErrorID = SYNTAX_ERROR;                 
	                    m_nPos = 1;
	                    break;
	                }
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }              
        			if ( IsMapAttr(m_pszArgv[1][0], m_pszArgv[3]) ) {  			        	
        				m_nPos = 100;	
        			}
        			else {
        				m_nPos = 4;                             				
        			}        			
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) { 
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;
		                m_nPos = 5;
		                break;
		            }   
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;                
		            	m_nPos = 5;
		            	break;
		            }                                    
					
		            ConvertAddress(m_pszArgv[1], szArgv2, nRet,SPACE_X0);
		            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv2);                                  
			            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);                                  
			        	
		            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 1;
		                break;
		            }        
		            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 5;
		                break;
		            }             
           			if ( IsMapAttr(m_pszArgv[1][0], m_pszArgv[4]) ) {  			        			            
           				m_nPos = 100;
           				isTrue = TRUE;	
           			}    
           			else {
           				m_nPos = 4;
        			}	
        		}	          
        		else {
        			m_nPos = 3;                         
        		}
        	}
			else {
				m_nPos = 1;           							
			}   
			m_nErrorID = SYNTAX_ERROR;     	    
			break;	
	}                                                        


/*    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
            m_nPos = 1;
            isTrue = TRUE;
            break;        
        case 2:        
        	if ( IsMapOption(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;
        	}
        	else if ( IsKeywordAll(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;                      
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) || IsAddrDefault(m_pszArgv[1]) ) {
	            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[1],szArgv1);                                  

                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;                 
                    m_nPos = 1;
                    break;
                }
        		m_nPos = 3;
        		isTrue = TRUE;         
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}
			else {
				m_nPos = 1;           				
				m_nErrorID = SYNTAX_ERROR;     	    
			}			
			break;
		case 3:
        	if ( IsMapOption(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}                                       
        	else if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			m_nPos = 4;
        			isTrue = TRUE;
        		}
        		else {	
        			m_nPos = 2;
        		}
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
	            ConvertAddress(m_pszArgv[1], szArgv1, nRet);
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[1],szArgv1);                                  
                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;                 
                    m_nPos = 1;
                    break;
                }
        		if ( IsAddrPX(m_pszArgv[2]) ) {
           			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	 
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[2],szArgv2);                                  
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }     		                                         
        			m_nPos = 4;
        			isTrue = TRUE;
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) {
        			m_nPos = 5;
        			isTrue = TRUE;
        		}	          
        		else {
        			m_nPos = 3;
        		}
        	}
			else {
				m_nPos = 1;           				
			}   
			m_nErrorID = SYNTAX_ERROR;     	    
			break;	
		case 4:
        	if ( IsMapOption(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}                                       
	       	else if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			if ( IsMapAttr(m_pszArgv[2][0], m_pszArgv[3]) ) {
        				m_nPos = 100;	
        				isTrue = TRUE;
        			}
        			else {	
        				m_nPos = 4;             
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}        			
        		}
        		else {	
        			m_nPos = 2;                             
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
        		if ( IsAddrPX(m_pszArgv[2]) ) {
        			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	 
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2); 
	                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
	                    m_nErrorID = SYNTAX_ERROR;                 
	                    m_nPos = 1;
	                    break;
	                }
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }     		                                         
	       			if ( IsMapAttr(m_pszArgv[3]) ) {  			        	
        				m_nPos = 100;	
        				isTrue = TRUE;
        			}
        			else {
        				m_nPos = 4;                     
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}	
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) { 
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;
		                m_nPos = 5;
		                break;
		            }   
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;                
		            	m_nPos = 5;
		            	break;
		            }                     
		            ConvertAddress(m_pszArgv[1], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv2);                                  
			            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);                                  
			        	
		            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 1;
		                break;
		            }        
		            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 5;
		                break;
		            }             
           			m_nPos = 4;
        			isTrue = TRUE;                          
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}	          
        		else {
        			m_nPos = 3;                         
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}
        	}
			else {
				m_nPos = 1;           				    
				m_nErrorID = SYNTAX_ERROR;     	    
			}   
			break;	
		case 5: 
        	if ( IsMapOption(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}                                       		
        	else if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			if ( IsMapAttr(m_pszArgv[2][0], m_pszArgv[3]) ) {
        				m_nPos = 100;	
        			}
        			else {	
        				m_nPos = 4;                     				
        			}        			
        		}
        		else {	
        			m_nPos = 2;                             
        		}       
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
        		if ( IsAddrPX(m_pszArgv[2]) ) {
        			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
	       			
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2); 
	                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
	                    m_nErrorID = SYNTAX_ERROR;                 
	                    m_nPos = 1;
	                    break;
	                }
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }              
        			if ( IsMapAttr(m_pszArgv[3]) ) {  			        	
        				m_nPos = 100;	
        			}
        			else {
        				m_nPos = 4;                             				
        			}	   
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) { 
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;
		                m_nPos = 5;
		                break;
		            }   
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;                
		            	m_nPos = 5;
		            	break;
		            }                                    
					
		            ConvertAddress(m_pszArgv[1], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv2);                                  
			            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);                                  
			        	
		            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 1;
		                break;
		            }        
		            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 5;
		                break;
		            }             
           			if ( IsMapAttr(m_pszArgv[4]) ) {  			        			            
           				m_nPos = 100;
           				isTrue = TRUE;
           			}    
           			else {
           				m_nPos = 4;
        				m_nErrorID = SYNTAX_ERROR;     	    
        			}	
        		}	          
        		else {
        			m_nPos = 3;                         
        			m_nErrorID = SYNTAX_ERROR;     	    
        		}
        	}
			else {
				m_nPos = 1;           				    
				m_nErrorID = SYNTAX_ERROR;     	    
			}   
			break;	
		default:
        	if ( IsMapOption(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;     	    
        	}                                       		
        	else if ( IsKeywordAll(m_pszArgv[1]) ) {
        		if ( IsMapMemType(m_pszArgv[2]) ) {
        			if ( IsMapAttr(m_pszArgv[2][0], m_pszArgv[3]) ) {
        				m_nPos = 100;	
        			}
        			else {	
        				m_nPos = 4;                     				
        			}        			
        		}
        		else {	
        			m_nPos = 2;                             
        		}        		
        	}
        	else if ( IsAddrPX(m_pszArgv[1]) ) {
        		if ( IsAddrPX(m_pszArgv[2]) ) {
        			retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
	       			
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2); 
	                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
	                    m_nErrorID = SYNTAX_ERROR;                 
	                    m_nPos = 1;
	                    break;
	                }
	                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
	                    m_nErrorID = SYNTAX_ERROR;
	                    m_nPos = 3;
	                    break;
	                }              
        			if ( IsMapAttr(m_pszArgv[3]) ) {  			        	
        				m_nPos = 100;	
        			}
        			else {
        				m_nPos = 4;                             				
        			}        			
        		}
        		else if ( IsKeywordLength(m_pszArgv[2]) ) { 
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;
		                m_nPos = 5;
		                break;
		            }   
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		                m_nErrorID = nRet;                
		            	m_nPos = 5;
		            	break;
		            }                                    
					
		            ConvertAddress(m_pszArgv[1], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv2);                                  
			            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);                                  
			        	
		            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 1;
		                break;
		            }        
		            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 5;
		                break;
		            }             
           			if ( IsMapAttr(m_pszArgv[4]) ) {  			        			            
           				m_nPos = 100;
           				isTrue = TRUE;	
           			}    
           			else {
           				m_nPos = 4;
        			}	
        		}	          
        		else {
        			m_nPos = 3;                         
        		}
        	}
			else {
				m_nPos = 1;           							
			}   
			m_nErrorID = SYNTAX_ERROR;     	    
			break;	
	}                                                        
*/    
	return isTrue;	
}   // End of CSyntaxCore::SyntaxCheckMap().

//MACro    macroname
BOOL CSyntaxCore::SyntaxCheckMacro(BOOL isSub)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;            
        case 2:
            if ( IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;  
        		isTrue = TRUE;
			}
			else {
                m_nErrorID = SYNTAX_ERROR;
                m_nPos = 1;
            }
            break;
        default:           
			if ( IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;  
			}
        	else {
        		m_nPos = 1;
        	}	  
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	
	return isTrue;    
	
}   // End of CSyntaxCore::SyntaxCheckMacro().
           
//MDel        macroname|ALl           
BOOL CSyntaxCore::SyntaxCheckMdel(BOOL isSub)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:                
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;
        case 2:
        	if ( IsKeywordAll(m_pszArgv[1]) || IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;
        	}             
        	else {
        		m_nPos = 1;               
        		m_nErrorID = SYNTAX_ERROR;
        	}	
            break;
        default:
        	if ( IsKeywordAll(m_pszArgv[1]) || IsMacroName(m_pszArgv[1]) ) {
        		m_nPos = 100;
        	}             
        	else {
        		m_nPos = 1;
        	}	
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	
	return isTrue;    
	
}   // End of CSyntaxCore::SyntaxCheckMdel().


// Memory       adr1 [adr2|Length length]
BOOL CSyntaxCore::SyntaxCheckMemory(BOOL isSub)
{       
	char szArgv1[260];
	char szArgv2[260];

    ADDR_RETCODE retCode;
        
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:                
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;
        case 2:   
            if ( IsAddr(m_pszArgv[1]) ) {
            	ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0 );
				NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[1],szArgv1);            		
            	m_nPos = 2;            	
            	isTrue = TRUE;
            }              
            else {
			    m_nPos = 1;
			    m_nErrorID = SYNTAX_ERROR;        			    
            }                       
            break;
        case 3:                       
            if ( IsAddr(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2], SPACE_X0 );
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;     
		            	m_nPos = 2;
		            }	           
		            else {
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
			            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
						NewMem(m_pszArgv[1], strlen(szArgv1)+1);
						NewMem(m_pszArgv[2], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv1);                                  
			            strcpy(m_pszArgv[2],szArgv2); 		            
			            m_nPos = 100;
			            isTrue = TRUE;
		            }                			
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
            		m_nPos = 3;
            		isTrue = TRUE;	
            	}            
            	else {         
            		m_nPos = 2;
					m_nErrorID = SYNTAX_ERROR;            	
            	}
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }      
            break;
        case 4:
            if ( IsAddr(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2],SPACE_X0);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;
		            }	           
		            else {   
						m_nPos = 100;
					}
					m_nErrorID = SYNTAX_ERROR;
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			                m_nErrorID = nRet;                
			            	m_nPos = 3;
			            	break;
			            }                     
			            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet,SPACE_X0)) {
			              	m_nErrorID = nRet;
			              	m_nPos = 3;
			            	break;
			            }
			            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv2);                                  
			            
			            ConvertLen(m_pszArgv[3], szArgv1);
			           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[3],szArgv1);                                  
					
						isTrue = TRUE;	
						m_nPos = 100;
            		}   
            		else {
	            		m_nPos = 3;
	            		m_nErrorID = nRet;                	            		
	            	}	
            	}            
            	else {         
            		m_nPos = 2;
					m_nErrorID = SYNTAX_ERROR;            	
            	}
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }       
            break;
        default:
            if ( IsAddr(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2],SPACE_X0);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;		            	
		            }	           
		            else {   
						m_nPos = 100;
					}
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			            	m_nPos = 3;
			            }                     
			            else {
							m_nPos = 100;
						}	
            		}   
            		else {
	            		m_nErrorID = nRet;                	            		
	            		m_nPos = 3;
	            	}	
            	}            
            	else {         
            		m_nPos = 2;
            	}
            }
            else {
            	m_nPos = 1;                       	
            }   
            m_nErrorID = SYNTAX_ERROR;    
            break;        	
    }  
                  
	return isTrue;                  
}   // End of CSyntaxCore::SyntaxCheckMemory().

//MENd
BOOL CSyntaxCore::SyntaxCheckMend(BOOL isSub)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	isTrue = TRUE;
        	break;            
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if ( !isDefineMacro ) {
    	m_nErrorID = SYNTAX_ERROR;
    }
	
	return isTrue;    
		
}   // End of CSyntaxCore::SyntaxCheckMend().
     
//MList [macroname]    
BOOL CSyntaxCore::SyntaxCheckMlist(BOOL isSub)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
            break;          
        case 2:
			if ( IsFilename(m_pszArgv[1], nRet) ) {
        		m_nPos = 100;  
        		isTrue = TRUE;
			}
        	else {
        		m_nPos = 1;       
        		m_nErrorID = nRet;
        	}	  
            break;
        default:
			if ( IsFilename(m_pszArgv[1], nRet) ) {
        		m_nPos = 100;  
			}
        	else {
        		m_nPos = 1;       
        	}	  
            m_nErrorID = SYNTAX_ERROR;
            break;
    }                 
    
	return isTrue;    
	
}   // End of CSyntaxCore::SyntaxCheckMlist().
       

// Outport      port data
//          ( port = 0 - 7, data =  0 - FF ) 
BOOL CSyntaxCore::SyntaxCheckOutport(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;                
        	m_nErrorID = SYNTAX_ERROR;
            break;          
        case 2:                       
        	if ( IsPort(m_pszArgv[1]) ) {
	        	m_nPos = 2;  
	        	isTrue = TRUE;                
        	}
        	else {
	        	m_nPos = 1;          		
        	}   
        	m_nErrorID = SYNTAX_ERROR;
        	break;        
        case 3:                       
        	if ( IsPort(m_pszArgv[1]) ) {
       			if ( IsByteData(m_pszArgv[2]) ) {
    				m_nPos = 100;
    				isTrue = TRUE;                
    			}
    			else {		
    				m_nPos = 2;           
    				m_nErrorID = SYNTAX_ERROR;
    			}        				        
        	}
        	else {
	        	m_nPos = 1;          		  
	        	m_nErrorID = SYNTAX_ERROR;
        	}   
        	break;        
        default:                       
        	if ( IsPort(m_pszArgv[1]) ) {        		
    			if ( IsByteData(m_pszArgv[2]) ) {
    				m_nPos = 100;
    			}
    			else {		
    				m_nPos = 2;                   				
    			}   
        	}
        	else {
	        	m_nPos = 1;          	        	
        	}   
        	m_nErrorID = SYNTAX_ERROR;
        	break;        
    }
	
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckOutport().


//Qualify     [[Address {Range adr1 adr2|xadr|<badrs..>}]
//            [DATum Byte|Word {Range data1 data2|xdata|bdata}]
//            [Status <status..>]] |
//            [Clear]
BOOL CSyntaxCore::SyntaxCheckQualify(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                    
	BOOL isTrue = FALSE;	                    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
	    case 1: 
	    	m_nPos = 1;
	    	isTrue = TRUE;       
            break;        
        case 2:
        	if ( IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;
        	}                 
        	else if ( IsKeywordAddress(m_pszArgv[1]) ) {
        		m_nPos = 2;   
        		isTrue = TRUE;                
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	else if ( IsKeywordDatum(m_pszArgv[1]) ) {
        		m_nPos = 3;   
        		isTrue = TRUE;            
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	else if ( IsKeywordStatus(m_pszArgv[1]) ) {
        		m_nPos = 4;   
        		isTrue = TRUE;            
        		m_nErrorID = SYNTAX_ERROR;
        	}             
        	else {
        		m_nPos = 1;               
        		m_nErrorID = SYNTAX_ERROR;
        	}        	                  
        	break;
        default:                                               	
	        // Initial flag.
	        BOOL isA = FALSE;	//Address
	        BOOL isD = FALSE;   //Datum
	        BOOL isS = FALSE;   //Status
            int nIndex = 1;  
            ADDR_RETCODE retCode;                                           
			char szArgv1[300];
			char szArgv2[300];
			            
            if ( IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;        	
        		m_nErrorID = SYNTAX_ERROR;	
        	}                             
        	while ( nIndex < nCount ) {  
        		//Address ...
       			if ( IsKeywordAddress(m_pszArgv[nIndex]) ) {
        			if ( !isA ) {       
        				isA = TRUE;	
        				if ( ++nIndex < nCount ) {
        					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {								
								if ( ++nIndex < nCount ) {
									if ( IsPAddr(m_pszArgv[nIndex]) ) {
								 		if ( ++nIndex < nCount ) {
								 			if ( IsPAddr(m_pszArgv[nIndex]) || IsAddrDefault(m_pszArgv[nIndex]) ) {
												retCode = AdrCheck2Addr(m_pszArgv[nIndex-1],m_pszArgv[nIndex],SPACE_P0);
									            if (ADR_OK == retCode) {       
										            if (!ConvertAddress(m_pszArgv[nIndex-1], szArgv1, nRet,SPACE_P0)) {
										              	m_nErrorID = nRet;
										            	break;
										            }	
										            if (!ConvertAddress(m_pszArgv[nIndex], szArgv2, nRet)) {
										              	m_nErrorID = nRet;
										            	break;
										            }	                          						                                         
													NewMem(m_pszArgv[nIndex-1], strlen(szArgv1)+1);
													NewMem(m_pszArgv[nIndex], strlen(szArgv2)+1);
										            strcpy(m_pszArgv[nIndex-1],szArgv1);                                  
										            strcpy(m_pszArgv[nIndex],szArgv2); 		                           
									 				m_nPos = 8;
									 				if ( ++nIndex >= nCount ) {								 				
									 					isTrue = TRUE;								 													 					
									 				}    
									 			}
									 			else {
									 				m_nPos = 7;
									 				m_nErrorID = SYNTAX_ERROR;
									 				break;
									 			}	
								 			}
								 			else {
								 				m_nPos = 7;
								 				m_nErrorID = SYNTAX_ERROR;
								 				break;
								 			}
								 		}
								 		else {
								 			m_nPos = 7;
								 			isTrue = TRUE;                    
								 			m_nErrorID = SYNTAX_ERROR;    
								 			break;
								 		}			
								 	}   
								 	else {
								 		m_nPos = 6;
								 		m_nErrorID = SYNTAX_ERROR;
								 		break;
								 	}
								}     
								else {
								 	m_nPos = 6;
								 	isTrue = TRUE;                    
								 	m_nErrorID = SYNTAX_ERROR;
								 	break;
								}
        					}	
        					else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
        						m_nPos = 8;
        						if ( ++nIndex >= nCount ) {
        							isTrue = TRUE;	
        						}
        					}
        					else if ( IsMultipleAddr(m_pszArgv[nIndex]) ) {
        						m_nPos = 8;
        						if ( ++nIndex >= nCount ) {
        							isTrue = TRUE;	
        						}
        					}
        					else {
        						m_nPos = 2;
        						m_nErrorID = SYNTAX_ERROR;
        						break;
        					}
        				}
        				else {
        					m_nPos = 2;
        					isTrue = TRUE;                  
        					m_nErrorID = SYNTAX_ERROR;
        					break;
        				}	
        			}   
        			else {                          
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}
        		}                   
        		//Datum ..
       			else if ( IsKeywordDatum(m_pszArgv[nIndex]) ) {
        			if ( !isD ) {       
        				isD = TRUE;	  
        				if ( ++nIndex < nCount ) {
        					if ( IsKeywordByteOrWord(m_pszArgv[nIndex]) ) {
		        				if ( ++nIndex < nCount ) {
		        					if ( IsKeywordRange(m_pszArgv[nIndex]) ) {								
										if ( ++nIndex < nCount ) {
											if ( IsEventData(m_pszArgv[nIndex]) ) {
										 		if ( ++nIndex < nCount ) {
										 			if ( IsEventData(m_pszArgv[nIndex]) ) {
										 				m_nPos = 13;          
										 				if ( ++nIndex >= nCount ) {								 																 					
										 					isTrue = TRUE;								 													 					
										 				}
										 			}
										 			else {
										 				m_nPos = 12;
										 				m_nErrorID = SYNTAX_ERROR;
										 				break;
										 			}
										 		}
										 		else {
										 			m_nPos = 12;
										 			isTrue = TRUE;                    
										 			m_nErrorID = SYNTAX_ERROR;    
										 			break;
										 		}			
										 	}   
										 	else {
										 		m_nPos = 11;
										 		m_nErrorID = SYNTAX_ERROR;
										 		break;
										 	}
										}     
										else {
										 	m_nPos = 11;
										 	isTrue = TRUE;                    
										 	m_nErrorID = SYNTAX_ERROR;
										 	break;
										}
		        					}	
		        					else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
		        						m_nPos = 13;
		        						if ( ++nIndex >= nCount ) {
		        							isTrue = TRUE;	
		        						}
		        					}
		        					else if ( IsEventData(m_pszArgv[nIndex]) ) {
		        						m_nPos = 13;
		        						if ( ++nIndex >= nCount ) {
		        							isTrue = TRUE;	
		        						}
		        					}
		        					else {
		        						m_nPos = 10;
		        						m_nErrorID = SYNTAX_ERROR;
		        						break;
		        					}
		        				}
		        				else {
		        					m_nPos = 10;
		        					isTrue = TRUE;                  
		        					m_nErrorID = SYNTAX_ERROR;
		        					break;
		        				}	
        							
        					}             
        					else {
        						m_nPos = 3;
        						m_nErrorID = SYNTAX_ERROR;
        						break; 
        					}
        				}
        				else {
        					m_nPos = 3;        					
        					isTrue = TRUE;
        					m_nErrorID = SYNTAX_ERROR;
        					break;
        				}
        			}   
        			else {                          
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;	
        			}
        		}                           		        
        		//Status..
        		else if ( IsKeywordStatus(m_pszArgv[nIndex]) ) {
					if ( !isS ) {
						isS = TRUE;
						if ( ++nIndex < nCount ) {
							if ( IsStatusOption(m_pszArgv[nIndex]) ) {
								m_nPos = 100;
								if ( ++nIndex >= nCount ) {
									isTrue = TRUE;
								}      
							}
							else {
								m_nPos = 4;
								m_nErrorID = SYNTAX_ERROR;     
								break;
							}
						}
						else {
							m_nPos = 4;
							isTrue = TRUE;
							m_nErrorID = SYNTAX_ERROR;
							break;
						}        		
					}
					else {
        				m_nPos = 100;
        				m_nErrorID = SYNTAX_ERROR;	
        				break;						
					}	
        		}
        		else {                              
        			m_nPos = 2;
        			m_nErrorID = SYNTAX_ERROR;		
        			break;	
        		}                                	
        	}
        	break;            
	}             
    return isTrue;
}	                              

                                    
/*
// POrt         port
BOOL CSyntaxCore::SyntaxCheckPort(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;                
        	m_nErrorID = SYNTAX_ERROR;
            break;          
        case 2:
            if ( IsPort(m_pszArgv[1]) ) {
            	m_nPos = 100;             
            	isTrue = TRUE;                
            }
            else {           
            	m_nPos = 1;
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            if ( IsPort(m_pszArgv[1]) ) {
            	m_nPos = 100;             
            }
            else {           
            	m_nPos = 1;
            }
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

	return isTrue;    
}   // End of CSyntaxCore::SyntaxCheckPort().
*/


// Register     [reg_id] [data]
BOOL CSyntaxCore::SyntaxCheckRegister(BOOL isSub)
{
		
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;                
            break;          
        case 2:  
            if ( IsRegName(m_pszArgv[1]) ) {
	        	m_nPos = 2;  
	        	isTrue = TRUE;                            
            }
            else {
                m_nErrorID = SYNTAX_ERROR;
                m_nPos = 1;
            }        
        	break;    
        case 3:            
            if ( IsRegName(m_pszArgv[1]) ) {
            	if ( IsRegData(m_pszArgv[1], m_pszArgv[2]) ) {
            		m_nPos = 100;
            		isTrue = TRUE;                            
            	}
            	else {                                           
	        		m_nPos = 2;           
	        		m_nErrorID = SYNTAX_ERROR;
	        	}	                          	        	
            }
            else {
                m_nErrorID = SYNTAX_ERROR;
                m_nPos = 1;
            }        
            break;
        default:
            if ( IsRegName(m_pszArgv[1]) ) {
            	if ( IsRegData(m_pszArgv[1], m_pszArgv[2]) ) {
            		m_nPos = 100;
            	}
            	else {                                           
	        		m_nPos = 2;           
	        	}	                          	        	
            }
            else {
                m_nPos = 1;
            }        
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	
	return isTrue;
	
}   // End of CSyntaxCore::SyntaxCheckRegister().


// RESet        [adr]
BOOL CSyntaxCore::SyntaxCheckReset(BOOL isSub)
{                    
    char szArgv[260];

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
        
    // Check command syntax.
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:        
            m_nPos = 1;  
			isTrue = TRUE;
            break;
        case 2:
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_P0)) {
              	m_nErrorID = nRet;
              	m_nPos = 1;  
            	break;
            }                      
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);
        	if ( IsPAddr(m_pszArgv[1]) ) {
                isTrue = TRUE;
                m_nPos = 100;  
            }    
            else {    
                m_nErrorID = ADDR_TYPE_ERROR;
                m_nPos = 1;  
            }   
	       	break;
        default:
        	if ( IsPAddr(m_pszArgv[1]) ) {
                m_nPos = 100;  
            }    
            else {    
                m_nPos = 1;  
            }   
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
    return isTrue;
}   // End of CSyntaxCore::SyntaxCheckReset().


//Restart
BOOL CSyntaxCore::SyntaxCheckRestart(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
        case 1:   
        	isTrue = TRUE;
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckRestart().


// SEarch       adr1 {adr2|Length length} {[Insensitive] "string"|data..}
BOOL CSyntaxCore::SyntaxCheckSearch(BOOL isSub)
{
	char szArgv1[260];
	char szArgv2[260];
	
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;             
    
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
		case 2:                       
			if ( IsAddrPX(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
			}
			m_nErrorID = SYNTAX_ERROR;			
			break;
		case 3:            
			if ( IsAddrPX(m_pszArgv[1]) ) {
				if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);	
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = NOT_SHOW_ERROR;
		            	m_nPos = 2;
		            	break;                                        
		            }	                              
                    else {
						m_nPos = 4;
						isTrue = TRUE;			            			
					}	
				}
				else if ( IsKeywordLength(m_pszArgv[2]) ) {
					m_nPos = 3;                                         
					isTrue = TRUE;			            			
				}
				else {
					m_nPos = 2;			            			
				}	
			}                                   
			else {
				m_nPos = 1;	
			}
			m_nErrorID = SYNTAX_ERROR;			
			break;
        case 4:          
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsKeywordLength(m_pszArgv[2]) ) {
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {		                
		                m_nPos = 3;                        
		                m_nErrorID = nRet;
		                break;
		            }    
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		            	m_nPos = 3;		            	
		                m_nErrorID = nRet;
		                break;
		            }              
		            m_nPos = 4;
		            m_nErrorID = SYNTAX_ERROR;       
            	}
            	else if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {    
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);	
		            if (ADR_OK != retCode) {      
		            	m_nErrorID = SYNTAX_ERROR; 
		            	m_nPos = 2;
		            	break;                                        
		            }	                              
            		if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
				    	m_nPos = 5;
				    	isTrue = TRUE;				    	
				    	m_nErrorID = SYNTAX_ERROR;
				    }
					else {				    
					    if ( !PreStringData(3, 2) ) {
					        m_nErrorID = SYNTAX_ERROR;
					        m_nPos = 4;
					        break;
					    }		            
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet,SPACE_X0);
			            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
			            if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;
			            }
			            NewMem(m_pszArgv[1], strlen(szArgv1)+1); 
			            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv1);                                  
			            strcpy(m_pszArgv[2],szArgv2);             		
			            if ( !IsFillDataRange(3, m_pszArgv, TRUE) ) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;
			            }
			            isTrue = TRUE;
			    	}        
            	}
            	else {
					m_nErrorID = SYNTAX_ERROR;			
					m_nPos = 2;            		
            	}
            }                  
            else {
				m_nErrorID = SYNTAX_ERROR;			
				m_nPos = 1;            		            
            }
            break;                          
        case 5:          
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsKeywordLength(m_pszArgv[2]) ) {
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {		                
		                m_nPos = 3;                        
		                m_nErrorID = nRet;
		                break;
		            }    
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		            	m_nPos = 3;		            	
		                m_nErrorID = nRet;
		                break;
		            } 
            		if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
				    	m_nPos = 5;
				    	isTrue = TRUE;				    	
				    	m_nErrorID = SYNTAX_ERROR;
				    }
					else {				    
					    if ( !PreStringData(4, 2) ) {
					        m_nErrorID = SYNTAX_ERROR;
					        m_nPos = 4;
					        break;
					    }		            
			            ConvertAddress(m_pszArgv[1], szArgv1, nRet,SPACE_X0);
			            if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;
			            }
			            if ( !IsFillDataRange(4, m_pszArgv, FALSE) ) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;
			            }                               		
			            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[1],szArgv1);   		            
			            ConvertLen(m_pszArgv[3], szArgv1);
			           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[3],szArgv1);   		            
			            m_nPos = 100; 
			            isTrue = TRUE;		            
		            }             
            	}
            	else if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {    
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);	
		            if (ADR_OK != retCode) {      
		            	m_nErrorID = SYNTAX_ERROR; 
		            	m_nPos = 2;
		            	break;                                        
		            }	                              
            		if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
					    if ( !PreStringData(4, 2) ) {
					        m_nErrorID = SYNTAX_ERROR;
					        m_nPos = 4;
					        break;
					    }
			            if ( IsString(m_pszArgv[4]) && IsFillDataRange(4, m_pszArgv, TRUE) ) {
			            	m_nPos = 100;
			            	isTrue = TRUE;
			            }
			            else {	
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;
			            }     					    		  
				    }
					else {				    
					    if ( !PreStringData(3, 2) ) {
					        m_nErrorID = SYNTAX_ERROR;
					        m_nPos = 4;
					        break;
					    }		
			            if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3]) ) {			            	
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;				            
			            }   
				        else if ( !IsFillDataRange(3, m_pszArgv, TRUE) ) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;				            
						}				        
			            else {
			            	m_nPos = 100;
			            	isTrue = TRUE;
			            }
					}                
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_X0);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1); 
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2);             		
		            isTrue = TRUE;
            	}
            	else {
					m_nErrorID = SYNTAX_ERROR;			
					m_nPos = 2;            		
            	}
            }                  
            else {
				m_nErrorID = SYNTAX_ERROR;			
				m_nPos = 1;            		            
            }
            break;                              
		default:            
		    int nArgc;
		    if ( IsKeywordLength(m_pszArgv[2]) ) {
		    	if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
		    		nArgc = 5;
		    	}             
		    	else {
		        	nArgc = 4;
		        }	
		    }
		    else {
		    	if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
		    		nArgc = 4;
		    	}             
		    	else {
		        	nArgc = 3;
		        }	
		    }
		
		    if ( !PreStringData(nArgc, 2) ) {
		        m_nErrorID = SYNTAX_ERROR;
		        m_nPos = 4;
		        break;
		    }
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsKeywordLength(m_pszArgv[2]) ) {
		            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {		                
		                m_nPos = 3;                        
		                m_nErrorID = nRet;
		                break;
		            }    
		            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
		            	m_nPos = 3;		            	
		            	m_nErrorID = nRet;
		            	break;
		            }              
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet,SPACE_X0);
		            if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
		            	if ( IsString(m_pszArgv[5]) && 
		            	     IsFillDataRange(5, m_pszArgv, FALSE) ) {
		            		m_nPos = 100;
		            		isTrue = TRUE;
		            	}                                                  
		            	else {
		            		m_nPos = 5;
		            		m_nErrorID = SYNTAX_ERROR;
		            		break;
		            	}   
		            }	
			        else {
			            if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;
			            }
	            		m_nPos = 100;
	            		isTrue = TRUE;		            	
		            }
		            if ( !IsFillDataRange(4, m_pszArgv, FALSE) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 4;
		                break;
		            }                               		
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[1],szArgv1);   		            
		            ConvertLen(m_pszArgv[3], szArgv1);
		           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[3],szArgv1);   		            
		            m_nPos = 100; 
		            isTrue = TRUE;		            
            	}
            	else if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
            		if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
		            	if ( IsString(m_pszArgv[4]) &&
		            		 IsFillDataRange(4, m_pszArgv, TRUE) ) {	
		            		m_nPos = 100;
		            		isTrue = TRUE;
		            	}                                                  
		            	else {
		            		m_nPos = 5;
		            		m_nErrorID = SYNTAX_ERROR;
		            		break;
		            	}
			        }
			        else {
			            if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
			                m_nErrorID = SYNTAX_ERROR;
			                m_nPos = 4;
			                break;
			            }
	            		m_nPos = 100;
	            		isTrue = TRUE;		            	
		            }
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2],SPACE_X0);	
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 2;
		            	break;                                        
		            }	                              
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1); 
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2);             		
		            if ( !IsFillDataRange(3, m_pszArgv, TRUE) ) {
		                m_nErrorID = SYNTAX_ERROR;
		                m_nPos = 4;
		                break;
		            }
            	}
            	else {
					m_nErrorID = SYNTAX_ERROR;			
					m_nPos = 2;            		
            	}
            }                  
            else {
				m_nErrorID = SYNTAX_ERROR;			
				m_nPos = 1;            		            
            }                             
        	break;    
    }
                
    return isTrue;
}   // End of CSyntaxCore::SyntaxCheckSearch().

//Old:
// Step         [Over] 
//              [ count | FOrever | adr1 adr2 | 
//              Till { Ret | CAll } | Till {@reg | adr} IS value ]      
//In the "hints.dat":
//Step ;[;Over;] [;count;|;FOrever;|;adr1 ;adr2;|;Till ;{;Ret;|;Call;}];
//New for chen's idea
//Step [[Over] [Forever]]|[OUt]
BOOL CSyntaxCore::SyntaxCheckStep(BOOL isSub)
{

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	     

    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			break;
        case 2:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				m_nPos = 2;       
				isTrue = TRUE;			
			}
            else if ( IsKeywordForever(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	isTrue = TRUE;
            }                 
            else if ( IsKeywordOut(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	isTrue = TRUE;
            }                     
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }                             
            break;
        case 3:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
            		m_nPos = 100;
            		isTrue = TRUE;
            	}
            	else {         
					m_nPos = 2;       
					m_nErrorID = SYNTAX_ERROR;
				}	
			}
            else if ( IsKeywordForever(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	m_nErrorID = SYNTAX_ERROR;
            }                 
            else if ( IsKeywordOut(m_pszArgv[1]) ) {
            	m_nPos = 100;
            	m_nErrorID = SYNTAX_ERROR;
            }                     
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }                             
            break;
		default:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
            		m_nPos = 100;            
            	}
            	else {         
					m_nPos = 2;       					
				}	
			}
            else if ( IsKeywordForever(m_pszArgv[1]) ) {
            	m_nPos = 100;            	
            }                 
            else if ( IsKeywordOut(m_pszArgv[1]) ) {
            	m_nPos = 100;            	
            }                     
            else {
            	m_nPos = 1;            	
            }              
            m_nErrorID = SYNTAX_ERROR;               
            break;
	}		        	
/*    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			break;
        case 2:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				m_nPos = 2;       
				isTrue = TRUE;			
			}
			else if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;       
				isTrue = TRUE;			
			}                                           
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				m_nPos = 4;       
				isTrue = TRUE;			  
				m_nErrorID = SYNTAX_ERROR;
			}
			else if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;       
				isTrue = TRUE;			
			}    
			else if ( IsPAddr(m_pszArgv[1]) || IsAddrDefault(m_pszArgv[1])) {
				m_nPos = 3;       
				isTrue = TRUE;	
				m_nErrorID = SYNTAX_ERROR;		
			}
			else {
				m_nPos = 1;       
				m_nErrorID = SYNTAX_ERROR;							
			}
            break;                        
        case 3:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;	
				}
				else if ( IsStepCount(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;	
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {
					m_nPos = 3;
					isTrue = TRUE;	                                
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsKeywordTill(m_pszArgv[2]) ) {
					m_nPos = 4;
					isTrue = TRUE;	                                    
					m_nErrorID = SYNTAX_ERROR;							
				}
				else {
					m_nPos = 2;                                       
					m_nErrorID = SYNTAX_ERROR;											
				}           			
			}
			else if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;       
				m_nErrorID = SYNTAX_ERROR;							
			}                                           
			else if ( IsKeywordTill(m_pszArgv[1]) ){
				if ( IsKeywordRet(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
				}
				else if ( IsKeywordCall(m_pszArgv[2]) ) {
					m_nPos = 100;
					isTrue = TRUE;
				}   
				else if ( IsStepReg(m_pszArgv[2]) ) {
					m_nPos = 5;
					isTrue = TRUE;                          
					m_nErrorID = SYNTAX_ERROR;				
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {
					m_nPos = 5;
					isTrue = TRUE;                          
					m_nErrorID = SYNTAX_ERROR;				
				}
				else {
					m_nPos = 4;       
					m_nErrorID = SYNTAX_ERROR;				
				}
			}
			else if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;       
				m_nErrorID = SYNTAX_ERROR;							
			}    
			else if ( IsPAddr(m_pszArgv[1]) || IsAddrDefault(m_pszArgv[1])) {
				if ( IsAddr(m_pszArgv[2]) ) {              
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2],SPACE_P0);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
		            ConvertAddress(m_pszArgv[1], szArgv1, nRet,SPACE_P0);
		            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
		            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
		            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
		            strcpy(m_pszArgv[1],szArgv1);                                  
		            strcpy(m_pszArgv[2],szArgv2); 
					m_nPos = 100;                           
					isTrue = TRUE;                          					
				}
				else {
					m_nPos = 3;       
					m_nErrorID = SYNTAX_ERROR;		
				}	
			}
			else {
				m_nPos = 1;       
				m_nErrorID = SYNTAX_ERROR;							
			}
            break;                        
        case 4:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsStepCount(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {
					if ( IsAddr(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[2],m_pszArgv[3],SPACE_P0);
			            if (ADR_OK != retCode) {       
			            	m_nErrorID = SYNTAX_ERROR;
			            	m_nPos = 3;
			            	break;
			            }	                              
			            ConvertAddress(m_pszArgv[2], szArgv1, nRet,SPACE_P0);
			            ConvertAddress(m_pszArgv[3], szArgv2, nRet);
			            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
			            NewMem(m_pszArgv[3], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[2],szArgv1);                                  
			            strcpy(m_pszArgv[3],szArgv2); 
						m_nPos = 100;                           
						isTrue = TRUE;                          					
					}
					else {						
						m_nPos = 3;
						m_nErrorID = SYNTAX_ERROR;							
					}	
				}
				else if ( IsKeywordTill(m_pszArgv[2]) ) {
					if ( IsKeywordRet(m_pszArgv[3]) ) {
						m_nPos = 100;
						isTrue = TRUE;
					}
					else if ( IsKeywordCall(m_pszArgv[3]) ) {
						m_nPos = 100;
						isTrue = TRUE;
					}
					else if ( IsStepReg(m_pszArgv[3]) ) {
						m_nPos = 5;
						isTrue = TRUE;
						m_nErrorID = SYNTAX_ERROR;							
					}
					else if ( IsPAddr(m_pszArgv[3]) || IsAddrDefault(m_pszArgv[3])) {
						m_nPos = 5;
						isTrue = TRUE;                                      
						m_nErrorID = SYNTAX_ERROR;							
					}
					else {
						m_nPos = 4;
						m_nErrorID = SYNTAX_ERROR;							
					}	
				}
				else {
					m_nPos = 2;                                       
					m_nErrorID = SYNTAX_ERROR;											
				}           			
			}
			else if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;       
				m_nErrorID = SYNTAX_ERROR;							
			}                                           
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsKeywordRet(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsKeywordCall(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}   
				else if ( IsStepReg(m_pszArgv[2]) ) {                   
					if ( IsKeywordIs(m_pszArgv[3]) ) {
					    m_nPos = 6;
					    isTrue = TRUE;
					}
					else {
						m_nPos = 5;						
					}	           
					m_nErrorID = SYNTAX_ERROR;				
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {         
					if ( IsKeywordIs(m_pszArgv[3]) ) {
					    m_nPos = 6;
					    isTrue = TRUE;
					}
					else {
						m_nPos = 5;						
					}	           
					m_nErrorID = SYNTAX_ERROR;				
				}
				else {
					m_nPos = 4;       
					m_nErrorID = SYNTAX_ERROR;				
				}
			}
			else if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;       
				m_nErrorID = SYNTAX_ERROR;							
			}    
			else if ( IsPAddr(m_pszArgv[1]) || IsAddrDefault(m_pszArgv[1])) {
				if ( IsAddr(m_pszArgv[2]) ) {              
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2],SPACE_P0);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
					m_nPos = 100;                           
				}
				else {
					m_nPos = 3;                 					
				}	
				m_nErrorID = SYNTAX_ERROR;		
			}
			else {
				m_nPos = 1;       
				m_nErrorID = SYNTAX_ERROR;							
			}
            break;                        
        case 5:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsStepCount(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {
					if ( IsAddr(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[2],m_pszArgv[3],SPACE_P0);
			            if (ADR_OK != retCode) {       
			            	m_nErrorID = SYNTAX_ERROR;
			            	m_nPos = 3;
			            	break;
			            }	                              
						m_nPos = 100;                           
					}
					else {						
						m_nPos = 3; 												
					}	
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsKeywordTill(m_pszArgv[2]) ) {
					if ( IsKeywordRet(m_pszArgv[3]) ) {
						m_nPos = 100;
						m_nErrorID = SYNTAX_ERROR;							
					}
					else if ( IsKeywordCall(m_pszArgv[3]) ) {
						m_nPos = 100;
						m_nErrorID = SYNTAX_ERROR;							
					}
					else if ( IsStepReg(m_pszArgv[3]) ) {
						if ( IsKeywordIs(m_pszArgv[4]) ) {
							m_nPos = 6;
							isTrue = TRUE;
						}   
						else {
							m_nPos = 5;   							
						}	
						m_nErrorID = SYNTAX_ERROR;							
					}
					else if ( IsPAddr(m_pszArgv[3]) || IsAddrDefault(m_pszArgv[3])) {
						if ( IsKeywordIs(m_pszArgv[4]) ) {
							m_nPos = 6;
							isTrue = TRUE;
						}   
						else {
							m_nPos = 5;   							
						}	
						m_nErrorID = SYNTAX_ERROR;							
					}
					else {
						m_nPos = 4;
						m_nErrorID = SYNTAX_ERROR;							
					}	
				}
				else {
					m_nPos = 2;                                       
					m_nErrorID = SYNTAX_ERROR;											
				}           			
			}
			else if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;       
				m_nErrorID = SYNTAX_ERROR;							
			}                                           
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsKeywordRet(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsKeywordCall(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}   
				else if ( IsStepReg(m_pszArgv[2]) ) {                   
					if ( IsKeywordIs(m_pszArgv[3]) ) {
					    if ( IsRegData(m_pszArgv[2]+1, m_pszArgv[4]) ) {
					    	m_nPos = 100;
					    	isTrue = TRUE;
					    }
					    else {		
					    	m_nPos = 6;
							m_nErrorID = SYNTAX_ERROR;							
						}						    
					}
					else {
						m_nPos = 5;						
						m_nErrorID = SYNTAX_ERROR;				
					}	                                        					
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {         
					if ( IsKeywordIs(m_pszArgv[3]) ) {
					    if ( IsAddrData(m_pszArgv[4]) ) {
					    	m_nPos = 100;
					    	isTrue = TRUE;
					    }
					    else {		
					    	m_nPos = 6;
							m_nErrorID = SYNTAX_ERROR;							
						}						    
					}
					else {
						m_nPos = 5;						
						m_nErrorID = SYNTAX_ERROR;				
					}
				}
				else {
					m_nPos = 4;       
					m_nErrorID = SYNTAX_ERROR;				
				}
			}
			else if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;       
				m_nErrorID = SYNTAX_ERROR;							
			}    
			else if ( IsPAddr(m_pszArgv[1]) || IsAddrDefault(m_pszArgv[1])) {
				if ( IsAddr(m_pszArgv[2]) ) {              
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2],SPACE_P0);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
					m_nPos = 100;                           
				}
				else {
					m_nPos = 3;                 					
				}	
				m_nErrorID = SYNTAX_ERROR;		
			}
			else {
				m_nPos = 1;       
				m_nErrorID = SYNTAX_ERROR;							
			}
            break;                        
        case 6:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsStepCount(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {
					if ( IsAddr(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[2],m_pszArgv[3],SPACE_P0);
			            if (ADR_OK != retCode) {       
			            	m_nErrorID = SYNTAX_ERROR;
			            	m_nPos = 3;
			            	break;
			            }	                              
						m_nPos = 100;                           
					}
					else {						
						m_nPos = 3; 												
					}	
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsKeywordTill(m_pszArgv[2]) ) {
					if ( IsKeywordRet(m_pszArgv[3]) ) {
						m_nPos = 100;
						m_nErrorID = SYNTAX_ERROR;							
					}
					else if ( IsKeywordCall(m_pszArgv[3]) ) {
						m_nPos = 100;
						m_nErrorID = SYNTAX_ERROR;							
					}
					else if ( IsStepReg(m_pszArgv[3]) ) {
						if ( IsKeywordIs(m_pszArgv[4]) ) {
						    if ( IsRegData(m_pszArgv[3]+1, m_pszArgv[5]) ) {
						    	m_nPos = 100;
						    	isTrue = TRUE;
						    }
						    else {		
						    	m_nPos = 6;
								m_nErrorID = SYNTAX_ERROR;							
							}						    
						}   
						else {
							m_nPos = 5;   							
							m_nErrorID = SYNTAX_ERROR;							
						}							
					}
					else if ( IsPAddr(m_pszArgv[3]) || IsAddrDefault(m_pszArgv[3])) {        
						if ( IsKeywordIs(m_pszArgv[4]) ) {
						    if ( IsAddrData(m_pszArgv[5]) ) {
						    	m_nPos = 100;
						    	isTrue = TRUE;
						    }
						    else {		
						    	m_nPos = 6;
								m_nErrorID = SYNTAX_ERROR;							
							}						   
						}
						else {
							m_nPos = 5;   							
							m_nErrorID = SYNTAX_ERROR;							
						}	 
					}
					else {
						m_nPos = 4;
						m_nErrorID = SYNTAX_ERROR;							
					}	
				}
				else {
					m_nPos = 2;                                       
					m_nErrorID = SYNTAX_ERROR;											
				}           			
			}
			else if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;       
				m_nErrorID = SYNTAX_ERROR;							
			}                                           
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsKeywordRet(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}
				else if ( IsKeywordCall(m_pszArgv[2]) ) {
					m_nPos = 100;
					m_nErrorID = SYNTAX_ERROR;							
				}   
				else if ( IsStepReg(m_pszArgv[2]) ) {                   
					if ( IsKeywordIs(m_pszArgv[3]) ) {
					    if ( IsRegData(m_pszArgv[2]+1, m_pszArgv[4]) ) {
					    	m_nPos = 100;
					    }
					    else {		
					    	m_nPos = 6;                                     							
						}	
						m_nErrorID = SYNTAX_ERROR;												    
					}
					else {
						m_nPos = 5;						
						m_nErrorID = SYNTAX_ERROR;				
					}	                                        					
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {         
					if ( IsKeywordIs(m_pszArgv[3]) ) {
					    if ( IsAddrData(m_pszArgv[4]) ) {
					    	m_nPos = 100;
					    }
					    else {		
					    	m_nPos = 6;                                     							
						}																    
					}
					else {
						m_nPos = 5;												
					}	                                        					
					m_nErrorID = SYNTAX_ERROR;				
				}
				else {
					m_nPos = 4;       
					m_nErrorID = SYNTAX_ERROR;				
				}
			}
			else if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;       
				m_nErrorID = SYNTAX_ERROR;							
			}    
			else if ( IsPAddr(m_pszArgv[1]) || IsAddrDefault(m_pszArgv[1])) {
				if ( IsAddr(m_pszArgv[2]) ) {              
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2],SPACE_P0);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
					m_nPos = 100;                           
				}
				else {
					m_nPos = 3;                 					
				}	
				m_nErrorID = SYNTAX_ERROR;		
			}
			else {
				m_nPos = 1;       
				m_nErrorID = SYNTAX_ERROR;							
			}
            break;                        
        default:
			if ( IsKeywordOver(m_pszArgv[1]) ) {
				if ( IsKeywordForever(m_pszArgv[2]) ) {
					m_nPos = 100;					
				}
				else if ( IsStepCount(m_pszArgv[2]) ) {
					m_nPos = 100;					
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {
					if ( IsAddr(m_pszArgv[3]) ) {
			        	retCode = AdrCheck2Addr(m_pszArgv[2],m_pszArgv[3],SPACE_P0);
			            if (ADR_OK != retCode) {       
			            	m_nErrorID = SYNTAX_ERROR;
			            	m_nPos = 3;
			            	break;
			            }	                              
						m_nPos = 100;                           
					}
					else {						
						m_nPos = 3; 												
					}						
				}
				else if ( IsKeywordTill(m_pszArgv[2]) ) {
					if ( IsKeywordRet(m_pszArgv[3]) ) {
						m_nPos = 100;
					}
					else if ( IsKeywordCall(m_pszArgv[3]) ) {
						m_nPos = 100;
					}
					else if ( IsStepReg(m_pszArgv[3]) ) {
						if ( IsKeywordIs(m_pszArgv[4]) ) {
						    if ( IsRegData(m_pszArgv[3]+1, m_pszArgv[5]) ) {
						    	m_nPos = 100;
						    }
						    else {		
						    	m_nPos = 6;
							}						    
						}   
						else {
							m_nPos = 5;   							
						}							
					}
					else if ( IsPAddr(m_pszArgv[3]) || IsAddrDefault(m_pszArgv[3])) {        
						if ( IsKeywordIs(m_pszArgv[4]) ) {
						    if ( IsAddrData(m_pszArgv[5]) ) {
						    	m_nPos = 100;
						    }
						    else {		
						    	m_nPos = 6;
							}						   
						}
						else {
							m_nPos = 5;   							
						}	 
					}
					else {
						m_nPos = 4;
					}	
				}
				else {
					m_nPos = 2;                                       
				}           			
			}
			else if ( IsKeywordForever(m_pszArgv[1]) ) {
				m_nPos = 100;       
			}                                           
			else if ( IsKeywordTill(m_pszArgv[1]) ) {
				if ( IsKeywordRet(m_pszArgv[2]) ) {
					m_nPos = 100;
				}
				else if ( IsKeywordCall(m_pszArgv[2]) ) {
					m_nPos = 100;
				}   
				else if ( IsStepReg(m_pszArgv[2]) ) {                   
					if ( IsKeywordIs(m_pszArgv[3]) ) {
					    if ( IsRegData(m_pszArgv[2]+1, m_pszArgv[4]) ) {
					    	m_nPos = 100;
					    }
					    else {		
					    	m_nPos = 6;                                     							
						}	
					}
					else {
						m_nPos = 5;						
					}	                                        					
				}
				else if ( IsPAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2])) {         
					if ( IsKeywordIs(m_pszArgv[3]) ) {
					    if ( IsAddrData(m_pszArgv[4]) ) {
					    	m_nPos = 100;
					    }
					    else {		
					    	m_nPos = 6;                                     							
						}																    
					}
					else {
						m_nPos = 5;												
					}	                                        					
				}
				else {
					m_nPos = 4;       
				}
			}
			else if ( IsStepCount(m_pszArgv[1]) ) {
				m_nPos = 100;       
			}    
			else if ( IsPAddr(m_pszArgv[1]) || IsAddrDefault(m_pszArgv[1])) {
				if ( IsAddr(m_pszArgv[2]) ) {              
		        	retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2],SPACE_P0);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;
		            	m_nPos = 3;
		            	break;
		            }	                              
					m_nPos = 100;                           
				}
				else {
					m_nPos = 3;                 					
				}	
			}
			else {
				m_nPos = 1;       
			}
            m_nErrorID = SYNTAX_ERROR;
            break;                        
    }
*/
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckStep().


// TEst         adr1 {adr2|Length length}
BOOL CSyntaxCore::SyntaxCheckTest(BOOL isSub)
{
	char szArgv1[260];
	char szArgv2[260];

    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
       
    // Check command syntax.
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;              
        	m_nErrorID = SYNTAX_ERROR;
        	break;
        case 2:   
            if ( IsAddr(m_pszArgv[1]) ) {
            	m_nPos = 2;            	
            	isTrue = TRUE;
            }              
            else {
			    m_nPos = 1;   			    
            }                       
            m_nErrorID = SYNTAX_ERROR;
            break;
        case 3:                       
            if ( IsAddr(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2]) ) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nErrorID = SYNTAX_ERROR;     
		            	m_nPos = 2;
		            }	           
		            else {
			            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet,SPACE_X0)) {
			              	m_nErrorID = nRet;
			            	break;
			            }	
			            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
			              	m_nErrorID = nRet;
			            	break;
			            }	                          						                                         
						NewMem(m_pszArgv[1], strlen(szArgv1)+1);
						NewMem(m_pszArgv[2], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv1);                                  
			            strcpy(m_pszArgv[2],szArgv2); 		            
			            m_nPos = 100;   
			            isTrue = TRUE;              
		            }                			
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
            		m_nPos = 3;
            		isTrue = TRUE;	
            	}            
            	else {         
            		m_nPos = 2;
					m_nErrorID = SYNTAX_ERROR;            	
            	}
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }      
            break;
        case 4:
            if ( IsAddr(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;
		            }	           
		            else {   
						m_nPos = 100;
					}
					m_nErrorID = SYNTAX_ERROR;
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			                m_nErrorID = nRet;                
			            	m_nPos = 3;
			            	break;
			            }                     
			            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet,SPACE_X0)) {
			              	m_nErrorID = nRet;
			              	m_nPos = 3;
			            	break;
			            }
			            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
			            strcpy(m_pszArgv[1],szArgv2);                                  
			            
			            ConvertLen(m_pszArgv[3], szArgv1);
			           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[3],szArgv1);                                  
					
						isTrue = TRUE;	
						m_nPos = 100;
            		}   
            		else {
	            		m_nPos = 3;
	            		m_nErrorID = nRet;                	            		
	            	}	
            	}            
            	else {         
            		m_nPos = 2;
					m_nErrorID = SYNTAX_ERROR;            	
            	}
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }       
            break;
        default:
            if ( IsAddr(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;		            	
		            }	           
		            else {   
						m_nPos = 100;
					}
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			            	m_nPos = 3;
			            }                     
						m_nPos = 100;
            		}   
            		else {
	            		m_nErrorID = nRet;                	            		
	            	}	
            	}            
            	else {         
            		m_nPos = 2;
            	}
            }
            else {
            	m_nPos = 1;                       	
            }   
            m_nErrorID = SYNTAX_ERROR;    
            break;
    }
        
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckTest().
                            
                            
//TRAce       [On|OFf|Clear]         
BOOL CSyntaxCore::SyntaxCheckTrace(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	         
	BOOL isTrue = FALSE;         
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
	    case 1:     
        	m_nPos = 1;   
        	isTrue = TRUE;              	    	   
            break; 
        case 2:
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ||
        		 IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;	 
        	}	 	          
        	else {
        		m_nPos = 1;     
        		m_nErrorID = SYNTAX_ERROR;   		
        	}              
        	break;
        default:
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ||
        		 IsKeywordClear(m_pszArgv[1]) ) {
        		m_nPos = 100;
        	}	 	          
        	else {
        		m_nPos = 1;        		
        	}               
        	m_nErrorID = SYNTAX_ERROR;
        	break;	        
	}
    return isTrue;
}	                              

//Trigger     [[Run] {LV1 | LV2 | LV1 Then LV2}
//            [Forward|Backward|Center|Delay count]] |
//            [On|OFf]
BOOL CSyntaxCore::SyntaxCheckTrigger(BOOL isSub)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	                    
	BOOL isTrue = FALSE;	                    
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    // Check command syntax.
    switch ( nCount ) {
	    case 1:       
	    	m_nPos = 1;
	    	isTrue = TRUE; 
            break;   
        case 2:   
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		isTrue = TRUE;	 
        	}	              
        	else if ( IsKeywordRun(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;
        		m_nErrorID = SYNTAX_ERROR;
        	}                
        	else if ( IsKeywordLv1(m_pszArgv[1]) ) {
        		m_nPos = 3;
        		isTrue = TRUE;        		
        	}                    
        	else if ( IsKeywordLv2(m_pszArgv[1]) ) {
        		m_nPos = 6;
        		isTrue = TRUE;        		
        	}                             
        	else {                        
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	break;    
        case 3:   
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;
        	}	              
        	else if ( IsKeywordRun(m_pszArgv[1]) ) {
	         	if ( IsKeywordLv1(m_pszArgv[2]) ) {
	        		m_nPos = 3;
	        		isTrue = TRUE;	        		
	        	}                    
	        	else if ( IsKeywordLv2(m_pszArgv[2]) ) {
	        		m_nPos = 6;
	        		isTrue = TRUE;	        		
	        	}                             
        		else {
	        		m_nPos = 2;	        		
	        		m_nErrorID = SYNTAX_ERROR;
	        	}	
        	}                
        	else if ( IsKeywordLv1(m_pszArgv[1]) ) {
        		if ( IsKeywordThen(m_pszArgv[2]) ) {
        			m_nPos = 5;
        			isTrue = TRUE;
        			m_nErrorID = SYNTAX_ERROR;	
        		}        
        		else if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			isTrue = TRUE;
        		}    
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			m_nPos = 4;
        			isTrue = TRUE;
        			m_nErrorID = SYNTAX_ERROR;
        		}           
        		else {
	        		m_nPos = 3;	        	
	        		m_nErrorID = SYNTAX_ERROR;	
	        	}	
        	}                    
        	else if ( IsKeywordLv2(m_pszArgv[1]) ) {
        		if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			isTrue = TRUE;
        		}                 
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			m_nPos = 4;
        			isTrue = TRUE;
        			m_nErrorID = SYNTAX_ERROR;
        		}                             
        		else {
	        		m_nPos = 6;	        	
	        		m_nErrorID = SYNTAX_ERROR;
	        	}	
        	}                             
        	else {                        
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	break;    
        case 4:   
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;
        	}	              
        	else if ( IsKeywordRun(m_pszArgv[1]) ) {
	         	if ( IsKeywordLv1(m_pszArgv[2]) ) {
	        		if ( IsKeywordThen(m_pszArgv[3]) ) {
	        			m_nPos = 5;
	        			isTrue = TRUE;
	        			m_nErrorID = SYNTAX_ERROR;
	        		}                             
	        		else if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        			isTrue = TRUE;
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			m_nPos = 4;
	        			isTrue = TRUE;
	        			m_nErrorID = SYNTAX_ERROR;
	        		}           
	        		else {
		        		m_nPos = 3;
		        		m_nErrorID = SYNTAX_ERROR;
		        	}	
	        	}                    
	        	else if ( IsKeywordLv2(m_pszArgv[2]) ) {
	        		if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        			isTrue = TRUE;
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			m_nPos = 4;
	        			isTrue = TRUE;
	        			m_nErrorID = SYNTAX_ERROR;
	        		}
	        		else {	        	
		        		m_nPos = 6;
		        		m_nErrorID = SYNTAX_ERROR;
		        	}	
	        	}	        	
        		else {
	        		m_nPos = 2;	        		
	        		m_nErrorID = SYNTAX_ERROR;
	        	}	
        	}                
        	else if ( IsKeywordLv1(m_pszArgv[1]) ) {
        		if ( IsKeywordThen(m_pszArgv[2]) ) {
        			if ( IsKeywordLv2(m_pszArgv[3]) ) {
        				m_nPos = 6;
        				isTrue = TRUE;
        			}                 
        			else {
	        			m_nPos = 5;	        			
	        			m_nErrorID = SYNTAX_ERROR;	
        			}
        		}        
        		else if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			m_nErrorID = SYNTAX_ERROR;	
        		}    
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        				isTrue = TRUE;
        			}                 
        			else {
	        			m_nPos = 4;
	        			m_nErrorID = SYNTAX_ERROR;
	        		}	
        		}           
        		else {
	        		m_nPos = 3;	        	
	        		m_nErrorID = SYNTAX_ERROR;	
	        	}	
        	}                    
        	else if ( IsKeywordLv2(m_pszArgv[1]) ) {
        		if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;               
        			m_nErrorID = SYNTAX_ERROR;	
        		}                 
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        				isTrue = TRUE;
        			}                 
        			else {
	        			m_nPos = 4;
	        			m_nErrorID = SYNTAX_ERROR;
	        		}	
        		}                             
        		else {
	        		m_nPos = 6;	        	
	        		m_nErrorID = SYNTAX_ERROR;
	        	}	
        	}                             
        	else {                        
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	break;    
        case 5:   
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;
        	}	              
        	else if ( IsKeywordRun(m_pszArgv[1]) ) {
	         	if ( IsKeywordLv1(m_pszArgv[2]) ) {
	        		if ( IsKeywordThen(m_pszArgv[3]) ) {
	        			if ( IsKeywordLv2(m_pszArgv[4]) ) {
	        				m_nPos = 6;
	        				isTrue = TRUE;
	        			}                 
	        			else {
		        			m_nPos = 5;	        			
		        			m_nErrorID = SYNTAX_ERROR;
		        		}	
	        		}                             
	        		else if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        			m_nErrorID = SYNTAX_ERROR;
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			if ( IsDelayCount(m_pszArgv[4]) ) { 
	        				m_nPos = 100;
	        				isTrue = TRUE;
	        			}
	        			else {	
		        			m_nPos = 4;
		        			m_nErrorID = SYNTAX_ERROR;
		        		}	
	        		}           
	        		else {
		        		m_nPos = 3;
		        		m_nErrorID = SYNTAX_ERROR;
		        	}	
	        	}                    
	        	else if ( IsKeywordLv2(m_pszArgv[2]) ) {
	        		if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;      
	        			m_nErrorID = SYNTAX_ERROR;
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			if ( IsDelayCount(m_pszArgv[4]) ) { 
	        				m_nPos = 100;
	        				isTrue = TRUE;
	        			}
	        			else {	
		        			m_nPos = 4;
		        			m_nErrorID = SYNTAX_ERROR;
		        		}	
	        		}
	        		else {	        	
		        		m_nPos = 6;
		        		m_nErrorID = SYNTAX_ERROR;
		        	}	
	        	}	        	
        		else {
	        		m_nPos = 2;	        		
	        		m_nErrorID = SYNTAX_ERROR;
	        	}	
        	}                
        	else if ( IsKeywordLv1(m_pszArgv[1]) ) {
        		if ( IsKeywordThen(m_pszArgv[2]) ) {
        			if ( IsKeywordLv2(m_pszArgv[3]) ) {
        				if ( IsKeywordForBackCen(m_pszArgv[4]) ) {
        					m_nPos = 100;
        					isTrue = TRUE;
        				}                        
        				else if ( IsKeywordDelay(m_pszArgv[4]) ) {
        					m_nPos = 4;
        					isTrue = TRUE;            
        					m_nErrorID = SYNTAX_ERROR;
        				}
        				else {
	        				m_nPos = 6;
	        				m_nErrorID = SYNTAX_ERROR;
	        			}	
        			}                 
        			else {
	        			m_nPos = 5;	        			
	        			m_nErrorID = SYNTAX_ERROR;	
        			}
        		}        
        		else if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			m_nErrorID = SYNTAX_ERROR;	
        		}    
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        			}                 
        			else {
	        			m_nPos = 4;
	        		}	
	        		m_nErrorID = SYNTAX_ERROR;	        			
        		}           
        		else {
	        		m_nPos = 3;	        	
	        		m_nErrorID = SYNTAX_ERROR;	
	        	}	
        	}                    
        	else if ( IsKeywordLv2(m_pszArgv[1]) ) {    
        		m_nErrorID = SYNTAX_ERROR;
        		if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;            				
        		}                 
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        			}                 
        			else {
	        			m_nPos = 4;	        			
	        		}	
        		}                             
        		else {
	        		m_nPos = 6;	        	
	        	}	
        	}                             
        	else {                        
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	break;    
        case 6:   
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;
        	}	              
        	else if ( IsKeywordRun(m_pszArgv[1]) ) {
	         	if ( IsKeywordLv1(m_pszArgv[2]) ) {
	        		if ( IsKeywordThen(m_pszArgv[3]) ) {
	        			if ( IsKeywordLv2(m_pszArgv[4]) ) {
	        				if ( IsKeywordForBackCen(m_pszArgv[5]) ) {
	        					m_nPos = 100;
	        					isTrue = TRUE;
	        				}                 
	        				else if ( IsKeywordDelay(m_pszArgv[5]) ) {
	        					m_nPos = 4;
	        					isTrue = TRUE;
	        					m_nErrorID = SYNTAX_ERROR;	
	        				}
	        				else {
		        				m_nPos = 6;
		        				m_nErrorID = SYNTAX_ERROR;
		        			}	
	        			}                 
	        			else {
		        			m_nPos = 5;	        			
		        			m_nErrorID = SYNTAX_ERROR;
		        		}	
	        		}                             
	        		else if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        			m_nErrorID = SYNTAX_ERROR;
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			if ( IsDelayCount(m_pszArgv[4]) ) { 
	        				m_nPos = 100;
	        			}
	        			else {	
		        			m_nPos = 4;               
		        		}	
		        		m_nErrorID = SYNTAX_ERROR;		        			
	        		}           
	        		else {
		        		m_nPos = 3;
		        		m_nErrorID = SYNTAX_ERROR;
		        	}	
	        	}                    
	        	else if ( IsKeywordLv2(m_pszArgv[2]) ) {
	        		if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;      
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			if ( IsDelayCount(m_pszArgv[4]) ) { 
	        				m_nPos = 100;	        				
	        			}
	        			else {	
		        			m_nPos = 4;
		        		}	
	        		}
	        		else {	        	
		        		m_nPos = 6;     
		        	}	
		        	m_nErrorID = SYNTAX_ERROR;		        		
	        	}	        	
        		else {
	        		m_nPos = 2;	        		
	        		m_nErrorID = SYNTAX_ERROR;
	        	}	
        	}                
        	else if ( IsKeywordLv1(m_pszArgv[1]) ) {
        		if ( IsKeywordThen(m_pszArgv[2]) ) {
        			if ( IsKeywordLv2(m_pszArgv[3]) ) {
        				if ( IsKeywordForBackCen(m_pszArgv[4]) ) {
        					m_nPos = 100;
		        			m_nErrorID = SYNTAX_ERROR;
        				}                           
        				else if ( IsKeywordDelay(m_pszArgv[4]) ) {
        					if ( IsDelayCount(m_pszArgv[5]) ) {
        						m_nPos = 100;
        						isTrue = TRUE;
        					}                 
        					else {
        						m_nPos  = 4;
        						m_nErrorID = SYNTAX_ERROR;
        					}
        				}
        				else {
	        				m_nPos = 6;
	        				m_nErrorID = SYNTAX_ERROR;
	        			}	
        			}                 
        			else {
	        			m_nPos = 5;	        			
	        			m_nErrorID = SYNTAX_ERROR;	
        			}
        		}        
        		else if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			m_nErrorID = SYNTAX_ERROR;	
        		}    
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        			}                 
        			else {
	        			m_nPos = 4;
	        		}	
	        		m_nErrorID = SYNTAX_ERROR;	        			
        		}           
        		else {
	        		m_nPos = 3;	        	
	        		m_nErrorID = SYNTAX_ERROR;	
	        	}	
        	}                    
        	else if ( IsKeywordLv2(m_pszArgv[1]) ) {    
        		m_nErrorID = SYNTAX_ERROR;
        		if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;            				
        		}                 
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        			}                 
        			else {
	        			m_nPos = 4;	        			
	        		}	
        		}                             
        		else {
	        		m_nPos = 6;	        	
	        	}	
        	}                             
        	else {                        
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	break;    
        case 7:   
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ) {
        		m_nPos = 100;
        		m_nErrorID = SYNTAX_ERROR;
        	}	              
        	else if ( IsKeywordRun(m_pszArgv[1]) ) {
	         	if ( IsKeywordLv1(m_pszArgv[2]) ) {
	        		if ( IsKeywordThen(m_pszArgv[3]) ) {
	        			if ( IsKeywordLv2(m_pszArgv[4]) ) {
	        				if ( IsKeywordForBackCen(m_pszArgv[5]) ) {
	        					m_nPos = 100;       
	        					m_nErrorID = SYNTAX_ERROR;
	        				}                 
	        				else if ( IsKeywordDelay(m_pszArgv[5]) ) {
	        					if ( IsDelayCount(m_pszArgv[6]) ) {
	        						m_nPos = 100;
	        						isTrue = TRUE;
	        					}                 
	        					else {
		        					m_nPos = 4;	        					
		        					m_nErrorID = SYNTAX_ERROR;	
		        				}	
	        				}
	        				else {
		        				m_nPos = 6;
		        				m_nErrorID = SYNTAX_ERROR;
		        			}	
	        			}                 
	        			else {
		        			m_nPos = 5;	        			
		        			m_nErrorID = SYNTAX_ERROR;
		        		}	
	        		}                             
	        		else if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        			m_nErrorID = SYNTAX_ERROR;
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			if ( IsDelayCount(m_pszArgv[4]) ) { 
	        				m_nPos = 100;
	        			}
	        			else {	
		        			m_nPos = 4;               
		        		}	
		        		m_nErrorID = SYNTAX_ERROR;		        			
	        		}           
	        		else {
		        		m_nPos = 3;
		        		m_nErrorID = SYNTAX_ERROR;
		        	}	
	        	}                    
	        	else if ( IsKeywordLv2(m_pszArgv[2]) ) {
	        		if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;      
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			if ( IsDelayCount(m_pszArgv[4]) ) { 
	        				m_nPos = 100;	        				
	        			}
	        			else {	
		        			m_nPos = 4;
		        		}	
	        		}
	        		else {	        	
		        		m_nPos = 6;     
		        	}	
		        	m_nErrorID = SYNTAX_ERROR;		        		
	        	}	        	
        		else {
	        		m_nPos = 2;	        		
	        		m_nErrorID = SYNTAX_ERROR;
	        	}	
        	}                
        	else if ( IsKeywordLv1(m_pszArgv[1]) ) {
        		if ( IsKeywordThen(m_pszArgv[2]) ) {
        			if ( IsKeywordLv2(m_pszArgv[3]) ) {
        				if ( IsKeywordForBackCen(m_pszArgv[4]) ) {
        					m_nPos = 100;
		        			m_nErrorID = SYNTAX_ERROR;
        				}                           
        				else if ( IsKeywordDelay(m_pszArgv[4]) ) {
        					if ( IsDelayCount(m_pszArgv[5]) ) {
        						m_nPos = 100;        						
        					}                 
        					else {
        						m_nPos  = 4; 
        					}	
        					m_nErrorID = SYNTAX_ERROR;        					
        				}
        				else {
	        				m_nPos = 6;
	        				m_nErrorID = SYNTAX_ERROR;
	        			}	
        			}                 
        			else {
	        			m_nPos = 5;	        			
	        			m_nErrorID = SYNTAX_ERROR;	
        			}
        		}        
        		else if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;
        			m_nErrorID = SYNTAX_ERROR;	
        		}    
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        			}                 
        			else {
	        			m_nPos = 4;
	        		}	
	        		m_nErrorID = SYNTAX_ERROR;	        			
        		}           
        		else {
	        		m_nPos = 3;	        	
	        		m_nErrorID = SYNTAX_ERROR;	
	        	}	
        	}                    
        	else if ( IsKeywordLv2(m_pszArgv[1]) ) {    
        		m_nErrorID = SYNTAX_ERROR;
        		if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;            				
        		}                 
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        			}                 
        			else {
	        			m_nPos = 4;	        			
	        		}	
        		}                             
        		else {
	        		m_nPos = 6;	        	
	        	}	
        	}                             
        	else {                        
        		m_nPos = 1;
        		m_nErrorID = SYNTAX_ERROR;
        	}
        	break;    
        default:
        	m_nErrorID = SYNTAX_ERROR;   
        	if ( IsKeywordOn(m_pszArgv[1]) ||
        		 IsKeywordOff(m_pszArgv[1]) ) {
        		m_nPos = 100;                 		
        	}	              
        	else if ( IsKeywordRun(m_pszArgv[1]) ) {
	         	if ( IsKeywordLv1(m_pszArgv[2]) ) {
	        		if ( IsKeywordThen(m_pszArgv[3]) ) {
	        			if ( IsKeywordLv2(m_pszArgv[4]) ) {
	        				if ( IsKeywordForBackCen(m_pszArgv[5]) ) {
	        					m_nPos = 100;       
	        				}                 
	        				else if ( IsKeywordDelay(m_pszArgv[5]) ) {
	        					if ( IsDelayCount(m_pszArgv[6]) ) {
	        						m_nPos = 100;
	        					}                 
	        					else {
		        					m_nPos = 4;	        					
		        				}	
	        				}
	        				else {
		        				m_nPos = 6;
		        			}	
	        			}                 
	        			else {
		        			m_nPos = 5;	        			
		        		}	
	        		}                             
	        		else if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			if ( IsDelayCount(m_pszArgv[4]) ) { 
	        				m_nPos = 100;
	        			}
	        			else {	
		        			m_nPos = 4;               
		        		}	
	        		}           
	        		else {
		        		m_nPos = 3;
		        	}	
	        	}                    
	        	else if ( IsKeywordLv2(m_pszArgv[2]) ) {
	        		if ( IsKeywordForBackCen(m_pszArgv[3]) ) {
	        			m_nPos = 100;      
	        		}                 
	        		else if ( IsKeywordDelay(m_pszArgv[3]) ) {
	        			if ( IsDelayCount(m_pszArgv[4]) ) { 
	        				m_nPos = 100;	        				
	        			}
	        			else {	
		        			m_nPos = 4;
		        		}	
	        		}
	        		else {	        	
		        		m_nPos = 6;     
		        	}	
	        	}	        	
        		else {
	        		m_nPos = 2;	        		
	        	}	
        	}                
        	else if ( IsKeywordLv1(m_pszArgv[1]) ) {
        		if ( IsKeywordThen(m_pszArgv[2]) ) {
        			if ( IsKeywordLv2(m_pszArgv[3]) ) {
        				if ( IsKeywordForBackCen(m_pszArgv[4]) ) {
        					m_nPos = 100;
        				}                           
        				else if ( IsKeywordDelay(m_pszArgv[4]) ) {
        					if ( IsDelayCount(m_pszArgv[5]) ) {
        						m_nPos = 100;        						
        					}                 
        					else {
        						m_nPos  = 4; 
        					}	
        				}
        				else {
	        				m_nPos = 6;
	        			}	
        			}                 
        			else {
	        			m_nPos = 5;	        			
        			}
        		}        
        		else if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;
        		}    
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        			}                 
        			else {
	        			m_nPos = 4;
	        		}	
	        		m_nErrorID = SYNTAX_ERROR;	        			
        		}           
        		else {
	        		m_nPos = 3;	        	
	        		m_nErrorID = SYNTAX_ERROR;	
	        	}	
        	}                    
        	else if ( IsKeywordLv2(m_pszArgv[1]) ) {    
        		m_nErrorID = SYNTAX_ERROR;
        		if ( IsKeywordForBackCen(m_pszArgv[2]) ) {
        			m_nPos = 100;            				
        		}                 
        		else if ( IsKeywordDelay(m_pszArgv[2]) ) {
        			if ( IsDelayCount(m_pszArgv[3]) ) {
        				m_nPos = 100;
        			}                 
        			else {
	        			m_nPos = 4;	        			
	        		}	
        		}                             
        		else {
	        		m_nPos = 6;	        	
	        	}	
        	}                             
        	else {                        
        		m_nPos = 1;
        	}
        	break;    
	}
    return isTrue;
}	                              

                                             
// Upload       adr1 {adr2|Length length} filename
BOOL CSyntaxCore::SyntaxCheckUpload(BOOL isSub)
{
	char szArgv1[260];
	char szArgv2[260];

    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
                                              
    // Check command syntax.
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	

    switch ( nCount ) {
        case 1:
        	m_nPos = 1;   
        	isTrue = TRUE;              
        	m_nErrorID = SYNTAX_ERROR;
        	break;
        case 2:   
            if ( IsAddrPX(m_pszArgv[1]) ){
            	m_nPos = 2;            	
            	isTrue = TRUE;
            }              
            else {
			    m_nPos = 1;   			    
            }                       
            m_nErrorID = SYNTAX_ERROR;
            break;
        case 3:                       
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2]) || IsAddrDefault(m_pszArgv[2]) ) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       		            	
		            	m_nPos = 2;
		            }	           
		            else {
		            	m_nPos = 4;
		            	isTrue = TRUE;
		            }                			
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
            		m_nPos = 3;
            		isTrue = TRUE;	
            	}            
            	else {         
            		m_nPos = 2;
            	}
            }
            else {
            	m_nPos = 1;
            }           
			m_nErrorID = SYNTAX_ERROR;            
            break;
        case 4:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;
		            }	           
		            else {    
			            if ( !IsFilename(m_pszArgv[3], nRet) ) {
			                m_nErrorID = nRet;
			                m_nPos = 4;
			            }         
                        else {
				            ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_P0);
				            ConvertAddress(m_pszArgv[2], szArgv2, nRet);
							NewMem(m_pszArgv[1], strlen(szArgv1)+1);
							NewMem(m_pszArgv[2], strlen(szArgv2)+1);
				            strcpy(m_pszArgv[1],szArgv1);                                  
				            strcpy(m_pszArgv[2],szArgv2); 		            
				            isTrue = TRUE;
				            m_nPos = 100;
				        }    
		            }					
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {			                
			            	m_nPos = 3;
			            }         
			            else {
							m_nPos = 4;  
							isTrue = TRUE;
						}	
            		}   
            		else {
	            		m_nPos = 3;	            		
	            	}	
            	}            
            	else {         
            		m_nPos = 2;                         					
            	}             	
            }
            else {
            	m_nPos = 1;
            	m_nErrorID = SYNTAX_ERROR;
            }       
            break;
        case 5:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;		            	
		            }	           
		            else {   
		            	if ( !IsFilename(m_pszArgv[3], nRet) ) {			                
			                m_nPos = 4;
			            }         
						m_nPos = 100;
					}             
					m_nErrorID = SYNTAX_ERROR;
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			            	m_nPos = 3;
			            	m_nErrorID = nRet;
			            	break;
			            }                     
                        if ( IsFilename(m_pszArgv[4], nRet) ) {			                
				            ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_P0);
				            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
				            strcpy(m_pszArgv[1],szArgv2);                                  
				            
				            ConvertLen(m_pszArgv[3], szArgv1);
				           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
				            strcpy(m_pszArgv[3],szArgv1);                                  
						
							isTrue = TRUE;	
							m_nPos = 100;
						}
						else {
							m_nErrorID = nRet;
							m_nPos = 4;
						}	
            		}   
            		else {
	            		m_nErrorID = nRet;                	            		
	            		m_nPos = 3;
	            	}	
            	}            
            	else {         
            		m_nPos = 2;               
            		m_nErrorID = SYNTAX_ERROR;
            	}
            }
            else {
            	m_nPos = 1;                   
            	m_nErrorID = SYNTAX_ERROR;    	
            }   
            break;
        default:
            if ( IsAddrPX(m_pszArgv[1]) ) {
            	if ( IsAddr(m_pszArgv[2])  || IsAddrDefault(m_pszArgv[2])) {
            		retCode = AdrCheck2Addr(m_pszArgv[1],m_pszArgv[2]);
		            if (ADR_OK != retCode) {       
		            	m_nPos = 2;		            	
		            }	           
		            else {   
		            	if ( !IsFilename(m_pszArgv[3], nRet) ) {			                
			                m_nPos = 4;
			            }         
						m_nPos = 100;
					}             
					m_nErrorID = SYNTAX_ERROR;
            	}
            	else if ( IsKeywordLength(m_pszArgv[2])) {
   		            if ( IsAddrLen(m_pszArgv[3], nRet) ) {
			            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
			            	m_nPos = 3;
			            	m_nErrorID = nRet;
			            	break;
			            }                     
                        if ( IsFilename(m_pszArgv[4], nRet) ) {			                
							m_nPos = 100;
						}
						else {
							m_nPos = 4;
						}	
            		}   
            		else {
            			m_nPos = 3;
	            		m_nErrorID = nRet;                	            		
	            	}	
            	}            
            	else {         
            		m_nPos = 2;               
            	}
            }
            else {
            	m_nPos = 1;                             	
            }   
            m_nErrorID = SYNTAX_ERROR;    	
            break;                          
    }

	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckUpload().


// Verify       [ON|OFf]
BOOL CSyntaxCore::SyntaxCheckVerify(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
        case 1:
        	m_nPos = 1;
			isTrue = TRUE;        	
            break;
        case 2:
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                m_nPos = 1;
            }              
            else {
            	m_nPos = 100;       
            	isTrue = TRUE;        	
            }	                                    
            break;
        default:
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 1;
            }              
            else {
            	m_nPos = 100;                   	    	
            }	                                    
            m_nErrorID = SYNTAX_ERROR;
            break;
    }             
    
	return isTrue;
}   // End of CSyntaxCore::SyntaxCheckVerify().


// Word         adr data1 [.. data16]
BOOL CSyntaxCore::SyntaxCheckWord(BOOL isSub)
{
	char szArgv[260];

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	     
    
    int nArgc;
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
		case 2:                       
			if ( IsAddr(m_pszArgv[1]) ) {
				m_nPos = 2;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
			}
			m_nErrorID = SYNTAX_ERROR;			
			break;
        default:
		    nArgc = 2;
		    
			if ( IsAddr(m_pszArgv[1]) ) {           
			    if ( !PreStringData(nArgc, 4) ) { 
			    	m_nErrorID = SYNTAX_ERROR;
			        m_nPos = 2;
			        break;
			    }            
				ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_X0);				
/*
	            if (IsBAddr(szArgv)) {
	            	if( !IsDataBit(m_pszArgv[2])) {
	            		m_nErrorID = SYNTAX_ERROR;
	            		m_nPos = 2;
	                	break;
	            	}                 
	            }	
	            else */
	            if ( !IsDataWord(m_pszArgv[2]) ) {
	                m_nErrorID = SYNTAX_ERROR;
	                m_nPos = 2;
	                break;
	            }
	            NewMem(m_pszArgv[1], strlen(szArgv)+1);
	            strcpy(m_pszArgv[1],szArgv);
	            if ( !IsDataRange(m_nArgc, m_pszArgv, 2) ) {
	                m_nErrorID = SYNTAX_ERROR;
	                m_nPos = 2;
	                break;
	            }    
				m_nPos = 3;
				isTrue = TRUE;			            			
			}                                   
			else {
				m_nPos = 1;	
				m_nErrorID = SYNTAX_ERROR;			
			}                                       			
			break;
	}		
                                            
    return isTrue;
}   // End of CSyntaxCore::SyntaxCheckWord().


// CReate       #symbol adr
BOOL CSyntaxCore::SyntaxCheckCreate(BOOL isSub)
{
	char szArgv1[260];

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );

    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:                
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;
        case 2:   
        	if ( IsVariableName(m_pszArgv[1]) ) {
        		m_nPos = 2;
        		isTrue = TRUE;        		
        	}
        	else {
        	    m_nPos = 1;
        	}                         
        	m_nErrorID = SYNTAX_ERROR;
        	break;
        case 3:
            if ( IsVariableName(m_pszArgv[1]) ) {
                if ( IsAddr(m_pszArgv[2]) ) {
                    ConvertAddress(m_pszArgv[2], szArgv1, nRet, SPACE_P0);
		            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[2],szArgv1);                                  
                	m_nPos = 100;
                	isTrue = TRUE;
                }
                else {
                    m_nPos = 2;           
                    m_nErrorID = SYNTAX_ERROR;
                }                
            }
            else {                        
            	m_nPos = 1;
                m_nErrorID = SYNTAX_ERROR;                
            }   
            break;
        default:
            if ( IsVariableName(m_pszArgv[1]) ) {
                if ( IsAddr(m_pszArgv[2]) ) {
                    ConvertAddress(m_pszArgv[2], szArgv1, nRet, SPACE_P0);
		            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[2],szArgv1);                                  
                	m_nPos = 100;
                }
                else {
                    m_nPos = 2;           
                }                
            }
            else {                        
            	m_nPos = 1;
            }   
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
    return isTrue;
   // End of CSyntaxCore::SyntaxCheckCreate().
}

// DElete       #symbol | $variable | All 
BOOL CSyntaxCore::SyntaxCheckDelete(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }                              
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;            
        case 2:
			if ( IsVariableName(m_pszArgv[1]) || 
            	 IsMacroVarName(m_pszArgv[1]) || 	
                 IsKeywordAll(m_pszArgv[1]) ) { 
            	m_nPos = 2;
            	isTrue = TRUE;
            }	  
            else {
            	m_nPos = 1;           
            	m_nErrorID = SYNTAX_ERROR;
            }   
            break;
        default:
			if ( IsVariableName(m_pszArgv[1]) || 
            	 IsMacroVarName(m_pszArgv[1]) || 	
                 IsKeywordAll(m_pszArgv[1]) ) { 
            	m_nPos = 2;
            }	  
            else {
            	m_nPos = 1;                       	
            }   
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return isTrue;    
}   // End of CSyntaxCore::SyntaxCheckDelete().


// LOAd         filename 
//              [Symbols|NOSymbols] 
//              [Code|NOCode]
//              [Warn|NOWarn] 
//				[SYStem|NOSYStem]
//				[P0|P1|P2|P3|X0|X1]
BOOL CSyntaxCore::SyntaxCheckLoad(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
	BOOL isError = TRUE;
	int nOption = 0; //bit0 - symbols=1 , nosymbols=0;
					 //bit1 - Code 
					 //bit2 - System
					 //bit3 - Warn					 
					 //bit4 - P0:,...
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;            
        case 2:
            if ( IsFilename(m_pszArgv[1], nRet) ) {
            	m_nPos = 2;
            	isTrue = TRUE;    
            }
            else { 
            	m_nPos = 1;    
                m_nErrorID = nRet;
            }
            break;
		default:  
            if ( IsFilename(m_pszArgv[1], nRet) ) {      
        	    for ( int i = 2; i < nCount; i++) {
            		if ( IsKeywordSymbols(m_pszArgv[i]) ||
            		     IsKeywordNosymbols(m_pszArgv[i]) ) {   
            		    if ( (nOption & 1) == 1 ) {
            				isError = FALSE;
            			}                   
            			else {
            				nOption |= 1;
            			}	
            		}         
            		else if ( IsKeywordCode(m_pszArgv[i]) ||
            		     IsKeywordNocode(m_pszArgv[i]) ) {
            		    if ( (nOption & 2) == 2 ) {
            				isError = FALSE;
            			}                   
            			else {
            				nOption |= 2;
            			}	                   
            		}         
            		else if ( IsKeywordSystem(m_pszArgv[i]) ||
            		     IsKeywordNosystem(m_pszArgv[i]) ) {
            		    if ( (nOption & 4) == 4 ) {
            				isError = FALSE;
            			}                   
            			else {
            				nOption |= 4;
            			}	            
            		}         
            		else if ( IsKeywordWarn(m_pszArgv[i]) ||
            		     IsKeywordNowarn(m_pszArgv[i]) ) {
            		    if ( (nOption & 8) == 8 ) {
            				isError = FALSE;
            			}                   
            			else {
            				nOption |= 8;
            			}	                   
            		}            		          
            		else if ( IsLoadBank(m_pszArgv[i]) ) {
            		    if ( (nOption & 16) == 16 ) {
            				isError = FALSE;
            			}                   
            			else {
            				nOption |= 16;
            			}	             
            		}   
            		else {
            			isError = FALSE;
            		}    
        		}               
        		if ( isError ) {
        			isTrue = TRUE;
					m_nPos = nOption + 2;					
        		}       
        		else {
        			m_nErrorID = SYNTAX_ERROR;
        			m_nPos = nOption + 2;
        		}          		            
            }                         			
           	else {
           		m_nPos = 1;                                 			                                      
           	}	
			break;        			            
    }
                              
	return isTrue;                              
}   // End of CSyntaxCore::SyntaxCheckLoad().


// QUEry        #symbol | #module#line_no | hex_adr
BOOL CSyntaxCore::SyntaxCheckQuery(BOOL isSub)
{

   // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {                                
		case 1:
			m_nPos = 1;       
			isTrue = TRUE;			            						
			m_nErrorID = SYNTAX_ERROR;			
			break;
        case 2:
            if ( !IsSymbolName(m_pszArgv[1]) &&
                 !IsAddr(m_pszArgv[1])  ) {
                m_nPos = 1; 
                m_nErrorID = SYNTAX_ERROR;
            }              
            else {
                m_nPos = 100;
                isTrue = TRUE;
            }            	
            break;
        default:
            if ( !IsSymbolName(m_pszArgv[1]) &&
                 !IsAddr(m_pszArgv[1])  ) {
                m_nPos = 1; 
            }              
            else {
                m_nPos = 100;
            }            	
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
    return isTrue;
}   // End of CSyntaxCore::SyntaxCheckQuery().


// SSave        filename
BOOL CSyntaxCore::SyntaxCheckSsave(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;            
        case 2:
			if ( IsFilename(m_pszArgv[1], nRet )) {                
        		m_nPos = 100;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 1;       
        		m_nErrorID = nRet;
        	}		
            break;
        default:
			if ( IsFilename(m_pszArgv[1], nRet )) {                
        		m_nPos = 100;
        	}
        	else {
        		m_nPos = 1;
        	}		
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	
	return isTrue;    
	
}   // End of CSyntaxCore::SyntaxCheckSsave().


// SRecall      filename
BOOL CSyntaxCore::SyntaxCheckSrecall(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
            m_nErrorID = SYNTAX_ERROR;
        	break;            
        case 2:
			if ( IsFilename(m_pszArgv[1], nRet )) {                
        		m_nPos = 100;
        		isTrue = TRUE;
        	}
        	else {
        		m_nPos = 1;       
                m_nErrorID = nRet;        		
        	}		
            break;
        default:
			if ( IsFilename(m_pszArgv[1], nRet )) {                
        		m_nPos = 100;
        	}
        	else {
        		m_nPos = 1;
        	}		
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	
	return isTrue;    
	    
}   // End of CSyntaxCore::SyntaxCheckSrecall().


// SYmbol       [ Global | Module | Lines | #module ]
BOOL CSyntaxCore::SyntaxCheckSymbol(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
        	break;            
        case 2:                               
            if ( IsKeywordGlobal(m_pszArgv[1]) ||
                 IsKeywordModule(m_pszArgv[1]) ||
                 IsKeywordLines(m_pszArgv[1]) ||
                 IsVariableName(m_pszArgv[1]) ) {
				m_nPos = 100;
				isTrue = TRUE;
			}
			else {
				m_nPos = 1;
                m_nErrorID = SYNTAX_ERROR;
   			}		        
            break;
        default:
            if ( IsKeywordGlobal(m_pszArgv[1]) ||
                 IsKeywordModule(m_pszArgv[1]) ||
                 IsKeywordLines(m_pszArgv[1]) ||
                 IsVariableName(m_pszArgv[1]) ) {
				m_nPos = 100;
			}
			else {
				m_nPos = 1;
			}		        
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	return isTrue;    
}   // End of CSyntaxCore::SyntaxCheckSymbol().

BOOL CSyntaxCore::SyntaxCheckWatch(BOOL isSub)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    BOOL isTrue = FALSE;                     
    int nCount;
    if ( isSub) {
    	nCount = m_nToken;
    }
    else {
    	nCount = m_nArgc;
    }	
    
    // Check command syntax.
    switch ( nCount ) {
        case 1:
        	m_nPos = 1;  
        	isTrue = TRUE;
			m_nErrorID = SYNTAX_ERROR;
        	break;                    
        case 2:                
			if ( !isSub ) {
	        	int nStrLen = strlen(m_pszArgv[1]);
	        	CString str;
				str = m_pszArgv[1];
				str.TrimLeft();
				str.TrimRight();       	
	        	if (str[0] == '\"' && str[str.GetLength()-1] == '\"') {
	        		str = str.Left(str.GetLength()-1);
	        		str = str.Right(str.GetLength()-1);
	        		strcpy(m_pszArgv[1], str);
	        		isTrue = TRUE;
	            }
	            else {
					m_nErrorID = SYNTAX_ERROR;                        
				}	
	        }
			else {
				if (IsString(m_pszArgv[1]) ) {
		        	m_nPos = 100; 
		        	isTrue = TRUE;
		        }
		        else {
					m_nPos = 1;	                                          
					m_nErrorID = SYNTAX_ERROR;                        
		        }
		    }    	              
		    break;
        default:
			if (IsString(m_pszArgv[1]) ) {
	        	m_nPos = 100;
	        }
	        else {
				m_nPos = 1;	        
	        }	
            m_nErrorID = SYNTAX_ERROR;
            break;
    }                             

   	return isTrue;    

}   // End of CSyntaxCore::SyntaxCheckWatch().


//////////////////////////////// End of File ////////////////////////////////
