/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.CPP
//
//  Description: The implementation file for the class: CSyntaxLib.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLib.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include <ctype.h>

#include "address.h"
#include "synlib.h"
#include "cpusvr.h"
#include "bankinit.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.
static char* BASED_CODE g_pszKeywordLength = "Length";
static char* BASED_CODE g_pszKeywordAll = "All";
static char* BASED_CODE g_pszKeywordInsensitive = "Insensitive";
static char* BASED_CODE g_pszKeywordRun = "Run";
static char* BASED_CODE g_pszKeywordFrom = "From";
static char* BASED_CODE g_pszKeywordTill = "Till";
static char* BASED_CODE g_pszKeywordOver = "Over";
static char* BASED_CODE g_pszKeywordForever = "Forever";
static char* BASED_CODE g_pszKeywordLines = "Lines";
static char* BASED_CODE g_pszKeywordClear = "Clear";
static char* BASED_CODE g_pszKeywordRange = "Range";
static char* BASED_CODE g_pszKeywordOn = "On";
static char* BASED_CODE g_pszKeywordOff = "Off";
static char* BASED_CODE g_pszKeywordEnable = "Enable";
static char* BASED_CODE g_pszKeywordDisable = "Disable";
static char* BASED_CODE g_pszKeywordBit = "Bit";
static char* BASED_CODE g_pszKeywordByte = "Byte";
static char* BASED_CODE g_pszKeywordGlobal = "Global";
static char* BASED_CODE g_pszKeywordClose = "Close";
static char* BASED_CODE g_pszKeywordAppend = "Append";
static char* BASED_CODE g_pszKeywordCommand = "Command";
static char* BASED_CODE g_pszKeywordAddress = "Address";
static char* BASED_CODE g_pszKeywordDatum = "Datum";
static char* BASED_CODE g_pszKeywordCount = "Count";
static char* BASED_CODE g_pszKeywordSymbols = "Symbols";
static char* BASED_CODE g_pszKeywordNosymbols = "Nosymbols";
static char* BASED_CODE g_pszKeywordCode = "Code";
static char* BASED_CODE g_pszKeywordNocode = "Nocode";
static char* BASED_CODE g_pszKeywordWarn = "Warn";
static char* BASED_CODE g_pszKeywordNowarn = "Nowarn";
static char* BASED_CODE g_pszKeywordDelay = "Delay";
static char* BASED_CODE g_pszKeywordModule = "Module";
static char* BASED_CODE g_pszKeywordMonitor = "Monitor";
static char* BASED_CODE g_pszKeywordNmi = "Nmi";
static char* BASED_CODE g_pszKeywordReset = "Reset";
static char* BASED_CODE g_pszKeywordNumber = "Number";
static char* BASED_CODE g_pszKeywordStatus = "Status";
static char* BASED_CODE g_pszKeywordNosystem = "Nosystem";
static char* BASED_CODE g_pszKeywordSystem = "System";
static char* BASED_CODE g_pszKeywordWord = "Word";
static char* BASED_CODE g_pszKeywordHigh = "High";
static char* BASED_CODE g_pszKeywordLow = "Low";
static char* BASED_CODE g_pszKeywordLv1 = "Lv1";
static char* BASED_CODE g_pszKeywordLv2 = "Lv2";
static char* BASED_CODE g_pszKeywordForward = "Forward";
static char* BASED_CODE g_pszKeywordBackward = "Backward";
static char* BASED_CODE g_pszKeywordCenter = "Center";
static char* BASED_CODE g_pszKeywordOut = "Out";
static char* BASED_CODE g_pszKeywordP0 = "P0:";
static char* BASED_CODE g_pszKeywordP1 = "P1:";
static char* BASED_CODE g_pszKeywordP2 = "P2:";
static char* BASED_CODE g_pszKeywordP3 = "P3:";
static char* BASED_CODE g_pszKeywordX0 = "X0:";
static char* BASED_CODE g_pszKeywordX1 = "X1:";
static char* BASED_CODE g_pszKeywordOverlay = "Overlay";
static char* BASED_CODE g_pszKeywordOr = "Or";
static char* BASED_CODE g_pszKeywordGuard = "Guard";
static char* BASED_CODE g_pszKeywordTarget = "Target";
static char* BASED_CODE g_pszKeywordThen = "Then";
static char* BASED_CODE g_pszKeywordSeparation = "Separation";
static char* BASED_CODE g_pszKeywordCombination = "Combination";

/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//for build
//int GetControlOption(CString &strReset,CString &strEa,CString &strEben);
//extern UINT GetCpuId();

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxLib.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::CSyntaxLib().
//
//  Description: The construction of the class: CSyntaxLib.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxLib::CSyntaxLib()
{
    isStatusS = FALSE;
	isStatusW = FALSE;
	isStatusR = FALSE;
	isStatusF = FALSE;
	//isStatusAK = FALSE;
	isDataByte = FALSE;
		
}   // End of CSyntaxLib::CSyntaxLib().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::~CSyntaxLib().
//
//  Description: The destruction of the class: CSyntaxLib.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxLib::~CSyntaxLib()
{

}   // End of CSyntaxLib::~CSyntaxLib().

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::StrToVar().
//
//  Description: Convert the string to an unsigned long value.
//
//  Input:  pszStr - The string to be converted.
//
//  Output: None.
//
//  Return: An unsigned long value.
//
/////////////////////////////////////////////////////////////////////////////
unsigned long CSyntaxLib::StrToVar(char* pszStr)
{
    // Assertion of the input parameters.
    ASSERT( pszStr );
    
    // Convertion.
    char* pszStopStr;
    unsigned long ul = strtoul(pszStr, &pszStopStr, 16);
    
    return (ul);

}   // End of CSyntaxLib::StrToVar().


// Convert an unsigned long value to a string.
void CSyntaxLib::VarToStr(unsigned long ulVar, char* pszStr)
{
    // Assertion of the input parameters.
    ASSERT( pszStr );
    
    // Convert an unsigned long value to a string.
    _ultoa(ulVar, pszStr, 16);

}   // End of CSyntaxLib::VarToStr().

		
BOOL CSyntaxLib::ConvertAddress(char* pszArgv1, char* pszArgv2, int &nRet, int /*space*/)                                            
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
    UINT i;
	
    retCode = AdrTextToAddr(pszArgv1, address/*, ADDR_SPACE(space)*/);	 
    //retCode = AdrShlCheck2Addr(pszArgv1, address/*, ADDR_SPACE(space)*/);	
	
	if (ADR_OK == retCode) {                  
		retCode = AdrAddrToHex(address,pszArgv2);
		if (ADR_OK == retCode) {   
			if (pszArgv2[1] == ':') {
				for (i= 2; i<strlen(pszArgv2); i++)
					pszArgv2[i] = pszArgv2[i+2];						
			}                            
			else if (pszArgv2[2] == ':') {
				for (i= 3; i<strlen(pszArgv2); i++)
					pszArgv2[i] = pszArgv2[i+2];						
			}   
			else {
				for (i= 0; i<strlen(pszArgv2); i++)
					pszArgv2[i] = pszArgv2[i+2];						
			}   
			return (TRUE);				
		}
		else    
			return (FALSE);	
    }
	else {
		switch (retCode) {
			case 2:
				nRet = ADDR_FORMATERROR;
				break;
			case 3:
				nRet = ADDR_ERROR;
				break;
			case 4:
				nRet = ADDR_OUT_OF_RANGE;	
				break;
		    case 5:
		        nRet = ADDR_NOSYMBOL;
		        break;
			case 6:
				nRet = ADDR_COMPERROR;	
				break;
		    case 7:
		        nRet = ADDR_OVERFLOW; 
		        break;
		    default:
		    	nRet = NO_ERROR;
		    	break;		        
		}
		return (FALSE);
	}	
}  //End of CSyntaxLib::ConvertAddress		


void CSyntaxLib::ConvertLen(char* pszArgv1, char* pszArgv2)                                            
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
    char 			tempAddress[256];
	
	retCode = AdrTextToAddr(pszArgv1, address, 0);
	if (ADR_OK != retCode) {
		return;
	}
	
	AdrAddrToHex( address, tempAddress );
	strcpy(pszArgv2, tempAddress+2);
	return;	
}  //End of CSyntaxLib::ConvertLen		

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::Is***().
//
//  Description: Syntax checking lib routines.
//
//  Input:  pszArgv - Token arguments of command.
//
//  Output: None.
//
//  Return: FALSE - error; TRUE - pass.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxLib::IsEventSequence(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "ev1 and ev2...".
    const int nMaxSeq = 40;
    static char* BASED_CODE pszEventSequence[nMaxSeq] = {
        "ev1 ",
        "ev2 ",
        "ev3 ",
        "ev1 and ev2 ",
        "ev1 and ev3 ",
        "ev2 and ev1 ",
        "ev2 and ev3 ",
        "ev3 and ev1 ",
        "ev3 and ev2 ",
        "ev1 or ev2 ",
        "ev1 or ev3 ",
        "ev2 or ev1 ",
        "ev2 or ev3 ",
        "ev3 or ev1 ",
        "ev3 or ev2 ",
        "ev1 and ev2 and ev3 ",
        "ev1 and ev3 and ev2 ",
        "ev2 and ev1 and ev3 ",
        "ev2 and ev3 and ev1 ",
        "ev3 and ev1 and ev2 ",
        "ev3 and ev2 and ev1 ",
        "ev1 or ev2 or ev3 ",
        "ev1 or ev3 or ev2 ",
        "ev2 or ev1 or ev3 ",
        "ev2 or ev3 or ev1 ",
        "ev3 or ev1 or ev2 ",
        "ev3 or ev2 or ev1 ",
        "ev1 and ev2 or ev3 ",
        "ev1 and ev3 or ev2 ",
        "ev2 and ev1 or ev3 ",
        "ev2 and ev3 or ev1 ",
        "ev3 and ev1 or ev2 ",
        "ev3 and ev2 or ev1 ",
        "ev1 or ev2 and ev3 ",
        "ev1 or ev3 and ev2 ",
        "ev2 or ev1 and ev3 ",
        "ev2 or ev3 and ev1 ",
        "ev3 or ev1 and ev2 ",
        "ev3 or ev2 and ev1 ",
        ""
    };
    
    for ( int i = 0; i < nMaxSeq; i++ ) {
        if ( 0 == stricmp(pszArgv, pszEventSequence[i]) ) {
            return (TRUE);
        }
    }
    return (FALSE);

}   // End of CSyntaxLib::IsEventSequence().

BOOL CSyntaxLib::IsKeywordLength(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    if ( 0 == stricmp(pszArgv, g_pszKeywordLength) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
}

BOOL CSyntaxLib::IsKeywordAll(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "all".
    if ( 0 == stricmp(pszArgv, g_pszKeywordAll) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }           
}

BOOL CSyntaxLib::IsKeywordInsensitive(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "insensitive".
    if ( 0 == stricmp(pszArgv, g_pszKeywordInsensitive) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordInsensitive().


BOOL CSyntaxLib::IsKeywordRun(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Run".
    if ( 0 == stricmp(pszArgv, g_pszKeywordRun) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordRun().


BOOL CSyntaxLib::IsKeywordFrom(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "From".
    if ( 0 == stricmp(pszArgv, g_pszKeywordFrom) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordFrom().


BOOL CSyntaxLib::IsKeywordTill(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Till".
    if ( 0 == stricmp(pszArgv, g_pszKeywordTill) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordTill().


BOOL CSyntaxLib::IsKeywordOver(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, g_pszKeywordOver) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordOver().


BOOL CSyntaxLib::IsKeywordForever(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Forever".
    return ( 0 == stricmp(pszArgv, g_pszKeywordForever) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordForever().

BOOL CSyntaxLib::IsKeywordLines(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lines".
    return ( 0 == stricmp(pszArgv, g_pszKeywordLines) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordLine().


BOOL CSyntaxLib::IsKeywordClear(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Clear".
    return ( 0 == stricmp(pszArgv, g_pszKeywordClear) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordClear().


BOOL CSyntaxLib::IsKeywordRange(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Range".
    return ( 0 == stricmp(pszArgv, g_pszKeywordRange) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordRange().

BOOL CSyntaxLib::IsKeywordOn(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "ON".
    return ( 0 == stricmp(pszArgv, g_pszKeywordOn) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordOn().


BOOL CSyntaxLib::IsKeywordOff(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "OFf".
    return ( 0 == stricmp(pszArgv, g_pszKeywordOff) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordOff().


BOOL CSyntaxLib::IsKeywordEnable(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Enable".
    return ( 0 == stricmp(pszArgv, g_pszKeywordEnable) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordEnable().


BOOL CSyntaxLib::IsKeywordDisable(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Disable".
    return ( 0 == stricmp(pszArgv, g_pszKeywordDisable) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordDisable().


BOOL CSyntaxLib::IsKeywordBit(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Bit".
    return ( 0 == stricmp(pszArgv, g_pszKeywordBit) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordBit().


BOOL CSyntaxLib::IsKeywordByte(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Byte".
    return ( 0 == stricmp(pszArgv, g_pszKeywordByte) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordByte().

BOOL CSyntaxLib::IsKeywordGlobal(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "GLOBAL".
    return ( 0 == stricmp(pszArgv, g_pszKeywordGlobal) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordGlobal().


BOOL CSyntaxLib::IsKeywordClose(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Close".
    return ( 0 == stricmp(pszArgv, g_pszKeywordClose) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordClose().


BOOL CSyntaxLib::IsKeywordAppend(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Append".
    return ( 0 == stricmp(pszArgv, g_pszKeywordAppend) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordAppend().


BOOL CSyntaxLib::IsKeywordCommand(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Command".
    return ( 0 == stricmp(pszArgv, g_pszKeywordCommand) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordCommand().

BOOL CSyntaxLib::IsKeywordAddress(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Address"
    if ( 0 != stricmp(pszArgv, g_pszKeywordAddress) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
    
}   //End of CSyntaxLib::IsKeywordAddress(). 

BOOL CSyntaxLib::IsKeywordDatum(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Datum"
    if ( 0 != stricmp(pszArgv, g_pszKeywordDatum) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
    
}   //End of CSyntaxLib::IsKeywordDatum(). 


BOOL CSyntaxLib::IsKeywordCount(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Count"
    if ( 0 != stricmp(pszArgv, g_pszKeywordCount) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
    
}   //End of CSyntaxLib::IsKeywordCount(). 



BOOL CSyntaxLib::IsKeywordSymbols(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Symbols"
    if ( 0 != stricmp(pszArgv, g_pszKeywordSymbols) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordNosymbols(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Nosymbols"
    if ( 0 != stricmp(pszArgv, g_pszKeywordNosymbols) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
} 


BOOL CSyntaxLib::IsKeywordCode(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Code"
    if ( 0 != stricmp(pszArgv, g_pszKeywordCode) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordNocode(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Nocode"
    if ( 0 != stricmp(pszArgv, g_pszKeywordNocode) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
} 


BOOL CSyntaxLib::IsKeywordWarn(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Warn"
    if ( 0 != stricmp(pszArgv, g_pszKeywordWarn) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
} 

BOOL CSyntaxLib::IsKeywordNowarn(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Nowarn"
    if ( 0 != stricmp(pszArgv, g_pszKeywordNowarn) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordDelay(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Delay".
    return ( 0 == stricmp(pszArgv, g_pszKeywordDelay) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordDelay().


BOOL CSyntaxLib::IsKeywordModule(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Module".
    return ( 0 == stricmp(pszArgv, g_pszKeywordModule) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordModule().

BOOL CSyntaxLib::IsKeywordMonitor(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Monitor".
    return ( 0 == stricmp(pszArgv, g_pszKeywordMonitor) ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordMonitor().

BOOL CSyntaxLib::IsKeywordControlOption(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
                      
    // Is "Reset|Nmi|EXtint".
	if ( 0 == stricmp(pszArgv, g_pszKeywordReset) ||
		 0 == stricmp(pszArgv, g_pszKeywordNmi) ) {
		return TRUE;	 
	}	            
	else {
		return FALSE;
	}	
    	
}   // End of CSyntaxLib::IsKeywordControlOption().

BOOL CSyntaxLib::IsKeywordNumber(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Number"
    if ( 0 != stricmp(pszArgv, g_pszKeywordNumber) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
    
}   //End of CSyntaxLib::IsKeywordNumber(). 

BOOL CSyntaxLib::IsKeywordStatus(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Status".
    if ( 0 == stricmp(pszArgv, g_pszKeywordStatus) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
}                      

BOOL CSyntaxLib::IsKeywordSystem(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "System"
    if ( 0 != stricmp(pszArgv, g_pszKeywordSystem) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 


BOOL CSyntaxLib::IsKeywordNosystem(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Nosystem"
    if ( 0 != stricmp(pszArgv, g_pszKeywordNosystem) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordByteOrWord(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Byte" or "Word"
    if ( 0 == stricmp(pszArgv, g_pszKeywordByte) ) {
    	isDataByte = TRUE;              
    }	
	else if ( 0 == stricmp(pszArgv, g_pszKeywordWord) ) {
		isDataByte = FALSE;        
    }
    else {
        return (FALSE);
    }                      
    
    return (TRUE);
    
}   //End of CSyntaxLib::IsKeywordWidth().   


BOOL CSyntaxLib::IsKeywordHigh(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "High".
    return ( 0 == stricmp(pszArgv, g_pszKeywordHigh) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordHigh().
                                                          

BOOL CSyntaxLib::IsKeywordLow(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Low".
    return ( 0 == stricmp(pszArgv, g_pszKeywordLow) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordLow().

BOOL CSyntaxLib::IsKeywordLv1(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lv1".
    return ( 0 == stricmp(pszArgv, g_pszKeywordLv1) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordLv1().


BOOL CSyntaxLib::IsKeywordLv2(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lv2".
    return ( 0 == stricmp(pszArgv, g_pszKeywordLv2) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordLv2().

BOOL CSyntaxLib::IsKeywordThen(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Then".
    return ( 0 == stricmp(pszArgv, g_pszKeywordThen) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordThen().

BOOL CSyntaxLib::IsKeywordForBackCen(char* pszArgv)
{
	if ( stricmp(pszArgv, g_pszKeywordForward) == 0 ||
		 stricmp(pszArgv, g_pszKeywordBackward) == 0 ||
		 stricmp(pszArgv, g_pszKeywordCenter) == 0 ) {
		return TRUE;
	}
	else {
		return FALSE;
	}		
}


BOOL CSyntaxLib::IsKeywordOut(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Out".
    return ( 0 == stricmp(pszArgv, g_pszKeywordOut) ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordOut().


BOOL CSyntaxLib::IsAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if (AdrIsOk(szArgv))
		return (TRUE);
	else {
		//Error handle			
		m_nErrorID = ADDR_ERROR;
		return (FALSE);
	}
}


BOOL CSyntaxLib::IsAddrLen(char* pszArgv, int &nRet)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "length".
  	char* p;  
  	ADDR_RETCODE retCode;
  	ADDRESS address;
  	p = new char [ strlen(pszArgv)+1 ];
  	ASSERT( p );
  	strcpy(p,pszArgv);
  	retCode = AdrTextToAddr(p, address,0);
  	if ( p ) {
  		delete []p;
  		p = 0;
  	}	
  	if (ADR_OK == retCode) {
		if (SPACE_UNDEFINE == address.adrSpace )
			return (TRUE);
		else {
			//Error handle			
			nRet = LEN_ERROR;
			return (FALSE);	          		        
		}	
  	}
  	else {
		//Error handle			
		nRet = LEN_ERROR;
		return (FALSE);	        
	}	
}
                        
// Is in the range: "addr Length length".
BOOL CSyntaxLib::IsLengthRange(char* pszAddr, char* pszLen, int &nRet)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr && pszLen );
    
	ADDR_RETCODE retCode1;
  	ADDR_RETCODE retCode2;
  	ADDRESS address1;    
    ADDRESS address2;
    int nBankInfo = 0;
    DWORD dwAddr1 = 0;
	DWORD dwAddr2 = 0;    
	
    retCode1 = AdrTextToAddr(pszAddr,address1);
    retCode2 = AdrTextToAddr(pszLen,address2,0);
	if (ADR_OK == retCode1 && ADR_OK == retCode2) {
		//nBankInfo = GetBankInfo();		
		//if ( address1.adrSpace == SPACE_I || nBankInfo == COMB1 || 
		//	 nBankInfo == SEPB1) {
			address2.adrAddress += address1.adrAddress;		
			address2.adrAddress--;		
			address2.adrSpace = address1.adrSpace;			
			retCode1 = AdrCheck2Addr(address1, address2);
	        if (ADR_OK == retCode1) {       
	            return (TRUE); 
	        }               
	        else {               
				//Error handle
				nRet = LEN_OUT_OF_RANGE;
	        	return (FALSE);
	        }	                                  
	    /*
	    }    
	    else if ( nBankInfo == COMB2 ) {	    
			dwAddr1 = GetAddrValue(address1);			
	    	dwAddr2 = dwAddr1 + address2.adrAddress - 1;
	    	if ( dwAddr2 > 0x1ffff ) {
	    		nRet = LEN_OUT_OF_RANGE;
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}
	    }               
	    else if ( nBankInfo == COMB4 ) {	    
			dwAddr1 = GetAddrValue(address1);			
	    	dwAddr2 = dwAddr1 + address2.adrAddress - 1;
	    	if ( dwAddr2 > 0x3ffff ) {
	    		nRet = LEN_OUT_OF_RANGE;
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}
	    }               
	    else if ( nBankInfo == SEPB2 ) {	    
			dwAddr1 = GetAddrValue(address1);			
	    	dwAddr2 = dwAddr1 + address2.adrAddress - 1;
	    	if ( dwAddr2 > 0x1ffff ) {
	    		nRet = LEN_OUT_OF_RANGE;
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}
	    } 	    
    	else {
    		return FALSE;
    	} */
    }
    else {
     	if (retCode1 != ADR_OK ) {
     		nRet = ADDR_ERROR;
     		return (FALSE);
     	}                  
		if (retCode2 != ADR_OK ) {     	
	     	nRet = LEN_ERROR;
	    	return (FALSE);
	    }
	    return (FALSE);	
    }	                          
    return TRUE;
}


BOOL CSyntaxLib::IsLengthRange(char* /*pszAddr*/, char* pszLen, char* pszTarget, int &nRet)
{
    // Assertion of the input parameters.
    ASSERT( pszLen && pszTarget );

	ADDR_RETCODE retCode1;
  	ADDR_RETCODE retCode2;
  	ADDRESS address1;    
    ADDRESS address2;
    int nBankInfo = 0;
    DWORD dwAddr1 = 0;
    DWORD dwAddr2 = 0;
    
    retCode1 = AdrTextToAddr(pszTarget,address1);
    retCode2 = AdrTextToAddr(pszLen,address2,0);
    if (ADR_OK == retCode1 && ADR_OK == retCode2) {
		//nBankInfo = GetBankInfo();
		//if ( address1.adrSpace == SPACE_I || nBankInfo == COMB1 || 
		//	 nBankInfo == SEPB1) {
			address2.adrAddress += address1.adrAddress;		
			address2.adrAddress--;		
			address2.adrSpace = address1.adrSpace;			
			retCode1 = AdrCheck2Addr(address1, address2);
	        if (ADR_OK == retCode1) {       
	            return (TRUE); 
	        }               
	        else {               
				//Error handle
				nRet = LEN_OUT_OF_RANGE;
	        	return (FALSE);
	        }	                                  
	    /*
	    }    
	    else if ( nBankInfo == COMB2 ) {	    
			dwAddr1 = GetAddrValue(address1);			
	    	dwAddr2 = dwAddr1 + address2.adrAddress - 1;
	    	if ( dwAddr2 > 0x1ffff ) {
	    		nRet = LEN_OUT_OF_RANGE;
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}
	    }               
	    else if ( nBankInfo == COMB4 ) {	    
			dwAddr1 = GetAddrValue(address1);			
	    	dwAddr2 = dwAddr1 + address2.adrAddress - 1;
	    	if ( dwAddr2 > 0x3ffff ) {
	    		nRet = LEN_OUT_OF_RANGE;
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}
	    }               
	    else if ( nBankInfo == SEPB2 ) {	    
			dwAddr1 = GetAddrValue(address1);			
	    	dwAddr2 = dwAddr1 + address2.adrAddress - 1;
	    	if ( dwAddr2 > 0x1ffff ) {
	    		nRet = LEN_OUT_OF_RANGE;
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}
	    } 	    
    	else {
    		return FALSE;
    	}   */
    }
    else {
     	if (retCode1 != ADR_OK ) {
     		nRet = ADDR_ERROR;
     		return (FALSE);
     	}                  
		if (retCode2 != ADR_OK ) {     	
	     	nRet = LEN_ERROR;
	    	return (FALSE);
	    }
	    return (FALSE);	
    }	

}


BOOL CSyntaxLib::IsAddrRange(char* pszAddr1, char* pszAddr2, char* pszAddr3)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr1 && pszAddr2 && pszAddr3 );

	ADDR_RETCODE retCode1;
  	ADDR_RETCODE retCode2;
  	ADDR_RETCODE retCode3; 

  	ADDRESS address1;    
  	ADDRESS address2;    
    ADDRESS address3;                                         
    ADDRESS address4;    
    int nBankInfo = 0;
    DWORD dwAddr1 = 0;
    DWORD dwAddr2 = 0;
    DWORD dwAddr3 = 0;
    DWORD dwAddr4 = 0;
    
    retCode1 = AdrTextToAddr(pszAddr1,address1);
    retCode2 = AdrTextToAddr(pszAddr2,address2);
    retCode3 = AdrTextToAddr(pszAddr3,address3);
    if (ADR_OK == retCode1 && ADR_OK == retCode2 && ADR_OK == retCode3) {
		//nBankInfo = GetBankInfo();
		//if ( address1.adrSpace == SPACE_I || nBankInfo == COMB1 || 
		//	 nBankInfo == SEPB1) {		
			address4.adrAddress = address3.adrAddress + 
				(address2.adrAddress - address1.adrAddress);		
			address4.adrSpace = address3.adrSpace;	
			retCode1 = AdrCheck2Addr(address3, address4);
	        if (ADR_OK == retCode1) {       
	            return (TRUE); 
	        }               
	        else {               
				m_nErrorID = ADDR_OUT_OF_RANGE;
	        	return (FALSE);
	        }	
	    /*
	    }   
	    else if ( nBankInfo == COMB2 ) {
	    	dwAddr1 = GetAddrValue(address1);
	    	dwAddr2 = GetAddrValue(address2);
	    	dwAddr3 = GetAddrValue(address3);
	    	dwAddr4 = dwAddr2 - dwAddr1 + dwAddr3;
	    	if ( dwAddr4 > 0x1ffff ) {	    		
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}	    
	    }    
	    else if ( nBankInfo == COMB4 ) {
	    	dwAddr1 = GetAddrValue(address1);
	    	dwAddr2 = GetAddrValue(address2);
	    	dwAddr3 = GetAddrValue(address3);
	    	dwAddr4 = dwAddr2 - dwAddr1 + dwAddr3;
	    	if ( dwAddr4 > 0x3ffff ) {	    		
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}	    
	    }    
	    else if ( nBankInfo == SEPB2 ) {
	    	dwAddr1 = GetAddrValue(address1);
	    	dwAddr2 = GetAddrValue(address2);
	    	dwAddr3 = GetAddrValue(address3);
	    	dwAddr4 = dwAddr2 - dwAddr1 + dwAddr3;
	    	if ( dwAddr4 > 0x1ffff ) {	    		
	    		return FALSE;	
	    	}	                        
	    	else {
	    		return TRUE;
	    	}	    
	    }*/    
    }
    else {
     	if (retCode1 != ADR_OK ) {
     		//nRet = ADDR_ERROR;           
     		m_nErrorID = ADDR_ERROR;
     		return (FALSE);
     	}                  
		if (retCode2 != ADR_OK ) {     	
	     	//nRet = LEN_ERROR;     
	     	m_nErrorID = LEN_ERROR;
	    	return (FALSE);
	    }
     	if (retCode3 != ADR_OK ) {
     		//nRet = ADDR_ERROR;    
     		m_nErrorID = ADDR_ERROR;
     		return (FALSE);
     	}                  
	    return (FALSE);	
    }	
    return TRUE;
}


BOOL CSyntaxLib::IsMapStartAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Convert symbol to standard address format.
    char szArgv[256];
    char* p1;
    char* p2;
    strcpy(szArgv, pszArgv);

    // Check map bound.
    if ( szArgv[1] == ':' ) {
    	p1 = szArgv + 2;	
    }                 
    else if ( szArgv[2] == ':' ) {
    	p1 = szArgv + 3;
    }                 
    else {
        p1 = szArgv;
    }
    p2 = p1;
    
    if ( strlen(p1) < 1 ) {
        return (FALSE);
    }
    while ( *p1 ) {
        if ( !isxdigit(*(p1++)) ) { 
			//Error handle
			m_nErrorID = ADDR_ERROR;
            return (FALSE);
        }    
    }

    unsigned long ul = StrToVar(p2);
	
	DWORD dwpMax = GetPMax();
    
    if ( ul < 0ul || ul > dwpMax ) {  
		//Error handle
		m_nErrorID = ADDR_OUT_OF_RANGE;
        return (FALSE);
    }
    else if ( 0 != (ul % 0x080) ) {          
		//Error handle
		m_nErrorID = ADDR_MAP_ERROR;
        return (FALSE);
    }

    return (TRUE);
}
                                             

BOOL CSyntaxLib::IsMapEndAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Convert symbol to standard address format.
    char szArgv[256];
    char* p1;
    char* p2;    
    strcpy(szArgv, pszArgv);   

    // Check map bound.
    if ( szArgv[1] == ':' ) {
    	p1 = szArgv + 2;	
    }                 
    else if ( szArgv[2] == ':' ) {
    	p1 = szArgv + 3;
    }                 
    else {
        p1 = szArgv;
    }
    p2 = p1;

    if ( strlen(p1) < 1 ) {
        return (FALSE);
    }
    while ( *p1 ) {
        if ( !isxdigit(*(p1++)) ) {
			m_nErrorID = ADDR_ERROR;
            return (FALSE);
        }    
    }

    unsigned long ul = StrToVar(p2);
                                
	DWORD dwpMax = GetPMax();
	                                
    if ( ul < 0ul || ul > dwpMax ) {		
		m_nErrorID = ADDR_OUT_OF_RANGE;
        return (FALSE);
    }
    else if ( 0 != ((ul+1) % 0x080) ) {
		m_nErrorID = ADDR_MAP_ERROR;
        return (FALSE);
    }                 
    
    return (TRUE);
}


BOOL CSyntaxLib::IsMapAddrLen(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
			m_nErrorID = ADDR_ERROR;
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x040000ul ) {
		m_nErrorID = ADDR_OUT_OF_RANGE;
        return (FALSE);
    }
    else if ( 0 != (ul % 0x080) ) {
		m_nErrorID = ADDR_MAP_ERROR;
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsMapMemType(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
	int nBankInfo = GetBankInfo();
	if ( nBankInfo == COMB1 ) {
		if ( stricmp(pszArgv, g_pszKeywordP0) == 0 ) {			 
			return TRUE;	 
		}	   
	}
	else if ( nBankInfo == COMB2 ) {
		if ( stricmp(pszArgv, g_pszKeywordP0) == 0 ||
			 stricmp(pszArgv, g_pszKeywordP1) == 0 ) {
			return TRUE;	 
		}	   
	}   
	else if ( nBankInfo == COMB4 ) {
		if ( stricmp(pszArgv, g_pszKeywordP0) == 0 ||
			 stricmp(pszArgv, g_pszKeywordP1) == 0 ||
			 stricmp(pszArgv, g_pszKeywordP2) == 0 ||
			 stricmp(pszArgv, g_pszKeywordP3) == 0 ) {
			return TRUE;	 
		}	   
	}                            
	else if ( nBankInfo == SEPB1 ) {
		if ( stricmp(pszArgv, g_pszKeywordP0) == 0 ||			 
			 stricmp(pszArgv, g_pszKeywordX0) == 0 ) {
			return TRUE;	 
		}	   
	}   
	else if ( nBankInfo == SEPB2 ) {
		if ( stricmp(pszArgv, g_pszKeywordP0) == 0 ||
			 stricmp(pszArgv, g_pszKeywordP1) == 0 ||
			 stricmp(pszArgv, g_pszKeywordX0) == 0 ||
			 stricmp(pszArgv, g_pszKeywordX1) == 0 ) {
			return TRUE;	 
		}	   
	}   

	return FALSE;
}

BOOL CSyntaxLib::IsKeywordOverlay(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Overlay".
    if ( 0 == stricmp(pszArgv, g_pszKeywordOverlay) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}

BOOL CSyntaxLib::IsKeywordTarget(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Target".
    if ( 0 == stricmp(pszArgv, g_pszKeywordTarget) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}                                                

BOOL CSyntaxLib::IsKeywordCombination(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Combination".
    if ( 0 == stricmp(pszArgv, g_pszKeywordCombination) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}

BOOL CSyntaxLib::IsKeywordSeparation(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Separation".
    if ( 0 == stricmp(pszArgv, g_pszKeywordSeparation) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}



BOOL CSyntaxLib::IsMapAttr(char chType, char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    ASSERT( 'P' == toupper(chType) || 'X' == toupper(chType) );
    
    // Is "attribute".
	//1.combination : attribute : Overlay,Target,Guard,Overlay Read only
	//				  p0-p3: 0x0--0xffff and x0-x3: 0x0--0xffff
	//2.Separation : p: attribute : Overlay,Target,Guard,Overlay Read only
	//				    p0-p1: 0x0--0xffff
	//		   		 x: attribute : Overlay, Target
	//				    x0-x1: 0x0--0xffff
    if ( toupper(chType) == 'P' ) {
	    if ( !stricmp(pszArgv, g_pszKeywordOverlay) ) {
	        return (TRUE);
	    }
	    else if ( !stricmp(pszArgv, g_pszKeywordOr) ) {
	        return (TRUE);
	    }
	    else if ( !stricmp(pszArgv, g_pszKeywordGuard) ) {
	        return (TRUE);
	    }
	    else if ( !stricmp(pszArgv, g_pszKeywordTarget) ) {
	        return (TRUE);
	    }
	}
    else if ( toupper(chType) == 'X' ) {
	    if ( !stricmp(pszArgv, g_pszKeywordOverlay) ) {
	        return (TRUE);
	    }
	    else if ( !stricmp(pszArgv, g_pszKeywordTarget) ) {
	        return (TRUE);
	    }
	}
    else {
		m_nErrorID = MAP_ATTR_ERROR;
        return (FALSE);
    }
	return (FALSE);
}


BOOL CSyntaxLib::IsRegName(char* pszRegName)
{          

    // Assertion of the input parameters.
    ASSERT( pszRegName );
    
    // Is in "RegName[]".
    CString str = strupr(pszRegName);
    for ( int i= 0; i < nMaxReg; i++ ) {
        if ( str == RegName[i] ) {
            return (TRUE);
        }
    }
	//Error handle
	m_nErrorID = REG_ERROR;
	//DisplayError();

    return FALSE;
}


BOOL CSyntaxLib::IsRegData(char* pszRegName, char* pszRegData)
{
    // Assertion of the input parameters.
    ASSERT( pszRegName );
    ASSERT( pszRegData );
    UINT i; 
    long lValue;                   
    char* p = pszRegData;

	CString str = strupr(pszRegName);
    if ( str == "PC" ) {
		if ( IsPAddr(pszRegData) ) {
			return TRUE;
		}               
		else {
			return FALSE;
		}	
	}
	
    if( '0' == pszRegData[0] && 'X' == toupper(pszRegData[1])) {
	    if (2 == strlen(pszRegData)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszRegData); i++) {
        	pszRegData[i] = pszRegData[i+2];
        }                               
    }
	else {
		while ( *p ) {
        	if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
            	return (FALSE);
        	}
    	}
    	char* pszStopStr;
		lValue = strtol(pszRegData,&pszStopStr, 10);
    	_ltoa(lValue,pszRegData,16);    
    }	                   

    // Is "REG DATA".    
    
    str = strupr(pszRegName);
    unsigned long ul = StrToVar(pszRegData);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
		//Error handle
		m_nErrorID = DATA_OUT_OF_RANGE;
        return (FALSE);
    }
    return (TRUE);
}                             



BOOL CSyntaxLib::IsFilename(char* pszArgv, int &nRet)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "filename".
    if ( strlen(pszArgv) >= _MAX_PATH ) {
        
        return (FALSE);
    }

    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
		//Error handle
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
      
    // Local driver: "..." invalid.
    // Netware driver: "..." valid.
    //if ( strstr(pszArgv, "...") ) {
    //    return (FALSE);
    //}
        
    if ( strstr(pszArgv, "\\\\") ||
         strstr(pszArgv, "//")   ||
         strstr(pszArgv, "\\/")  ||
         strstr(pszArgv, "/\\") ) {
		//Error handle
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    char pszDrive[_MAX_DRIVE];
    char pszDir[_MAX_DIR];
    char pszFname[_MAX_FNAME];
    char pszExt[_MAX_EXT];

    _splitpath(pszArgv, pszDrive, pszDir, pszFname, pszExt);

    if ( strchr(pszDir, ':')   ||
         strchr(pszFname, ':') ||
         strchr(pszExt, ':') ) {
		//Error handle
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    if ( *pszDrive && 
         !(*pszDrive >= 'A' && *pszDrive <= 'Z') &&
         !(*pszDrive >= 'a' && *pszDrive <= 'z') ) {
		//Error handle
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    if ( strchr(pszFname, '.') ) {
		//Error handle
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    if ( !*pszFname ) {
		//Error handle
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    return (TRUE);
}

BOOL CSyntaxLib::IsVariableName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {               
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
        return (FALSE);
    }

    if ( !iscsymf(pszArgv[1]) ) {
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
        return (FALSE);
    }

    if ( '_' == pszArgv[1] && strlen(pszArgv) < 3 ) {
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
        return (FALSE);
    }
    
    BOOL isUnderscore = FALSE;
    char* p = pszArgv+1;
    if ( '_' == *p ) {
        isUnderscore = TRUE;
    }
            
    while ( *p ) {
        if ( !iscsym(*p) && '?' != *p ) {
			//Error handle
			m_nErrorID = VARIABLE_NAME_ERROR;
            return (FALSE);
        }
        else if ( '_' != *(p++) ) {
            isUnderscore = FALSE;
        }
    }

    if ( isUnderscore ) {
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}


BOOL CSyntaxLib::IsSymbolName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {              
		//Error handle
		m_nErrorID = SYMBOL_NAME_ERROR;
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
		//Error handle
		m_nErrorID = SYMBOL_NAME_ERROR;
        return (FALSE);
    }

    return (TRUE);
}


BOOL CSyntaxLib::IsDataLong(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "12345678...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
			//Error handle
			m_nErrorID = DATA_ERROR;
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE/4 ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataLong().


BOOL CSyntaxLib::IsDataWord(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "1234...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
			//Error handle
			m_nErrorID = DATA_ERROR;
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE/2 ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataWord().


BOOL CSyntaxLib::IsData(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "x xx ...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p)) {
			//Error handle
			m_nErrorID = DATA_ERROR;
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsData().


BOOL CSyntaxLib::IsString(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "string".
    if ( strlen(pszArgv) > MAX_FILL_SIZE + 2 || strlen(pszArgv) < 3 ) {
        return (FALSE);
    }

    if ( '\"' != *pszArgv || '\"' != *(pszArgv+strlen(pszArgv)-1) ) {
        return (FALSE);
    }

    char* p = pszArgv;
    while ( *p ) {
        if ( *p < 0x020 || *p > 0x07E ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsString().


BOOL CSyntaxLib::IsDataRange(int nArgc, char* pszArgv[], int nDigit)
{
    // Assertion of the input parameters.
	//ASSERT( nArgc >= 3 && nArgc <= 5 );
    //ASSERT( 3 == nArgc );
    ASSERT( 1 == nDigit || 2 == nDigit || 4 == nDigit );
    
    // Check the Data field range.
    int nCount = 0;
    char* p = pszArgv[nArgc-1];
    while ( *p ) {
        if ( ' ' == *p ) {
            nCount++;
        }
        p++;
    }

    unsigned long ul;

    // Convert symbol to standard address format.
    char szAddr1[256];
    strcpy(szAddr1, pszArgv[1]);

    ADDRESS         address;
	AdrTextToAddr(szAddr1, address);

	DWORD dwpMax = GetPMax();
	DWORD dwxMax = GetXMax();
	DWORD dwiMax = GetIMax();
    
    switch (address.adrSpace) {   
    	case SPACE_P0: 
    	case SPACE_P1:
    	case SPACE_P2:
    	case SPACE_P3:
    	    ul = dwpMax;
			break;
    	case SPACE_X0: 
    	case SPACE_X1:
    	case SPACE_X2:
    	case SPACE_X3:
    	    ul = dwxMax;
			break;
		case SPACE_I:
			ul = dwiMax;
			break;        
    }

    if ( ul - address.adrAddress + 1 < (unsigned long)(nCount * nDigit) ) {
        return (FALSE);
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataRange().
  
BOOL CSyntaxLib::IsAddrData(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv))
			return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFul ) {
		//Error handle
		m_nErrorID = DATA_OUT_OF_RANGE;
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsAddrData().

BOOL CSyntaxLib::IsDelayCount(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv))
			return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x7FFFul ) {
		//Error handle
		m_nErrorID = DATA_OUT_OF_RANGE;
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsDelayCount().


BOOL CSyntaxLib::IsEv1Count(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv))
			return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0xFFFFul ) {
		//Error handle
		m_nErrorID = DATA_OUT_OF_RANGE;
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsEv1Count().

BOOL CSyntaxLib::IsWildcardAddr(char* pszArgv) 
{                              

    // Assertion of the input parameters.
    ASSERT( pszArgv );

	//support 2 format: "P0:(1xff)", "(1xff)" 
	int nBankInfo;
	CString strAddr;
	
    if ( pszArgv[0] != '(' ) {
    	if ( pszArgv[0] == 'P' || pszArgv[0] == 'p' ) { 
    		nBankInfo = GetBankInfo();		
			if ( nBankInfo == COMB1 || nBankInfo == SEPB1 ) {
    			if ( pszArgv[1] != '0' ) {
    				return FALSE;
    			}                
    		}
    		else if ( nBankInfo == COMB2 || nBankInfo == SEPB2 ) {	
    			if ( pszArgv[1] != '0' && pszArgv[1] != '1') {
    				return FALSE;
    			}                
    		}
    		else if ( nBankInfo == COMB4 ) {	
    			if ( pszArgv[1] != '0' && pszArgv[1] != '1'
    				 && pszArgv[1] != '2') {
    				return FALSE;
    			}                
    		}
    	}
    	else {
    		return FALSE;	
    	}                
    	if ( strlen(pszArgv) <= 3 ) {
    		return FALSE;	
    	}
    	strAddr = pszArgv;
    	strAddr = strAddr.Right(strlen(pszArgv)-3);	
    }                                      
    else {
    	strAddr = pszArgv;
    }                     
    
    if ( strAddr[0] == '(' && strAddr[strAddr.GetLength()-1] == ')' ) {
     	if ( toupper(strAddr[strAddr.GetLength()-2]) == 'B' &&
     		 strAddr.GetLength() == 19 ) {
     		//Bit wildcard
	        for ( int i = 1; i < 17; i++ ) { 
	            if ( '0' != strAddr[i] &&
	                 '1' != strAddr[i] &&
	                 'X' != toupper(strAddr[i]) ) {
	                return (FALSE);
	            }
	        }
	        for ( i = 0; i < 17; i++ ) {
	            if ( 'X' == toupper(strAddr[i]) ) {
	                return (TRUE);
	            }
	            else {
	                continue;
	            }
	        }
	        return (FALSE);         			 
     	}	
     	else {
     		//Byte wildcard
	        if ( 6 != strAddr.GetLength() ) {
	            return (FALSE);
	        }     
	        for ( int i = 1; i < 5; i++ ) { 
	            if ( !isxdigit(strAddr[i])  &&	                 
	                 'X' != toupper(strAddr[i]) ) {
	                return (FALSE);
	            }
	        }
	        for ( i = 1; i < 5; i++ ) {
	            if ( 'X' == toupper(strAddr[i]) ) {
	                return (TRUE);
	            }
	            else {
	                continue;
	            }
	        }
	        return (FALSE);         		
     	}    
    }
    else {
    	return FALSE;
    }
    return TRUE;
	
	/*
    if ( '(' != pszArgv[0] && ')' != pszArgv[strlen(pszArgv)-1])
    	return (FALSE);        
    else { 
		for (i = 0; i < strlen(pszArgv)-1 ; i++) {
			pszArgv[i] = pszArgv[i+1];
		}
		pszArgv[strlen(pszArgv)-2] = '\0';    
    }                                         	                          
    
    // Binary or Hexadecimal wildcard code.
    if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-1)) && 17 == strlen(pszArgv)) { 
        for ( i = 0; i < 17-1; i++ ) { 
            if ( '0' != pszArgv[i] &&
                 '1' != pszArgv[i] &&
                 'X' != toupper(pszArgv[i]) ) {
                return (FALSE);
            }
        }
        for ( i = 0; i < 17; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }
    else {
        // Hexidecimal code.   (3XXF)
        if ( 4 != strlen(pszArgv) ) {
            return (FALSE);
        }     
        
        char* p = pszArgv;
        while ( *p ) {
            if ( isxdigit(*p) || 'X' == toupper(*p) ) {
                p++;
            }
            else {
                return (FALSE);
            }
        } 
        for ( int i = 0; i < 4; i++ ) { 
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }
*/
}   // End of CSyntaxLib::IsWildcardAddr().


BOOL CSyntaxLib::IsWildcardData(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	int i;
	    
    // Binary or Hexadecimal wildcard code.
    if ( '(' != pszArgv[0] && ')' != pszArgv[strlen(pszArgv)-1])
    	return (FALSE);                                  

	CString strData;           
	strData = pszArgv;
//	strData = strData.Left(strData.GetLength()-1);
//	strData = strData.Right(strData.GetLength()-1);

	if ( isDataByte ) {	
     	if ( toupper(strData[strData.GetLength()-2]) == 'B' &&
     		 strData.GetLength() == 11 ) {
	        for ( i = 1; i < 9; i++ ) {        
	            if ( '0' != strData[i] &&         	            
	                 '1' != strData[i] &&
	                 'X' != toupper(strData[i]) ) {
	                return (FALSE);
	            }
	        }
	        for ( i = 0; i < 9; i++ ) {
	            if ( 'X' == toupper(strData[i]) ) {
	                return (TRUE);
	            }
	            else {
	                continue;
	            }
	        }
	        return (FALSE);
	    }
	    else {
	        // Hexidecimal code. (XF)
	        if ( 4 != strlen(strData) ) {
	            return (FALSE);
	        }
	        for ( int i = 1; i < 3; i++ ) { 
	            if ( !isxdigit(strData[i])  &&	                 
	                 'X' != toupper(strData[i]) ) {
	                return (FALSE);
	            }
	        }
	        
	        for ( i = 1; i < 3; i++ ) {
	            if ( 'X' == toupper(strData[i]) ) {
	                return (TRUE);
	            }
	            else {
	                continue;
	            }
	        }
	        return (FALSE);
	    }
	}
	else {
     	if ( toupper(strData[strData.GetLength()-2]) == 'B' &&
     		 strData.GetLength() == 19 ) {
	        for ( i = 1; i < 17; i++ ) {        
	            if ( '0' != strData[i] &&
	                 '1' != strData[i] &&
	                 'X' != toupper(strData[i]) ) {
	                return (FALSE);
	            }
	        }
	        for ( i = 1; i < 17; i++ ) {
	            if ( 'X' == toupper(strData[i]) ) {
	                return (TRUE);
	            }
	            else {
	                continue;
	            }
	        }
	        return (FALSE);
	    }
	    else {
	        // Hexidecimal code. (XF1X)
	        if ( 6 != strlen(strData) ) {
	            return (FALSE);
	        }
	        for ( int i = 1; i < 5; i++ ) { 
	            if ( !isxdigit(strData[i])  &&	                 
	                 'X' != toupper(strData[i]) ) {
	                return (FALSE);
	            }
	        }
	        
	        for ( i = 1; i < 5; i++ ) {
	            if ( 'X' == toupper(strData[i]) ) {
	                return (TRUE);
	            }
	            else {
	                continue;
	            }
	        }
	        return (FALSE);
	    }                     	
	}	    

}   // End of CSyntaxLib::IsWildcardData().


BOOL CSyntaxLib::IsEventData(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            
    char* pszStopStr;
    
    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    	
		lValue = strtol(pszArgv,&pszStopStr, 16);
    	_ltoa(lValue,pszArgv,16);    
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
	            return (FALSE);
	        }
	    }           
    
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                 
	
    if ( strlen(pszArgv) < 1 ) {
		m_nErrorID = DATA_OUT_OF_RANGE;
        return (FALSE);
    }

	if ( isDataByte ) {
		if ( strlen(pszArgv) > 2 ) {
			m_nErrorID = DATA_OUT_OF_RANGE;
	        return (FALSE);		
		}
	}                      
	else {
		if ( strlen(pszArgv) > 4 ) {
			m_nErrorID = DATA_OUT_OF_RANGE;
	        return (FALSE);		
		}	
	}
/*                 
    // Is "FF".
    if ( strlen(pszArgv) < 1 || strlen(pszArgv) > 2 ) {
		//Error handle
		m_nErrorID = DATA_OUT_OF_RANGE;
        return (FALSE);
    }   
*/
    return (TRUE);

}   // End of CSyntaxLib::IsEventData().


BOOL CSyntaxLib::IsListFrame(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );               
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    // Is "7FFF".
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x07FFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}   // End of CSyntaxLib::IsListFrame().

BOOL CSyntaxLib::IsPort(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     
                     
   	if ( 0 == stricmp(pszArgv, "0") ||
   	     0 == stricmp(pszArgv, "1") ||
       	 0 == stricmp(pszArgv, "2") || 
   	     0 == stricmp(pszArgv, "3") ||
       	 0 == stricmp(pszArgv, "4") || 
       	 0 == stricmp(pszArgv, "5") || 
   	     0 == stricmp(pszArgv, "6") ||
       	 0 == stricmp(pszArgv, "7") ) {
       	 return (TRUE);
   	}
   	else {
		//Error handle
		m_nErrorID = PORT_ERROR;
		return (FALSE);	 
   	}	

}   // End of CSyntaxLib::IsPort().


BOOL CSyntaxLib::IsBitNo(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "01234567".
    if ( 0 == stricmp(pszArgv, "0") ||
         0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ||
         0 == stricmp(pszArgv, "4") ||
         0 == stricmp(pszArgv, "5") ||
         0 == stricmp(pszArgv, "6") ||
         0 == stricmp(pszArgv, "7") ||
         0 == stricmp(pszArgv, "0x0") ||
         0 == stricmp(pszArgv, "0x1") ||
         0 == stricmp(pszArgv, "0x2") ||
         0 == stricmp(pszArgv, "0x3") ||
         0 == stricmp(pszArgv, "0x4") ||
         0 == stricmp(pszArgv, "0x5") ||
         0 == stricmp(pszArgv, "0x6") ||
         0 == stricmp(pszArgv, "0x7")) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}   // End of CSyntaxLib::IsBitNo().


BOOL CSyntaxLib::IsBitData(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "0|1".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x01ul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsBitData().


BOOL CSyntaxLib::IsByteData(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    long lValue;
    char* p = pszArgv;                

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {   
    	if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   

    // Is "FF".
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsByteData().


BOOL CSyntaxLib::IsCommand(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "command".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isalnum(*p) && '@' != *p && '$' != *p) {
            return (FALSE);
        }
        else {
            p++;
        }
    }
    return (TRUE);

}   // End of CSyntaxLib::IsCommand().


BOOL CSyntaxLib::IsGoMonitorTimer(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    UINT i; 
    long lValue;
    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
		if (2 == strlen(pszArgv)) return (FALSE);				    	
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    // Is "FF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x0FFul ) {
        return (FALSE);
    }
    else {    	
        return (TRUE);
    }

}   // End of CSyntaxLib::IsMonitorTimer().

//not modify
BOOL CSyntaxLib::IsDiagnosisOption(int nArgc, char* pszArgv[])
{
     // Assertion of the input parameters.
/*
    ASSERT( nArgc > 1 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    int nPio = FALSE;
    int nMap = FALSE;
	int nEventaddr = FALSE;
	int nEventdata = FALSE;
	int nSpoon = FALSE;
	int nEmulation = FALSE;
	int nTrace = FALSE;
	     
    for ( i = 1; i < nArgc; i++ ) {
        CString str = strupr(pszArgv[i]);
        if ( str == "PIO") {
			if (nPio == FALSE)
				nPio = TRUE;
			else 
				return (FALSE); 
        }
        else if (str == "MAP"){
      		if (nMap == FALSE)
      			nMap = TRUE;		  
			else 
				return (FALSE); 
        }
        else if (str == "EVENTADDR"){ 
        	if (nEventaddr == FALSE)
        		nEventaddr = TRUE;        	 
			else 
				return (FALSE); 
        }
        else if (str == "EVENTDATA"){
        	if (nEventdata == FALSE)
        		nEventdata = TRUE;        	 
			else 
				return (FALSE); 
        }
        else if (str == "SPOON"){
           	if (nSpoon == FALSE)
        		nSpoon = TRUE;        	 
			else 
				return (FALSE); 
		}
        else if (str == "EMULATION"){
           	if (nEmulation == FALSE)
	       		nEmulation = TRUE;        	 
			else 
				return (FALSE); 
        }
        else if (str == "TRACE"){
        	if (nTrace == FALSE)
        		nTrace = TRUE;        	 
			else 
				return (FALSE); 
        }
        else {
            return (FALSE);
        }
    } 
*/
    return (TRUE);
}


BOOL CSyntaxLib::IsMacroName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );      
    // Is "filename".
    if ( strlen(pszArgv) >= _MAX_PATH ) {
        return (FALSE);
    }

    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
        return (FALSE);
    }
      
    // Local driver: "..." invalid.
    // Netware driver: "..." valid.
    //if ( strstr(pszArgv, "...") ) {
    //    return (FALSE);
    //}
        
    if ( strstr(pszArgv, "\\\\") ||
         strstr(pszArgv, "//")   ||
         strstr(pszArgv, "\\/")  ||
         strstr(pszArgv, "/\\") ) {
        return (FALSE);
    }
    
    char pszDrive[_MAX_DRIVE];
    char pszDir[_MAX_DIR];
    char pszFname[_MAX_FNAME];
    char pszExt[_MAX_EXT];

    _splitpath(pszArgv, pszDrive, pszDir, pszFname, pszExt);

    if ( strchr(pszDir, ':')   ||
         strchr(pszFname, ':') ||
         strchr(pszExt, ':') ) {
        return (FALSE);
    }
    
    if ( *pszDrive && 
         !(*pszDrive >= 'A' && *pszDrive <= 'Z') &&
         !(*pszDrive >= 'a' && *pszDrive <= 'z') ) {
        return (FALSE);
    }
    
    if ( strchr(pszFname, '.') ) {
        return (FALSE);
    }                            
    
    if (strlen(pszFname) > 8 ) {
        return (FALSE);
    }                            
    
    if ( 0 == stricmp(pszFname, "ALL") && !*pszExt) {
		return (FALSE);    
    }
    
    if ( !*pszFname ) {
        return (FALSE);
    }
    
    return (TRUE);

}                    

BOOL CSyntaxLib::IsMacroVarName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	
    // Is "$xxx".
    if ( strlen(pszArgv) < 2 ) {
        return (FALSE);
    }
    
    if ( '$' != pszArgv[0] ) {
        return (FALSE);
    }

    if ( !iscsymf(pszArgv[1]) ) {
        return (FALSE);
    }

    if ( '_' == pszArgv[1] && strlen(pszArgv) < 3 ) {
        return (FALSE);
    }
    
    BOOL isUnderscore = FALSE;
    char* p = pszArgv+1;
    if ( '_' == *p ) {
        isUnderscore = TRUE;
    }
            
    while ( *p ) {
        if ( !iscsym(*p) && '?' != *p ) {
            return (FALSE);
        }
        else if ( '_' != *(p++) ) {
            isUnderscore = FALSE;
        }
    }

    if ( isUnderscore ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}

BOOL CSyntaxLib::IsCommandName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );         
 	if ( 20 < strlen(pszArgv) ) {
 		return (FALSE);
 	}                  
	
	char* p = pszArgv;
	while (*p) {
	    if ( !isalnum(*p)  ) {
            return (FALSE);
        }
		p++;
	} 	
    return (TRUE);
}    

BOOL CSyntaxLib::IsListFrameSub(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );               
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    // Is "7FFF".
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x07FFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}   // End of CSyntaxLib::IsListFrameSub().


BOOL CSyntaxLib::IsAddrLen(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "length".
  	char* p;  
  	ADDR_RETCODE retCode;
  	ADDRESS address;
  	p = new char [ strlen(pszArgv)+1 ];
  	ASSERT( p );
  	strcpy(p,pszArgv);
  	retCode = AdrTextToAddr(p, address,0);
  	if ( p ) {
  		delete []p;
  		p = 0;
  	}	
  	if (ADR_OK == retCode) {
		if (SPACE_UNDEFINE == address.adrSpace )
			return (TRUE);
		else {
			return (FALSE);	          		        
		}	
  	}
  	else {
		return (FALSE);	        
	}	
}


BOOL CSyntaxLib::IsAddrPX(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if ( IsPAddr(szArgv) || IsXAddr(szArgv) ) {
		return (TRUE);
	}
	else {
	    return (FALSE);
	}	                                          
}


BOOL CSyntaxLib::IsAddrPXI(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if ( IsXAddr(szArgv) || 
		 IsPAddr(szArgv) ||
		 IsIAddr(szArgv) ) {
		return (TRUE);
	}
	else {
	    return (FALSE);
	}	                                          
}

BOOL CSyntaxLib::IsListStatus(CString pszArgv)
{
    
	//List, Qualify has same status, not support status 'F'    
    
    // Is "S", "R", "AK" or "W".
    if ( 0 == stricmp(pszArgv, "S") ) {  
    	if ( !isStatusS ) {
    		isStatusS = TRUE;
    	}
    	else {
    		return FALSE;
    	}	
    }    	             
    else if ( 0 == stricmp(pszArgv, "R") ) {
    	if ( !isStatusR ) {
    		isStatusR = TRUE;
    	}
    	else {
    		return FALSE;
    	}	    
    }
    else if ( 0 == stricmp(pszArgv, "W") ) {
    	if ( !isStatusW ) {
    		isStatusW = TRUE;
    	}
    	else {
    		return FALSE;
    	}	    
    }
/*
	else if ( 0 == stricmp(pszArgv, "AK") ) {
		if ( !isStatusAK ) {
			isStatusAK = TRUE;
		}
		else {
			return FALSE;
		}		
	}
*/
    else {
        return (FALSE);
    }  
    return TRUE;                           
}    


BOOL CSyntaxLib::IsStatusOption(char* pszArgv)
{                                

    // Assertion of the input parameters.
    ASSERT( pszArgv );

	CString strStatus(pszArgv);           
	CString strToken("");
	int nLen = strStatus.GetLength();
	int nPos = 0;
	
	if ( strStatus[0] == '<' && strStatus[nLen-1] == '>' ) {
	    strStatus = strStatus.Right(nLen-1);
	    strStatus = strStatus.Left(nLen-2);
	    strStatus.TrimLeft();              
	    strStatus.TrimRight();
	    if ( strStatus.IsEmpty() ) {
	    	return FALSE;
	    }
	    for (;;) {
	    	nPos = strStatus.Find(' ');
	    	if ( nPos == -1 ) {   
	    		if ( IsListStatus(strStatus) ) {
	    			return TRUE;
	    		}               
	    		else {
	    			return FALSE;
	    		}     		    		
	    	}                    
	    	else {
	    		strToken = strStatus.Left(nPos);
			    if ( !IsListStatus(strToken) ) {
			    	return FALSE;
			    }	 				    			    
			    strStatus = strStatus.Right(strStatus.GetLength()-nPos-1);
			    strStatus.TrimLeft();
	    	}                        
	    }	    
	}
	else {
		return FALSE;
	}    
}                      
            

BOOL CSyntaxLib::IsPAddr(char* pszArgv)
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
	
	retCode = AdrTextToAddr(pszArgv, address);
	if (ADR_OK != retCode) {
		return FALSE;
	}               
	if ( address.adrSpace >= SPACE_P0 && address.adrSpace <= SPACE_P3 ) {
		return TRUE;
	}               	
	
	return FALSE;	
}

BOOL CSyntaxLib::IsXAddr(char* pszArgv)
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
	
	retCode = AdrTextToAddr(pszArgv, address);
	if (ADR_OK != retCode) {
		return FALSE;
	}               
	if ( address.adrSpace >= SPACE_X0 && address.adrSpace <= SPACE_X3 ) {
		return TRUE;
	}               	
	
	return FALSE;	
}                   


BOOL CSyntaxLib::IsIAddr(char* pszArgv)
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
	
	retCode = AdrTextToAddr(pszArgv, address);
	if (ADR_OK != retCode) {
		return FALSE;
	}               
	if ( SPACE_I == address.adrSpace ) {
		return TRUE;
	}               	
	
	return FALSE;	
}                   
                               
BOOL CSyntaxLib::IsAddrDefault(char* pszArgv)
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
	
	retCode = AdrTextToAddr(pszArgv, address);
	if (ADR_OK != retCode) {
		return FALSE;
	}               
	if ( address.adrSpace == SPACE_UNDEFINE ) {
		return TRUE;
	}               	
	
	return FALSE;	
}

                    
BOOL CSyntaxLib::IsStepReg(char* pszArgv) 
{
	if ( pszArgv[0] != '@' ) {
		return FALSE;
	}
	else {
		if ( IsRegName(pszArgv+1) ) {	
			return TRUE;
		}
		else {	     
			return FALSE;
		}	
	}	
}


BOOL CSyntaxLib::IsMultipleAddr(char* pszArgv)
{
	CString strAddr(pszArgv);           
	CString strToken("");
	int nLen = strAddr.GetLength();
	int nPos = 0;    
	int nNum = 0;

	// modify by richard to enable user to input one address without <> 9/5	
	if ( strAddr[0] == '<' && strAddr[nLen-1] == '>' ) {
	    strAddr = strAddr.Right(nLen-1);
	    strAddr = strAddr.Left(nLen-2);
	    strAddr.TrimLeft();              
	    strAddr.TrimRight();
	}
	else{
		strAddr.TrimLeft();
		strAddr.TrimRight();
	}
	
	    if ( strAddr.IsEmpty() ) {
	    	return FALSE;
	    }                                
	    for (;;) {
	    	nPos = strAddr.Find(' ');
	    	if ( nPos == -1 ) {   
	    		if ( IsPAddr((char*)(const char*)strAddr) 
	    			 /*|| IsAddrDefault((char*)(const char*)strAddr)*/ ) {
	    			if ( nNum >= 10 ) {
	    				return FALSE;
	    			}
	    			else {	
	    				return TRUE;
	    			}	
	    		}               
	    		else {
	    			return FALSE;
	    		}     
	    	}                    
	    	else {
	    		strToken = strAddr.Left(nPos);
			    if ( !IsPAddr((char*)(const char*)strToken) /*&&
			    	 !IsAddrDefault((char*)(const char*)strToken)*/ ) {
			    	return FALSE;
			    }	 
			    strAddr = strAddr.Right(strAddr.GetLength()-nPos-1);
			    strAddr.TrimLeft();
			    nNum++;
	    	}                        
	    }	    
//    }                
//    else {
//    	return FALSE;
//    }
}                                                   
                                
DWORD CSyntaxLib::GetAddrValue(ADDRESS addr)
{
	if ( addr.adrSpace == SPACE_I || addr.adrSpace == SPACE_UNDEFINE ) {
		return addr.adrAddress;
	}                        
	else if ( addr.adrSpace == SPACE_P0 || addr.adrSpace == SPACE_X0 ) {
		return addr.adrAddress;	
	}                          
	else if ( addr.adrSpace == SPACE_P1 || addr.adrSpace == SPACE_X1 ) {		
		return (addr.adrAddress + 0x10000);	
	}                          
	else if ( addr.adrSpace == SPACE_P2 || addr.adrSpace == SPACE_X2 ) {		
		return (addr.adrAddress + 0x20000);	
	}                          
	else if ( addr.adrSpace == SPACE_P3 || addr.adrSpace == SPACE_X3 ) {		
		return (addr.adrAddress + 0x30000);	
	}                          
	else {
		return 0;
	}	
}	

BOOL CSyntaxLib::IsFillDataRange(int nPos, char* pszArgv[], BOOL isAddr)
{                                    

	ADDRESS address1, address2;         
	DWORD dwAddr1, dwAddr2;
	int nCount = 0;
	
    // Check the Data field range.
	char* p;
	
	p = pszArgv[nPos];		
    
    if ( '\"' == *p ) {
    	nCount = strlen(p)-2;
    }                      
    else {
	    while ( *p ) {
	        if ( ' ' == *p ) {
	            nCount++;
	        }
	        p++;
	    }
	}
	
    // Convert symbol to standard address format.           
    unsigned long ul;
    if ( isAddr ) {
	    AdrShellToAddr(pszArgv[1], address1/*, SPACE_X0*/);		    
	    AdrShellToAddr(pszArgv[2], address2);
	    
	    if ( address2.adrSpace == SPACE_UNDEFINE ) {
	    	address2.adrSpace = address1.adrSpace;	
	    }		    
		dwAddr1 = GetAddrValue(address1);			
		dwAddr2 = GetAddrValue(address2);				              
	    ul = dwAddr2 - dwAddr1 + 1;  
	}                   
    else {	    
	    AdrShellToAddr(pszArgv[3], address1);
	    ul = address1.adrAddress;	        
	}                

    if ( ul < (unsigned long)(nCount) ) {
        return (FALSE);
    }                               
    
    return (TRUE);

}   // End of CSyntaxLib::IsFillDataRange().


BOOL CSyntaxLib::IsLoadBank(char* pszArgv) 
{
	int nBankInfo = GetBankInfo();
	if ( nBankInfo == COMB1 ) {
		if ( 0 != stricmp(pszArgv, g_pszKeywordP0) ) {
			return (FALSE);
		}
	}                        
	else if ( nBankInfo == SEPB1 ) {
		if ( 0 != stricmp(pszArgv, g_pszKeywordX0) &&
			 0 != stricmp(pszArgv, g_pszKeywordP0) ) {
			return (FALSE);
		}	
	}
    else if ( nBankInfo == COMB2 ) {
		if ( 0 != stricmp(pszArgv, g_pszKeywordP0) && 
			 0 != stricmp(pszArgv, g_pszKeywordP1) ) {
			return (FALSE);
		}
	}              
	else if ( nBankInfo == SEPB2 ) {
		if ( 0 != stricmp(pszArgv, g_pszKeywordX0) &&
			 0 != stricmp(pszArgv, g_pszKeywordX1) &&
			 0 != stricmp(pszArgv, g_pszKeywordP0) &&
			 0 != stricmp(pszArgv, g_pszKeywordP1) ) {
			return (FALSE);
		}	
	}
    else if ( nBankInfo == COMB4 ) {
		if ( 0 != stricmp(pszArgv, g_pszKeywordP0) && 
			 0 != stricmp(pszArgv, g_pszKeywordP1) &&
			 0 != stricmp(pszArgv, g_pszKeywordP2) && 
			 0 != stricmp(pszArgv, g_pszKeywordP3) ) {
			return (FALSE);
		}
	}              
                  
	return (TRUE);                  
}


#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

void WINAPI DllGetMemoryRange(CPUMEMORYRANGE& cmr) 
{

    //CPUMEMORYRANGE stRange;

    GetMemoryRange(cmr); 

}

int WINAPI DllGetMemMode(void)
{   
	//0:COM, 1:SEP                  
	return g_nMemMode;
}                     

int WINAPI DllGetBankNumber(void)
{                      
	//0: 1 BANK, 1: 2 BANKS, 2: 4BANKS
	return g_nBankNumber;
}                     


#ifdef __cplusplus
}
#endif	// __cplusplus

//////////////////////////////// End of File ////////////////////////////////
