/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.H
//
//  Description: The header file for the class: CSyntaxLib.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLib.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNLIB_
#define _SYNLIB_

#include "syntest.h"   

/////////////////////////////////////////////////////////////////////////////
// CSyntaxLib class.
class CSyntaxLib : public CSyntaxTest
{
// Construction & Destruction.
public:
    CSyntaxLib();
    ~CSyntaxLib();
    
// Member variables.
private:
    // Local macro definition.
    enum { MAX_FILL_SIZE = 32 };
    
	BOOL isStatusS;
	BOOL isStatusW;
	BOOL isStatusR;
	BOOL isStatusF;
	BOOL isStatusAK;

protected:
    enum { NO_ERROR          = 0,
    	   NOT_SHOW_ERROR 		=1,
           NO_COMMAND 			=2,
           NO_SUCH_COMMAND		=3,
           SYNTAX_ERROR			=4,           
    	   ADDR_OUT_OF_RANGE	=5,
           LEN_OUT_OF_RANGE		=6,
           LEN_ERROR			=7,
           ADDR_ERROR			=8,	
           ADDR_TYPE_ERROR		=9,
           ADDR_MAP_ERROR		=10,
           MAP_ATTR_ERROR		=11,
           REG_ERROR			=12,
           DATA_OUT_OF_RANGE	=13,
           DATA_ERROR			=14,                      
           FILE_NAME_ERROR		=15,
           MODULE_NAME_ERROR	=16,            
		   VARIABLE_NAME_ERROR	=17,      
		   SYMBOL_NAME_ERROR	=18, 
		   COUNT_ERROR			=19,   
		   COUNT_OUT_OF_RANGE	=20,  	           
		   PORT_ERROR			=21,
	       ADDR_FORMATERROR		=22,       
	       ADDR_NOSYMBOL		=23,	                               	
	       ADDR_COMPERROR		=24,     
	       ADDR_OVERFLOW		=25,     
	       ADDR_EMPTY			=26,     
		   STATUS_ERROR			=27,			   
           NO_TRACE_BOARD		=28,
           MAX_ERROR         = 100
    };
                 
    int m_nErrorID;             

public:
	BOOL isDataByte;

// Implementations.
public:                           
    unsigned long StrToVar(char* pszStr) ;
    void VarToStr(unsigned long ulVar, char* pszStr) ;

    // Syntax check lib routine.                              
    BOOL ConvertAddress(char* pszArgv1, char* pszArgv2, int &nRet, int space=1) ;
    void ConvertLen(char* pszArgv1, char* pszArgv2) ;                                            
    BOOL IsAddr(char* pszArgv) ;         
    BOOL IsPAddr(char* pszArgv) ;    
    BOOL IsXAddr(char* pszArgv) ;    
    BOOL IsIAddr(char* pszArgv) ;    
	BOOL IsAddrPX(char* pszArgv) ;		
	BOOL IsAddrPXI(char* pszArgv) ;     
	
    BOOL IsAddrLen(char* pszArgv, int &nRet) ;
    BOOL IsKeywordLength(char* pszArgv) ;
    BOOL IsLengthRange(char* pszAddr, char* pszLen, int &nRet) ;
    BOOL IsLengthRange(char* pszAddr, char* pszLen, char* pszTarget, int &nRet) ;
    BOOL IsAddrRange(char* pszAddr1, char* pszAddr2) ;
    BOOL IsAddrRange(char* pszAddr1, char* pszAddr2, char* pszAddr3) ;
    
    BOOL IsMapStartAddr(char* pszArgv) ;
    BOOL IsMapEndAddr(char* pszArgv) ;
    BOOL IsMapAddrLen(char* pszArgv) ;
    BOOL IsMapMemType(char* pszArgv) ;
	BOOL IsMapAttr(char chType, char* pszArgv) ;    
	
    BOOL IsRegName(char* pszRegName) ;
    BOOL IsRegData(char* pszRegName, char* pszRegData) ;
    
    BOOL IsKeywordAll(char* pszArgv) ;
    
    BOOL IsFilename(char* pszArgv, int &nRet) ;
    
    BOOL IsVariableName(char* pszArgv) ;
    BOOL IsSymbolName(char* pszArgv) ;
	BOOL IsMacroVarName(char* pszArgv) ;
	    
    BOOL IsData(char* pszArgv) ;
    BOOL IsDataWord(char* pszArgv) ;
    BOOL IsDataLong(char* pszArgv) ;
    BOOL IsString(char* pszArgv) ;
    BOOL IsDataRange(int nArgc, char* pszArgv[], int nDigit) ;
    BOOL IsKeywordInsensitive(char* pszArgv) ;
    
    BOOL IsKeywordRun(char* pszArgv) ;
    BOOL IsKeywordFrom(char* pszArgv) ;
    BOOL IsKeywordTill(char* pszArgv) ;
    
    BOOL IsKeywordOver(char* pszArgv) ;
    BOOL IsKeywordForever(char* pszArgv) ;
    BOOL IsAddrData(char* pszArgv) ;
    
    BOOL IsKeywordLines(char* pszArgv) ;
    
    BOOL IsKeywordClear(char* pszArgv) ;
    
    BOOL IsKeywordRange(char* pszArgv) ;
    BOOL IsWildcardAddr(char* pszArgv) ;
    BOOL IsWildcardData(char* pszArgv) ;
    BOOL IsEventData(char* pszArgv) ;
    
    BOOL IsListFrame(char* pszArgv) ;
    
    BOOL IsKeywordOn(char* pszArgv) ;
    BOOL IsKeywordOff(char* pszArgv) ;

    BOOL IsKeywordEnable(char* pszArgv) ;
    BOOL IsKeywordDisable(char* pszArgv) ;
    BOOL IsKeywordBit(char* pszArgv) ;
    BOOL IsKeywordByte(char* pszArgv) ;

    BOOL IsPort(char* pszArgv) ;
    BOOL IsBitNo(char* pszArgv) ;
    BOOL IsBitData(char* pszArgv) ;
    BOOL IsByteData(char* pszArgv) ;
    
    BOOL IsKeywordGlobal(char* pszArgv) ;

    BOOL IsKeywordClose(char* pszArgv) ;
    BOOL IsKeywordAppend(char* pszArgv) ;
    BOOL IsKeywordCommand(char* pszArgv) ;

    BOOL IsKeywordDelay(char* pszArgv) ;
    
    BOOL IsKeywordModule(char* pszArgv) ;
    
    BOOL IsCommand(char* pszArgv) ;
    
    BOOL IsKeywordMonitor(char* pszArgv) ;
    BOOL IsGoMonitorTimer(char* pszArgv) ;

    BOOL IsKeywordControlOption(char* pszArgv) ;

    BOOL IsDiagnosisOption(int nArgc, char* pszArgv[]) ;
	
	BOOL IsMacroName(char* pszArgv) ;
	BOOL IsCommandName(char* pszArgv) ;        
	
	BOOL IsKeywordNumber(char* pszArgv) ;

	BOOL IsAddrLen(char* pszArgv) ;

	BOOL IsKeywordAddress(char* pszArgv) ;
	BOOL IsKeywordDatum(char* pszArgv) ;
	BOOL IsKeywordCount(char* pszArgv) ;

	BOOL IsKeywordSymbols(char* pszArgv) ;
	BOOL IsKeywordNosymbols(char* pszArgv) ;
	BOOL IsKeywordCode(char* pszArgv) ;
	BOOL IsKeywordNocode(char* pszArgv) ;
	BOOL IsKeywordWarn(char* pszArgv) ;
	BOOL IsKeywordNowarn(char* pszArgv) ;	
	BOOL IsListFrameSub(char* pszArgv) ; 

	BOOL IsKeywordStatus(char* pszArgv) ;		
	BOOL IsStatusOption(char* pszArgv) ;
	BOOL IsKeywordSystem(char* pszArgv) ;
	BOOL IsKeywordNosystem(char* pszArgv) ;
	BOOL IsStepReg(char* pszArgv) ;  
	
	BOOL IsMultipleAddr(char* pszArgv) ;           	
	BOOL IsListStatus(CString pszArgv) ;
	BOOL IsKeywordByteOrWord(char* pszArgv) ;	
    BOOL IsKeywordHigh(char* pszArgv) ;
    BOOL IsKeywordLow(char* pszArgv) ;
	BOOL IsEventSequence(char* pszArgv) ;	
	BOOL IsKeywordLv1(char* pszArgv) ;
	BOOL IsKeywordLv2(char* pszArgv) ;
	BOOL IsKeywordThen(char* pszArgv) ;
	BOOL IsKeywordForBackCen(char* pszArgv) ;
	BOOL IsAddrDefault(char* pszArgv) ;	
	BOOL IsKeywordOut(char* pszArgv) ;
	
	DWORD GetAddrValue(ADDRESS addr) ;	
	BOOL IsFillDataRange(int nArgc, char* pszArgv[], BOOL isAddr) ;	                                 
	BOOL IsLoadBank(char* pszArgv) ;	
	BOOL IsDelayCount(char* pszArgv) ; 
	BOOL IsEv1Count(char* pszArgv) ;
	BOOL IsKeywordOverlay(char* pszArgv) ;
	BOOL IsKeywordTarget(char* pszArgv) ;
	BOOL IsKeywordCombination(char* pszArgv) ;
	BOOL IsKeywordSeparation(char* pszArgv) ;			

};  // End of class: CSyntaxLib.

#endif
//////////////////////////////// End of File ////////////////////////////////
