/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNTAX.H
//
//  Description: The header file for the class: CSyntaxCheck.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxCheck.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNTAX_
#define _SYNTAX_

#include "syncore.h"
                      
/////////////////////////////////////////////////////////////////////////////
// CSyntaxCheck class.
class CSyntaxCheck : public CSyntaxCore
{
// Construction & Destruction.
public:
    CSyntaxCheck();
    ~CSyntaxCheck();
    
// Member variables.
private:
//	int m_nEvent;    

protected:
    // Local macro definition.
    enum { MIN_KEY = 0x20, MAX_KEY = 0x7F, TOKEN_KEY = 0x20, KEY_DQ = 0x22 };
    
    enum { MAX_FILL_SIZE = 32 };
    
    // Receive from the Shell command line.
    int m_nLen;
    char m_pchLineBuf[MAX_CMDLINE+1];

    // Command ID.
    //int m_nCommandID;
    
// Implementations.
//private:    
protected:                                
	void SetSyntaxColorRunMacro(int nPos, int& nArgc, SynColor syncolor[]);                                                                           
	void SetSyntaxColorVarDefine(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorAlias(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorAssemble(int nPos, int& nArgc, SynColor syncolor[]);
//	void SetSyntaxColorBit(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorBreakpoint(int nPos, int& nArgc, SynColor syncolor[]); 
	void SetSyntaxColorByte(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorChecksum(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorClear(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorCompare(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorControl(int nPos, int& nArgc, SynColor syncolor[]);
//  void SetSyntaxColorCopy(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorCycle(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDisassemble(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDiagnosis(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv1(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv2(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv3(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEvent(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorFill(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorGo(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorHalt(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorHelp(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorIdentify(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorInclude(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorInport(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorJump(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLevel(int nPos, int& nArgc, SynColor syncolor[]); 
	void SetSyntaxColorList(int nPos, int& nArgc, SynColor syncolor[]);  
	void SetSyntaxColorLog(int nPos, int& nArgc, SynColor syncolor[]);  
	void SetSyntaxColorLong(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLv1(int nPos, int& nArgc, SynColor syncolor[]); 
	void SetSyntaxColorLv2(int nPos, int& nArgc, SynColor syncolor[]); 
	void SetSyntaxColorMacro(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMap(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMdel(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMemory(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMend(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMlist(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorOutport(int nPos, int& nArgc, SynColor syncolor[]); 
	void SetSyntaxColorQualify(int nPos, int& nArgc, SynColor syncolor[]); 
//	void SetSyntaxColorPort(int nPos, int& nArgc, SynColor syncolor[]);	
	void SetSyntaxColorRegister(int nPos, int& nArgc, SynColor syncolor[]);	
	void SetSyntaxColorReset(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorRestart(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorSearch(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorStep(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTest(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTrace(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTrigger(int nPos, int& nArgc, SynColor syncolor[]); 
	void SetSyntaxColorUpload(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorVerify(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorWord(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorCreate(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDelete(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLoad(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorQuery(int nPos, int& nArgc, SynColor syncolor[]);		                                                       
	void SetSyntaxColorSsave(int nPos, int& nArgc, SynColor syncolor[]);			                                                       
	void SetSyntaxColorSrecall(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorSymbol(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorWatch(int nPos, int& nArgc, SynColor syncolor[]);
	
	void SetSyntaxColorInit(int& nArgc, SynColor syncolor[]);		           

public:
    // Syntax check common routine.
    void CopyCommandLine(const char* pchEditBuf, const int nLen);
    BOOL CommandParse(void);
    BOOL CommandParseSub(void);
    BOOL CheckCommandKeyword(BOOL isSub = FALSE);
    void DisplaySyntaxError(void) const;
    void DispatchCommand(void);

public:                                                                                    
	BOOL CheckCommandSyntax(const char* pchEditBuf, const int nLen);
    BOOL CheckCommandSyntax(const char* pchEditBuf, const int nLen, int& nPos);
	void SetSyntaxColor(int nPos, int& nArgc, SynColor syncolor[]);	
	
};  // End of class: CSyntaxCheck.

#endif
//////////////////////////////// End of File ////////////////////////////////
