/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNTEST.H
//
//  Description: The header file for the class: CSyntaxTest.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxTest.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNTEST_
#define _SYNTEST_


/////////////////////////////////////////////////////////////////////////////
// CSyntaxTest class.
class CSyntaxTest
{
// Construction & Destruction.
public:
    CSyntaxTest();
    ~CSyntaxTest();
    
// Member variables.
protected:
    BOOL m_isServer;

// Implementations.
protected:
    void ShowLine(char* pszBuffer) const;
    void DelayOneSecond(void) const;

#ifdef _SERVER_TEST
    inline void DumpText(const char* pszDumpText) const
    {
        AfxMessageBox(pszDumpText);
    };
    inline void DumpVar(const int nVar) const
    {                                            
        char pszBuffer[18];
        AfxMessageBox(_itoa(nVar, pszBuffer, 10));
    };    
    inline void DumpVar(const unsigned long ulVar) const
    {                                            
        char pszBuffer[34];
        AfxMessageBox(_ultoa(ulVar, pszBuffer, 10));
    };    
#else
    inline void DumpText(const char* /* pszDumpText */) const {};
    inline void DumpVar(const int /* nVar */) const {};
    inline void DumpVar(const unsigned long /* ulVar */) const {};
#endif  // _SERVER_TEST

};  // End of class: CSyntaxTest.

#endif
//////////////////////////////// End of File ////////////////////////////////
