/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/BRWFRM.CPP   1.0   15 Aug 1997 14:03:40   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/BRWFRM.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:40   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:16   ZJRD
** 1.0c
** 
****************************************************************************/

// brwfrm.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcgbl.h"
#include "srcaddr.h"

#include "srcdata.h"
#include "srctext.h"
#include "srcbar.h"
#include "brwfrm.h"
#include "srcdoc.h"
#include "srcview.h"
#include "srcsrch.h"

#include "flttool.h"
#include "abiextfn.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBrowseFrame

IMPLEMENT_DYNCREATE(CBrowseFrame, CMDIChildWnd)

#define new DEBUG_NEW

/////////////////////////////////////////////////////////////////////////////
// Exported function

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

CMDIChildWnd* WINAPI SrcGetBrowseWindow()
{
	// Point to Browse window
	return ::pBrowseWnd;
}

BOOL WINAPI SrcIsBrowseWindowOpened()
{
	// Is it opening?
	return (0 != ::pBrowseWnd);
}

void WINAPI SrcOpenBrowseWindow()
{
	// Check CPU status
	DWORD dwStatus;
	if ( ICE_OK != ::emuGetCpuStatus(&dwStatus) || (dwStatus & 0x10) ) {
		::SrcDisplayErrorMessage(::errEPRun);
		return;
	}

	// Open Browse window
    ASSERT(!::pBrowseWnd);
	::pBrowseTemplate->OpenDocumentFile(NULL);
	
	// Update Browse window
    ASSERT(::pBrowseWnd);
	((CBrowseFrame*)::pBrowseWnd)->UpdateBrowseWindow(::brwOpen);
}

void WINAPI SrcCloseBrowseWindow()
{
    // Close Browse window
    ASSERT(::pBrowseWnd);
    ::pBrowseWnd->SendMessage(WM_CLOSE);
}

void WINAPI SrcUpdateBrowseWindow(int nMode, const BOOL bOpenFirst /* = FALSE */)
{
	// Check CPU status
	DWORD dwStatus;
	if ( ICE_OK != ::emuGetCpuStatus(&dwStatus) || (dwStatus & 0x10) ) {
//		::SrcDisplayErrorMessage(::errEPRun);
		return;
	}

	// Open browse window first
	if ( bOpenFirst ) {
		if ( !::pBrowseWnd ) {
			::pBrowseTemplate->OpenDocumentFile(NULL);
			nMode = ::brwOpen;
		}
		if ( ::pBrowseWnd->IsIconic() ) {
        	::pBrowseWnd->ShowWindow(SW_RESTORE);
        }
		::pBrowseWnd->BringWindowToTop();
	}

	// Browse window is opened
    if ( ::pBrowseWnd ) {
		// Update wizard bar
		if ( ::brwOpen == nMode ) {
			::SrcUpdateBrowseWizardBar(FALSE, TRUE, FALSE, FALSE, TRUE);
		}
		else {
			::SrcUpdateBrowseWizardBar(FALSE, FALSE, TRUE, TRUE, FALSE);
		}
	
		// Update Browse window
		((CBrowseFrame*)::pBrowseWnd)->UpdateBrowseWindow(nMode);
	}
}

#ifdef __cplusplus
}
#endif	// __cplusplus

/////////////////////////////////////////////////////////////////////////////
// Public function

void SrcUpdateBrowseWizardBar(const BOOL& bInitBar, const BOOL& bGetModule, const BOOL& bSelModule, const BOOL& bGetInfo, const BOOL& bRedrawProp)
{
	bInitBar;
	bGetModule;
	bSelModule;
	bGetInfo;
	bRedrawProp;

	// Update wizard bar
//	((CBrowseFrame*)::pBrowseWnd)->GetWizardBar()->UpdateWizardBar(bInitBar, bGetModule, bSelModule, bGetInfo, bRedrawProp, TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// CBrowseFrame

CBrowseFrame::CBrowseFrame()
{
	// Point to the Browse window
	::pBrowseWnd = this;
}

CBrowseFrame::~CBrowseFrame()
{
	// Point to NULL
	::pBrowseWnd = 0;
}


BEGIN_MESSAGE_MAP(CBrowseFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CBrowseFrame)
	ON_WM_GETMINMAXINFO()
	ON_WM_MDIACTIVATE()
	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_CBN_SELCHANGE(IDC_COMBO_SRC_WIZARDBAR_MODULE, OnSelchangeComboSrcWizardbarModule)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CBrowseFrame common routine

void CBrowseFrame::UpdateBrowseWindow(const int nMode)
{
	// Update Browse view
	((CSourceView*)GetActiveView())->SetBrowseMode(TRUE);
	((CSourceView*)GetActiveView())->UpdateBrowseWindow(nMode);
}


/////////////////////////////////////////////////////////////////////////////
// CBrowseFrame message handlers

void CBrowseFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	// TODO: Add your message handler code here and/or call default
	
    // Set the minimum range
//    CRect rect(0,0,0,34);
    CRect rect(0,0,0,0);
    if ( m_wndWizardBar.GetSafeHwnd() ) {
    	m_wndWizardBar.GetWindowRect(rect);
    }

    int xMin = 23*8 + ::GetSystemMetrics(SM_CXVSCROLL);
    int yMin = 4*13 + rect.Height() + ::GetSystemMetrics(SM_CYHSCROLL) + ::GetSystemMetrics(SM_CYCAPTION) + ::GetSystemMetrics(SM_CYFRAME) + 2;
    lpMMI->ptMinTrackSize = CPoint(xMin, yMin);

	CMDIChildWnd::OnGetMinMaxInfo(lpMMI);
}

void CBrowseFrame::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd) 
{
	CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
	
	// TODO: Add your message handler code here

	// Update toolbar
    if ( bActivate && this == pActivateWnd ) {
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate), LONG(WID_BROWSE));
    }
    else if ( !bActivate && !pActivateWnd ) {
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate));
    }
}

void CBrowseFrame::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	
	// Close search dialog
    if ( ::pSrcSearchDlg && !::pBrowseWnd ) {
    	::pSrcSearchDlg->SendMessage(WM_COMMAND, IDCANCEL);
    }

	CMDIChildWnd::OnClose();
}

int CBrowseFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
    // Create Wizard Bar
//	if ( !m_wndWizardBar.Create(this, IDD_SRC_WIZARDBAR, CBRS_TOP, IDD_SRC_WIZARDBAR) ) {
//		TRACE0("Failed to create wizard bar\n");
//		return -1;
//	}
//	else {
//		::SrcUpdateBrowseWizardBar(TRUE, TRUE, FALSE, FALSE, TRUE);
//	}

	return 0;
}

void CBrowseFrame::OnSelchangeComboSrcWizardbarModule()
{
	// TODO: Add your control notification handler code here
	
	// Set Browse index
	CComboBox* pCombo = (CComboBox*)(m_wndWizardBar.GetDlgItem(IDC_COMBO_SRC_WIZARDBAR_MODULE));
	int nSelect(-1);
	if ( pCombo->GetCount() >= 1 ) {
		nSelect = pCombo->GetCurSel();
	}
	::SrcAddModuleDesc(nSelect);

	// Browse one module
	::g_nSrcGroupEntry = ::SRC_BROWSE;
	::SrcBrowseModule();

    // Set focus to view
	GetActiveView()->SetFocus();
}
