/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCBAR.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCBAR.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:08   ZJRD
** 1.0c
** 
****************************************************************************/

// srcbar.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcgbl.h"
#include "srcbar.h"       
#include "srcview.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Static variable

static int BASED_CODE nID[] = { IDC_PROP, IDC_COMBO_SRC_WIZARDBAR_MODULE };
static char BASED_CODE szFormat[] = "    %B %d, %Y    %H:%M:%S";
static char BASED_CODE szConvert[] = "    %02d/%02d/%02d --- %02d:%02d:%02d";

/////////////////////////////////////////////////////////////////////////////
// CSourceWizardBar

IMPLEMENT_DYNAMIC(CSourceWizardBar, CDialogBar)

BEGIN_MESSAGE_MAP(CSourceWizardBar, CDialogBar)
	//{{AFX_MSG_MAP(CSourceWizardBar)
	ON_WM_MOUSEMOVE()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceWizardBar common routines

void CSourceWizardBar::UpdateWizardBar(const BOOL& bInitBar, const BOOL& bGetModule, const BOOL& bSelModule, const BOOL& bGetInfo, const BOOL& bRedrawProp, const BOOL& bHideProp /* = FALSE */)
{
	// Initial wizard bar
	if ( bInitBar ) {
		InitBar();
	}
	
	// Hide Property button in Browse window
	if ( bHideProp ) {
		m_btnProp.DestroyWindow();
	}

	// Get module info
	if ( bGetModule ) {
		GetModule();
	}
	
	// Select module
	if ( bSelModule ) {
		SelModule();
	}
	
	// Update info static
	if ( bGetInfo ) {
		GetInfo();
	}
	
	// Update Property button
	if ( !bHideProp && bRedrawProp ) {
		RedrawProp();
	}
}

void CSourceWizardBar::InitBar()
{
	// Set list-box font
    HFONT hFont = (HFONT)::GetStockObject(ANSI_FIXED_FONT);
    CFont font;
	GetDlgItem(IDC_COMBO_SRC_WIZARDBAR_MODULE)->SetFont(font.FromHandle(hFont));

	// Attach the CBitmapButton to the dialog control
	VERIFY(m_btnProp.SubclassDlgItem(IDC_PROP, this));

	// Load resource from this DLL
	HINSTANCE hInstEXE = AfxGetResourceHandle();
	AfxSetResourceHandle(::SrcGetDLLHandle());

	// Load icon: doc.ico
	m_hIcon = AfxGetApp()->LoadIcon(IDI_MASK);	// IDI_DOC

    // Restore the old resource chain
	AfxSetResourceHandle(hInstEXE);
}

void CSourceWizardBar::RedrawProp()
{
	// Load resource from this DLL
	HINSTANCE hInstEXE = AfxGetResourceHandle();
	AfxSetResourceHandle(::SrcGetDLLHandle());

	// Load bitmap
	if ( ::bSrcHintsOn ) {
		m_btnProp.LoadBitmaps("PROPD", NULL, NULL, "PROPU");
	}
	else {
		m_btnProp.LoadBitmaps("PROPU", NULL, NULL, "PROPU");
	}

    // Restore the old resource chain
	AfxSetResourceHandle(hInstEXE);

	// Update this button
	m_btnProp.InvalidateRect(NULL);
	m_btnProp.UpdateWindow();
}

void CSourceWizardBar::GetModule()
{
	// Remove module combo-box
	((CComboBox*)GetDlgItem(IDC_COMBO_SRC_WIZARDBAR_MODULE))->ResetContent();

	// Enable control
	BOOL bEnable = ::SrcIsLoadedSymbol();
	GetDlgItem(IDC_COMBO_SRC_WIZARDBAR_MODULE)->EnableWindow(bEnable);

	// Get Module info
	if ( bEnable ) {
		GetModuleInfo();
	}
}

void CSourceWizardBar::SelModule()
{
	// Set combo-box
	BOOL bBrowse = ((CSourceView*)(((CFrameWnd*)GetParent())->GetActiveView()))->IsBrowse();
	((CComboBox*)GetDlgItem(IDC_COMBO_SRC_WIZARDBAR_MODULE))->SetCurSel(::SrcGetModuleIndex(bBrowse));
}

void CSourceWizardBar::GetInfo()
{
	// Set bitmap
	((CStatic*)GetDlgItem(IDC_STATIC_SRC_WIZARDBAR_DOC))->SetIcon(m_hIcon);
	
	// Set static
	CString strInfo;
	GetFileInfo(strInfo);
	((CStatic*)GetDlgItem(IDC_STATIC_SRC_WIZARDBAR_MODULE))->SetWindowText(strInfo);
}

void CSourceWizardBar::GetModuleInfo()
{
	// Get module info from Symbol server
	CStringList* pModuleList = new CStringList;
	::SrcGetModuleList(pModuleList);

	// Add to the list box
	CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_SRC_WIZARDBAR_MODULE);
	pCombo->ResetContent();
	POSITION pos = pModuleList->GetHeadPosition();
	while ( pos ) {
		pCombo->AddString(pModuleList->GetNext(pos));
	}

	// No selection
	pCombo->SetCurSel(-1);

	// Free module info list
	pModuleList->RemoveAll();
	delete pModuleList;
}

void CSourceWizardBar::GetFileInfo(CString& strInfo)
{
	// Info: C:\EP251\SAMPLE\PRIME\PRIME1.C    March 19, 1997    08:23:32
	strInfo = "";

	// Get module name
	SYM_DESCRIPTOR dwModuleDesc;
	BOOL bBrowse = ((CSourceView*)(((CFrameWnd*)GetParent())->GetActiveView()))->IsBrowse();
	if ( ::SrcGetModuleDesc(bBrowse, dwModuleDesc) ) {
		CString strModule;
		if ( ::SrcGetModuleName(dwModuleDesc, strModule) ) {
			// Get module path
			CString strPath, strTime;
			if ( ::SrcGetModulePath(strModule, strPath) ) {
				// Get date & time
				CFileStatus rStatus;
				if ( CFile::GetStatus(strPath, rStatus) ) {
					//strTime = rStatus.m_mtime.Format(::szFormat);		// binding MFC library
					//strTime = Format(rStatus.m_mtime, ::szFormat);	// using MFC250(D).DLL
					strTime = Convert(rStatus.m_mtime, ::szConvert);   	// using MFC extension DLL
					strInfo = strPath + strTime;
				}
			}
		}
	}
}

CString CSourceWizardBar::Convert(const CTime& time, const char* pFormat) const
{
	// MFC extension DLL version doesn't support: strftime()
	CString strTime("");

	int nYear = time.GetYear();
	int nMonth = time.GetMonth();
	int nDay = time.GetDay();
	int nHour = time.GetHour();
	int nMinute = time.GetMinute();
	int nSecond = time.GetSecond();

	strTime.Format(pFormat, nMonth, nDay, nYear, nHour, nMinute, nSecond);
	return strTime;
}

CString CSourceWizardBar::Format(const CTime& time, const char* /*pFormat*/) const
{
	// MFC 2.5 DLL version doesn't support: CTime::Format()
    char szBuffer[128];

	time_t timer = time.GetTime();
    struct tm* ptmTemp = localtime(&timer);
    ASSERT(ptmTemp != NULL);

//    if ( !strftime(szBuffer, sizeof(szBuffer), pFormat, ptmTemp) ) {
        szBuffer[0] = '\0';
//    }

    return szBuffer;
}

void CSourceWizardBar::ShowHintTip(const CPoint pt)
{
	// Search child control
	for ( int i(0); i < sizeof(::nID)/sizeof(int); i++ ) {
//		CWnd* pWnd = GetDlgItem(::nID[i]);
		CWnd* pWnd = GetDescendantWindow(::nID[i]);
		if ( pWnd ) {
			CRect rect;
			pWnd->GetWindowRect(rect);
			if ( rect.PtInRect(pt) ) {
				if ( m_nTipID != ::nID[i] ) {
					m_nTipID = ::nID[i];
	
					HINSTANCE hInstEXE = AfxGetResourceHandle();
					AfxSetResourceHandle(::SrcGetDLLHandle());

					CString strTip;
					strTip.LoadString(m_nTipID);
					ASSERT(!strTip.IsEmpty());

					AfxSetResourceHandle(hInstEXE);
					
					m_wndTip.UpdateTip(strTip, pt);
				}
				return;
			}
		}
	}

	// Hiden hints tip
	if ( -1 != m_nTipID ) {
		m_wndTip.UpdateTip();
		m_nTipID = -1;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSourceWizardBar message handlers

int CSourceWizardBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialogBar::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	// Create the tip window
	if ( !m_wndTip.Create() ) {
		ASSERT(FALSE);
		return -1;
	}

	return 0;
}

void CSourceWizardBar::OnDestroy() 
{
	CDialogBar::OnDestroy();
	
	// TODO: Add your message handler code here
	
	// Destroy tip window
	m_wndTip.DestroyWindow();
}

void CSourceWizardBar::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
	// Show control tip if moving within the control
	if ( GetFocus() == ((CMDIChildWnd*)GetParent())->GetActiveView() ) {
		CPoint pt(point);
		ClientToScreen(&pt);
		// don't show hints first
//		ShowHintTip(pt);
	}

	CDialogBar::OnMouseMove(nFlags, point);
}
