/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCBAR.H__   1.0   15 Aug 1997 14:03:42   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCBAR.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:42   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:22   ZJRD
** 1.0c
** 
****************************************************************************/

// srcbar.h : header file
//
#ifndef _SRCBAR_H_
#define _SRCBAR_H_

#include "srctip.h"

/////////////////////////////////////////////////////////////////////////////
// CSourceWizardBar dialog

class CSourceWizardBar : public CDialogBar
{
// Construction
    DECLARE_DYNAMIC(CSourceWizardBar)
public:
	CSourceWizardBar() : m_nTipID(-1) { }
	virtual ~CSourceWizardBar() { }

protected:
	CBitmapButton m_btnProp;

protected:
	HICON m_hIcon;

protected:
	CSourceTipWnd m_wndTip;
	int m_nTipID;

// Implementation
public:
	void UpdateWizardBar(const BOOL& bInitBar, const BOOL& bGetModule, const BOOL& bSelModule, const BOOL& bGetInfo, const BOOL& bRedrawProp, const BOOL& bHideProp = FALSE);
	void HideHintTip() { m_wndTip.UpdateTip(); m_nTipID = -1; }

protected:
	void InitBar();
	void RedrawProp();
	void GetModule();
	void SelModule();
	void GetInfo();

protected:
	void GetModuleInfo();
	void GetFileInfo(CString& strInfo);

	CString Format(const CTime& time, const char* pFormat) const;
	CString Convert(const CTime& time, const char* pFormat) const;

protected:
	void ShowHintTip(const CPoint pt);

protected:
	// Generated message map functions
	//{{AFX_MSG(CSourceWizardBar)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
