/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCDATA.H__   1.0   15 Aug 1997 14:03:42   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCDATA.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:42   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:22   ZJRD
** 1.0c
** 
****************************************************************************/

// srcdata.h : header file
//
#ifndef _SRCDATA_H_
#define _SRCDATA_H_

/////////////////////////////////////////////////////////////////////////////
// Forward reference

class CSourceData;
	class CSourceAttr;

class CAssemblyData;
	class CAssemblyCode;


/////////////////////////////////////////////////////////////////////////////
// CSourceAttr

class CSourceAttr : public CObject
{
	DECLARE_SERIAL(CSourceAttr)

// Construction & Destruction
public:
	CSourceAttr() { }

	CSourceAttr(const int nStartCol, const int nEndCol, const COLORREF clrSyntax)
		: m_nStartCol(nStartCol), m_nEndCol(nEndCol), m_clrSyntax(clrSyntax)
	{ }

	virtual ~CSourceAttr() { }

// Attributes
protected:
	int m_nStartCol;
	int m_nEndCol;
	COLORREF m_clrSyntax;

public:
	int GetStart() const { return m_nStartCol; }
	
	int GetEnd() const { return m_nEndCol; }
	
	COLORREF GetColor() const { return m_clrSyntax; }
};


/////////////////////////////////////////////////////////////////////////////
// CSourceData

class CSourceData : public CObject
{
	DECLARE_SERIAL(CSourceData)

// Construction & Destruction
public:
	CSourceData()
	{
		m_pAttrList = new CObList;
	}

	CSourceData(const CString& strLine) : m_strLine(strLine)
	{
		m_pAttrList = new CObList;
	}

	virtual ~CSourceData()
	{
		POSITION pos = m_pAttrList->GetHeadPosition();
		while ( pos ) {
			CSourceAttr* pObj = (CSourceAttr*)m_pAttrList->GetNext(pos);
			delete pObj;
		}
		m_pAttrList->RemoveAll();
		delete m_pAttrList;
	}

// Attributes
protected:
	CString m_strLine;
	CObList* m_pAttrList;

public:
	const CString& GetLine() const { return m_strLine; }
	
	CObList* GetList() const { return m_pAttrList; }
};


/////////////////////////////////////////////////////////////////////////////
// CAssemblyCode

class CAssemblyCode : public CObject
{
	DECLARE_SERIAL(CAssemblyCode)

// Construction & Destruction
public:
	CAssemblyCode() { }

	CAssemblyCode(const CString& strLabel, const CString& strAddr, const CString& strObj, const CString& strInst)
		: m_strLabel(strLabel), m_strAddr(strAddr), m_strObj(strObj), m_strInst(strInst)
	{ }

	virtual ~CAssemblyCode() { }

// Attributes
protected:
	CString m_strLabel;
	CString m_strAddr;
	CString m_strObj;
	CString m_strInst;

public:
	const CString& GetLabel() const { return m_strLabel; }
	
	const CString& GetAddr() const { return m_strAddr; }
	
	const CString& GetObj() const { return m_strObj; }

	const CString& GetInst() const { return m_strInst; }
};


/////////////////////////////////////////////////////////////////////////////
// CAssemblyData

class CAssemblyData : public CObject
{
	DECLARE_SERIAL(CAssemblyData)

// Construction & Destruction
public:
	CAssemblyData() : m_nLine(-1)
	{
		m_pAsmList = new CObList;
	}
	
	CAssemblyData(const int nLine) : m_nLine(nLine)
	{
		m_pAsmList = new CObList;
	}

	virtual ~CAssemblyData()
	{
		POSITION pos = m_pAsmList->GetHeadPosition();
		while ( pos ) {
			CAssemblyCode* pObj = (CAssemblyCode*)m_pAsmList->GetNext(pos);
			delete pObj;
		}
		m_pAsmList->RemoveAll();
		delete m_pAsmList;
	}

// Attributes
protected:
	int m_nLine;	// ASM: -1; Mixed: line number
	CObList* m_pAsmList;

public:
	int GetLine() const { return m_nLine; }
	
	CObList* GetList() const { return m_pAsmList; }
};

#endif
/////////////////////////////////////////////////////////////////////////////
