/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCDOC.H__   1.0   15 Aug 1997 14:03:42   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCDOC.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:42   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:20   ZJRD
** 1.0c
** 
****************************************************************************/

// srcdoc.h : header file
//
#ifndef _SRCDOC_H_
#define _SRCDOC_H_

/////////////////////////////////////////////////////////////////////////////
// CSourceDocument document

class CSourceDocument : public CDocument
{
protected:
	CSourceDocument();			// protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CSourceDocument)

// Attributes
public:
	static const COLORREF m_clrComment;
	static const COLORREF m_clrKeyword;
	static const COLORREF m_clrCode;
	static const COLORREF m_clrGray;
	static const COLORREF m_clrYellow;
	static const COLORREF m_clrWhite;
	
protected:
	CString m_strFilePath;
public:
	const CString& GetPath() const { return m_strFilePath; }
	void SetPath(const CString& strPath) { m_strFilePath = strPath; }

protected:
	int m_nMode;
public:
	int GetMode() const { return m_nMode; }
	void SetMode(const int nMode) { m_nMode = nMode; }

protected:
	int m_nAction;
public:
	enum { getAsm = 0, getMix, getSrc };
	void SetAction(const int nAction) { m_nAction = nAction; }

protected:
	int m_nMaxSrcRow;
	int m_nMaxSrcCol;

	int m_nMaxAsmRow;
	int m_nMaxAsmCol;

protected:
	CSourceAddr m_AddrStart, m_AddrEnd;
	int m_nAsmLine;

protected:
	CObList* m_pSrcList;
	CObList* m_pAsmList;
public:
	CObList* GetSrcList() const { return m_pSrcList; }
	CObList* GetAsmList() const { return m_pAsmList; }

protected:
	BOOL m_bInComment;

// Operations
protected:
	void FreeList(BOOL bClose);
	
	void GetAsmCode(const int nLine);
	void GetSrcCode();
	void GetMixCode();

	void ParseLine(const CString& strLine);

	BOOL IsKeyword(const CString& strToken) const;

protected:
	void SaveListFile(const CString& strFile) const;

	void SaveAsmFile(CStdioFile* fp) const;
	void SaveMixedFile(CStdioFile* fp) const;
	void SaveSourceFile(CStdioFile* fp) const;

public:
	BOOL IsDelimiter(const char ch) const;

	void SetAsmRange(const CSourceAddr& AddrStart, const CSourceAddr& AddrEnd);
	void SetAsmRange(const CSourceAddr& AddrStart, const int& nAsmLine);

	CSize GetTotalSize() const;
	int GetTotalPage(const CSize sizePage, const int nLeft) const;

	void UpdateDocument();

// Overrides
public:

protected:
	virtual	BOOL OnNewDocument();

// Implementation
public:
	virtual ~CSourceDocument();
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CSourceDocument)
	afx_msg void OnFileSaveAs();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
