/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCICON.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCICON.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:10   ZJRD
** 1.0c
** 
****************************************************************************/

// srcicon.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcgbl.h"
#include "srcicon.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourceIconWnd

IMPLEMENT_DYNAMIC(CSourceIconWnd, CStatic)

CSourceIconWnd::CSourceIconWnd()
	: m_nWhichIcon(head), m_nCloudsX(0), m_nRatio(0), m_clrRGB(RGB(0,0,0))
{
	// Load resource from this DLL
	HINSTANCE hInstEXE = AfxGetResourceHandle();
	AfxSetResourceHandle(::SrcGetDLLHandle());

	// Load bitmap
	CDC* pDC = GetDC();
	int nBit = pDC->GetDeviceCaps(BITSPIXEL);
	ReleaseDC(pDC);

	if ( nBit > 8 ) {
	    m_bmpClouds.LoadBitmap(IDB_CLOUDS);
//	    m_bmpTree.LoadBitmap(IDB_TREE);
	    m_bmpTree.LoadBitmap(IDB_MOUSE);
	}
	else {
	    m_bmpClouds.LoadBitmap(IDB_MARBLE);
	    m_bmpTree.LoadBitmap(IDB_MOUSE);
	}

    // Restore the old resource chain
	AfxSetResourceHandle(hInstEXE);
}

CSourceIconWnd::~CSourceIconWnd()
{
    // Delete bitmap
    m_bmpClouds.DeleteObject();
    m_bmpTree.DeleteObject();
}

BEGIN_MESSAGE_MAP(CSourceIconWnd, CStatic)
	//{{AFX_MSG_MAP(CSourceIconWnd)
	ON_WM_PAINT()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceIconWnd common routines

void CSourceIconWnd::UpdateIconWindow(BOOL bNewIcon /*= TRUE*/)
{
	// Draw something in a CWnd object
	if ( bNewIcon ) {
		m_nWhichIcon = m_nWhichIcon < tail-1 ? ++m_nWhichIcon : head+1;
		if ( clouds != m_nWhichIcon ) {
			m_nCloudsX = 0;
		}
	}
	else {
		PaintIcon();
	}
}

void CSourceIconWnd::ClearScreen()
{
	// Clear the whole frame window
	CDC* pDC = GetDC();
	
	HBRUSH hBrush = (HBRUSH)::GetStockObject(BLACK_BRUSH);
	CBrush brush;
	pDC->FillRect(m_rectClient, brush.FromHandle(hBrush));
	
	ReleaseDC(pDC);
}

void CSourceIconWnd::PaintIcon(CDC* pDC /*= NULL*/)
{
	// Draw something
	switch ( m_nWhichIcon ) {
	case clouds:
		DrawClouds(pDC);
		break;
	case tree:
		DrawTree(pDC);
		break;
	case circle:
		DrawCircle(pDC);
		break;
	default:
		ASSERT(FALSE);
		return;
	}
}

void CSourceIconWnd::DrawClouds(CDC* pDC)
{
	// Draw an animation
	if ( pDC ) {
		NULL;
	}
	else {
		CDC* pDC = GetDC();

	    CDC dc;
	    dc.CreateCompatibleDC(pDC);

    	CBitmap* pBmpOld = dc.SelectObject(&m_bmpClouds);
    	
		BITMAP bm;
		m_bmpClouds.GetObject(sizeof(BITMAP), &bm);
		m_nCloudsX = m_nCloudsX >= bm.bmWidth - m_rectClient.Width() - 2 ? 0 : ++m_nCloudsX;

	    pDC->BitBlt(1, 1, m_rectClient.Width(), m_rectClient.Height(), &dc, m_nCloudsX, 0, SRCCOPY);
	    dc.SelectObject(pBmpOld);

		ReleaseDC(pDC);
	}
}

void CSourceIconWnd::DrawTree(CDC* pDC)
{
	// Draw a static bitmap
	if ( pDC ) {
		NULL;
	}
	else {
		CDC* pDC = GetDC();

	    CDC dc;
	    dc.CreateCompatibleDC(pDC);

    	CBitmap* pBmpOld = dc.SelectObject(&m_bmpTree);
    	
	    pDC->BitBlt(1, 1, m_rectClient.Width(), m_rectClient.Height(), &dc, 0, 0, SRCCOPY);
	    dc.SelectObject(pBmpOld);

		ReleaseDC(pDC);
	}
}

void CSourceIconWnd::DrawCircle(CDC* pDC)
{
	// Clear screen
	ClearScreen();

	// Draw a circle
	if ( pDC ) {
		NULL;
	}
	else {
		CDC* pDC = GetDC();
		
		CBrush brush(RGB(0,0,0));
		CBrush* pOldBrush = pDC->SelectObject(&brush);
		
		// Draw a rand circle
		GetRandRGB();
	
		CPen penCircle(PS_INSIDEFRAME, 1, m_clrRGB);
		CPen* pOldPen = pDC->SelectObject(&penCircle);

	    GetRandRatio();
	
	    CRect rect(m_rectClient.left+m_nRatio, m_rectClient.top+m_nRatio, m_rectClient.right-m_nRatio, m_rectClient.bottom-m_nRatio);
		pDC->Ellipse(rect);
		
		pDC->SelectObject(pOldPen);
		
		// Draw a rand star
		CPoint pt[4];
		pt[0] = CPoint(rect.left+rect.Width()/2, rect.top);
		pt[1] = CPoint(rect.left, rect.top+rect.Height()/2);
		pt[2] = CPoint(rect.left+rect.Width()/2, rect.top+rect.Height());
		pt[3] = CPoint(rect.right, rect.top+rect.Height()/2);
		
		GetRandRGB();
		CPen penLine(PS_INSIDEFRAME, 1, m_clrRGB);
		pOldPen = pDC->SelectObject(&penLine);

		pDC->Polygon(pt, 4);
		
		GetRandRGB();
		pDC->MoveTo(pt[0]);
		pDC->LineTo(pt[2]);
		pDC->MoveTo(pt[1]);
		pDC->LineTo(pt[3]);

		pDC->SelectObject(pOldPen);

		pDC->SelectObject(pOldBrush);
		ReleaseDC(pDC);
	}
}

void CSourceIconWnd::GetRandRGB()
{
	// Get the rand RGB value
	COLORREF clr(RGB(0,0,0));
	do {
		BYTE r = (BYTE)(rand() % 255);
		BYTE g = (BYTE)(rand() % 255);
		BYTE b = (BYTE)(rand() % 255);
		clr = RGB(r,g,b);
	} while ( m_clrRGB == clr );
	m_clrRGB = clr;
}

void CSourceIconWnd::GetRandRatio()
{
	// Get rand ratio
	int nRatio;
	do {
    	nRatio = abs(rand() % (m_rectClient.Width()/2-5));
    } while ( 0 == nRatio || m_nRatio == nRatio );
    m_nRatio = nRatio;
}

/////////////////////////////////////////////////////////////////////////////
// CSourceIconWnd message handlers

void CSourceIconWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Draw something
//	PaintIcon(&dc);
	
	// Do not call CWnd::OnPaint() for painting messages
}

void CSourceIconWnd::OnSize(UINT nType, int cx, int cy)
{
	CStatic::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here

	// Calc the client size
	GetClientRect(m_rectClient);
	m_rectClient = CRect(m_rectClient.left+1, m_rectClient.top+1, m_rectClient.right-1, m_rectClient.bottom-1);
}
