/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCINFO.CPP   1.0   15 Aug 1997 14:03:38   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCINFO.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:38   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:10   ZJRD
** 1.0c
** 
****************************************************************************/

// srcinfo.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcsht.h"
#include "srcgbl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Global string

static char BASED_CODE szPoint[] = "...";

/////////////////////////////////////////////////////////////////////////////
// CSourceLoadInfoPage dialog

CSourceLoadInfoPage::CSourceLoadInfoPage(CWnd* pParent /*=NULL*/)
	: CPropertyPage(CSourceLoadInfoPage::IDD),
	m_uTimerID(0)
{
	pParent;

	//{{AFX_DATA_INIT(CSourceLoadInfoPage)
	m_strModule = "";
	m_strSymbol = "";
	m_strType = "";
	m_strFunction = "";
	m_strByte = "";
	m_strLine = "";
	m_strPC = "";
	m_strFile = "";
	//}}AFX_DATA_INIT
}

void CSourceLoadInfoPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSourceLoadInfoPage)
	DDX_Control(pDX, IDC_STATIC_LOADINFO_ICON, m_wndIcon);
	DDX_Text(pDX, IDC_STATIC_LOADINFO_MODULE, m_strModule);
	DDX_Text(pDX, IDC_STATIC_LOADINFO_SYMBOL, m_strSymbol);
	DDX_Text(pDX, IDC_STATIC_LOADINFO_TYPE, m_strType);
	DDX_Text(pDX, IDC_STATIC_LOADINFO_FUNCTION, m_strFunction);
	DDX_Text(pDX, IDC_STATIC_LOADINFO_BYTE, m_strByte);
	DDX_Text(pDX, IDC_STATIC_LOADINFO_LINE, m_strLine);
	DDX_Text(pDX, IDC_STATIC_LOADINFO_PC, m_strPC);
	DDX_Text(pDX, IDC_EDIT_LOADINFO_FILE, m_strFile);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSourceLoadInfoPage, CPropertyPage)
	//{{AFX_MSG_MAP(CSourceLoadInfoPage)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceLoadInfoPage common routine

void CSourceLoadInfoPage::GetLoadInfo()
{
	// Query from symbol server
	if ( ::SrcIsLoadedSymbol() ) {
		m_strFile = ::SrcGetTargetPath();

		// Get current load info
		CString strModuleName;
		int nRatio;
		if ( ::SrcGetLoadInfo(nRatio, strModuleName, m_strModule, m_strSymbol, m_strType, m_strFunction, m_strByte, m_strLine, m_strPC) ) {
			return;
		}
	}
	
	// Don't load
	m_strFile = "";
	m_strModule = "";
	m_strSymbol = "";
	m_strType = "";
	m_strFunction = "";
	m_strByte = "";
	m_strLine = "";
	m_strPC = "";
}

/////////////////////////////////////////////////////////////////////////////
// CSourceLoadInfoPage message handlers

BOOL CSourceLoadInfoPage::OnKillActive()
{
	// TODO: Add your message handler code here

	// Kill one-shot timer
	if ( 0 != m_uTimerID ) {
		KillTimer(m_uTimerID);
		m_uTimerID = 0;
	}

	return CPropertyPage::OnKillActive();
}

BOOL CSourceLoadInfoPage::OnSetActive()
{
	// TODO: Add your message handler code here

	// Set timer
 	m_uTimerID = SetTimer(tmEvent, tmElapse, NULL);

	return CPropertyPage::OnSetActive();
}

void CSourceLoadInfoPage::OnOK()
{   
	// Get data
	UpdateData();
	
	// Changed this page
	SetModified(FALSE);
	CancelToClose();

	// Kill one-shot timer
	if ( 0 != m_uTimerID ) {
		KillTimer(m_uTimerID);
		m_uTimerID = 0;
	}
}

void CSourceLoadInfoPage::OnCancel()
{
	// TODO: Add your message handler code here

	// Kill one-shot timer
	if ( 0 != m_uTimerID ) {
		KillTimer(m_uTimerID);
		m_uTimerID = 0;
	}
}

BOOL CSourceLoadInfoPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here

	// Update icon window
	m_wndIcon.SendMessage(WM_SIZE);
	m_wndIcon.UpdateIconWindow();

	// Set timer
 	m_uTimerID = SetTimer(tmEvent, tmElapse, NULL);

	// Get Load info
	GetLoadInfo();
		
	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSourceLoadInfoPage::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
	// Update icon window
	m_wndIcon.UpdateIconWindow();

	CPropertyPage::OnLButtonDblClk(nFlags, point);
}

void CSourceLoadInfoPage::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	
	// Not our timer
	if ( m_uTimerID != nIDEvent ) {
		CPropertyPage::OnTimer(nIDEvent);
		return;
	}
    
	// Update icon window
	m_wndIcon.UpdateIconWindow(FALSE);

	// Eat spurious WM_TIMER messages
//	MSG msg;
//	while ( ::PeekMessage(&msg, m_hWnd, WM_TIMER, WM_TIMER, PM_REMOVE) );
}
