/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCPROG.CPP   1.0   15 Aug 1997 14:03:40   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCPROG.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:40   ZJRD
** Initial revision.
** 
****************************************************************************/

// srcprog.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcprog.h"
#include "srcgbl.h"

#include "ldrexp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourceLoadProgressDlg dialog

CSourceLoadProgressDlg::CSourceLoadProgressDlg(const CString& strFile, CWnd* pParent /*=NULL*/)
	: CDialog(CSourceLoadProgressDlg::IDD, pParent), m_nPercent(0), m_nOldPercent(0), m_uTimerID(0), m_bLoading(FALSE)
{
	//{{AFX_DATA_INIT(CSourceLoadProgressDlg)
	m_strModule = "";
	m_strSymbol = "";
	m_strType = "";
	m_strFunction = "";
	m_strByte = "";
	m_strLine = "";
	m_strPC = "";
	m_strFile = strFile;
	m_strModuleName = "";
	//}}AFX_DATA_INIT
}

void CSourceLoadProgressDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSourceLoadProgressDlg)
	DDX_Control(pDX, IDC_BUTTON_LOADPROGRESS_FINISH, m_btnFinish);
	DDX_Control(pDX, IDC_BUTTON_LOADPROGRESS_ABORT, m_btnAbort);
	DDX_Control(pDX, IDC_STATIC_LOADPROGRESS_BAR, m_staticBar);
	DDX_Text(pDX, IDC_STATIC_LOADPROGRESS_MODULE, m_strModule);
	DDX_Text(pDX, IDC_STATIC_LOADPROGRESS_SYMBOL, m_strSymbol);
	DDX_Text(pDX, IDC_STATIC_LOADPROGRESS_TYPE, m_strType);
	DDX_Text(pDX, IDC_STATIC_LOADPROGRESS_FUNCTION, m_strFunction);
	DDX_Text(pDX, IDC_STATIC_LOADPROGRESS_BYTE, m_strByte);
	DDX_Text(pDX, IDC_STATIC_LOADPROGRESS_LINE, m_strLine);
	DDX_Text(pDX, IDC_STATIC_LOADPROGRESS_PC, m_strPC);
	DDX_Text(pDX, IDC_EDIT_LOADPROGRESS_FILE, m_strFile);
	DDX_Text(pDX, IDC_EDIT_LOADPROGRESS_MODULENAME, m_strModuleName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSourceLoadProgressDlg, CDialog)
	//{{AFX_MSG_MAP(CSourceLoadProgressDlg)
	ON_BN_CLICKED(IDC_BUTTON_LOADPROGRESS_ABORT, OnButtonLoadprogressAbort)
	ON_BN_CLICKED(IDC_BUTTON_LOADPROGRESS_FINISH, OnButtonLoadprogressFinish)
	ON_WM_PAINT()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceLoadProgressDlg common routine

void CSourceLoadProgressDlg::EnableControl()
{
	// Enable controls
	m_btnFinish.EnableWindow(m_nPercent == 100);
	m_btnAbort.EnableWindow(m_nPercent < 100);
	if (m_nPercent == 100)   m_btnFinish.SetFocus();

}

void CSourceLoadProgressDlg::UpdateLoadInfo()
{
	// Get load status
	if ( !::SrcGetLoadInfo(m_nPercent, m_strModuleName, m_strModule, m_strSymbol, m_strType, m_strFunction, m_strByte, m_strLine, m_strPC) || m_nOldPercent > 0 && m_nPercent == 0 || 100 == m_nPercent ) {
		if ( 0 != m_uTimerID ) {
			KillTimer(m_uTimerID);
			m_uTimerID = 0;
		}
	}

	// No any progress
	if ( m_nPercent == m_nOldPercent ) {
		return;
	}
	else {
		m_nOldPercent = m_nPercent;
	}
	
	// Enable controls
	EnableControl();

	// DDE
	UpdateData(FALSE);
	
	// Update bar
	CRect rect;
	m_staticBar.GetWindowRect(rect);
	ScreenToClient(&rect);
	InvalidateRect(rect, FALSE);   
	UpdateWindow();
//	m_staticBar.UpdateWindow();
}

/////////////////////////////////////////////////////////////////////////////
// CSourceLoadProgressDlg message handlers

BOOL CSourceLoadProgressDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	// Center window
	CenterWindow();

	// Enable controls
	EnableControl();

	// Set timer
 	m_uTimerID = SetTimer(tmEvent, tmElapse, NULL);

	// DDE
	UpdateData(FALSE);

	return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSourceLoadProgressDlg::OnCancel()
{
	// TODO: Add extra validation here

	// Kill one-shot timer
	if ( 0 != m_uTimerID ) {
		KillTimer(m_uTimerID);
		m_uTimerID = 0;
	}

	CDialog::OnCancel();
}

void CSourceLoadProgressDlg::OnButtonLoadprogressAbort() 
{
	// TODO: Add your control notification handler code here

	// Abort load progress
	::bSrcAbortLoad = TRUE;

    // Cancel dialog
	OnCancel();	
}

void CSourceLoadProgressDlg::OnButtonLoadprogressFinish() 
{
	// TODO: Add your control notification handler code here
	
	// Finish load progress
	::bSrcAbortLoad = FALSE;

    // Cancel dialog
	OnCancel();	
}

void CSourceLoadProgressDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Update progress bar    
	
	CWnd* pWnd = &m_staticBar;
	CDC* pDC = &dc; //m_staticBar.GetDC();

	CRect rect;
	pWnd->GetClientRect(rect);        
	pWnd->ClientToScreen(&rect);    
	ScreenToClient(&rect);

//	CBrush brushGray(RGB(192,192,192));
	CBrush *pBrushGray = CBrush::FromHandle((HBRUSH)GetStockObject(
				GRAY_BRUSH));
	CBrush* pBrushOld = pDC->SelectObject(pBrushGray);
	rect.left += 1;
	rect.top += 1;
	rect.right -= 1;
	rect.bottom -= 1;
	CRect rectBar(rect);
	pDC->FillRect(rect, pBrushGray);
	pDC->SelectObject(pBrushOld);

	if ( m_nPercent > 0 ) {
		CBrush brushBlue(RGB(0,0,255));
		pBrushOld = pDC->SelectObject(&brushBlue);
		long lRight = long(rect.right);
		lRight = lRight * m_nPercent / 100;
		rect.right = int(lRight);
		pDC->FillRect(rect, &brushBlue);
		pDC->SelectObject(pBrushOld);
	}

	static char BASED_CODE szFormat[] = "%d %%";
	CString strPercent;
	strPercent.Format(szFormat, m_nPercent);
  	pDC->SetBkMode(TRANSPARENT);
//	pDC->SetROP2(R2_NOTCOPYPEN);
	pDC->SetTextColor(RGB(0,0,0));
	pDC->DrawText(strPercent, strPercent.GetLength(), rectBar, DT_SINGLELINE|DT_VCENTER|DT_CENTER);

//	pWnd->ReleaseDC(pDC);

	// Do not call CDialog::OnPaint() for painting messages
}

void CSourceLoadProgressDlg::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	// Our timer fired
	if ( m_uTimerID == nIDEvent ) {
		if ( !m_bLoading ) {
			// Start to load
			m_bLoading = TRUE;
			::StarterLoader(m_strFile, ::nSrcLoadOption);
		}
		else {
			// Update progress bar
			UpdateLoadInfo();
		}
	}

	CDialog::OnTimer(nIDEvent);
}
