/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCSRCH.CPP   1.0   15 Aug 1997 14:03:40   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCSRCH.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:03:40   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:14   ZJRD
** 1.0c
** 
****************************************************************************/

// srcsrch.cpp : implementation file
//

#include "stdafx.h"
#include "srcdll.h"
#include "srcgbl.h"
#include "srcsrch.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourceSearchDlg dialog

CSourceSearchDlg::CSourceSearchDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSourceSearchDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSourceSearchDlg)
	m_bWord = ::bSrcSearchWord;
	m_bCase = ::bSrcSearchCase;
	m_strWhat = "";
	m_nDirect = ::nSrcSearchDirect;
	//}}AFX_DATA_INIT

	// Create modeless dialog
	Create(IDD, pParent);
}

void CSourceSearchDlg::PostNcDestroy()
{
	CDialog::PostNcDestroy();

	// TODO: Add extra cleanup here

	// Delete modeless pointer
	delete this;
	::pSrcSearchDlg = 0;
}

void CSourceSearchDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSourceSearchDlg)
	DDX_Control(pDX, IDC_COMBO_SRCSEARCH_WHAT, m_comboWhat);
	DDX_Control(pDX, IDC_BUTTON_SRCSEARCH_SEARCH, m_btnSearch);
	DDX_Check(pDX, IDC_CHECK_SRCSEARCH_MATCH, m_bWord);
	DDX_Check(pDX, IDC_CHECK_SRCSEARCH_CASE, m_bCase);
	DDX_CBString(pDX, IDC_COMBO_SRCSEARCH_WHAT, m_strWhat);
	DDX_Radio(pDX, IDC_RADIO_SRCSEARCH_UP, m_nDirect);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSourceSearchDlg, CDialog)
	//{{AFX_MSG_MAP(CSourceSearchDlg)
	ON_BN_CLICKED(IDC_BUTTON_SRCSEARCH_SEARCH, OnButtonSrcsearchSearch)
	ON_CBN_EDITCHANGE(IDC_COMBO_SRCSEARCH_WHAT, OnEditchangeComboSrcsearchWhat)
	ON_CBN_SELCHANGE(IDC_COMBO_SRCSEARCH_WHAT, OnSelchangeComboSrcsearchWhat)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSourceSearchDlg message handlers

BOOL CSourceSearchDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	// Center dialog position
	CenterWindow();

	// Set combo-box
	m_comboWhat.ResetContent();
	POSITION pos = ::pSourceSearchList->GetHeadPosition();
	while ( pos ) {
		m_comboWhat.AddString(::pSourceSearchList->GetNext(pos));
	}
	if ( m_comboWhat.GetCount() >= 1 ) {
		m_comboWhat.SetCurSel(0);
		m_comboWhat.GetLBText(0, m_strWhat);
	}

	// Disable control
	m_btnSearch.EnableWindow(!m_strWhat.IsEmpty());
	
    // Set data
	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSourceSearchDlg::OnButtonSrcsearchSearch()
{
	// TODO: Add your control notification handler code here
	
	// Get data
	UpdateData();
	
	// Change to Search Next
	HINSTANCE hInstEXE = AfxGetResourceHandle();
	AfxSetResourceHandle(::SrcGetDLLHandle());

	CString strNext;
	strNext.LoadString(IDS_SRC_SEARCHNEXT);
	m_btnSearch.SetWindowText(strNext);

	AfxSetResourceHandle(hInstEXE);

	// Add to combo box without same token
	for ( int i(0); i < m_comboWhat.GetCount(); i++ ) {
		CString strItem;
		m_comboWhat.GetLBText(i, strItem);
		if ( strItem == m_strWhat ) {
			m_comboWhat.DeleteString(i);
			break;
		}
	}
	m_comboWhat.InsertString(0, m_strWhat);

	// Global flag
	::bSrcSearchWord = m_bWord;
	::bSrcSearchCase = m_bCase;
	::nSrcSearchDirect = m_nDirect;

	UpdateData(FALSE);

	// Add searched token to combo-box in Source view
	::SrcSetBarToken(m_strWhat);
	
	// Search Next
	GetParent()->SendMessage(WM_COMMAND, ID_EDIT_SEARCHNEXT);
}

void CSourceSearchDlg::OnEditchangeComboSrcsearchWhat()
{
	// TODO: Add your control notification handler code here

	// Get data
	UpdateData();
	
	// Disable control
	m_btnSearch.EnableWindow(!m_strWhat.IsEmpty());
}

void CSourceSearchDlg::OnCancel()
{
	// TODO: Add extra cleanup here

	// Destroy modeless dialog
	DestroyWindow();
}

void CSourceSearchDlg::OnSelchangeComboSrcsearchWhat()
{
	// TODO: Add your control notification handler code here
	
	// Get data
	UpdateData();
	
	// Disable control
	if ( m_comboWhat.GetCount() >= 1 ) {
		m_comboWhat.GetLBText(m_comboWhat.GetCurSel(), m_strWhat);
	}
	m_btnSearch.EnableWindow(!m_strWhat.IsEmpty());
}
