/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCVIEW.H__   1.0   15 Aug 1997 14:03:42   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCVIEW.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:42   ZJRD
** Initial revision.
** 
**    Rev 1.1.7.0   19 Jun 1997 14:49:20   ZJRD
** 1.0c
** 
****************************************************************************/

// srview.h : header file
//
#ifndef _SRCVIEW_H_
#define _SRCVIEW_H_

#include "srctip.h"      
#include "srctext.h"
#include "srcaddr.h"       
#include "srcdoc.h"

/////////////////////////////////////////////////////////////////////////////
// CSourceView view

class CSourceView : public CTextView
{
protected:
	CSourceView();			// protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CSourceView)

// Attributes
public:
	void UpdateSourceWindow(const int nMode);
	void UpdateBrowseWindow(const int nMode);
	void HideDataTip();

protected:
	BOOL m_bBrowse;
public:
	void SetBrowseMode(const BOOL bBrowse) { m_bBrowse = bBrowse; }
	BOOL IsBrowse() const { return m_bBrowse; }

public:
	void InspectSource(const CSourceAddr& Addr) { BrowseFromAddr(Addr); }

protected:
	BOOL m_bCursorLink;
	CSourceAddr m_CursorLinkAddr;
public:
	void SetCursorLink(const BOOL bCursorLink) { m_bCursorLink = bCursorLink; }
	void CursorLink(const CSourceAddr& Addr) { m_CursorLinkAddr = Addr; BrowseFromAddr(m_CursorLinkAddr); }

protected:
	int GetMode() const { return ((CSourceDocument*)GetDocument())->GetMode(); }

protected:
	int m_nBitWidth, m_nNumWidth, m_nAddrWidth, m_nObjWidth;
	int GetLeftSpace() const;

protected:
	CSourceTipWnd m_wndTip;

protected:
	enum { tmEvent = 1, tmElapse = 250 };
    UINT m_uTimerID;

protected:
	CString m_strTip;
	CPoint m_ptTip;

	void SetDataTip();
	void GetTipToken(CString& strToken);
	void GetTipValue(const CString& strToken);

protected:
	DWORD m_dwMinPC, m_dwMaxPC;
	CSourceAddr m_PC;
	BOOL GetPC();
	BOOL SetPC();

protected:
	int m_nPCLine;
	int m_nOldPCLine;
	int m_nPCStartCol;
	int m_nPCEndCol;
	void GetPCLinePos();

protected:
	CSize m_sizeFont;

protected:
	int m_nCurPage;
	int m_nTotalPage;
	CSize m_sizePage;

protected:
	BOOL m_bLine;
	BOOL m_bSymbolic;
	BOOL m_bSyntaxColor;

protected:
	enum { localVariable = 0, localFunction, localGeneral, localBrowse, localPrint };

protected:
	CRect m_rectClient;
	CSize m_sizeScroll;
	CSize m_sizeClient;

protected:
	CPoint m_ptCaret;
	CPoint m_ptOldCaret;
	
	void MoveCaretPos();

protected:
	CString m_strMarkToken;
	CPoint m_ptMarkToken;

	void MarkToken(BOOL bGetToken = TRUE);
	void GetMarkToken();
	void ClearTokenMark(BOOL bRedraw = TRUE);

protected:
	enum { bmpWidth = 16, bmpHeight = 13 };

	CBitmap m_bmpBP;
	CBitmap m_bmpBPPC;
	CBitmap m_bmpPC;
	CBitmap m_bmpLink;

	void DrawBitmap(CDC* pDC, CBitmap* pBmp, const int xPos, const int yPos);

protected:
	enum { bpNo = 0, bpSet, bpClear };
	int m_nDrawBP;
	CSourceAddr m_BP;

	void MarkBP(CDC* pDC);
	void MarkBP();

// Operations
protected:
	BOOL IsLoadSource() const;
	BOOL IsPCHasSource() const;
	BOOL IsInSourceRange(CSourceAddr& Addr, CString& strPath, SYM_DESCRIPTOR& dwModuleDesc);
    BOOL IsNewModule(const CString& strModulePath) const;
    BOOL IsMarkVariable() const;
    BOOL IsMarkFunction() const;

protected:
	BOOL GetModule(CString& strModulePath, SYM_DESCRIPTOR& dwModuleDesc);
	void SetModulePath(const CString& strModulePath);
	void ShowTitle();
	void AddModuleDepth(const SYM_DESCRIPTOR dwModuleDesc);

protected:
	void SetAsmRange(const CSourceAddr& AddrStart) const;
	BOOL GetStartAddr(CSourceAddr& AddrStart);
	void ScrollAsmCode(UINT nSBCode, const int nPos);
	void SetAsmScrollPos();
	void GetStartAddr(const CSourceAddr& AddrBase, CSourceAddr& AddrStart, const int nUpLine = 1);

protected:
	void SetScrollSizes();
	void GetScrollSize();

	void GetListIndex(const int nStartLine, CObList* pSrcList, CObList* pAsmList, int& nSrcIndex, int& nAsmIndex);

protected:
	void DisplaySourceContent(const int nAction);

	void DisplayDocumentContent(CDC* pDC);
	void DisplayAssemblyCode(CDC* pDC);
	void DisplayMixedCode(CDC* pDC);
	void DisplaySourceCode(CDC* pDC);

	void PrintDocumentContent(CDC* pDC);
	void PrintFooter(CDC* pDC);
	void PrintAssemblyCode(CDC* pDC);
	void PrintMixedCode(CDC* pDC);
	void PrintSourceCode(CDC* pDC);

	void UpdateOtherWindows();

protected:
	void ScrollToPosition(const int nRow, const int nCol = -1, const BOOL bDown = TRUE);
	void ScrollToAddr(const CSourceAddr& Addr);
	BOOL GetMixedLine(const CSourceAddr& Addr, int& nLine);
	void GetMixedLine(const int nSrcLine, int& nLine);

protected:
	CString m_strSearchToken;

	void SearchToken();
	CPoint SearchToken(const int nRow, const int nCol, const BOOL bDown = TRUE);
	int ReverseFind(const CString& strSrc, const CString& strSub) const;

	void ViewToken(const CPoint ptFound, const BOOL bDown = TRUE);

protected:
	void BrowseFromAddr(const CSourceAddr& Addr);
	void UpdateToPC(int nMode);
	BOOL LineToAddr(const int nLine, CSourceAddr& Addr);

protected:
	BOOL GetCpuStatus() const;

// Overrides
protected:
	virtual	void OnDraw(CDC* pDC);		// overridden to draw this view
    virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);

// Implementation
protected:
	virtual ~CSourceView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	// Printing support
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);

	// Generated message map functions
protected:
	//{{AFX_MSG(CSourceView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnUpdateViewLinenumbering(CCmdUI* pCmdUI);
	afx_msg void OnViewLinenumbering();
	afx_msg void OnUpdateViewSyntaxcoloring(CCmdUI* pCmdUI);
	afx_msg void OnViewSyntaxcoloring();
	afx_msg void OnUpdateViewSymbolicdisassembly(CCmdUI* pCmdUI);
	afx_msg void OnViewSymbolicdisassembly();
	afx_msg void OnUpdateViewAssemble(CCmdUI* pCmdUI);
	afx_msg void OnViewAssemble();
	afx_msg void OnUpdateViewMixed(CCmdUI* pCmdUI);
	afx_msg void OnViewMixed();
	afx_msg void OnUpdateViewSource(CCmdUI* pCmdUI);
	afx_msg void OnViewSource();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnOptionsLoadoption();
	afx_msg void OnOptionsSourceextensionname();
	afx_msg void OnUpdateFileBrowsemodule(CCmdUI* pCmdUI);
	afx_msg void OnFileBrowsemodule();
	afx_msg void OnOptionsSourcepath();
	afx_msg void OnFileLoad();
	afx_msg void OnRunBreakpoint();
	afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
	afx_msg void OnEditSearch();
	afx_msg void OnUpdateEditSearchnext(CCmdUI* pCmdUI);
	afx_msg void OnEditSearchnext();
	afx_msg void OnGroupSource();
	afx_msg void OnUpdateFileLoadinfo(CCmdUI* pCmdUI);
	afx_msg void OnFileLoadinfo();
	afx_msg void OnUpdateFilePrevmodule(CCmdUI* pCmdUI);
	afx_msg void OnFilePrevmodule();
	afx_msg void OnUpdateFileNextmodule(CCmdUI* pCmdUI);
	afx_msg void OnFileNextmodule();
	afx_msg void OnEditBrowsefrom();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg void OnFilePrint();
	afx_msg void OnFilePrintPreview();
	afx_msg void OnFilePrintSetup();
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnShiftf10();
	afx_msg void OnRunJump();
	afx_msg void OnLocalWarchvar();
	afx_msg void OnLocalInspectsource();
	afx_msg void OnLocalShowloadaddr();
	afx_msg void OnLocalSetbp();
	afx_msg void OnLocalClearbp();
	afx_msg void OnLocalSearchvar();
	afx_msg void OnRunGotocursor();
	afx_msg void OnViewSourcemode();
	afx_msg void OnToggleHints();
	afx_msg void OnUpdateToggleHints(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditBrowsefrom(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileLoad(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLocalClearbp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLocalSetbp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRunGotocursor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewSourcemode(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGroupSource(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLocalInspectsource(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLocalSearchvar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLocalShowloadaddr(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLocalWarchvar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionsLoadoption(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionsSourceextensionname(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionsSourcepath(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRunBreakpoint(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRunJump(CCmdUI* pCmdUI);
	afx_msg void OnRunJumptocursor();
	afx_msg void OnUpdateRunJumptocursor(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////////////////////////////////////////////////////
