/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SRCDLL/SRCGBL.H__   1.0   15 Aug 1997 14:03:46   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SRCDLL/SRCGBL.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:03:46   ZJRD
** Initial revision.
** 
****************************************************************************/

// srcgbl.h : header file
//
#ifndef _SRCGBL_H_
#define _SRCGBL_H_

#include "symblsvr.h"

/////////////////////////////////////////////////////////////////////////////
// Forward reference

class CSourceSearchDlg;

/////////////////////////////////////////////////////////////////////////////
// Global variable

extern CMultiDocTemplate* pSourceTemplate;
extern CMultiDocTemplate* pBrowseTemplate;

extern CMDIChildWnd* pSourceWnd;
extern CMDIChildWnd* pBrowseWnd;

extern int nSrcLoadOption;
extern CString* pSrcTargetPath;
extern CString* pSrcTargetExt;

extern CStringList* pSourcePathList;
extern CStringList* pSourceExtNameList;

extern CObList* pBpDataList;

extern CSourceSearchDlg* pSrcSearchDlg;
extern BOOL bSrcSearchWord;
extern BOOL bSrcSearchCase;
extern int nSrcSearchDirect;
extern CStringList* pSourceSearchList;

extern int g_nSrcGroupEntry;

extern int g_nSrcModuleDepth;
extern int g_nSrcModuleIndex;
extern CObList* g_pSourceModuleDescList;

extern int g_nBrwModuleDepth;
extern int g_nBrwModuleIndex;
extern CObList* g_pBrowseModuleDescList;

extern CStringList* pSourceFromList;
extern CStringList* pSourceJumpList;

extern BOOL bSrcHintsOn;

extern CObList* pSourceModuleInfoList;

extern BOOL bSrcAbortLoad;

extern BOOL bSrcSymbolic;

/////////////////////////////////////////////////////////////////////////////
// Global enum

enum { SRC_NULL = 0, SRC_MAIN, SRC_SOURCE, SRC_BROWSE };
enum {
	// Default: LDR_CODE|LDR_SYMBOL|LDR_STATUS|LDR_WARNING
	LDR_CODE 	= 0x1,
	LDR_SYMBOL  = 0x2,
	LDR_STATUS  = 0x4,
	LDR_WARNING = 0x8,
	LDR_DEMAND  = 0x10,
	LDR_SYSTEM  = 0x20
};

/////////////////////////////////////////////////////////////////////////////
// Global function

HINSTANCE SrcGetDLLHandle();

void SrcUpdateSourceWizardBar(const BOOL& bInitBar, const BOOL& bGetModule, const BOOL& bSelModule, const BOOL& bGetInfo, const BOOL& bRedrawProp);
void SrcUpdateBrowseWizardBar(const BOOL& bInitBar, const BOOL& bGetModule, const BOOL& bSelModule, const BOOL& bGetInfo, const BOOL& bRedrawProp);

void SrcHideDataTip();
void SrcHideHintTip();

BOOL SrcGetAllModuleInfo();

BOOL SrcGetModuleList(CStringList* &pList);
BOOL SrcGetFunctionList(const CString& strModule, CStringList* &pList);
BOOL SrcGetModuleName(const SYM_DESCRIPTOR dwModuleDesc, CString& strModuleName);
BOOL SrcGetLineRange(const BOOL bBrowse, const int nLine, CSourceAddr& AddrStart, CSourceAddr& AddrEnd);
BOOL SrcGetFuncRange(const CString& strName, CSourceAddr& AddrStart, CSourceAddr& AddrEnd);
BOOL SrcGetModule(const CSourceAddr& Addr, CString& strModulePath, SYM_DESCRIPTOR& dwModuleDesc);
BOOL SrcIsInSource(const CSourceAddr& Addr);

void SrcGetModuleAddrRange(const CString& strModule, CString& strRange);
BOOL SrcGetLoadInfo(int& nRatio, CString& strModuleName, CString& strModule, CString& strSymbol, CString& strType, CString& strFunction, CString& strByte, CString& strLine, CString& strPC);

void SrcGetInitPC(CSourceAddr& Addr);

BOOL SrcAddrToLine(const BOOL bBrowse, const CSourceAddr& Addr, int& nLine, int& nStart, int& nEnd);

BOOL SrcIsMarkVariable(const CString& strToken, const int nLine);
BOOL SrcIsMarkFunction(const CString& strToken);

void SrcAddModuleDesc(const int nModuleSelect);

int SrcGetModuleIndex(const BOOL bBrowse);
BOOL SrcGetModuleDesc(const BOOL bBrowse, SYM_DESCRIPTOR& dwModuleDesc);

const CString& SrcGetTargetPath();
BOOL SrcGetModulePath(const CString& strModuleName, CString& strModulePath);

CStringList* SrcGetExtNameList();
CStringList* SrcGetPathList();
CObList* SrcGetModuleInfoList();

int SrcGetMaxByte();
int SrcGetAddrWidth();

void SrcGetPCRange(DWORD& dwMinPC, DWORD& dwMaxPC);

#endif
/////////////////////////////////////////////////////////////////////////////
