/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

// stepsvr.h : header file
//
#ifndef _STEPSVR_H_
#define _STEPSVR_H_

/////////////////////////////////////////////////////////////////////////////
// CStepServer

class CStepServer
{
// Contruction & Destruction
public:
    CStepServer() : m_nLine(-1), m_nStmt(-1), m_dwModuleDesc(-1) { }
    virtual ~CStepServer() { }

// Attributes
protected:
	int m_nMode;
	
protected:
	BOOL m_bInShell;

protected:
	CSourceAddr m_Addr;

// Implementation
protected:
	void StepKernel();
	void StepLowLevel();
	void StepHighLevel();
	
protected:
	BOOL IsEPStop() const;

	BOOL IsMatchRet(const CSourceAddr& Addr) const;
	BOOL IsMatchCall(const CSourceAddr& Addr, CSourceAddr& AddrLib, CSourceAddr& AddrNext) const;
	BOOL IsInRootBank(const CSourceAddr& Addr) const;

protected:
	int m_nLine, m_nStmt;
	SYM_DESCRIPTOR m_dwModuleDesc;
	BOOL IsInNewSourceLine(const CSourceAddr& Addr, const BOOL bAfterRun = TRUE);

protected:
	void ShowNextCode() const;

public:
    void StepAction(int nArgc, char* pszArgv[]);
    void StepAction(const int nMode);
};

#endif
