/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCFIDLG.CPP
//
//  Description:The implement file for the class: CTrcFiDlg
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// trcfidlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "trcfidlg.h"
#include "trcpub.h"
#include "hosterrs.h"  
#include "afxpriv.h"
//#include "myedit.h"
//#include "trcserve.h"
//#include "uicom2.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
#define AAA		50
/////////////////////////////////////////////////////////////////////////////
// CTrcFiDlg dialog


CTrcFiDlg::CTrcFiDlg(CWnd* pParent /*=NULL*/)
    : CFileDialog(FALSE, NULL, NULL, OFN_OVERWRITEPROMPT, "Trace Data [*.trc]|*.trc|All File [*.*]|*.*||", pParent)
{
	//{{AFX_DATA_INIT(CTrcFiDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	CMyEdit::m_edit1=NULL;
	CMyEdit::m_edit2=NULL;
	m_ofn.lpstrTitle = "Save Trace";
	m_nIDHelp = 0x4e65;
}                                         

void CTrcFiDlg::DoDataExchange(CDataExchange* pDX)
{
	CFileDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrcFiDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

void CTrcFiDlg::OnOK()
{

//	WinHelp(0x2000b, HELP_CONTEXTPOPUP);

int i;                
BOOL bOk;
long value;
char buf[20];
char buf2[20];

	bOk=TRUE;
	GetDlgItemText(IDC_SAVETRACEDLG_EDIT1,buf,10);
	buf[10]='\0';
	if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
	{
		value = strtol(buf,NULL,16);
		if ((value>0xffff)||(value<0)) bOk = FALSE;
		_ultoa(value,buf2 , 16);
		if (lstrcmpi(buf2,buf+2)!=0)
			bOk = FALSE;
		if (bOk) m_dwSaveStart = (DWORD)value;
	}
	else
	{
		value = strtol(buf,NULL,10);
		if ((value>0xffff)||(value<0)) bOk = FALSE;
		_ultoa(value,buf2 , 10);
		if (lstrcmpi(buf2,buf)!=0)
			bOk = FALSE;
		if (bOk) m_dwSaveStart = (DWORD)value;
	}
	if (!bOk)
	{
		ErrDisplayError(ER_TRC_INPUT_ERR);
		m_parseEditStart.SetFocus();
		m_parseEditStart.SetSel(0,-1);
		return;
	}

	bOk=TRUE;
	GetDlgItemText(IDC_SAVETRACEDLG_EDIT2,buf,10);
	buf[10]='\0';
	if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
	{
		value = strtol(buf,NULL,16);
		if ((value>0xffff)||(value<0)) bOk = FALSE;
		_ultoa(value,buf2 , 16);
		if (lstrcmpi(buf2,buf+2)!=0)
			bOk = FALSE;
		if (bOk) m_dwSaveEnd = (DWORD)value;
	}                     
	else
	{
		value = strtol(buf,NULL,10);
		if ((value>0xffff)||(value<0)) bOk = FALSE;
		_ultoa(value,buf2 , 10);
		if (lstrcmpi(buf2,buf)!=0)
			bOk = FALSE;
		if (bOk) m_dwSaveEnd = (DWORD)value;
	}               
	if (!bOk||m_dwSaveStart>m_dwSaveEnd)
	{
		ErrDisplayError(ER_TRC_INPUT_ERR);
		m_parseEditEnd.SetFocus();
		m_parseEditEnd.SetSel(0,-1);
		return;
	}
	Default();
//  EndDialog(1);
}

BEGIN_MESSAGE_MAP(CTrcFiDlg, CFileDialog)
    //{{AFX_MSG_MAP(CTrcFiDlg)
    ON_WM_CREATE() 
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcFiDlg message handlers

int CTrcFiDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFileDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO: Add your specialized creation code here
RECT 	rect;
long 	x,y;                      

	GetWindowRect(&rect);
	x=rect.right-rect.left;
	y=(rect.bottom-rect.top)*11/9;

	m_950125_x=x;
	m_950125_y=y;
	SetWindowPos(NULL, 0,0,int(x), int(y), SWP_NOMOVE | SWP_NOZORDER);

	rect.left = int(x*10/472);	
	rect.top =  int(y*(207+AAA)/350);
	rect.right = int(x*356/472);
	rect.bottom = int(y*(260+AAA)/350);
	m_frameFrameRange.Create("Frame Range",
							WS_VISIBLE | WS_CHILD | SS_BLACKFRAME,
							rect,
							this,
							IDC_SAVETRACEDLG_FRAMERANGE);

	rect.left = int(x*15/472);
	rect.top =  int(y*(200+AAA)/350);
	rect.right = int(x*105/472);
	rect.bottom = int(y*(220+AAA)/350);
	m_frameFrameRangeText.Create("Frame Range",
							WS_VISIBLE | WS_CHILD | SS_LEFT,
							rect,
							this,
							IDC_SAVETRACEDLG_FRAMERANGE);

	rect.left = int(x*30/472);
	rect.top =  int(y*(230+AAA)/350);
	rect.right = int(x*75/472);
	rect.bottom = int(y*(255+AAA)/350);
	m_labelStart.Create("Start:",
							WS_VISIBLE | WS_CHILD,
							rect,
							this,
							IDC_SAVETRACEDLG_START);

	rect.left = int(x*195/472);
	rect.top =  int(y*(230+AAA)/350);
	rect.right = int(x*240/472);
	rect.bottom = int(y*(255+AAA)/350);
	m_labelEnd.Create("End:",
							WS_VISIBLE | WS_CHILD,
							rect,
							this,
							IDC_SAVETRACEDLG_END);

	rect.left = int(x*75/472);
	rect.top =  int(y*(224+AAA)/350);
	rect.right = int(x*145/472);
	rect.bottom = int(y*(247+AAA)/350);
	m_parseEditStart.Create(WS_VISIBLE | WS_CHILD | WS_BORDER |WS_TABSTOP,
							rect,
							this,
							IDC_SAVETRACEDLG_EDIT1);

	rect.left = int(x*240/472);
	rect.top =  int(y*(224+AAA)/350);
	rect.right = int(x*310/472);
	rect.bottom = int(y*(247+AAA)/350);
	m_parseEditEnd.Create(WS_VISIBLE | WS_CHILD | WS_BORDER |WS_TABSTOP,
							rect,
							this,
							IDC_SAVETRACEDLG_EDIT2);

	SetDlgItemText(IDC_SAVETRACEDLG_EDIT1,"0x0");
	SetDlgItemText(IDC_SAVETRACEDLG_EDIT2,"0x0");
	return 0;
}

BOOL CTrcFiDlg::OnInitDialog()
{
	CFileDialog::OnInitDialog();
	CenterWindow();

	// TODO: Add extra initialization here 
char buf[20];

	m_parseEditStart.SubclassEdit2((UINT)IDC_SAVETRACEDLG_EDIT1, this, PES_NUMBERS);
	m_parseEditStart.SetRange(0,100);              
	m_parseEditEnd.SubclassEdit2((UINT)IDC_SAVETRACEDLG_EDIT2, this, PES_NUMBERS);
	m_parseEditEnd.SetRange(0,100);

DWORD lastFrame;
int nErrorID = ICE_OK;

	lastFrame=TS_GetLastFrame();
	if (lastFrame>0)
	{
		m_parseEditStart.SetRange(0,(int)lastFrame);              
		m_parseEditEnd.SetRange(0,(int)lastFrame);
		sprintf(buf,"0x%x",(int)lastFrame);
		SetDlgItemText(IDC_SAVETRACEDLG_EDIT2,buf);                                               
	}
	else 
	{
		m_parseEditStart.SetRange(0,0);              
		m_parseEditEnd.SetRange(0,0);
		SetDlgItemText(IDC_SAVETRACEDLG_EDIT2,"0x0");                                               
	}

	CRect rect1(int(m_950125_x*145/472),
				int(m_950125_y*(224+AAA)/350),
				int(m_950125_x*165/472),
				int(m_950125_y*(247+AAA)/350));   
	CRect rect2(int(m_950125_x*310/472),
				int(m_950125_y*(224+AAA)/350),
				int(m_950125_x*330/472),
				int(m_950125_y*(247+AAA)/350));

	m_spinStart.Create(WS_VISIBLE | WS_CHILD | MSS_VERTICAL,
		rect1,this,IDC_SAVETRACEDLG_EDIT1);
	m_spinStart.SetAssociate(&m_parseEditStart);
	m_spinEnd.Create(WS_VISIBLE | WS_CHILD | MSS_VERTICAL,
		rect2,this,IDC_SAVETRACEDLG_EDIT2);
	m_spinEnd.SetAssociate(&m_parseEditEnd);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

