/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCGRPDI.CPP
//
//  Description:The implement file for the class: CTraceGroupDialog
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//		2. Link with address server, 3/28/1996
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"                
#include "resource.h"

//#include "abibase.h"
//#include "trcserve.h"
//#include "trcwin.h"
#include "trcgrpdi.h"
#include "trcpub.h"
#include "stdlib.h"
#include "uicom2.h"

//#include "address.h"
//#include "addrapi.h"

//#include "cpust.h"
//#include "synlib.h"
#include "hosterrs.h"


#ifdef _DEBUG          
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern int GetCurrentBank(void);

extern int GetTokenNum(char* string);

int searchc(char* str1, char ch, int count)
{
    int i=0;
    int p=0;
    
    if (count==0) return 0;
    
    do
    {
        if (*str1==ch) i++;
        str1++; 
        p++;
    }while((i<count)&&(*str1!='\0'));
    return(p-1);
}           

const char* RetAddrText(U32 addr)
{
static char	buf[10];

	buf[0]=NULL;
	wsprintf(buf, "P%d:%x", HIWORD(addr), LOWORD(addr));
	return buf;
}

void SetAddrText(U32 addr, char* pBuf)
{
	strcpy(pBuf, RetAddrText(addr));
}

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog Dialog

IMPLEMENT_DYNAMIC(CTraceGroupDialog, CPropertySheet)

void CTraceGroupDialog::DlgInit(void)
{
	m_bDisplayChange=FALSE;
	AddPage(&m_eventPage);
	AddPage(&m_trcctrlPage);
	AddPage(&m_triggerPage);
	AddPage(&m_filterPage);
}

CTraceGroupDialog::CTraceGroupDialog(CWnd* pParent /*=NULL*/)
	: CPropertySheet("Trace Setup", pParent)
{
	DlgInit();
}                       

CTraceGroupDialog::CTraceGroupDialog(CWnd* pParent, int tab)
	: CPropertySheet("Trace Setup", pParent, tab)
{                               
	DlgInit();
}

void CTraceGroupDialog::forlive(BOOL live)
{
	m_bModeless=live;
}

BEGIN_MESSAGE_MAP(CTraceGroupDialog, CPropertySheet)
	//{{AFX_MSG_MAP(CTraceGroupDialog)
	ON_WM_CREATE()
	ON_WM_SYSCOMMAND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog message handlers
int CTraceGroupDialog::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    // Add the preview window to the property sheet.

	int nReturn;
	if ((nReturn = CPropertySheet::OnCreate(lpCreateStruct))!=0)
		return nReturn;

	CenterWindow();
	return 0;
}

void CTraceGroupDialog::OnSysCommand(UINT nID, LPARAM lParam)
{
	// TODO: Add your message handler code here and/or call default
	// Disable to move or restore dialog.
	switch ( nID & 0x0FFF0 )
	{
		case SC_MOVE:
		//	return;
			break;
		default:
			break;
	}

	CPropertySheet::OnSysCommand(nID, lParam);
}

//void CTraceGroupDialog::OnOK()
//{
//	ASSERT_VALID(this);
//  
//    bStillOn=FALSE;
//	if (GetActivePage()->OnKillActive())
//	{
//		GetActivePage()->OnOK();
//		if (!m_bModeless&&!bStillOn)
//			EndDialog(IDOK);
//	}
//}

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpEventPage dialog

CTrcGrpEventPage::CTrcGrpEventPage()
	: CCheckPage(CTrcGrpEventPage::IDD)
{
	//{{AFX_DATA_INIT(CTrcGrpEventPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_event.nActiveEvent = 1;
	m_event.nEv1AddrMode = 1;
	m_event.Ev1StartAddrTxt[0]='\0';
	m_event.Ev1StartAddrTxt2[0]='\0';
	m_event.Ev1StartAddrTxt3[0]='\0';
	m_event.Ev1EndAddrTxt[0]='\0';
	m_event.nEv1AddrType = 0;
	m_event.nEv1DataMode = 1;
	m_event.Ev1StartDataTxt[0]='\0'; 
	m_event.Ev1StartDataTxt2[0]='\0';
	m_event.Ev1StartDataTxt3[0]='\0';
	m_event.Ev1EndDataTxt[0]='\0';
	m_event.nEv1DataType=0;

	m_event.Ev1DataWidthByte=TRUE;

	m_event.Ev1CountTxt[0]='\0';

	m_event.nEv2AddrMode = 1;
	m_event.Ev2StartAddrTxt[0]='\0'; 
	m_event.Ev2StartAddrTxt2[0]='\0';
	m_event.Ev2StartAddrTxt3[0]='\0';
	m_event.Ev2EndAddrTxt[0]='\0';
	m_event.nEv2AddrType = 0;
	m_event.nEv2DataMode = 1;
	m_event.Ev2StartDataTxt[0]='\0'; 
	m_event.Ev2StartDataTxt2[0]='\0';
	m_event.Ev2StartDataTxt3[0]='\0';
	m_event.Ev2EndDataTxt[0]='\0';
	m_event.nEv2DataType=0;

	m_event.Ev2DataWidthByte=TRUE;

	m_event.nEv3HL = 0;

//	m_nIDHelp=IDD_TRCGRP_EVENT;
	m_bApply=FALSE;

	GetEv1();
	GetEv2();
	GetEv3();
}

BOOL CTrcGrpEventPage::OnSetActive()
{
	CPropertyPage::OnSetActive();
	SetModified(m_bApply);
	return TRUE;
}

BOOL CTrcGrpEventPage::OnKillActive()
{
	if(m_bApply)
		m_bChanged=FALSE;
	return TRUE;
}

void CTrcGrpEventPage::OnOK()
{
	((CTraceGroupDialog*)GetParent())->forlive(FALSE);
	if(!m_bApply)
		return;
	if(OnSet())
	{
		CPropertyPage::OnOK();
		SetModified(FALSE);
		m_bApply=FALSE;
	}
	else ((CTraceGroupDialog*)GetParent())->forlive(TRUE);
}

void CTrcGrpEventPage::OnCancel()
{
	((CTraceGroupDialog*)GetParent())->forlive(FALSE);
}
void CTrcGrpEventPage::EnableEventCtrl(BOOL bEnable)
{
	GetDlgItem(IDC_GRPTRC_EVT_STATIC2)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDRMODE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_RANGE1)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_MULTI1)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_WILD1)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDR)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAMODE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_RANGE2)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_MULTI2)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_WILD2)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATA)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAWIDTH)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_WIDTHBYTE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_WIDTHWORD)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(!bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(!bEnable);
}

void CTrcGrpEventPage::EnableClearEvent(BOOL bEnable, BOOL bEv1)
{
	GetDlgItem(IDC_GRPTRC_EVT_STATIC2)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDRMODE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_RANGE1)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_MULTI1)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_WILD1)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDR)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAMODE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_RANGE2)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_MULTI2)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_WILD2)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATA)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAWIDTH)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_WIDTHBYTE)->EnableWindow(bEnable);
	GetDlgItem(IDC_GRPTRC_EVT_WIDTHWORD)->EnableWindow(bEnable);
	
	if (bEv1) 
	{  
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(bEnable);
		GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(bEnable);  
	}
	else{
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(FALSE);
	}
}

void CTrcGrpEventPage::ShowAddr(int ev)
{
	if (m_event.nEv1AddrMode!=1&&ev==1||m_event.nEv2AddrMode!=1&&ev==2)
	{
		GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
	}
	else
	{
		GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
		CComboBox* a=(CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
		a->SetCurSel((ev==1)?m_event.nEv1AddrType:m_event.nEv2AddrType);
	}
	if(ev==1)
	{
		if(m_event.nEv1AddrMode==1)
		{
			SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt);
			SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt);
		}
		else if(m_event.nEv1AddrMode==2)
			SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt2);
		else if(m_event.nEv1AddrMode==3)
			SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt3);
	}
	else
	{
		if(m_event.nEv2AddrMode==1)
		{
			SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt);
			SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt);
		}
		else if(m_event.nEv2AddrMode==2)
			SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt2);
		else if(m_event.nEv2AddrMode==3)
			SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt3);
	}
}

void CTrcGrpEventPage::ShowData(int ev)
{
	if (m_event.nEv1DataMode!=1&&ev==1||m_event.nEv2DataMode!=1&&ev==2)
	{
		GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Da&ta");
	}                       
	else
	{
		GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
		CComboBox* a=(CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
		a->SetCurSel((ev==1)?m_event.nEv1DataType:m_event.nEv2DataType);
	}
	if(ev==1)
	{
		if(m_event.nEv1DataMode==1)
		{
			SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt);
			SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt);
		}
		else if(m_event.nEv1DataMode==2)
			SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt2);
		else if(m_event.nEv1DataMode==3)
			SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt3);
	}
	else
	{
		if(m_event.nEv2DataMode==1)
		{
			SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt);
			SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt);
		}
		else if(m_event.nEv2DataMode==2)
			SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt2);
		else if(m_event.nEv2DataMode==3)
			SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt3);
	}
}

void CTrcGrpEventPage::Ev1Init()
{
	BOOL old=m_bApply;
	m_bApply=TRUE;		//walk through                     

	GetDlgItem(IDC_GRPTRC_EVT_CLEAR)->EnableWindow(TRUE);
	if (m_bEv1Clear){
		((CButton*)GetDlgItem(IDC_GRPTRC_EVT_CLEAR))->SetCheck(1);
		EnableClearEvent(FALSE, TRUE);
		m_bApply = old;
		return;
	}

	EnableClearEvent(TRUE, TRUE);

	((CButton*)GetDlgItem(IDC_GRPTRC_EVT_CLEAR))->SetCheck(0);
	if (m_event.nEv1AddrMode!=1)
	{
		GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
	}                       
	else
	{
		GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
	}
	if (m_event.nEv1DataMode!=1)
	{
		GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Da&ta");
	}
	else
	{
		GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
	}
	switch (m_event.nEv1AddrMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_RANGE1);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_MULTI1);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_WILD1);
		default:
			break;
	}
	switch (m_event.nEv1DataMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_RANGE2);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_MULTI2);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_WILD2);
		default:
			break;
	}
	if(m_event.nEv1AddrMode==1)
	{
		SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt);
		SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt);
	}
	else if(m_event.nEv1AddrMode==2)
		SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt2);
	else if(m_event.nEv1AddrMode==3)
		SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt3);

	CWnd* t=GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
	CComboBox* a=(CComboBox *)t;
	a->SetCurSel(m_event.nEv1AddrType);

	t=GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
	a=(CComboBox *)t;
	a->SetCurSel(m_event.nEv1DataType);
	if(m_event.nEv1DataMode==1) 
	{
		SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt);
		SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt);
	}              
	else if(m_event.nEv1DataMode==2)    
		SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt2);    
	else if(m_event.nEv1DataMode==3)    
		SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt3);    
	SetDlgItemText(IDC_GRPTRC_EVT_COUNT,m_event.Ev1CountTxt);

	if(m_event.Ev1DataWidthByte)
		CheckRadioButton(IDC_GRPTRC_EVT_WIDTHBYTE, IDC_GRPTRC_EVT_WIDTHWORD,IDC_GRPTRC_EVT_WIDTHBYTE);
	else
		CheckRadioButton(IDC_GRPTRC_EVT_WIDTHBYTE, IDC_GRPTRC_EVT_WIDTHWORD,IDC_GRPTRC_EVT_WIDTHWORD);

	m_bApply=old;    
}

void CTrcGrpEventPage::Ev2Init()
{
	BOOL old=m_bApply;
	m_bApply=TRUE;

	GetDlgItem(IDC_GRPTRC_EVT_CLEAR)->EnableWindow(TRUE);
	if (m_bEv2Clear){
		((CButton*)GetDlgItem(IDC_GRPTRC_EVT_CLEAR))->SetCheck(1);
		EnableClearEvent(FALSE, FALSE);
		m_bApply = old;
		return;
	}

	EnableClearEvent(TRUE, FALSE);

	((CButton*)GetDlgItem(IDC_GRPTRC_EVT_CLEAR))->SetCheck(0);
    if (m_event.nEv2AddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
    }
    if (m_event.nEv2DataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Da&ta");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
    }

    switch (m_event.nEv2AddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_WILD1);
        default:
            break;
    }

    switch (m_event.nEv2DataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_WILD2);
        default:
            break;
    }
    if(m_event.nEv2AddrMode==1)
	{
		SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt);
		SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt);
	}
    else if(m_event.nEv2AddrMode==2)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt2);
    else if(m_event.nEv2AddrMode==3)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt3);

    CWnd* t=GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv2AddrType);

    t=GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv2DataType);
    if(m_event.nEv2DataMode==1) 
	{
		SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt);
		SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt);
	}              
    else if(m_event.nEv2DataMode==2)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt2);    
    else if(m_event.nEv2DataMode==3)    
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt3);    
	if(m_event.Ev2DataWidthByte)
		CheckRadioButton(IDC_GRPTRC_EVT_WIDTHBYTE, IDC_GRPTRC_EVT_WIDTHWORD,IDC_GRPTRC_EVT_WIDTHBYTE);
	else
		CheckRadioButton(IDC_GRPTRC_EVT_WIDTHBYTE, IDC_GRPTRC_EVT_WIDTHWORD,IDC_GRPTRC_EVT_WIDTHWORD);

	m_bApply=old;
}

void CTrcGrpEventPage::Ev3Init()
{
	switch (m_event.nEv3HL)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW,IDC_GRPTRC_EVT_HIGH);
			break;
		case 0:
			CheckRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW,IDC_GRPTRC_EVT_LOW);
			break;
		default:
			break;
	}
}                                     

void CTrcGrpEventPage::GetEv1()
{
int ii;
char strData[100];
BUS_EVENT ev1;

	if(!TS_GetBusEv(1, m_bEv1Clear, ev1))
	{
		m_event.nEv1AddrMode = 1;
		m_event.Ev1StartAddrTxt[0]='\0';
		m_event.Ev1StartAddrTxt2[0]='\0';
		m_event.Ev1StartAddrTxt3[0]='\0';
		m_event.Ev1EndAddrTxt[0]='\0';
		m_event.nEv1AddrType = 0;
		m_event.nEv1DataMode = 1;
		m_event.Ev1StartDataTxt[0]='\0'; 
		m_event.Ev1StartDataTxt2[0]='\0'; 
		m_event.Ev1StartDataTxt3[0]='\0'; 
		m_event.Ev1EndDataTxt[0]='\0';
		m_event.nEv1DataType=0;
		m_event.Ev1DataWidthByte = TRUE;
		m_event.Ev1CountTxt[0]='\0';
		m_bEv1Clear = TRUE;
		return;
	}

//	if (m_bEv1Clear) return;
	
	switch (ev1.addrType)
	{
		case 0:
			m_event.nEv1AddrMode = 3;
			strcpy(m_event.Ev1StartAddrTxt3,"XXXX");
			break;
		case 2:                    
			GetWildCard(TRUE, 18, ev1.addrValue[0], ev1.addrValue[1], strData);
			strcpy(m_event.Ev1StartAddrTxt3, strData);
			m_event.nEv1AddrMode = 3;
			break;
		case 3:
			SetAddrText(ev1.addrValue[0], m_event.Ev1StartAddrTxt);
			SetAddrText(ev1.addrValue[1], m_event.Ev1EndAddrTxt);
			m_event.nEv1AddrType = 0;
			m_event.nEv1AddrMode = 1;
			break;
		case 1:                   
			m_event.Ev1StartAddrTxt2[0]=NULL;
			for(ii=0; ii<int(ev1.addrCount); ii++)
			{
				strcat(m_event.Ev1StartAddrTxt2,
					RetAddrText(ev1.addrValue[ii]));
				strcat(m_event.Ev1StartAddrTxt2," ");
			}
			m_event.nEv1AddrMode = 2;
			break;
		default:
			ASSERT(0);
			break;
	}
	if(ev1.dataType&0x80)
		m_event.Ev1DataWidthByte=FALSE;
	else
		m_event.Ev1DataWidthByte=TRUE;
	switch(ev1.dataType&0x7f)
	{
		case 0:   
			m_event.nEv1DataMode = 3;
			if(m_event.Ev1DataWidthByte)
				strcpy(m_event.Ev1StartDataTxt3,"XX");
			else
				strcpy(m_event.Ev1StartDataTxt3,"XXXX");
			break;
		case 2:
			GetWildCard(FALSE, m_event.Ev1DataWidthByte?8:16,
				ev1.dataValue1, ev1.dataValue2, strData);
			strcpy(m_event.Ev1StartDataTxt3, strData);
			m_event.nEv1DataMode = 3;
			break;
		case 3:
			if(m_event.Ev1DataWidthByte)
			{
				sprintf(m_event.Ev1StartDataTxt,"0x%02x",ev1.dataValue1);
				sprintf(m_event.Ev1EndDataTxt,"0x%02x",ev1.dataValue2);
			}
			else
			{
				sprintf(m_event.Ev1StartDataTxt,"0x%04x",ev1.dataValue1);
				sprintf(m_event.Ev1EndDataTxt,"0x%04x",ev1.dataValue2);
			}
			m_event.nEv1DataType=0;
			m_event.nEv1DataMode = 1;
			break;
		case 1:
			if(m_event.Ev1DataWidthByte)
				sprintf(m_event.Ev1StartDataTxt2,"0x%02x",ev1.dataValue1);
			else
				sprintf(m_event.Ev1StartDataTxt2,"0x%04x",ev1.dataValue1);
			m_event.nEv1DataMode = 2;
			break;
		default:
			ASSERT(0);
			break;
	}
	sprintf(m_event.Ev1CountTxt,"0x%04x",ev1.counter);
}

void CTrcGrpEventPage::GetEv2()
{
int ii;
char strData[100];
BUS_EVENT ev2;

	if(!TS_GetBusEv(2, m_bEv2Clear, ev2))
	{
		m_event.nEv2AddrMode = 1;
		m_event.Ev2StartAddrTxt[0]='\0';
		m_event.Ev2StartAddrTxt2[0]='\0';
		m_event.Ev2StartAddrTxt3[0]='\0';
		m_event.Ev2EndAddrTxt[0]='\0';
		m_event.nEv2AddrType = 0;
		m_event.nEv2DataMode = 1;
		m_event.Ev2StartDataTxt[0]='\0'; 
		m_event.Ev2StartDataTxt2[0]='\0';
		m_event.Ev2StartDataTxt3[0]='\0';
		m_event.Ev2EndDataTxt[0]='\0';
		m_event.nEv2DataType=0;
		m_event.Ev1DataWidthByte = TRUE;
		m_bEv2Clear = TRUE;
		return;
	}                      
	
//	if (m_bEv2Clear) return;
	
	switch (ev2.addrType)
	{
		case 0:                                  
			m_event.nEv2AddrMode = 3;
			strcpy(m_event.Ev2StartAddrTxt3,"XXXX");
			break;
		case 2:                    
			GetWildCard(TRUE, 18, ev2.addrValue[0], ev2.addrValue[1], strData);
			strcpy(m_event.Ev2StartAddrTxt3, strData);
			m_event.nEv2AddrMode = 3;
			break;
		case 3:
			SetAddrText(ev2.addrValue[0], m_event.Ev2StartAddrTxt);
			SetAddrText(ev2.addrValue[1], m_event.Ev2EndAddrTxt);
			m_event.nEv2AddrType = 0;
			m_event.nEv2AddrMode = 1;
			break;
		case 1:
			m_event.Ev2StartAddrTxt2[0]=NULL;
			for(ii=0; ii<int(ev2.addrCount); ii++)
			{
				strcat(m_event.Ev2StartAddrTxt2,
					RetAddrText(ev2.addrValue[ii]));
				strcat(m_event.Ev2StartAddrTxt2," ");
			}
			m_event.nEv2AddrMode = 2;
			break;
		default:
			ASSERT(0);
			break;
	}             
	if(ev2.dataType&0x80)
		m_event.Ev2DataWidthByte=FALSE;
	else
		m_event.Ev2DataWidthByte=TRUE;
	switch (ev2.dataType&0x7f)
	{
		case 0:   
			m_event.nEv2DataMode = 3;
			if(m_event.Ev2DataWidthByte)
				strcpy(m_event.Ev2StartDataTxt3,"XX");
			else
				strcpy(m_event.Ev2StartDataTxt3,"XXXX");
			break;
		case 2:
			GetWildCard(FALSE, m_event.Ev2DataWidthByte?8:16,
				ev2.dataValue1, ev2.dataValue2, strData);
			strcpy(m_event.Ev2StartDataTxt3, strData);
			m_event.nEv2DataMode = 3;
			break;
		case 3:
			if(m_event.Ev2DataWidthByte)
			{
				sprintf(m_event.Ev2StartDataTxt,"0x%02x",ev2.dataValue1);
				sprintf(m_event.Ev2EndDataTxt,"0x%02x",ev2.dataValue2);
			}
			else
			{
				sprintf(m_event.Ev2StartDataTxt,"0x%04x",ev2.dataValue1);
				sprintf(m_event.Ev2EndDataTxt,"0x%04x",ev2.dataValue2);
			}
			m_event.nEv2DataType=0;
			m_event.nEv2DataMode = 1;
			break;
		case 1:
			if(m_event.Ev2DataWidthByte)
				sprintf(m_event.Ev2StartDataTxt2,"0x%02x",ev2.dataValue1);
			else
				sprintf(m_event.Ev2StartDataTxt2,"0x%04x",ev2.dataValue1);
			m_event.nEv2DataMode = 2;
			break;
		default:
			ASSERT(0);
			break;
	}
}

void CTrcGrpEventPage::GetEv3()
{
WORD ev3;

	if(!TS_GetExtEv(ev3))
	{  
		ASSERT(0);
		return;
	}
	m_event.nEv3HL = ev3;
}

void CTrcGrpEventPage::SetEv1()
{
STATUS nRetSvr;

	BeginWaitCursor();
	nRetSvr=TS_SetBusEv(1, m_bEv1Clear, m_EvBus);
	EndWaitCursor();
	if (ICE_OK!=nRetSvr)
		ErrDisplayError(ER_ICE_OK+nRetSvr);
}

void CTrcGrpEventPage::SetEv2()
{
STATUS nRetSvr;

	BeginWaitCursor();
	nRetSvr=TS_SetBusEv(2, m_bEv2Clear, m_EvBus);
	EndWaitCursor();

	if (ICE_OK!=nRetSvr)
		ErrDisplayError(ER_ICE_OK+nRetSvr);
}

void CTrcGrpEventPage::SetEv3()
{
STATUS nRetSvr;

	BeginWaitCursor();
	nRetSvr = TS_SetExtEv(WORD(m_event.nEv3HL));
	EndWaitCursor();

	if (ICE_OK!=nRetSvr)
		ErrDisplayError(ER_ICE_OK+nRetSvr);
}

BOOL CTrcGrpEventPage::OnSet()				//tab1
{
unsigned char status;

	GetCpuStatus(status);
	if(status==STATUS_GO)				//CPU is run
	{
		ErrDisplayError(ER_EMU_GOFLY_ERR_MSG);
		return FALSE;
	}
	m_bEmptyFlag=TRUE;
	m_nold_addrmode=0;
	m_nold_datamode=0;

	m_nErrLocate=0;		//1:startaddr; 2:endaddr; 3:startdata; 4:enddata
						//5:count.
	switch(m_event.nActiveEvent)						//ev1
	{
		case 1:             
			if (m_bEv1Clear){
				SetEv1();
				return TRUE;
			}
			
			if(m_event.nEv1AddrMode==3)				//default
				chkWildAddr(m_event.Ev1StartAddrTxt3);
			else if(m_event.nEv1AddrMode==1)
				chkRangeAddr(m_event.nEv1AddrType, m_event.Ev1StartAddrTxt,
							m_event.Ev1EndAddrTxt);
			else if(m_event.nEv1AddrMode==2)
				chkMultipleAddr(m_event.Ev1StartAddrTxt2);
			if(m_nErrLocate)
				break;
			if(m_event.nEv1DataMode==3)
				chkWildData(m_event.Ev1StartDataTxt3,m_event.Ev1DataWidthByte);
			else if(m_event.nEv1DataMode==1)
	            chkRangeData(m_event.nEv1DataType, m_event.Ev1StartDataTxt,
							m_event.Ev1EndDataTxt,m_event.Ev1DataWidthByte);
			else if(m_event.nEv1DataMode==2)
				chkSingleData(m_event.Ev1StartDataTxt2,m_event.Ev1DataWidthByte);
			if(m_nErrLocate)
				break;
			m_EvBus.dataType|=(m_event.Ev1DataWidthByte?0:0x80);
			chkCount(m_event.Ev1CountTxt);
			if(m_nErrLocate)
				break;
			if(!m_event.Ev1DataWidthByte)
				m_EvBus.dataType|=0x80;
			if(!m_bEmptyFlag)
			{
				SetEv1();
				if(m_nold_datamode)
				{
					m_event.nEv1DataMode=3;
					if(m_event.Ev1DataWidthByte)
						strcpy(m_event.Ev1StartDataTxt3,"XX");
					else
						strcpy(m_event.Ev1StartDataTxt3,"XXXX");
				}
				if(m_nold_addrmode)
				{
					m_event.nEv1AddrMode=3;
					strcpy(m_event.Ev1StartAddrTxt3,"XXXX");
				}
				if(m_nold_addrmode||m_nold_datamode)
					Ev1Init();
				return TRUE;
			}
			else
			{
				ErrDisplayError(ER_TRC_NONEINPUT);
				return FALSE;
			}
				break;
		case 2:                                         //ev2
			if (m_bEv2Clear){
				SetEv2();
				return TRUE;
			}
			
			if(m_event.nEv2AddrMode==3)				//default
				chkWildAddr(m_event.Ev2StartAddrTxt3);
			else if(m_event.nEv2AddrMode==1)
				chkRangeAddr(m_event.nEv2AddrType, m_event.Ev2StartAddrTxt,
							m_event.Ev2EndAddrTxt);
			else if(m_event.nEv2AddrMode==2)
				chkMultipleAddr(m_event.Ev2StartAddrTxt2);
			if(m_nErrLocate)
				break;
			if(m_event.nEv2DataMode==3)				//data
				chkWildData(m_event.Ev2StartDataTxt3,m_event.Ev2DataWidthByte);
			else if(m_event.nEv2DataMode==1)
				chkRangeData(m_event.nEv2DataType, m_event.Ev2StartDataTxt,
							m_event.Ev2EndDataTxt,m_event.Ev2DataWidthByte);
			else if(m_event.nEv2DataMode==2)
				chkSingleData(m_event.Ev2StartDataTxt2,m_event.Ev2DataWidthByte);
			if(m_nErrLocate)
				break;
			if(!m_event.Ev2DataWidthByte)
				m_EvBus.dataType|=0x80;
			if(!m_bEmptyFlag)
			{
				SetEv2();
				if(m_nold_datamode)
				{
					m_event.nEv2DataMode=3;
					if(m_event.Ev2DataWidthByte)
						strcpy(m_event.Ev2StartDataTxt3,"XX");
					else
						strcpy(m_event.Ev2StartDataTxt3,"XXXX");
				}
				if(m_nold_addrmode)
				{
					m_event.nEv2AddrMode=3;
					strcpy(m_event.Ev2StartAddrTxt3,"XXXX");
				}
				if(m_nold_addrmode||m_nold_datamode)
					Ev2Init();
				return TRUE;
			}
			else
			{
				ErrDisplayError(ER_TRC_NONEINPUT);
				return FALSE;
			}
			break;
		case 3:											//ev3
			SetEv3();
			return TRUE;
		default:
			return FALSE;
	}
	if(m_nErrLocate==1)
		GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->SetFocus();
	else if(m_nErrLocate==2)
		GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->SetFocus();
	else if(m_nErrLocate==3)
		GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->SetFocus();
	else if(m_nErrLocate==4)
		GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->SetFocus();
	else if(m_nErrLocate==5)
		GetDlgItem(IDC_GRPTRC_EVT_COUNT)->SetFocus();
	return FALSE;
}

void CTrcGrpEventPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrcGrpEventPage)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}                                         

BEGIN_MESSAGE_MAP(CTrcGrpEventPage, CPropertyPage)
	//{{AFX_MSG_MAP(CTrcGrpEventPage)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_EV1, OnGrptrcEvtEv1)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_EV2, OnGrptrcEvtEv2)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_EV3, OnGrptrcEvtEv3)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_MULTI1, OnGrptrcEvtMulti1)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_MULTI2, OnGrptrcEvtMulti2)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_RANGE1, OnGrptrcEvtRange1)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_RANGE2, OnGrptrcEvtRange2)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_WILD1, OnGrptrcEvtWild1)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_WILD2, OnGrptrcEvtWild2)
	ON_CBN_SELCHANGE(IDC_GRPTRC_EVT_ADDRTYPE, OnSelendokGrptrcEvtAddrtype)
	ON_CBN_SELCHANGE(IDC_GRPTRC_EVT_DATATYPE, OnSelendokGrptrcEvtDatatype)
	ON_EN_CHANGE(IDC_GRPTRC_EVT_STARTADDR, OnChangeGrptrcEvtStartaddr)
	ON_EN_CHANGE(IDC_GRPTRC_EVT_STARTDATA, OnChangeGrptrcEvtStartdata)
	ON_EN_CHANGE(IDC_GRPTRC_EVT_ENDADDR, OnChangeGrptrcEvtEndaddr)
	ON_EN_CHANGE(IDC_GRPTRC_EVT_ENDDATA, OnChangeGrptrcEvtEnddata)
	ON_EN_CHANGE(IDC_GRPTRC_EVT_COUNT, OnChangeGrptrcEvtCount)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_HIGH, OnGrptrcEvtHigh)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_LOW, OnGrptrcEvtLow)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_WIDTHBYTE, OnGrptrcEvtWidthbyte)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_WIDTHWORD, OnGrptrcEvtWidthword)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_CLEAR, OnGrptrcEvtClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcGrpEventPage message handlers

BOOL CTrcGrpEventPage::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here
	CheckRadioButton(IDC_GRPTRC_EVT_EV1,IDC_GRPTRC_EVT_EV3,IDC_GRPTRC_EVT_EV1);
	GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(FALSE);
	GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(FALSE);
	Ev1Init();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcGrpEventPage::OnGrptrcEvtEv1()
{
	// TODO: Add your control notification handler code here
	if(m_event.nActiveEvent == 1)
		return;
	if(m_event.nActiveEvent == 2)
	{
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(TRUE); 
	}
	else
		EnableEventCtrl(TRUE);
		
	m_event.nActiveEvent = 1;                            
	Ev1Init();
}

void CTrcGrpEventPage::OnGrptrcEvtEv2()
{
	// TODO: Add your control notification handler code here
	if(m_event.nActiveEvent == 2)
		return;
	if(m_event.nActiveEvent == 1)
	{
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(FALSE);
		EnableEventCtrl(TRUE);
	}
	m_event.nActiveEvent = 2;
	Ev2Init();
}

void CTrcGrpEventPage::OnGrptrcEvtEv3()
{
	// TODO: Add your control notification handler code here
	if(m_event.nActiveEvent == 3)
		return;
	m_event.nActiveEvent = 3;
	EnableEventCtrl(FALSE);
	GetDlgItem(IDC_GRPTRC_EVT_CLEAR)->EnableWindow(FALSE);
	Ev3Init();
}

void CTrcGrpEventPage::OnGrptrcEvtMulti1()
{
	// TODO: Add your control notification handler code here

	switch (m_event.nActiveEvent)
	{
		case 1:   
			if(m_event.nEv1AddrMode==2)
				return;
			m_event.nEv1AddrMode = 2;
			ShowAddr(1);
			break;
		case 2:
			if(m_event.nEv2AddrMode==2)
				return;
			m_event.nEv2AddrMode = 2;
			ShowAddr(2);
			break;
		default:
			break;
	}
}

void CTrcGrpEventPage::OnGrptrcEvtMulti2()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			if(m_event.nEv1DataMode==2)
				return;
			m_event.nEv1DataMode = 2;
			ShowData(1);
			break;
		case 2:
			if(m_event.nEv2DataMode==2)
				return;
			m_event.nEv2DataMode = 2;
			ShowData(2);
			break;
		default:
			break;
	}
}

void CTrcGrpEventPage::OnGrptrcEvtRange1()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			if(m_event.nEv1AddrMode==1)
				return;
			m_event.nEv1AddrMode = 1;
			ShowAddr(1);
			break;
		case 2:
			if(m_event.nEv2AddrMode==1)
				return;
			m_event.nEv2AddrMode = 1;
			ShowAddr(2);
			break;
		default:
			break;
	}
}

void CTrcGrpEventPage::OnGrptrcEvtRange2()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			if(m_event.nEv1DataMode==1)
				return;
			m_event.nEv1DataMode = 1;
			ShowData(1);
			break;
		case 2:
			if(m_event.nEv2DataMode==1)
				return;
			m_event.nEv2DataMode = 1;
			ShowData(2);
			break;
		default:
			break;
	}
}

void CTrcGrpEventPage::OnGrptrcEvtWild1()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			if(m_event.nEv1AddrMode==3)
				return;
			m_event.nEv1AddrMode = 3;
			ShowAddr(1);
			break;
		case 2:
			if(m_event.nEv2AddrMode==3)
				return;
			m_event.nEv2AddrMode = 3;
			ShowAddr(2);
			break;
		default:
			break;
	}
}

void CTrcGrpEventPage::OnGrptrcEvtWild2()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			if(m_event.nEv1DataMode==3)
				return;
			m_event.nEv1DataMode = 3;
			ShowData(1);
			break;
		case 2:
			if(m_event.nEv2DataMode==3)
				return;
			m_event.nEv2DataMode = 3;
			ShowData(2);
			break;
		default:
			break;
	}
}

void CTrcGrpEventPage::OnSelendokGrptrcEvtAddrtype()
{
	// TODO: Add your control notification handler code here
	CComboBox* t;
	t = (CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
	int i=t->GetCurSel();
	switch (m_event.nActiveEvent)
	{
		case 1:   
			m_event.nEv1AddrType = i;
			break;
		case 2:
			m_event.nEv2AddrType = i;
			break;
		default:
			break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnSelendokGrptrcEvtDatatype()
{
	// TODO: Add your control notification handler code here
	CComboBox* t;
	t = (CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
	int i=t->GetCurSel();
	switch (m_event.nActiveEvent)
	{
		case 1:   
			m_event.nEv1DataType = i;
			break;
		case 2:
			m_event.nEv2DataType = i;
			break;
		default:
			break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}    
}

void CTrcGrpEventPage::OnChangeGrptrcEvtStartaddr()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:
			if(m_event.nEv1AddrMode==1)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt,64);
			else if(m_event.nEv1AddrMode==2)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt2,164);
			else if(m_event.nEv1AddrMode==3)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt3,64);
				break;
		case 2:                                                          
			if(m_event.nEv2AddrMode==1) 
				GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt,64);
			else if(m_event.nEv2AddrMode==2)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt2,164);
			else if(m_event.nEv2AddrMode==3)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt3,64);
			break;
		default:
			break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnChangeGrptrcEvtStartdata()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			if(m_event.nEv1DataMode==1)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt,64);
			else if(m_event.nEv1DataMode==2)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt2,64);
			else if(m_event.nEv1DataMode==3)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt3,64);
				break;
		case 2:                                                          
			if(m_event.nEv2DataMode==1)         
				GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt,64);
			else if(m_event.nEv2DataMode==2)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt2,64);
			else if(m_event.nEv2DataMode==3)
				GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt3,64);
			break;
		default:
		    break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnChangeGrptrcEvtEndaddr()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			GetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt,64);
			break;
		case 2:                                                          
			GetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt,64);
			break;
		default:
			break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnChangeGrptrcEvtEnddata()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			GetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt,64);
			break;
		case 2:                                                          
			GetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt,64);
			break;
		default:
			break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnChangeGrptrcEvtCount()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:   
			GetDlgItemText(IDC_GRPTRC_EVT_COUNT,m_event.Ev1CountTxt,64);
			break;
		default:
			break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

/*
void CTrcGrpEventPage::OnGrptrcEvtAk()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_AK)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1AK = check;
            break;
        case 2:                                                          
            m_event.bEv2AK = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnGrptrcEvtF()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_F)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1F = check;
            break;
        case 2:                                                          
            m_event.bEv2F = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}
*/
void CTrcGrpEventPage::OnGrptrcEvtHigh()
{
	// TODO: Add your control notification handler code here
	if(m_event.nEv3HL==1)
		return;
	m_event.nEv3HL = 1;
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnGrptrcEvtLow()
{
	// TODO: Add your control notification handler code here
	if(m_event.nEv3HL==0)
		return;
	m_event.nEv3HL = 0;
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}
/*
void CTrcGrpEventPage::OnGrptrcEvtR()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_R)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1R = check;
            break;
        case 2:                                                          
            m_event.bEv2R = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnGrptrcEvtS()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_S)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1S = check;
            break;
        case 2:                                                          
            m_event.bEv2S = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnGrptrcEvtW()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_W)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1W = check;
            break;
        case 2:                                                          
            m_event.bEv2W = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}
*/

void CTrcGrpEventPage::OnGrptrcEvtWidthbyte()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:
			if(m_event.Ev1DataWidthByte)
				return;
			else {
				m_event.Ev1DataWidthByte=TRUE; 
				if (m_event.nEv1DataMode == 3 && 
					strcmp(m_event.Ev1StartDataTxt3, "XXXX")==0)
				{
					strcpy(m_event.Ev1StartDataTxt3, "XX");    
					SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA, m_event.Ev1StartDataTxt3);
				}
			}
			break;
		case 2:
			if(m_event.Ev2DataWidthByte)
				return;
			else {
				m_event.Ev2DataWidthByte=TRUE;         
				if (m_event.nEv2DataMode == 3 && 
					strcmp(m_event.Ev2StartDataTxt3, "XXXX")==0)
				{
					strcpy(m_event.Ev2StartDataTxt3, "XX");    
					SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA, m_event.Ev2StartDataTxt3);
				}
			}
			break;
		default:
			ASSERT(0);
			break;
	} 
	
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpEventPage::OnGrptrcEvtWidthword()
{
	// TODO: Add your control notification handler code here
	switch (m_event.nActiveEvent)
	{
		case 1:
			if(!m_event.Ev1DataWidthByte)
				return;
			else{
				m_event.Ev1DataWidthByte=FALSE;
				if (m_event.nEv1DataMode == 3 && 
					strcmp(m_event.Ev1StartDataTxt3, "XX")==0)
				{
					strcpy(m_event.Ev1StartDataTxt3, "XXXX");    
					SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA, m_event.Ev1StartDataTxt3);
				}
			}
			break;
		case 2:
			if(!m_event.Ev2DataWidthByte)
				return;
			else{
				m_event.Ev2DataWidthByte=FALSE;
				if (m_event.nEv2DataMode == 3 && 
					strcmp(m_event.Ev2StartDataTxt3, "XX")==0)
				{
					strcpy(m_event.Ev2StartDataTxt3, "XXXX");    
					SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA, m_event.Ev2StartDataTxt3);
				}   
			}
			break;
		default:
			ASSERT(0);
			break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTrcctrlPage dialog

CTrcGrpTrcctrlPage::CTrcGrpTrcctrlPage()
	: CCheckPage(CTrcGrpTrcctrlPage::IDD)
{
	//{{AFX_DATA_INIT(CTrcGrpTrcctrlPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
TRIGGER_LOGIC Trig;

	if(!TS_GetTraceOnGo(m_traceControl.bStartTrace))
		ASSERT(0);
	if(!TS_GetTrigger(Trig))
		ASSERT(0);
	switch (Trig.trigFlag)
	{
		case 0:
			m_traceControl.nDelay = 4;
			//sprintf(m_traceControl.delayTxt,"0x%x",Trig.m_trig.DlayCnt);
			sprintf(m_traceControl.delayTxt,"%u",Trig.delayCount);
			break;
		case 1:		//forward
			m_traceControl.nDelay = 3;
			break;
		case 2:		//backward
			m_traceControl.nDelay = 1;
			break;
		case 3:		//center
			m_traceControl.nDelay = 2;
			break;
		default:
			ASSERT(0);
			break;  
	}
	//m_nIDHelp=IDD_TRCGRP_CONTROL;
	m_bApply=FALSE;
}

BOOL CTrcGrpTrcctrlPage::OnSetActive()
{
	CPropertyPage::OnSetActive();
	SetModified(m_bApply);
	return TRUE;
}

BOOL CTrcGrpTrcctrlPage::OnKillActive()
{
	if(m_bApply)
		m_bChanged=FALSE;
	return TRUE;
}

void CTrcGrpTrcctrlPage::OnOK()
{
	((CTraceGroupDialog*)GetParent())->forlive(FALSE);
	if(!m_bApply)
		return;
	if(OnSet())
	{
		CPropertyPage::OnOK();
		SetModified(FALSE);
		m_bApply=FALSE;
	}
	else ((CTraceGroupDialog*)GetParent())->forlive(TRUE);
}

void CTrcGrpTrcctrlPage::OnCancel()
{
	((CTraceGroupDialog*)GetParent())->forlive(FALSE);
}

void CTrcGrpTrcctrlPage::TraceControlInit()
{                                             
	BOOL old=m_bApply;
	m_bApply=TRUE;
	if(m_traceControl.bStartTrace)
		CheckDlgButton(IDC_GRPTRC_TRC_STARTTRACE, TRUE);
	else
		CheckDlgButton(IDC_GRPTRC_TRC_STARTTRACE, FALSE);

	switch (m_traceControl.nDelay)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_PRETRG);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_CENTRG);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_POSTTRG);
			break;
		case 4:
			CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_DELAY);
			break;
		default:
			ASSERT(0);
			break;
	}

	if (m_traceControl.nDelay==4)
	{
		GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(TRUE);
		SetDlgItemText(IDC_GRPTRC_TRC_COMBO,m_traceControl.delayTxt);
	}
	else
		GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
	m_bApply=old;
}                          

BOOL CTrcGrpTrcctrlPage::OnSet()					//tab2
{
ADDRESS	adr;
ADDR_RETCODE	ret;
unsigned char status;
STATUS retSvr;
TRIGGER_LOGIC trig;

	m_nErrLocate=0;
	GetCpuStatus(status);
	if(status==STATUS_GO)				//CPU is run
	{
		ErrDisplayError(ER_EMU_GOFLY_ERR_MSG);
		return FALSE;
	}
	if (m_traceControl.nDelay==4)
		chkDelay(m_traceControl.delayTxt);
	if(m_nErrLocate)
	{
		GetDlgItem(IDC_GRPTRC_TRC_COMBO)->SetFocus();
		return FALSE;
	}
	retSvr=TS_SetTraceOnGo(m_traceControl.bStartTrace);
	if(retSvr!=ICE_OK)
		ErrDisplayError(retSvr+ER_ICE_OK);
	if(!TS_GetTrigger(trig))
		ASSERT(0);
	switch (m_traceControl.nDelay)
	{
		case 1:
			trig.trigFlag = 2;         //backward
			break;
		case 2:
			trig.trigFlag = 3;         //center
			break;
		case 3:
			trig.trigFlag = 1;			//forward
			break;
		case 4:
			trig.trigFlag = 0;			//delay count
			//just like chkcount routine
			ret=AdrTextToAddr(m_traceControl.delayTxt, adr, 0);
			if(ret!=ADR_OK||adr.adrAddress>0x7fff)
			{
				ErrDisplayError(ER_TRC_COUNT_ERR);
				return FALSE;
			}
			trig.delayCount=adr.adrAddress;
			break;
		default:
			ASSERT(0);
			break;  
	}
	BeginWaitCursor();
	retSvr=TS_SetTrigger(trig);//trigFlag, delayCount
	EndWaitCursor();
	if(ICE_OK!=retSvr)
	{
		ErrDisplayError(ER_ICE_OK+retSvr);
		return FALSE; 
	}
	return TRUE;
}

void CTrcGrpTrcctrlPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrcGrpTrcctrlPage)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTrcGrpTrcctrlPage, CPropertyPage)
	//{{AFX_MSG_MAP(CTrcGrpTrcctrlPage)
	ON_BN_CLICKED(IDC_GRPTRC_TRC_STARTTRACE, OnGrptrcTrcStarttrace)
	ON_BN_CLICKED(IDC_GRPTRC_TRC_CENTRG, OnGrptrcTrcCentrg)
	ON_BN_CLICKED(IDC_GRPTRC_TRC_DELAY, OnGrptrcTrcDelay)
	ON_BN_CLICKED(IDC_GRPTRC_TRC_POSTTRG, OnGrptrcTrcPosttrg)
	ON_BN_CLICKED(IDC_GRPTRC_TRC_PRETRG, OnGrptrcTrcPretrg)
	ON_EN_CHANGE(IDC_GRPTRC_TRC_COMBO, OnChangeGrptrcTrcCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTrcctrlPage message handlers
BOOL CTrcGrpTrcctrlPage::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here
	TraceControlInit();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcStarttrace()
{
	// TODO: Add your control notification handler code here
	m_traceControl.bStartTrace = !m_traceControl.bStartTrace;
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}    
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcCentrg()
{
	// TODO: Add your control notification handler code here
	if(m_traceControl.nDelay == 2)
		return;
	m_traceControl.nDelay = 2;
	GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}    
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcDelay()
{
	// TODO: Add your control notification handler code here
	if(m_traceControl.nDelay==4)
		return;
	m_traceControl.nDelay = 4;
	GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(TRUE);
	GotoDlgCtrl(GetDlgItem(IDC_GRPTRC_TRC_COMBO));
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcPosttrg()
{
	// TODO: Add your control notification handler code here
	if(m_traceControl.nDelay==3)
		return;
	m_traceControl.nDelay = 3;
	GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcPretrg()
{
	// TODO: Add your control notification handler code here
	if(m_traceControl.nDelay==1)
		return;
	m_traceControl.nDelay = 1;
	GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpTrcctrlPage::OnChangeGrptrcTrcCombo()
{
	// TODO: Add your control notification handler code here

	GetDlgItemText(IDC_GRPTRC_TRC_COMBO, m_traceControl.delayTxt, 64);
	if(!m_bApply&&m_traceControl.delayTxt[0]!=0)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTriggerPage dialog

CTrcGrpTriggerPage::CTrcGrpTriggerPage()
	: CPropertyPage(CTrcGrpTriggerPage::IDD)
{
	//{{AFX_DATA_INIT(CTrcGrpTriggerPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
TRIGGER_LEVEL level;
TRIGGER_LOGIC trig;

	m_trigger.nActiveLevel = 1;
	if(!TS_GetLevel(1, level))
		m_trigger.level1.nSet=10;		//ev1 or ev2 or ev3
	else
		m_trigger.level1.nSet=GetLvCondIndex(level.dwCond);
	if(!TS_GetLevel(2, level))
		m_trigger.level2.nSet=10;		//ev1 or ev2 or ev3
	else
		m_trigger.level2.nSet=GetLvCondIndex(level.dwCond);

	if(!TS_GetTrigger(trig))
	{
		m_trigger.bRun = FALSE;
		m_trigger.nTriggerSet = 0;
	}
	else
	{
		m_trigger.bRun = trig.runFlag;
		m_trigger.nTriggerSet = GetTrigLvIdIndex(trig);
	}
	if(!TS_GetTrigStatus(m_trigger.bTriggerEnable))
		m_trigger.bTriggerEnable = TRUE;

	m_bApply=FALSE;
	//m_nIDHelp=IDD_TRCGRP_TRIGGER;
}

BOOL CTrcGrpTriggerPage::OnSetActive()
{
	CPropertyPage::OnSetActive();
	SetModified(m_bApply);
	return TRUE;
}

BOOL CTrcGrpTriggerPage::OnKillActive()
{
	if(m_bApply)
		m_bChanged=FALSE;
	return TRUE;
}

void CTrcGrpTriggerPage::OnOK()
{
	((CTraceGroupDialog*)GetParent())->forlive(FALSE);
	if(!m_bApply)
		return;
	if(OnSet())
	{
		CPropertyPage::OnOK();
		SetModified(FALSE);
		m_bApply=FALSE;
	}
	else
		((CTraceGroupDialog*)GetParent())->forlive(TRUE);
}

void CTrcGrpTriggerPage::OnCancel()
{
	((CTraceGroupDialog*)GetParent())->forlive(FALSE);
}

void CTrcGrpTriggerPage::TriggerInit()
{
	CComboBox* a;
	switch (m_trigger.nActiveLevel)
	{
		case 1:               
			CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV1);
			a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
			a->SetCurSel(m_trigger.level1.nSet);
			break;
		case 2:
		    CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV2);
		    a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
		    a->SetCurSel(m_trigger.level2.nSet);
		    break;
		default:
			ASSERT(0);
		    break;
	}
	if (m_trigger.bTriggerEnable)
		CheckRadioButton(IDC_GRPTRC_TRG_ENABLE, IDC_GRPTRC_TRG_DISABLE, IDC_GRPTRC_TRG_ENABLE);
	else
		CheckRadioButton(IDC_GRPTRC_TRG_ENABLE, IDC_GRPTRC_TRG_DISABLE, IDC_GRPTRC_TRG_DISABLE);
	CheckDlgButton(IDC_GRPTRC_TRG_RUN, m_trigger.bRun);
	a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_COMBO);
	a->SetCurSel(m_trigger.nTriggerSet);
}

DWORD CTrcGrpTriggerPage::GetLvCond(int nIndex)
{
	switch (nIndex)
	{
		case 0:
			return (DWORD)0xaaaaaaaa;
		case 1:
			return (DWORD)0xcccccccc;
		case 2:
			return (DWORD)0xf0f0f0f0;
		case 3:
			return (DWORD)0x88888888;
		case 4:
			return (DWORD)0xa0a0a0a0;
		case 5:
			return (DWORD)0xc0c0c0c0;
		case 6:
			return (DWORD)0xeeeeeeee;
		case 7:
			return (DWORD)0xfafafafa;
		case 8:
			return (DWORD)0xfcfcfcfc;
		case 9:
			return (DWORD)0x80808080;
		case 10:
			return (DWORD)0xfefefefe;
		case 11:
			return (DWORD)0xf8f8f8f8;
		case 12:
			return (DWORD)0xecececec;
		case 13:
			return (DWORD)0xeaeaeaea;
		case 14:
			return (DWORD)0xe0e0e0e0;
		case 15:
			return (DWORD)0xc8c8c8c8;
		case 16:
			return (DWORD)0xa8a8a8a8;
		default:
			ASSERT(0);
		    return (DWORD)-1;
	}
}

int CTrcGrpTriggerPage::GetLvCondIndex(DWORD dwCond)
{
	switch (dwCond)
	{
		case (DWORD)0xaaaaaaaa:
			return 0;
		case (DWORD)0xcccccccc:
			return 1;
		case (DWORD)0xf0f0f0f0:
			return 2;
		case (DWORD)0x88888888:
			return 3;
		case (DWORD)0xa0a0a0a0:
			return 4;
		case (DWORD)0xc0c0c0c0:
			return 5;
		case (DWORD)0xeeeeeeee:
			return 6;
		case (DWORD)0xfafafafa:
			return 7;
		case (DWORD)0xfcfcfcfc:
			return 8;
		case (DWORD)0x80808080:
			return 9;
		case (DWORD)0xfefefefe:
			return 10;
		case (DWORD)0xf8f8f8f8:
			return 11;
		case (DWORD)0xecececec:
			return 12;
		case (DWORD)0xeaeaeaea:
			return 13;
		case (DWORD)0xe0e0e0e0:
			return 14;
		case (DWORD)0xc8c8c8c8:
			return 15;
		case (DWORD)0xa8a8a8a8:
			return 16;
		default:
			ASSERT(0);
		    return -1;
	}
}

int  CTrcGrpTriggerPage::GetTrigLvIdIndex(TRIGGER_LOGIC trig)
{
	if (trig.levelCount==1)
	{
		if (trig.levelID[0]==1)
			return 0;
		else if (trig.levelID[0]==2)
			return 1;
	}
	else if (trig.levelCount==2)
	{
		if ((trig.levelID[0]==1)&&(trig.levelID[1]==2))
			return 2;
	}
	ASSERT(0);
	return -1;
}

void CTrcGrpTriggerPage::SetTrigLvId(int nIndex, TRIGGER_LOGIC& trig)
{
	trig.levelCount=1;
	trig.levelID[0]=1;
	if(nIndex==0)
		;
	else if(nIndex==1)
		trig.levelID[0]=2;
	else if(nIndex==2)
	{
		trig.levelCount=2;
		trig.levelID[1]=2;
	}
	else
		ASSERT(0);
}

void CTrcGrpTriggerPage::SetLevel(int nLvID)
{
TRIGGER_LEVEL level;
STATUS retSvr;

	if(nLvID==1)
		level.dwCond=GetLvCond(m_trigger.level1.nSet);
	else
		level.dwCond=GetLvCond(m_trigger.level2.nSet);
	BeginWaitCursor();
	retSvr=TS_SetLevel(nLvID, level);
	EndWaitCursor();
	if (ICE_OK!=retSvr)
		ErrDisplayError(ER_ICE_OK+retSvr);
}

void CTrcGrpTriggerPage::SetTrigger()
{
STATUS retSvr;
TRIGGER_LOGIC trig;

	if(!TS_GetTrigger(trig))
		ASSERT(0);
	trig.runFlag=(FLAG)m_trigger.bRun;
	SetTrigLvId(m_trigger.nTriggerSet, trig);

	BeginWaitCursor();
	retSvr=TS_SetTrigger(trig);
	EndWaitCursor();
	if (ICE_OK!=retSvr)
		ErrDisplayError(ER_ICE_OK+retSvr);
	BeginWaitCursor();
	retSvr=TS_SetTrigStatus(m_trigger.bTriggerEnable);
	EndWaitCursor();
	if (ICE_OK!=retSvr)
		ErrDisplayError(ER_ICE_OK+retSvr);
}

BOOL CTrcGrpTriggerPage::OnSet()			//tab3
{
unsigned char status;

	GetCpuStatus(status);
	if(status==STATUS_GO)				//CPU is run
	{
		ErrDisplayError(ER_EMU_GOFLY_ERR_MSG);
		return FALSE;
	}
	
	switch (m_trigger.nActiveLevel)
	{
		case 1:
			SetLevel(1);
			break;
		case 2:
			SetLevel(2);
			break;
		default:
			break;
	}
	SetTrigger();
	return TRUE;
}

void CTrcGrpTriggerPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrcGrpTriggerPage)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTrcGrpTriggerPage, CPropertyPage)
	//{{AFX_MSG_MAP(CTrcGrpTriggerPage)
	ON_BN_CLICKED(IDC_GRPTRC_TRG_LV1, OnGrptrcTrgLv1)
	ON_BN_CLICKED(IDC_GRPTRC_TRG_LV2, OnGrptrcTrgLv2)
	ON_CBN_SELCHANGE(IDC_GRPTRC_TRG_EVTYPE, OnSelendokGrptrcTrgEvtype)
	ON_BN_CLICKED(IDC_GRPTRC_TRG_ENABLE, OnGrptrcTrgEnable)
	ON_BN_CLICKED(IDC_GRPTRC_TRG_DISABLE, OnGrptrcTrgDisable)
	ON_BN_CLICKED(IDC_GRPTRC_TRG_RUN, OnGrptrcTrgRun)
	ON_CBN_SELCHANGE(IDC_GRPTRC_TRG_COMBO, OnSelendokGrptrcTrgCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTriggerPage message handlers

BOOL CTrcGrpTriggerPage::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here
	TriggerInit();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcGrpTriggerPage::OnGrptrcTrgLv1()
{
	// TODO: Add your control notification handler code here
	if(m_trigger.nActiveLevel==1)
		return;
	m_trigger.nActiveLevel = 1;
	TriggerInit();
}

void CTrcGrpTriggerPage::OnGrptrcTrgLv2()
{
	// TODO: Add your control notification handler code here
	if(m_trigger.nActiveLevel==2)
		return;
	m_trigger.nActiveLevel = 2;
	TriggerInit();
}

void CTrcGrpTriggerPage::OnSelendokGrptrcTrgEvtype()
{
	// TODO: Add your control notification handler code here
	CComboBox* t = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
	int i = t->GetCurSel();
	switch (m_trigger.nActiveLevel)
	{
		case 1:
			m_trigger.level1.nSet = i;
			break;
		case 2:
		    m_trigger.level2.nSet = i;
		    break;
		default:
		    break;
	}
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpTriggerPage::OnGrptrcTrgEnable()
{
	// TODO: Add your control notification handler code here
	if(m_trigger.bTriggerEnable)
		return;
	m_trigger.bTriggerEnable = TRUE;
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpTriggerPage::OnGrptrcTrgDisable()
{
	// TODO: Add your control notification handler code here
	if(!m_trigger.bTriggerEnable)
		return;
	m_trigger.bTriggerEnable = FALSE;
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpTriggerPage::OnGrptrcTrgRun()
{
	// TODO: Add your control notification handler code here
	if(IsDlgButtonChecked(IDC_GRPTRC_TRG_RUN)==0)
		m_trigger.bRun = FALSE;
	else
		m_trigger.bRun = TRUE;
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpTriggerPage::OnSelendokGrptrcTrgCombo()
{
	// TODO: Add your control notification handler code here
	CComboBox* t = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_COMBO);
	m_trigger.nTriggerSet = t->GetCurSel();
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpFilterPage dialog

CTrcGrpFilterPage::CTrcGrpFilterPage()
	: CCheckPage(CTrcGrpFilterPage::IDD)
{
	//{{AFX_DATA_INIT(CTrcGrpFilterPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_filter.nActiveChoice = 1;
	for(int i=0; i<2; i++)
	{
		m_filter.f[i].nAddrMode = 1;
		m_filter.f[i].StartAddrTxt[0]='\0';
		m_filter.f[i].StartAddrTxt2[0]='\0';
		m_filter.f[i].StartAddrTxt3[0]='\0';
		m_filter.f[i].EndAddrTxt[0]='\0';
		m_filter.f[i].nAddrType = 0;
		m_filter.f[i].nDataMode = 1;
		m_filter.f[i].StartDataTxt[0]='\0';
		m_filter.f[i].StartDataTxt2[0]='\0';
		m_filter.f[i].StartDataTxt3[0]='\0';
		m_filter.f[i].EndDataTxt[0]='\0';
		m_filter.f[i].nDataType=0;
		m_filter.f[i].bS = FALSE;
		m_filter.f[i].bR = FALSE;
		m_filter.f[i].bW = FALSE;
		m_filter.f[i].bAK = FALSE;
		m_filter.f[i].DataWidthByte=TRUE;
	}
	m_bDisplayChange=FALSE;
	m_bApply=FALSE;
//	m_nIDHelp=IDD_TRCGRP_FILTER;

	GetFilter(1);
	GetFilter(2);
}

BOOL CTrcGrpFilterPage::OnSetActive()
{
	CPropertyPage::OnSetActive();
	SetModified(m_bApply);
	return TRUE;
}

BOOL CTrcGrpFilterPage::OnKillActive()
{
	if(m_bApply)
		m_bChanged=FALSE;
	return TRUE;
}

void CTrcGrpFilterPage::OnOK()
{
	((CTraceGroupDialog*)GetParent())->forlive(FALSE);
	if(!m_bApply)
		return;
	if(OnSet())
	{	
		CPropertyPage::OnOK();
		SetModified(FALSE);
		m_bApply=FALSE;
		ASSERT(m_pParentWnd->IsKindOf(RUNTIME_CLASS(CTraceGroupDialog)));
		((CTraceGroupDialog*)m_pParentWnd)->m_bDisplayChange=m_bDisplayChange;
	}
	else ((CTraceGroupDialog*)GetParent())->forlive(TRUE);
}

void CTrcGrpFilterPage::OnCancel()
{
	((CTraceGroupDialog*)GetParent())->forlive(FALSE);
}

void CTrcGrpFilterPage::FilterInit()
{   
	BOOL old=m_bApply;
	m_bApply=TRUE;
	switch (m_filter.nActiveChoice)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_FLT_DISPLAY,IDC_GRPTRC_FLT_TRACE,IDC_GRPTRC_FLT_DISPLAY);
			InitCtrl(0);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_FLT_DISPLAY,IDC_GRPTRC_FLT_TRACE,IDC_GRPTRC_FLT_TRACE);
			InitCtrl(1);
			break;
		default:
			break;
	}
	m_bApply=old;
}                   

void CTrcGrpFilterPage::InitCtrl(int index)
{
	if (m_filter.f[index].nAddrMode!=1)
	{
		GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
	}                       
	else
	{
		GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
	}
	if (m_filter.f[index].nDataMode!=1)
	{
		GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(FALSE);
		GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Da&ta");
	}
	else
	{
		GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(TRUE);
		GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
	}

	switch (m_filter.f[index].nAddrMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_RANGE1);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_MULTI1);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_WILD1);
		default:
			break;
	}

	switch (m_filter.f[index].nDataMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_RANGE2);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_MULTI2);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_WILD2);
		default:
			break;
	}
	if(m_filter.f[index].nAddrMode==1)
	{
		SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.f[index].StartAddrTxt);
		SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.f[index].EndAddrTxt);
	}
	else if(m_filter.f[index].nAddrMode==2)
		SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.f[index].StartAddrTxt2);
	else if(m_filter.f[index].nAddrMode==3)
		SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.f[index].StartAddrTxt3);
	CWnd* t=GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
	CComboBox* a=(CComboBox *)t;
	a->SetCurSel(m_filter.f[index].nAddrType);
	t=GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
	a=(CComboBox *)t;
	a->SetCurSel(m_filter.f[index].nDataType);
	if(m_filter.f[index].nDataMode==1)
	{
		SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.f[index].StartDataTxt);
		SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.f[index].EndDataTxt);
	}
	else if(m_filter.f[index].nDataMode==2)
		SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.f[index].StartDataTxt2);
	else if(m_filter.f[index].nDataMode==3)
		SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.f[index].StartDataTxt3);

	if (m_filter.f[index].bS)
		CheckDlgButton(IDC_GRPTRC_FLT_S, TRUE);
	else
		CheckDlgButton(IDC_GRPTRC_FLT_S, FALSE);
	if (m_filter.f[index].bR)
		CheckDlgButton(IDC_GRPTRC_FLT_R, TRUE);
	else
		CheckDlgButton(IDC_GRPTRC_FLT_R, FALSE);
	if (m_filter.f[index].bW)
		CheckDlgButton(IDC_GRPTRC_FLT_W, TRUE);
	else
		CheckDlgButton(IDC_GRPTRC_FLT_W, FALSE);
	if (m_filter.f[index].bAK)
		CheckDlgButton(IDC_GRPTRC_FLT_AK, TRUE);
	else
		CheckDlgButton(IDC_GRPTRC_FLT_AK, FALSE);

	if(m_filter.f[index].DataWidthByte)
		CheckRadioButton(IDC_GRPTRC_FLT_WIDTHBYTE, IDC_GRPTRC_FLT_WIDTHWORD,IDC_GRPTRC_FLT_WIDTHBYTE);
	else
		CheckRadioButton(IDC_GRPTRC_FLT_WIDTHBYTE, IDC_GRPTRC_FLT_WIDTHWORD,IDC_GRPTRC_FLT_WIDTHWORD);
}

void CTrcGrpFilterPage::GetFilter(int fltID)
{
int ii, index;
char strData[100];
BOOL retSvr;
QUALIFY Qlfy;

	if(fltID==1)
	{
		retSvr=TS_GetQualify(FALSE, Qlfy);
		index=0;
	}
	else
	{
		retSvr=TS_GetQualify(TRUE, Qlfy);
		index=1;
	}
	if(!retSvr)
	{
		m_filter.f[index].nAddrMode = 1;
		m_filter.f[index].StartAddrTxt[0]='\0';
		m_filter.f[index].EndAddrTxt[0]='\0';
		m_filter.f[index].nAddrType = 0;
		m_filter.f[index].nDataMode = 1;
		m_filter.f[index].StartDataTxt[0]='\0';
		m_filter.f[index].EndDataTxt[0]='\0';
		m_filter.f[index].nDataType=0;
		m_filter.f[index].bS = FALSE;
		m_filter.f[index].bR = FALSE;
		m_filter.f[index].bW = FALSE;
		m_filter.f[index].bAK = FALSE;
		m_filter.f[index].DataWidthByte=TRUE;
		return;
	}
	switch (Qlfy.addrType)
	{
		case 0:
		    m_filter.f[index].nAddrMode = 3;
		    strcpy(m_filter.f[index].StartAddrTxt3,"XXXX");
		    break;
		case 2:                    
			GetWildCard(TRUE, 18, Qlfy.addrValue[0], Qlfy.addrValue[1], strData);
			strcpy(m_filter.f[index].StartAddrTxt3, strData);
			m_filter.f[index].nAddrMode = 3;  
			break;
		case 3:
			SetAddrText(Qlfy.addrValue[0], m_filter.f[index].StartAddrTxt);
			SetAddrText(Qlfy.addrValue[1], m_filter.f[index].EndAddrTxt);
			m_filter.f[index].nAddrType = 0;
			m_filter.f[index].nAddrMode = 1;
			break;
		case 1:                   
			m_filter.f[index].StartAddrTxt2[0]=NULL;
			for(ii=0; ii<int(Qlfy.addrCount); ii++)
			{
				strcat(m_filter.f[index].StartAddrTxt2,
					RetAddrText(Qlfy.addrValue[ii]));
				strcat(m_filter.f[index].StartAddrTxt2," ");
			}
			m_filter.f[index].nAddrMode = 2;
			break;
		default:
		    break;
	}             
	if(Qlfy.dataType&0x80)
		m_filter.f[index].DataWidthByte=FALSE;
	else
		m_filter.f[index].DataWidthByte=TRUE;
	switch(Qlfy.dataType&0x7f)
	{
		case 0:   
			m_filter.f[index].nDataMode = 3;
			if(m_filter.f[index].DataWidthByte)
				strcpy(m_filter.f[index].StartDataTxt3,"XX");
			else
				strcpy(m_filter.f[index].StartDataTxt3,"XXXX");
			break;
		case 2:
			GetWildCard(FALSE, m_filter.f[index].DataWidthByte?8:16,
				Qlfy.dataValue1, Qlfy.dataValue2, strData);
			strcpy(m_filter.f[index].StartDataTxt3, strData);
			m_filter.f[index].nDataMode = 3;
			break;
		case 3:
			if(m_filter.f[index].DataWidthByte)
			{
				sprintf(m_filter.f[index].StartDataTxt,"0x%02x",Qlfy.dataValue1);
				sprintf(m_filter.f[index].EndDataTxt,"0x%02x",Qlfy.dataValue2);
			}
			else
			{
				sprintf(m_filter.f[index].StartDataTxt,"0x%04x",Qlfy.dataValue1);
				sprintf(m_filter.f[index].EndDataTxt,"0x%04x",Qlfy.dataValue2);
			}
			m_filter.f[index].nDataType=0;
			m_filter.f[index].nDataMode = 1;
			break;
		case 1:
			if(m_filter.f[index].DataWidthByte)
				sprintf(m_filter.f[index].StartDataTxt2,"0x%02x",Qlfy.dataValue1);
			else
				sprintf(m_filter.f[index].StartDataTxt2,"0x%04x",Qlfy.dataValue1);
			m_filter.f[index].nDataMode = 2;
			break;
		default:
			ASSERT(0);
			break;
	}
	m_filter.f[index].bS = Qlfy.statusValue&0x1?TRUE:FALSE;
	m_filter.f[index].bR = Qlfy.statusValue&0x4?TRUE:FALSE;
	m_filter.f[index].bW = Qlfy.statusValue&0x2?TRUE:FALSE;
	m_filter.f[index].bAK = Qlfy.statusValue&0x8?TRUE:FALSE;
}

void CTrcGrpFilterPage::SetFilter(int index)
{
WORD wVar1;
STATUS nRetSvr;

	wVar1=0;
	if(m_filter.f[index].bS)
		wVar1+=0x1;
	if(m_filter.f[index].bR)
		wVar1+=0x4;
	if(m_filter.f[index].bW)
		wVar1+=0x2;
	if(m_filter.f[index].bAK)
		wVar1+=0x8;
	m_Qlfy.statusValue = wVar1; 
	m_Qlfy.filterFlag = 1;

	BeginWaitCursor();
	nRetSvr=TS_SetQualify(index==0?FALSE:TRUE, m_Qlfy);
	EndWaitCursor();
	if (ICE_OK!=nRetSvr)
		ErrDisplayError(ER_ICE_OK+nRetSvr);
}

BOOL CTrcGrpFilterPage::OnSet()						//tab4
{
int index;

	m_bEmptyFlag=TRUE;
	m_nold_addrmode=0;
	m_nold_datamode=0;

	m_nErrLocate=0;		//1:startaddr; 2:endaddr; 3:startdata; 4:enddata
						//5:count.
	index=m_filter.nActiveChoice-1;
	if(index==1)
	{
		unsigned char status;
		GetCpuStatus(status);
		if(status==STATUS_GO)				//CPU is run
		{
			ErrDisplayError(ER_EMU_GOFLY_ERR_MSG);
			return FALSE;
		}
		m_Qlfy.filterFlag=0;
	}
	else
		m_Qlfy.filterFlag=1;

	if(m_filter.f[index].nAddrMode==3)
		chkWildAddr(m_filter.f[index].StartAddrTxt3, TRUE);
	else if(m_filter.f[index].nAddrMode==1)
		chkRangeAddr(m_filter.f[index].nAddrType, m_filter.f[index].StartAddrTxt,
				m_filter.f[index].EndAddrTxt, TRUE);
	else if(m_filter.f[index].nAddrMode==2)
		chkMultipleAddr(m_filter.f[index].StartAddrTxt2, TRUE);
	if(m_nErrLocate)
		goto POS1;
	if(m_filter.f[index].nDataMode==3)
		chkWildData(m_filter.f[index].StartDataTxt3, 
			m_filter.f[index].DataWidthByte, TRUE);
	else if(m_filter.f[index].nDataMode==1)
		chkRangeData(m_filter.f[index].nDataType, m_filter.f[index].StartDataTxt,
					m_filter.f[index].EndDataTxt, m_filter.f[index].DataWidthByte,  TRUE);
	else if(m_filter.f[index].nDataMode==2)
		chkSingleData(m_filter.f[index].StartDataTxt2, m_filter.f[index].DataWidthByte, TRUE);
	if(m_nErrLocate)
		goto POS1;
	if(!m_filter.f[index].DataWidthByte)
		m_Qlfy.dataType|=0x80;
	if(m_filter.f[index].bS||m_filter.f[index].bR
                   ||m_filter.f[index].bW||m_filter.f[index].bAK
                   ||!m_bEmptyFlag)
	{
		SetFilter(index);
		if(m_nold_datamode)
		{
			m_filter.f[index].nDataMode=3;
			if(m_filter.f[index].DataWidthByte)
				strcpy(m_filter.f[index].StartDataTxt3,"XX");
			else
				strcpy(m_filter.f[index].StartDataTxt3,"XXXX");
		}
		if(m_nold_addrmode)
		{
			m_filter.f[index].nAddrMode=3;
			strcpy(m_filter.f[index].StartAddrTxt3,"XXXX");
		}
		if(m_nold_addrmode||m_nold_datamode) 
			InitCtrl(index);
		m_bDisplayChange=TRUE;
		return TRUE;
	}
	else
	{
		ErrDisplayError(ER_TRC_NONEINPUT);
		return FALSE;
	}
	POS1:
	if(m_nErrLocate==1)
		GetDlgItem(IDC_GRPTRC_FLT_STARTADDR)->SetFocus();
	else if(m_nErrLocate==2)
		GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->SetFocus();
	else if(m_nErrLocate==3)
		GetDlgItem(IDC_GRPTRC_FLT_STARTDATA)->SetFocus();
	else if(m_nErrLocate==4)
		GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->SetFocus();
	return FALSE;
}

void CTrcGrpFilterPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrcGrpFilterPage)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTrcGrpFilterPage, CPropertyPage)
	//{{AFX_MSG_MAP(CTrcGrpFilterPage)
	ON_CBN_SELCHANGE(IDC_GRPTRC_FLT_ADDRTYPE, OnSelendokGrptrcFltAddrtype)
	ON_CBN_SELCHANGE(IDC_GRPTRC_FLT_DATATYPE, OnSelendokGrptrcFltDatatype)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_DISPLAY, OnGrptrcFltDisplay)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_TRACE, OnGrptrcFltTrace)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_MULTI1, OnGrptrcFltMulti1)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_MULTI2, OnGrptrcFltMulti2)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_RANGE1, OnGrptrcFltRange1)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_RANGE2, OnGrptrcFltRange2)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_WILD1, OnGrptrcFltWild1)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_WILD2, OnGrptrcFltWild2)
	ON_EN_CHANGE(IDC_GRPTRC_FLT_ENDADDR, OnChangeGrptrcFltEndaddr)
	ON_EN_CHANGE(IDC_GRPTRC_FLT_ENDDATA, OnChangeGrptrcFltEnddata)
	ON_EN_CHANGE(IDC_GRPTRC_FLT_STARTADDR, OnChangeGrptrcFltStartaddr)
	ON_EN_CHANGE(IDC_GRPTRC_FLT_STARTDATA, OnChangeGrptrcFltStartdata)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_AK, OnGrptrcFltAk)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_R, OnGrptrcFltR)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_S, OnGrptrcFltS)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_W, OnGrptrcFltW)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_WIDTHBYTE, OnGrptrcFltWidthbyte)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_WIDTHWORD, OnGrptrcFltWidthword)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcGrpFilterPage message handlers
BOOL CTrcGrpFilterPage::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	FilterInit();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcGrpFilterPage::OnSelendokGrptrcFltAddrtype()
{
	// TODO: Add your control notification handler code here
	CComboBox* t;
	t = (CComboBox *)GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
	int i=t->GetCurSel();
	m_filter.f[m_filter.nActiveChoice-1].nAddrType = i;
}

void CTrcGrpFilterPage::OnSelendokGrptrcFltDatatype()
{
	// TODO: Add your control notification handler code here
	CComboBox* t;
	t = (CComboBox *)GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
	int i=t->GetCurSel();
	m_filter.f[m_filter.nActiveChoice-1].nDataType = i;
}

void CTrcGrpFilterPage::OnGrptrcFltDisplay()
{
	// TODO: Add your control notification handler code here
	m_filter.nActiveChoice = 1;
	FilterInit();
}

void CTrcGrpFilterPage::OnGrptrcFltTrace()
{
	// TODO: Add your control notification handler code here
	m_filter.nActiveChoice = 2;
	FilterInit();
}

void CTrcGrpFilterPage::OnGrptrcFltMulti1()
{
	// TODO: Add your control notification handler code here
	m_filter.f[m_filter.nActiveChoice-1].nAddrMode = 2;
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, 
		m_filter.f[m_filter.nActiveChoice-1].StartAddrTxt2);
}

void CTrcGrpFilterPage::OnGrptrcFltMulti2()
{
	// TODO: Add your control notification handler code here
	m_filter.f[m_filter.nActiveChoice-1].nDataMode = 2;
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,
		m_filter.f[m_filter.nActiveChoice-1].StartDataTxt2);
}

void CTrcGrpFilterPage::OnGrptrcFltRange1()
{
    // TODO: Add your control notification handler code here
	m_filter.f[m_filter.nActiveChoice-1].nAddrMode = 1;
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, 
		m_filter.f[m_filter.nActiveChoice-1].StartAddrTxt);
	SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,
		m_filter.f[m_filter.nActiveChoice-1].EndAddrTxt);
}

void CTrcGrpFilterPage::OnGrptrcFltRange2()
{
	// TODO: Add your control notification handler code here
	m_filter.f[m_filter.nActiveChoice-1].nDataMode = 1;
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,
		m_filter.f[m_filter.nActiveChoice-1].StartDataTxt);
	SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,
		m_filter.f[m_filter.nActiveChoice-1].EndDataTxt);
}

void CTrcGrpFilterPage::OnGrptrcFltWild1()
{
	// TODO: Add your control notification handler code here
	m_filter.f[m_filter.nActiveChoice-1].nAddrMode = 3;
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,
		m_filter.f[m_filter.nActiveChoice-1].StartAddrTxt3);
}

void CTrcGrpFilterPage::OnGrptrcFltWild2()
{
	// TODO: Add your control notification handler code here
	m_filter.f[m_filter.nActiveChoice-1].nDataMode = 3;
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,
		m_filter.f[m_filter.nActiveChoice-1].StartDataTxt3);
}

void CTrcGrpFilterPage::OnChangeGrptrcFltEndaddr()
{
	// TODO: Add your control notification handler code here
	GetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,
		m_filter.f[m_filter.nActiveChoice-1].EndAddrTxt, 64);
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnChangeGrptrcFltEnddata()
{
	// TODO: Add your control notification handler code here
	GetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,
		m_filter.f[m_filter.nActiveChoice-1].EndDataTxt, 64);
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnChangeGrptrcFltStartaddr()
{
	// TODO: Add your control notification handler code here
	if(m_filter.f[m_filter.nActiveChoice-1].nAddrMode == 1)//range
		GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,
			m_filter.f[m_filter.nActiveChoice-1].StartAddrTxt, 64);
	else if(m_filter.f[m_filter.nActiveChoice-1].nAddrMode == 2)//multiple
		GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,
			m_filter.f[m_filter.nActiveChoice-1].StartAddrTxt2, 164);
	else if(m_filter.f[m_filter.nActiveChoice-1].nAddrMode == 3)//wildcard
		GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,
			m_filter.f[m_filter.nActiveChoice-1].StartAddrTxt3, 64);
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnChangeGrptrcFltStartdata()
{
	// TODO: Add your control notification handler code here
	if(m_filter.f[m_filter.nActiveChoice-1].nDataMode ==1)
		GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,
			m_filter.f[m_filter.nActiveChoice-1].StartDataTxt, 64);
	if(m_filter.f[m_filter.nActiveChoice-1].nDataMode ==2)
		GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,
			m_filter.f[m_filter.nActiveChoice-1].StartDataTxt2, 64);
	if(m_filter.f[m_filter.nActiveChoice-1].nDataMode ==3)
		GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,
			m_filter.f[m_filter.nActiveChoice-1].StartDataTxt3, 64);
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnGrptrcFltAk()
{
	// TODO: Add your control notification handler code here
BOOL check;

	if (IsDlgButtonChecked(IDC_GRPTRC_FLT_AK)==0)
		check=FALSE;
	else
		check=TRUE;
	m_filter.f[m_filter.nActiveChoice-1].bAK = check;
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnGrptrcFltR()
{
	// TODO: Add your control notification handler code here
BOOL check;

	if (IsDlgButtonChecked(IDC_GRPTRC_FLT_R)==0)
		check=FALSE;
	else
		check=TRUE;
	m_filter.f[m_filter.nActiveChoice-1].bR = check;
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnGrptrcFltS()
{
	// TODO: Add your control notification handler code here
BOOL check;

	if (IsDlgButtonChecked(IDC_GRPTRC_FLT_S)==0)
		check=FALSE;
	else
		check=TRUE;
	m_filter.f[m_filter.nActiveChoice-1].bS = check;   
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnGrptrcFltW()
{
	// TODO: Add your control notification handler code here
BOOL check;

	if (IsDlgButtonChecked(IDC_GRPTRC_FLT_W)==0)
		check=FALSE;
	else
		check=TRUE;
	m_filter.f[m_filter.nActiveChoice-1].bW = check;   
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnGrptrcFltWidthbyte()
{
	// TODO: Add your control notification handler code here
	if(m_filter.f[m_filter.nActiveChoice-1].DataWidthByte)
		return;
	else{
		m_filter.f[m_filter.nActiveChoice-1].DataWidthByte=TRUE;
	
		if (m_filter.f[m_filter.nActiveChoice-1].nDataMode == 3 &&
			strcmp(m_filter.f[m_filter.nActiveChoice-1].StartDataTxt3, "XXXX") == 0)
		{   
			strcpy(m_filter.f[m_filter.nActiveChoice-1].StartDataTxt3, "XX");
			SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, "XX");
		}
	}


	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

void CTrcGrpFilterPage::OnGrptrcFltWidthword()
{
	// TODO: Add your control notification handler code here
	if(!m_filter.f[m_filter.nActiveChoice-1].DataWidthByte)
		return;
	else{
		m_filter.f[m_filter.nActiveChoice-1].DataWidthByte=FALSE;

		if (m_filter.f[m_filter.nActiveChoice-1].nDataMode == 3 &&
			strcmp(m_filter.f[m_filter.nActiveChoice-1].StartDataTxt3, "XX") == 0)
		{   
			strcpy(m_filter.f[m_filter.nActiveChoice-1].StartDataTxt3, "XXXX");
			SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, "XXXX");
		}
	}

	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CCheckPage dialog

CCheckPage::CCheckPage(UINT nIDTemplate)
	: CPropertyPage(nIDTemplate)
{
	//{{AFX_DATA_INIT(CCheckPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_bEmptyFlag=TRUE;
	m_nold_addrmode=0;
	m_nold_datamode=0;
	m_nErrLocate=0;
}

CString CCheckPage::delspace(const char* p)
{
int	i=0, len;
CString thin;
	
	while(p[i++]==' ');
	i--;
	thin=&p[i];
	len=thin.GetLength();
	
	for(i=len-1; i>=0; i--)
		if(thin[i]!=' ')
			break;
	thin=thin.Left(i+1);
	return thin;	
}

void CCheckPage::chkWildAddr(const char* p, BOOL isQlfy)
{
int len;
U32 dwVal, dwValMask;
CString str;

	str=delspace(p);
	len = str.GetLength();
	if (len==0)
	{
		m_nold_addrmode=3;
		if(isQlfy)
			m_Qlfy.addrType=0;
		else
			m_EvBus.addrType=0;
		return;
	}
	m_bEmptyFlag=FALSE;
	strcpy(m_pBuffer, str);
	if(!IsWildcard(CP_ADDR, m_pBuffer))
	{
		m_nErrLocate=1;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(!SetWildCard(TRUE, 18, dwVal, dwValMask, str))
	{
		m_nErrLocate=1;
		ErrDisplayError(ER_TRC_CONVERTERR);
		return;
	}
	if(isQlfy)
	{
		m_Qlfy.addrType=2;
		m_Qlfy.addrValue[0]=dwVal;
		m_Qlfy.addrValue[1]=dwValMask;
	}
	else
	{
		m_EvBus.addrType=2;
		m_EvBus.addrValue[0]=dwVal;
		m_EvBus.addrValue[1]=dwValMask;
	}
/*
int		i, j, len;
char	wa[16];
unsigned char hb;

	str.MakeUpper();
	if(str.Find('X')==-1)
	{
		m_nErrLocate=1;
		ErrDisplayError(ER_TRCGRP_DATA1_NOWILD);
		return;
	}
	if (len<=4&&len>0)
	{
		for(i=0;i<len;i++)
			if(!(str[i]>='0'&&str[i]<='9'
				||str[i]>='A'&&str[i]<='F'||str[i]=='X'))
			{
				m_nErrLocate=1;
				ErrDisplayError(ER_TRCGRP_ADDR_INVALIDCHAR);
				return;
			}
		for(i=0; i<(4-len)*4; i++)
			wa[i]=0;
		for(j=0;i<16;i+=4,j++)
		{
			hb=unsigned char((str[j]=='X')?0xff:(str[j]>='0'&&str[j]<='9'?
						str[j]-'0':str[j]-'A'+10));
			wa[i]=(hb==0xff)?'X':hb&8?'1':'0';
			wa[i+1]=(hb==0xff)?'X':hb&4?'1':'0';
			wa[i+2]=(hb==0xff)?'X':hb&2?'1':'0';
			wa[i+3]=(hb==0xff)?'X':hb&1?'1':'0';
		}
	}
	else if(len<=16&&len>4)
	{
		for(i=0;i<len;i++)
			if(str[i]!='0'&&str[i]!='1'&&str[i]!='X')
			{
				m_nErrLocate=1;
				ErrDisplayError(ER_TRCGRP_ADDR_INVALIDCHAR);
				return;
			}
		for(i=0; i<16-len; i++)
			wa[i]=0;
		for(j=0;i<16;i++,j++)
		{
			wa[i]=str[j];
		}
	}
	else
	{
	 	m_nErrLocate=1;
		ErrDisplayError(ER_TRCGRP_ADDR1_ERR);
		return;
	}
	m_EvBus.addr[0][0]=0;
	m_EvBus.addr[1][0]=0xffff;
	m_EvBus.addrCount=2;
	m_EvBus.qlfyType[4]=2;
	m_EvBus.qlfyType[5]=0;
	for(j=0;j<16;j++)
	{
		switch (wa[j])
		{
			case 'X':
				m_EvBus.addr[1][0]-=(WORD)(1<<(15-j));
				break;
			case '0':
				break;
			case '1':
				m_EvBus.addr[0][0]+=(WORD)(1<<(15-j));
				break;
			default:
				break;
		}
	}
*/
}

void CCheckPage::chkRangeAddr(int type,const char* p1,const char* p2,
								BOOL isQlfy)
{
ADDRESS	adr1, adr2;
ADDR_RETCODE	ret1, ret2;
CString	str=p1;	
	
	ret1=AdrTextToAddr(str, adr1);
	str=p2;
	ret2=AdrTextToAddr(str, adr2);
	if(ret1==ret2&&ret1==ADR_EMPTY)
	{
		m_nold_addrmode=1;
		if(isQlfy)
			m_Qlfy.addrType=0;
		else
			m_EvBus.addrType=0;
		return;
	}
	m_bEmptyFlag=FALSE;
	if(ret1!=ADR_OK)
	{
		m_nErrLocate=1;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}	       
	if(ret2!=ADR_OK)
	{
		m_nErrLocate=2;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(type==1)		//length
	{
		adr2.adrAddress+=adr1.adrAddress-1;
		adr2.adrSpace=adr1.adrSpace;
	}
	if(adr1.adrSpace==SPACE_UNDEFINE)
	{
		adr1.adrSpace=SPACE_P0;
	}
	if(adr2.adrSpace==SPACE_UNDEFINE)
	{
		adr2.adrSpace=adr1.adrSpace;
	}
	if(adr1.adrSpace<SPACE_P0||adr1.adrSpace>SPACE_P3)
	{
		m_nErrLocate=1;
		ErrDisplayError(ER_TRC_PSPACEERR);
		return;
	}
	if(AdrCheck2Addr(adr1, adr2)!=ADR_OK)
	{
		m_nErrLocate=1;
		ErrDisplayError(ER_TRC_RANGEERR);
		return;
	}
	if(isQlfy)
	{
		m_Qlfy.addrType=3;
		m_Qlfy.addrCount=2;
		m_Qlfy.addrValue[0]=adr1.adrAddress+(U32(adr1.adrSpace-SPACE_P0)<<16);
		m_Qlfy.addrValue[1]=adr2.adrAddress+(U32(adr2.adrSpace-SPACE_P0)<<16);
	}
	else
	{
		m_EvBus.addrType=3;
		m_EvBus.addrCount=2;
		m_EvBus.addrValue[0]=adr1.adrAddress+(U32(adr1.adrSpace-SPACE_P0)<<16);
		m_EvBus.addrValue[1]=adr2.adrAddress+(U32(adr2.adrSpace-SPACE_P0)<<16);
	}
}

void CCheckPage::chkMultipleAddr(char* p, BOOL isQlfy)
{
int		i;	
char 	txt1[200];
char*	ptr;
CString	str;
ADDRESS	adr;
ADDR_RETCODE	ret;

	i=GetTokenNum(p);
	if (i>10)
	{
		m_nErrLocate=1;
		ErrDisplayError(ER_TRC_ADDR_TOOMUCH);
		return;
	}
	if (i==0)
	{
		m_nold_addrmode=2;
		if(isQlfy)
			m_Qlfy.addrType=0;
		else
			m_EvBus.addrType=0;
		return;
	}
	m_bEmptyFlag=FALSE;
	strcpy(txt1,p);
	ptr=strtok(txt1," ,");
	i=0;
	do
	{
		str=ptr;
		ret=AdrTextToAddr(str, adr);
		if(ret!=ADR_OK)
		{
		 	m_nErrLocate=1;
		 	ErrDisplayError(ER_APP_SYNTAXERR);
		 	return;
		}
		if(adr.adrSpace==SPACE_UNDEFINE)
			adr.adrSpace=SPACE_P0;
		if(!AdrCheckAddrRange(adr))
		{
			m_nErrLocate=1;
			ErrDisplayError(ER_APP_SYNTAXERR);
			return;
		}
		if(isQlfy)
			m_Qlfy.addrValue[i]=adr.adrAddress+(U32(adr.adrSpace-SPACE_P0)<<16);
		else
			m_EvBus.addrValue[i]=adr.adrAddress+(U32(adr.adrSpace-SPACE_P0)<<16);
		ptr = strtok(NULL, " ,");
		i++;
	}while(ptr!=NULL);
	if(isQlfy)
	{
		m_Qlfy.addrType=1;
		m_Qlfy.addrCount=U8(i);
	}
	else
	{
		m_EvBus.addrType=1;
		m_EvBus.addrCount=U8(i);
	}
}

void CCheckPage::chkWildData(const char* p, BOOL bByte, BOOL isQlfy)
{
int len;
U32 dwVal, dwValMask;
CString str;

	str=delspace(p);
	len = str.GetLength();
	if (len==0)
	{
		m_nold_datamode=3;
		if(isQlfy)
			m_Qlfy.dataType=0;
		else
			m_EvBus.dataType=0;
		return;
	}
	m_bEmptyFlag=FALSE;
	strcpy(m_pBuffer, str);
	if(!IsWildcard(bByte?CP_DATABYTE:CP_DATAWORD, m_pBuffer))
	{
		m_nErrLocate=3;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(!SetWildCard(FALSE, bByte?8:16, dwVal, dwValMask, str))
	{
		m_nErrLocate=1;
		ErrDisplayError(ER_TRC_CONVERTERR);
		return;
	}
	if(isQlfy)
	{
		m_Qlfy.dataType=2;
		m_Qlfy.dataValue1=(U16)dwVal;
		m_Qlfy.dataValue2=(U16)dwValMask;
	}
	else
	{
		m_EvBus.dataType=2;
		m_EvBus.dataValue1=(U16)dwVal;
		m_EvBus.dataValue2=(U16)dwValMask;
	}
/*
int		i, j, len;
char	wa[8];
unsigned char hb;
CString str;
	
	str=delspace(p);
	len = str.GetLength();
	if (i==0)
	{
		m_nold_datamode=3;
		m_EvBus.qlfyType[6]=0;
		m_EvBus.qlfyType[7]=0;
		return;
	}
	m_bEmptyFlag=FALSE;	
	str.MakeUpper();
	if(str.Find('X')==-1)
	{
		m_nErrLocate=3;
		ErrDisplayError(ER_TRCGRP_DATA1_NOWILD);
		return;
	}
	if (len<=2&&len>0)
	{
		for(i=0;i<len;i++)
			if(!(str[i]>='0'&&str[i]<='9'
				||str[i]>='A'&&str[i]<='F'||str[i]=='X'))
			{
				m_nErrLocate=3;
				ErrDisplayError(ER_TRCGRP_DATA1_ERR);
				return;
			}
		for(i=0; i<(2-len)*4; i++)
			wa[i]=0;
		for(j=0;i<8;i+=4,j++)
		{
			hb=unsigned char((str[j]=='X')?0xff:(str[j]>='0'&&str[j]<='9'?
						str[j]-'0':str[j]-'A'+10));
			wa[i]=(hb==0xff)?'X':hb&8?'1':'0';
			wa[i+1]=(hb==0xff)?'X':hb&4?'1':'0';
			wa[i+2]=(hb==0xff)?'X':hb&2?'1':'0';
			wa[i+3]=(hb==0xff)?'X':hb&1?'1':'0';
		}	
	}
	else if(len<=8&&len>2)
	{
		for(i=0;i<len;i++)
			if(str[i]!='0'&&str[i]!='1'&&str[i]!='X')
			{
				m_nErrLocate=3;
				ErrDisplayError(ER_TRCGRP_DATA1_ERR);
				return;
			}
		for(i=0; i<8-len; i++)
			wa[i]=0;
		for(j=0;i<8;i++,j++)
		{
			wa[i]=str[j];
		}
	}
	else
	{
	 	m_nErrLocate=3;
		ErrDisplayError(ER_TRCGRP_DATA1_ERR);
		return;
	}
	m_EvBus.data1=0;
	m_EvBus.data2=0xffff;
	m_EvBus.qlfyType[6]=2;
	m_EvBus.qlfyType[7]=0;
	for(j=0;j<8;j++)
	{
		switch (wa[j])
		{
			case 'X':
				m_EvBus.data2-=(WORD)(1<<(7-j));
				break;
			case '0':
				break;
			case '1':
				m_EvBus.data1+=(WORD)(1<<(7-j));
				break;
			default:
				break;
		}
	}
*/
}

void CCheckPage::chkRangeData(int type, const char* p1,
				const char* p2, BOOL bByte, BOOL isQlfy)
{
ADDRESS	adr1, adr2;
ADDR_RETCODE	ret1, ret2;
CString str=p1;

    ret1=AdrTextToAddr(str, adr1, 0);
	str=p2;
    ret2=AdrTextToAddr(str, adr2, 0);
	if(ret1==ret2&&ret1==ADR_EMPTY)
	{
		m_nold_datamode=1;
		if(isQlfy)
			m_Qlfy.dataType=0;
		else
			m_EvBus.dataType=0;
		return;
	}
	m_bEmptyFlag=FALSE;
	if(ret1!=ADR_OK)
	{
		m_nErrLocate=3;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(bByte&&adr1.adrAddress>0xff||!bByte&&adr1.adrAddress>0xffff)
	{
		m_nErrLocate=3;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(ret2!=ADR_OK)
	{
		m_nErrLocate=4;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(type==1)		//length
		adr2.adrAddress+=adr1.adrAddress-1;
	if(adr2.adrAddress<adr1.adrAddress)
	{
		m_nErrLocate=4;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(bByte&&adr2.adrAddress>0xff||!bByte&&adr2.adrAddress>0xffff)
	{
		m_nErrLocate=4;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(isQlfy)
	{
		m_Qlfy.dataType=3;
		m_Qlfy.dataValue1=(U16)adr1.adrAddress;
		m_Qlfy.dataValue2=(U16)adr2.adrAddress;
	}
	else
	{
		m_EvBus.dataType=3;
		m_EvBus.dataValue1=(U16)adr1.adrAddress;
		m_EvBus.dataValue2=(U16)adr2.adrAddress;
	}
}

void CCheckPage::chkSingleData(const char* p, BOOL bByte, BOOL isQlfy)
{
ADDRESS	adr;
ADDR_RETCODE	ret;
CString str=p;
	
	ret=AdrTextToAddr(str, adr, 0);
	if(ret==ADR_EMPTY)
	{
		m_nold_datamode=2;
		if(isQlfy)
			m_Qlfy.dataType=0;
		else
			m_EvBus.dataType=0;
		return;
	}
	m_bEmptyFlag=FALSE;
	if(ret!=ADR_OK)
	{
		m_nErrLocate=3;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(bByte&&adr.adrAddress>0xff||!bByte&&adr.adrAddress>0xffff)
	{
		m_nErrLocate=3;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
	if(isQlfy)
	{
		m_Qlfy.dataType=1;
		m_Qlfy.dataValue1=(U16)adr.adrAddress;
	}
	else
	{
		m_EvBus.dataType=1;
		m_EvBus.dataValue1=(U16)adr.adrAddress;
	}
}

void CCheckPage::chkDelay(const char* p)
{
ADDRESS	adr;
ADDR_RETCODE	ret;
CString str=p;
	
	ret=AdrTextToAddr(str, adr, 0);
	if(ret==ADR_EMPTY)
	{
		return;
	}
	m_bEmptyFlag=FALSE;
	if(ret!=ADR_OK||adr.adrAddress>0x7fff||
		adr.adrSpace!=SPACE_UNDEFINE)
	{
		m_nErrLocate=5;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
    if(adr.adrAddress==0)
    {
		return;
	}
}

void CCheckPage::chkCount(const char* p)
{
ADDRESS	adr;
ADDR_RETCODE	ret;
CString str=p;
	
	ret=AdrTextToAddr(str, adr, 0);
	if(ret==ADR_EMPTY)
	{
		m_EvBus.counter=0;
		return;
	}
	m_bEmptyFlag=FALSE;
	if(ret!=ADR_OK||adr.adrAddress>0xffff||
		adr.adrSpace!=SPACE_UNDEFINE)
	{
		m_nErrLocate=5;
		ErrDisplayError(ER_APP_SYNTAXERR);
		return;
	}
    if(adr.adrAddress==0)
    {
		m_EvBus.counter=0;
		return;
	}
	m_EvBus.counter=adr.adrAddress;
}

void CCheckPage::compressWild(char* p)
{
int i, temp;
int hexnum=strlen(p);
char buf[5];
	
	ASSERT(hexnum==16||hexnum==8);
	for(i=0; i<hexnum; i+=4)
	{
		if(p[i]=='x'||p[i+1]=='x'||p[i+2]=='x'||p[i+3]=='x')
			if(p[i]=='x'&&p[i+1]=='x'&&p[i+2]=='x'&&p[i+3]=='x')
				continue;
			else
				return;
		continue;			
	}
	for(i=0; i<hexnum/4; i++)
	{
		if(p[4*i]=='x')
		{
			p[i]='x';
			continue;
		}
		temp=8*(p[4*i]-'0')+4*(p[4*i+1]-'0')+2*(p[4*i+2]-'0')+p[4*i+3]-'0';
		itoa(temp, buf, 16);
		p[i]=buf[0];
	}
	p[i]=0;
}

BOOL CCheckPage::IsWildcard(int bFlag, const char* p)
{
//valid syntax:
//addr: xxxx; p0:xxxx; xxxxxxxxxxxxxxxxb; p0:xxxxxxxxxxxxxxxxb
//data: xx(byte); xxxx(word); xxxxxxxxb; xxxxxxxxxxxxxxxxb
CString	str=p;
int	nibbles=(bFlag==CP_DATABYTE)?2:4;
int len, i;

	if(bFlag==CP_ADDR)
	{
		if((p[0]=='p'||p[0]=='P')&&(p[2]==':')&&
			(p[1]-'0'>=0)&&(p[1]-'0'<GetBankNum()/(IsMapCombination()?1:2)))
			str=p+3;
	}
	len=str.GetLength();
	str.MakeUpper();
	if(str.Find('X')==-1)
	{
		return FALSE;
	}
	if (len==nibbles)
	{
		for(i=0;i<len;i++)
			if(!(str[i]>='0'&&str[i]<='9'
				||str[i]>='A'&&str[i]<='F'||str[i]=='X'))
				return FALSE;
		return TRUE;
	}
	else if(len==nibbles*4+1)
	{
		for(i=0;i<len-1;i++)
			if(str[i]!='0'&&str[i]!='1'&&str[i]!='X')
				return FALSE;
		if(str[len-1]!='B')
			return FALSE;
		return TRUE;
	}
	return FALSE;
}

BOOL CCheckPage::GetWildCard(BOOL bAddr,
								int nValBits,
								U32 dwVal,
								U32 dwValMask,
								char* pBuf)
{
	if(nValBits==18)
		nValBits=16;
BOOL bRet=TS_GetWildCard(bAddr, nValBits, dwVal, dwValMask, pBuf);
CString str=pBuf;
int len=str.GetLength();
int i, j;

	for(i=0, j=0; i<len; i++)
	{
		if(str[i]!='('&&str[i]!=')')
			pBuf[j++]=str[i];
	}
	pBuf[j]=NULL;
	return bRet;
}

BOOL CCheckPage::SetWildCard(BOOL bAddr,
								int nValBits,
								U32& dwVal,
								U32& dwValMask,
								const char* pBuf)
{
CString str=pBuf, str1;

	str+=')';
	if(pBuf[2]==':')
	{
		str1=str.Left(3);
		str1+='(';
		str1+=str.Right(str.GetLength()-3);
	}
	else
	{
		str1='(';
		str1+=str;
	}
	return TS_SetWildCard(bAddr, nValBits, dwVal, dwValMask, str1);
}

void CCheckPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCheckPage)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCheckPage, CPropertyPage)
	//{{AFX_MSG_MAP(CCheckPage)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCheckPage message handlers

void CTrcGrpEventPage::OnGrptrcEvtClear()
{
	// TODO: Add your control notification handler code here
	int nCheck;
	
	nCheck = ((CButton*)GetDlgItem(IDC_GRPTRC_EVT_CLEAR))->GetCheck();
	
//	((CButton*)GetDlgItem(IDC_GRPTRC_EVT_CLEAR))->SetCheck(nCheck);	
	if(!m_bApply)
	{
		m_bApply=TRUE;
		SetModified(TRUE);
	}
		
	switch(m_event.nActiveEvent)
	{
		case 1:
			m_bEv1Clear = nCheck;
			Ev1Init();
			break;
		case 2:
			m_bEv2Clear = nCheck;
			Ev2Init();
			break;
	}
}
