/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCGRPDI.H
//
//  Description:The header file for the class: CTraceGroupDialog
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _TRCGRPDI_
    #define _TRCGRPDI_

#include "abitype.h"

struct eventInfo{
	int nActiveEvent;	// 1/2/3

	int nEv1AddrMode;	// 1/2/3
	int  nEv1AddrType;	// 0/1//length or end addr
	char Ev1StartAddrTxt[65];
	char Ev1StartAddrTxt2[165];
	char Ev1StartAddrTxt3[65];
	char Ev1EndAddrTxt[65];

	int nEv1DataMode; 	// 1/2/3
	int  nEv1DataType; 	// 0/1//length or end data
	char Ev1StartDataTxt[65];
	char Ev1StartDataTxt2[165];
	char Ev1StartDataTxt3[65];
	char Ev1EndDataTxt[65];

	BOOL Ev1DataWidthByte;//	TRUE: byte, FALSE: WORD
	char Ev1CountTxt[10];

	int nEv2AddrMode; 	// 1/2/3
	int  nEv2AddrType;	// 0/1//length or end addr
	char Ev2StartAddrTxt[65];
	char Ev2StartAddrTxt2[165];
	char Ev2StartAddrTxt3[65];
	char Ev2EndAddrTxt[65];

	int nEv2DataMode;	// 1/2/3
	int  nEv2DataType;	// 0/1//length or end data
	char Ev2StartDataTxt[65]; 
	char Ev2StartDataTxt2[165];
	char Ev2StartDataTxt3[65];
	char Ev2EndDataTxt[65];

	BOOL Ev2DataWidthByte;//	TRUE: byte, FALSE: WORD

	int nEv3HL;	// 1/2
};

struct filterStruct{
	int nAddrMode;	// 1/2/3
	int  nAddrType;	// 0/1
	char StartAddrTxt[65];
	char StartAddrTxt2[165];
	char StartAddrTxt3[65];
	char EndAddrTxt[65];
	
	int nDataMode;	// 1/2/3
	int  nDataType;	// 0
	char StartDataTxt[65];
	char StartDataTxt2[165];
	char StartDataTxt3[65];
	char EndDataTxt[65];
	
	BOOL bS;
	BOOL bR;
	BOOL bW;
	BOOL bAK;

	BOOL DataWidthByte;//	TRUE: byte, FALSE: WORD
};

struct filterInfo{
	int nActiveChoice;	// 1/2
	struct filterStruct f[2];	//f[0]: display; f[1]: trace
}; 

struct traceControlInfo {
	BOOL bStartTrace;
	int nDelay; 	// 1/2/3/4
	char delayTxt[65];
};            

struct level {
	int nSet; // 0-17
};

struct triggerInfo {
	int nActiveLevel;	// 1/2
	struct level level1;
	struct level level2;
	BOOL bTriggerEnable;
	BOOL bRun;
	int nTriggerSet;	// 0-4
};

int GetTokenNum(char*);
int searchc(char*, char, int);

/////////////////////////////////////////////////////////////////////////////
// CCheckPage: never have instance.

class CCheckPage : public CPropertyPage
{
// Construction
public:
	CCheckPage(UINT nIDTemplate);

// Dialog Data
	//{{AFX_DATA(CCheckPage)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CCheckPage)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected:
	enum		{CP_ADDR, CP_DATAWORD, CP_DATABYTE};
	BOOL		m_bEv;
	BUS_EVENT	m_EvBus;
	QUALIFY		m_Qlfy;
	BOOL		m_bEmptyFlag;
    int			m_nold_addrmode;
    int			m_nold_datamode;
	int			m_nErrLocate;	//1:startaddr; 2:endaddr; 3:startdata; 
								//4:enddata; 5:count	
	char		m_pBuffer[200];

protected:
	CString 	delspace(const char* p);
	void 		chkWildAddr(const char* p, BOOL isQlfy=FALSE);
	void 		chkRangeAddr(int type,const char* p1,const char* p2, BOOL isQlfy=FALSE);
	void 		chkMultipleAddr(char* p, BOOL isQlfy=FALSE);
	void 		chkWildData(const char* p, BOOL bByte, BOOL isQlfy=FALSE);
	void 		chkRangeData(int type, const char* p1, const char* p2, BOOL bByte, BOOL isQlfy=FALSE);
    void 		chkSingleData(const char* p, BOOL bByte, BOOL isQlfy=FALSE);
    void 		chkCount(const char* p);
    void		chkDelay(const char* p);
    void		compressWild(char* p);
    BOOL		IsWildcard(int bFlag, const char* p);
	BOOL 		GetWildCard(BOOL bAddr, int nValBits, U32 dwVal, U32 dwValMask, char* pBuf);
	BOOL 		SetWildCard(BOOL bAddr, int nValBits, U32& dwVal, U32& dwValMask, const char* pBuf);

};

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpEventPage dialog

class CTrcGrpEventPage : public CCheckPage
{
// Construction
public:
	CTrcGrpEventPage();	// standard constructor
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	virtual void OnOK();
	virtual void OnCancel();
    
// Dialog Data
	//{{AFX_DATA(CTrcGrpEventPage)
	enum { IDD = IDD_TRCGRP_EV };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTrcGrpEventPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnGrptrcEvtEv1();
	afx_msg void OnGrptrcEvtEv2();
	afx_msg void OnGrptrcEvtEv3();
	afx_msg void OnGrptrcEvtMulti1();
	afx_msg void OnGrptrcEvtMulti2();
	afx_msg void OnGrptrcEvtRange1();
	afx_msg void OnGrptrcEvtRange2();
	afx_msg void OnGrptrcEvtWild1();
	afx_msg void OnGrptrcEvtWild2();
	afx_msg void OnSelendokGrptrcEvtAddrtype();
	afx_msg void OnSelendokGrptrcEvtDatatype();
	afx_msg void OnChangeGrptrcEvtStartaddr();
	afx_msg void OnChangeGrptrcEvtStartdata();
	afx_msg void OnChangeGrptrcEvtEndaddr();
	afx_msg void OnChangeGrptrcEvtEnddata();
	afx_msg void OnChangeGrptrcEvtCount();
	afx_msg void OnGrptrcEvtHigh();
	afx_msg void OnGrptrcEvtLow();
	afx_msg void OnGrptrcEvtWidthbyte();
	afx_msg void OnGrptrcEvtWidthword();
	afx_msg void OnGrptrcEvtClear();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//custum:
//private member:
private:
	struct eventInfo m_event;
	BOOL	m_bApply; 
	
	BOOL	m_bEv1Clear;
	BOOL	m_bEv2Clear;

//private function:
private:
	void EnableEventCtrl(BOOL);
	void EnableClearEvent(BOOL, BOOL);
	void ShowAddr(int event);
	void ShowData(int event);
	    
	void Ev1Init();
	void Ev2Init();
	void Ev3Init();

	void GetEv1();
	void GetEv2();
	void GetEv3();

	void SetEv1();
	void SetEv2();
	void SetEv3();

public:
	BOOL OnSet();
};

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTrcctrlPage dialog

class CTrcGrpTrcctrlPage : public CCheckPage
{
// Construction
public:
	CTrcGrpTrcctrlPage();	// standard constructor
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	virtual void OnOK();
	virtual void OnCancel();
	
// Dialog Data
	//{{AFX_DATA(CTrcGrpTrcctrlPage)
	enum { IDD = IDD_TRCGRP_TRCCTRL };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTrcGrpTrcctrlPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnGrptrcTrcStarttrace();
	afx_msg void OnGrptrcTrcCentrg();
	afx_msg void OnGrptrcTrcDelay();
	afx_msg void OnGrptrcTrcPosttrg();
	afx_msg void OnGrptrcTrcPretrg();
	afx_msg void OnChangeGrptrcTrcCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//custum:
//private member:
private:
	struct traceControlInfo m_traceControl;
	BOOL	m_bApply;
	
//private function:	
private:
	void TraceControlInit();

public:
	BOOL OnSet();
};

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTriggerPage dialog

class CTrcGrpTriggerPage : public CPropertyPage
{
// Construction
public:
	CTrcGrpTriggerPage();	// standard constructor
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	virtual void OnOK();
	virtual void OnCancel();

// Dialog Data
	//{{AFX_DATA(CTrcGrpTriggerPage)
	enum { IDD = IDD_TRCGRP_TRIGR };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTrcGrpTriggerPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnGrptrcTrgLv1();
	afx_msg void OnGrptrcTrgLv2();
	afx_msg void OnSelendokGrptrcTrgEvtype();
	afx_msg void OnGrptrcTrgEnable();
	afx_msg void OnGrptrcTrgDisable();
	afx_msg void OnGrptrcTrgRun();
	afx_msg void OnSelendokGrptrcTrgCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//custum:
//private member:
private:
	struct triggerInfo m_trigger;
	BOOL	m_bApply;
//private function:	
private:
	void TriggerInit();
	int  GetLvCondIndex(DWORD dwCond);
	DWORD GetLvCond(int nIndex);
	int  GetTrigLvIdIndex(TRIGGER_LOGIC trig);
	void SetTrigLvId(int nIndex, TRIGGER_LOGIC& trig);
	void SetLevel(int nLvID);
	void SetTrigger();

public:
	BOOL OnSet();
};

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpFilterPage dialog

class CTrcGrpFilterPage : public CCheckPage
{
// Construction
public:
	CTrcGrpFilterPage();	// standard constructor
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	virtual void OnOK();
	virtual void OnCancel();
// Dialog Data
	//{{AFX_DATA(CTrcGrpFilterPage)
	enum { IDD = IDD_TRCGRP_FLT };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTrcGrpFilterPage)
	virtual BOOL OnInitDialog();	
	afx_msg void OnSelendokGrptrcFltAddrtype();
	afx_msg void OnSelendokGrptrcFltDatatype();
	afx_msg void OnGrptrcFltDisplay();
	afx_msg void OnGrptrcFltTrace();
	afx_msg void OnGrptrcFltMulti1();
	afx_msg void OnGrptrcFltMulti2();
	afx_msg void OnGrptrcFltRange1();
	afx_msg void OnGrptrcFltRange2();
	afx_msg void OnGrptrcFltWild1();
	afx_msg void OnGrptrcFltWild2();
	afx_msg void OnChangeGrptrcFltEndaddr();
	afx_msg void OnChangeGrptrcFltEnddata();
	afx_msg void OnChangeGrptrcFltStartaddr();
	afx_msg void OnChangeGrptrcFltStartdata();
	afx_msg void OnGrptrcFltAk();
	afx_msg void OnGrptrcFltR();
	afx_msg void OnGrptrcFltS();
	afx_msg void OnGrptrcFltW();
	afx_msg void OnGrptrcFltWidthbyte();
	afx_msg void OnGrptrcFltWidthword();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//custum:
//private member:
private:
	struct filterInfo m_filter;
    BOOL m_bApply;
    
public:	
	BOOL 	m_bDisplayChange;

//private function:	
private:
	void FilterInit();
	void InitCtrl(int index);

	void GetFilter(int nFltID);
	void SetFilter(int nFltID);

public:
	BOOL OnSet();
};

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog

class CTraceGroupDialog : public CPropertySheet
{
public:
	DECLARE_DYNAMIC(CTraceGroupDialog)
	CTraceGroupDialog(CWnd* pWndParent = NULL);
	CTraceGroupDialog(CWnd* pParent, int tab);

protected:
    //{{AFX_MSG(CTraceGroupDialog)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	void DlgInit(void);

// Attributes
	CTrcGrpEventPage	m_eventPage;
	CTrcGrpTrcctrlPage	m_trcctrlPage;
	CTrcGrpTriggerPage	m_triggerPage;
	CTrcGrpFilterPage	m_filterPage;

public:
	BOOL	m_bDisplayChange;

public:
	void forlive(BOOL live);	
};
#endif
