/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCGTDLG.CPP
//
//  Description:The implement file for the class: CTrcGtdlg
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// trcgtdlg.cpp : implementation file
//

#include "stdafx.h"       
#include "resource.h"

#include "spin.h"
#include "myedit.h"
#include "trcgtdlg.h"
#include "trcpub.h"

//#include "stdlib.h"
//#include "trcserve.h"
//#include "uicom2.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTrcGtdlg dialog
                     

CTrcGtdlg::CTrcGtdlg(CWnd* pParent /*=NULL*/)
    : CDialog(CTrcGtdlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTrcGtdlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	CMyEdit::m_edit2=NULL;
	CMyEdit::m_edit1=NULL;
}

void CTrcGtdlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrcGtdlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTrcGtdlg, CDialog)
	//{{AFX_MSG_MAP(CTrcGtdlg)
	ON_BN_CLICKED(IDC_TRC_GOTO_OK, OnTrcGotoOk)
	ON_BN_CLICKED(IDC_TRC_GOTO_CANCEL, OnTrcGotoCancel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcGtdlg message handlers

void CTrcGtdlg::OnTrcGotoOk()
{
	// TODO: Add your control notification handler code here   
char text[20];
char text2[20];
long result1;
int result;   
BOOL bOk;
long lvalue;
int i, len;      
CWnd* ctrl;

	bOk = TRUE; 
	GetDlgItemText(IDC_TRC_GOTO_COMBO, text, 7);
	if ((text[0]=='0')&&((text[1]=='x')||(text[1]=='X')))
	{
		i=2;
		len=strlen(text);
		while(text[i]=='0')
		i++;
		if(text[i]=='\0')
		i--;
		if(i!=2)
		{
			memmove(&text[2], &text[i], len-i);
			text[2+len-i]='\0';
		} 
		lvalue = strtol(text,NULL,16);
		if ((lvalue>0xffff)||(lvalue<0))
			bOk = FALSE;
		_ultoa(lvalue,text2 , 16);
		if (lstrcmpi(text2,text+2)!=0)
			bOk = FALSE;
		if (bOk) result = (int)lvalue;
	}
	else
	{
		i=0;
		len=strlen(text);
		while(text[i]=='0')
			i++;
		if(text[i]=='\0')
			i--;
		if(i!=0)
		{
			memmove(&text[0], &text[i], len-i);
			text[len-i]='\0';
		} 
		lvalue = strtol(text,NULL,10);
		if ((lvalue>0xffff)||(lvalue<0))
			bOk = FALSE;
		_ultoa(lvalue,text2 , 10);
		if (lstrcmpi(text2,text)!=0)
			bOk = FALSE;
		if (bOk) result = lvalue;
	}
	if (m_lastFrame<result||result<0)
		bOk=FALSE;
	if (!bOk)
	{   
		MessageBeep(-1);
		MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
		ctrl = GetDlgItem(IDC_TRC_GOTO_COMBO);
		((CEdit *)ctrl)->SetFocus();
		((CEdit *)ctrl)->SetSel(0,-1);
		return;
	}
	dwGotoFrame=result;
	EndDialog(IDOK);
}

void CTrcGtdlg::OnTrcGotoCancel()
{
	// TODO: Add your control notification handler code here
	EndDialog(-1);
}

BOOL CTrcGtdlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	    
	// TODO: Add extra initialization here
char text[50];
	
	sprintf(text+2,"%x",0);
	text[0]='0';
	text[1]='x';
	SetDlgItemText(IDC_TRC_GOTO_COMBO,text);

	m_edit.SubclassEdit(IDC_TRC_GOTO_COMBO, this, PES_NUMBERS);

UINT lastFrame;

	lastFrame=TS_GetLastFrame();
	if (lastFrame>1)
		m_edit.SetRange(0, (int)lastFrame);
	else
		m_edit.SetRange(0,0);
	sprintf(text,"Frame [0 - %d/0x%X]",lastFrame,lastFrame);
	m_lastFrame=lastFrame;
	SetDlgItemText(IDC_TRC_GOTO_STATIC,text);

	RECT rect;
	m_edit.GetWindowRect(&rect);
	ScreenToClient(&rect);
//    rect.left = 255;
//    rect.top = 41;
//    rect.right = 270;
//    rect.bottom = 61;
	rect.left = rect.right + 2;
	rect.right = rect.left + 15;
	m_spin.Create(WS_VISIBLE | WS_CHILD | MSS_VERTICAL,
		rect,this,IDC_TRC_GOTO_COMBO);
	m_spin.SetAssociate(&m_edit);
	m_edit.SetFocus();
	m_edit.SetSel(0,-1);
	return FALSE;  // return TRUE  unless you set the focus to a control
}
