#ifndef _trcpub_h
#define _trcpub_h

#include "abiextfn.h"

#define STORE_MAP		1
#define STORE_EVENT     2
#define STORE_QUALIFY	4

struct FrameData
{
	WORD	physicalNo;
	DWORD	dwAddr;
	char	frameNo[6];
	char	addr[9];
	char	data[6];    
	char	status[4];
	char	spare[7];
	char	portdata[4];
};    

struct InsData
{
	WORD    physicalNo;  
	BYTE	intNo; // first or second byte or current frame
	DWORD	dwAddr;
	char    frameNo[6];
	char	addr[9];
	char	instruction[128];
};

struct IntroInsData
{
	DWORD	dwAddr;
	CString strIns;
};	 


#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

void  WINAPI ValidTraceBuffer();  
void  WINAPI TraceWnd(unsigned char trace);
BOOL  WINAPI GetElapseTimeStr(char* szStr);

#ifdef __cplusplus
}
#endif	// __cplusplus
 

BOOL  IsTraceClear();
void  ClearTraceCache();

void  RefreshTraceWnd();

void  TS_TraceClear(); 

DWORD TS_GetLastFrame();      

/****************************************************************************
** nFlag = -1 means reading trace buffer beginning with dwCurFrame - 1, 
** nFlag = -2 means reading trace buffer beginning with dwCurFrame - dwFrameNum
** nFlag =  0 means reading trace buffer beginning with dwCurFrame
** nFlag =  1 means reading trace buffer beginning with dwCurFrame + 1
** nFlag =  2 means reading trace buffer beginning with dwCurFrame + dwFrameNum
*****************************************************************************/
int 	TS_GetBusRecord(int nFlag, DWORD& dwCurFrame, DWORD& dwFrameNum, 
			FrameData* pReturnBuf);
int 	TS_GetInsRecord(int nFlag, DWORD& dwCurFrame, BYTE& byIntNo,
			DWORD& dwFrameNum, InsData* pReturnBuf);

BOOL 	TS_GetBusEv(int nEvID, BOOL& bClearFlag, BUS_EVENT& evData);
STATUS	TS_SetBusEv(int nEvID, BOOL bClearFlag,  BUS_EVENT evData);
BOOL 	TS_GetQualify(BOOL bHard, QUALIFY& qlfyData);
STATUS 	TS_SetQualify(BOOL bHard, QUALIFY qlfyData);
BOOL 	TS_GetExtEv(WORD& evData);
STATUS 	TS_SetExtEv(WORD evData);
BOOL 	TS_GetLevel(int nLvID, TRIGGER_LEVEL& lvData);
STATUS 	TS_SetLevel(int nLvID, TRIGGER_LEVEL lvData);
BOOL 	TS_GetTrigger(TRIGGER_LOGIC& trigData);
STATUS 	TS_SetTrigger(TRIGGER_LOGIC trigData);
BOOL 	TS_GetTrigStatus(BOOL& bTrigStatus);
STATUS 	TS_SetTrigStatus(BOOL bTrigStatus);
BOOL 	TS_GetTraceOnGo(BOOL& trcData);
STATUS 	TS_SetTraceOnGo(BOOL trcData);
BOOL 	TS_GetWildCard(BOOL bAddr, int nValBits, U32 dwVal, U32 dwValMask, char* pBuf);
BOOL 	TS_SetWildCard(BOOL bAddr, int nValBits, U32& dwVal, U32& dwValMask, const char* pBuf);
BOOL	TS_SaveTraceToFile(int nTraceMode, const char* szFileName, DWORD dwStart,
					DWORD dwEnd, BOOL bOverWrite);

BOOL InitTrace();
void Ev1Cmd(int nArgc, char* pszArgv[]);
void Ev2Cmd(int nArgc, char* pszArgv[]);
void Ev3Cmd(int nArgc, char* pszArgv[]);
void EventCmd(int nArgc, char* pszArgv[]);
void Lv1Cmd(int nArgc, char* pszArgv[]);
void Lv2Cmd(int nArgc, char* pszArgv[]);
void LevelCmd(int nArgc, char* pszArgv[]);
void TriggerCmd(int nArgc, char* pszArgv[]);
void QualifyCmd(int nArgc,char* pszArgv[]);
void TraceCmd(int nArgc, char* pszArgv[]);
void ListCmd(int nArgc, char* pszArgv[]);
void ControlCmd(int nArgc, char* pszArgv[]);
void InportCmd(int nArgc, char* pszArgv[]);
void OutportCmd(int nArgc, char* pszArgv[]);

void SaveConfig(const char* filename, WORD option);
void RestoreConfig(const char* filename, WORD option);
void SaveConfigHead(CArchive& ar, WORD option);
BOOL RestoreConfigHead(CArchive& ar, WORD& option, BOOL bShowMsg);

//void SaveEventToFile(CArchive& ar);
//void SaveQualifyToFile(CArchive& ar);
//void RestoreEventFromFile(ar, BOOL bAction);
//void RestoreQualifyFromFile(ar, BOOL bAction);


BOOL SetTraceStatus(int nStatus);
BOOL SaveCurTraceStatus();
BOOL RestoreLastTraceStatus();

BOOL IsEpRunning();

void ShowMsgToStatusBar(const char* szMsg);
void ShowReadTraceCurSite(DWORD dwCur);

#endif
