
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TRCSCHDG.CPP   1.7.1.0.1.2   09 Dec 1996 10:15:48   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TRCSCHDG.CPP  $
** 
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCSCHDG.CPP
//
//  Description:The implement file for the class: CTrcSchDg
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// trcschdg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "trcschdg.h"    
#include "trcwin.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTrcSchDg dialog

CString g_trcSearchContent;    
CStringList g_trcSearchList;
int			g_nTrcSearchMode;

BOOL CTrcSchDg::m_bSearchAddress = FALSE;
BOOL CTrcSchDg::m_bSearchData = FALSE;
BOOL CTrcSchDg::m_bSearchInstruction = FALSE;
BOOL CTrcSchDg::m_bSearchSpare = FALSE;
BOOL CTrcSchDg::m_bSearchStatus = FALSE;
BOOL CTrcSchDg::m_bSearchFrame = FALSE;
int  CTrcSchDg::m_nSearchMode = 0;

CTrcSchDg::CTrcSchDg(CWnd* pParent /*=NULL*/, int nTrcMode)
	: CDialog(CTrcSchDg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTrcSchDg)
	m_strSearchWhat = "";
	//}}AFX_DATA_INIT
	m_nTrcMode = nTrcMode;	
}

void CTrcSchDg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrcSchDg)
	DDX_Control(pDX, IDC_TRC_SEARCH_SEARCH, m_btnSearch);
	DDX_Control(pDX, IDC_TRC_SEARCH_COMBO, m_comboSearchWhat);
	DDX_CBString(pDX, IDC_TRC_SEARCH_COMBO, m_strSearchWhat);
	DDV_MaxChars(pDX, m_strSearchWhat, 100);
	DDX_Check(pDX, IDC_TRC_SEARCH_ADDRESS, m_bSearchAddress);
	DDX_Check(pDX, IDC_TRC_SEARCH_DATA, m_bSearchData);
	DDX_Check(pDX, IDC_TRC_SEARCH_INSTRUCTION, m_bSearchInstruction);
	DDX_Check(pDX, IDC_TRC_SEARCH_SPARE, m_bSearchSpare);
	DDX_Check(pDX, IDC_TRC_SEARCH_STATUS, m_bSearchStatus);
	DDX_Check(pDX, IDC_TRC_SEARCH_FRAME, m_bSearchFrame);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTrcSchDg, CDialog)
	//{{AFX_MSG_MAP(CTrcSchDg)
	ON_BN_CLICKED(IDC_TRC_SEARCH_CANCEL, OnTrcSearchCancel)
	ON_BN_CLICKED(IDC_TRC_SEARCH_SEARCH, OnTrcSearchSearch)
	ON_CBN_EDITCHANGE(IDC_TRC_SEARCH_COMBO, OnEditchangeTrcSearchWhat)
	ON_CBN_SELCHANGE(IDC_TRC_SEARCH_COMBO, OnSelchangeTrcSearchWhat)
	ON_BN_CLICKED(IDC_TRC_SEARCH_FRAME, OnTrcSearchFrame)
	ON_BN_CLICKED(IDC_TRC_SEARCH_DATA, OnTrcSearchData)
	ON_BN_CLICKED(IDC_TRC_SEARCH_ADDRESS, OnTrcSearchAddress)
	ON_BN_CLICKED(IDC_TRC_SEARCH_INSTRUCTION, OnTrcSearchInstruction)
	ON_BN_CLICKED(IDC_TRC_SEARCH_SPARE, OnTrcSearchSpare)
	ON_BN_CLICKED(IDC_TRC_SEARCH_STATUS, OnTrcSearchStatus)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcSchDg message handlers

void CTrcSchDg::OnTrcSearchCancel()
{
	// TODO: Add your control notification handler code here
	EndDialog(-1);
}

void CTrcSchDg::OnTrcSearchSearch()
{
	// TODO: Add your control notification handler code here

	// Add to combo box without same token
	POSITION pos = ::g_trcSearchList.GetHeadPosition();
	POSITION nextPos = pos;
	while ( nextPos ) {  
		if (m_strSearchWhat == ::g_trcSearchList.GetNext(nextPos));
			g_trcSearchList.RemoveAt(pos);
		
		pos = nextPos;			
	}                                

	g_trcSearchList.AddHead(m_strSearchWhat);	
    
    g_trcSearchContent = m_strSearchWhat;
	g_nTrcSearchMode = m_nSearchMode;
	
	EndDialog(1);               
}

BOOL CTrcSchDg::OnInitDialog()
{
	CDialog::OnInitDialog();
    CenterWindow();
	
	// TODO: Add extra initialization here
	
	// Set combo-box
	m_comboSearchWhat.ResetContent();
	
	POSITION pos = ::g_trcSearchList.GetHeadPosition();
	while ( pos ) {
		m_comboSearchWhat.AddString(::g_trcSearchList.GetNext(pos));
	}                                
	
	if ( m_comboSearchWhat.GetCount() >= 1 ) {
		m_comboSearchWhat.SetCurSel(0);
		m_comboSearchWhat.GetLBText(0, m_strSearchWhat);
	}

	// Disable control      
	if (m_nTrcMode == CTraceWindow::TRACEMODE_BUS)
		GetDlgItem(IDC_TRC_SEARCH_INSTRUCTION)->EnableWindow(FALSE);
	else{
		GetDlgItem(IDC_TRC_SEARCH_DATA)->EnableWindow(FALSE);
		GetDlgItem(IDC_TRC_SEARCH_STATUS)->EnableWindow(FALSE);
		GetDlgItem(IDC_TRC_SEARCH_SPARE)->EnableWindow(FALSE);
	}
		
	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcSchDg::OnEditchangeTrcSearchWhat()
{
	// TODO: Add your control notification handler code here
	
	UpdateData(TRUE);
	
	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);
}

void CTrcSchDg::OnSelchangeTrcSearchWhat()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	if (m_comboSearchWhat.GetCount() >= 1){
		m_comboSearchWhat.GetLBText(m_comboSearchWhat.GetCurSel(), m_strSearchWhat);
	}
	
	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);	
		
}


void CTrcSchDg::OnTrcSearchFrame()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	if (m_bSearchFrame)
		m_nSearchMode |= SEARCH_FRAME;
	else m_nSearchMode &= (~SEARCH_FRAME);	

	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);	
}

void CTrcSchDg::OnTrcSearchData()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	if (m_bSearchData)
		m_nSearchMode |= SEARCH_DATA;
	else m_nSearchMode &= (~SEARCH_DATA);	

	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);	
}

void CTrcSchDg::OnTrcSearchAddress()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	if (m_bSearchAddress)
		m_nSearchMode |= SEARCH_ADDRESS;
	else m_nSearchMode &= (~SEARCH_ADDRESS);	

	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);	
}

void CTrcSchDg::OnTrcSearchInstruction()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	if (m_bSearchInstruction)
		m_nSearchMode |= SEARCH_INSTRUCTION;
	else m_nSearchMode &= (~SEARCH_INSTRUCTION);	

	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);	
}

void CTrcSchDg::OnTrcSearchSpare()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	if (m_bSearchSpare)
		m_nSearchMode |= SEARCH_SPARE;
	else m_nSearchMode &= (~SEARCH_SPARE);	

	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);	
}

void CTrcSchDg::OnTrcSearchStatus()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	if (m_bSearchStatus)
		m_nSearchMode |= SEARCH_STATUS;
	else m_nSearchMode &= (~SEARCH_STATUS);	

	m_btnSearch.EnableWindow((!m_strSearchWhat.IsEmpty()) && m_nSearchMode);	
}
